/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import org.h2.engine.SysProperties;
import org.h2.util.StatementBuilder;

public class IntArray {
    private int[] data;
    private int size;
    private int hash;

    public IntArray() {
        this(10);
    }

    public IntArray(int n2) {
        this.data = new int[n2];
    }

    public IntArray(int[] nArray) {
        this.data = nArray;
        this.size = nArray.length;
    }

    public void add(int n2) {
        if (this.size >= this.data.length) {
            this.ensureCapacity(this.size + this.size);
        }
        this.data[this.size++] = n2;
    }

    public int get(int n2) {
        if (SysProperties.CHECK && n2 >= this.size) {
            throw new ArrayIndexOutOfBoundsException("i=" + n2 + " size=" + this.size);
        }
        return this.data[n2];
    }

    public void remove(int n2) {
        if (SysProperties.CHECK && n2 >= this.size) {
            throw new ArrayIndexOutOfBoundsException("i=" + n2 + " size=" + this.size);
        }
        System.arraycopy(this.data, n2 + 1, this.data, n2, this.size - n2 - 1);
        --this.size;
    }

    public void ensureCapacity(int n2) {
        if ((n2 = Math.max(4, n2)) >= this.data.length) {
            int[] nArray = new int[n2];
            System.arraycopy(this.data, 0, nArray, 0, this.data.length);
            this.data = nArray;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntArray)) {
            return false;
        }
        IntArray intArray = (IntArray)object;
        if (this.hashCode() != intArray.hashCode() || this.size != intArray.size) {
            return false;
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.data[i2] == intArray.data[i2]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int n2 = this.size + 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            n2 = n2 * 31 + this.data[i2];
        }
        this.hash = n2;
        return n2;
    }

    public int size() {
        return this.size;
    }

    public void toArray(int[] nArray) {
        System.arraycopy(this.data, 0, nArray, 0, this.size);
    }

    public String toString() {
        StatementBuilder statementBuilder = new StatementBuilder("{");
        for (int i2 = 0; i2 < this.size; ++i2) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(this.data[i2]);
        }
        return statementBuilder.append('}').toString();
    }

    public void removeRange(int n2, int n3) {
        if (SysProperties.CHECK && (n2 > n3 || n3 > this.size)) {
            throw new ArrayIndexOutOfBoundsException("from=" + n2 + " to=" + n3 + " size=" + this.size);
        }
        System.arraycopy(this.data, n3, this.data, n2, this.size - n3);
        this.size -= n3 - n2;
    }
}

