/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.h2.engine.Constants;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;

public class IOUtils {
    private IOUtils() {
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                IOUtils.trace("closeSilently", null, closeable);
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void skipFully(InputStream inputStream, long l2) throws IOException {
        try {
            while (l2 > 0L) {
                long l3 = inputStream.skip(l2);
                if (l3 <= 0L) {
                    throw new EOFException();
                }
                l2 -= l3;
            }
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
    }

    public static void skipFully(Reader reader, long l2) throws IOException {
        try {
            while (l2 > 0L) {
                long l3 = reader.skip(l2);
                if (l3 <= 0L) {
                    throw new EOFException();
                }
                l2 -= l3;
            }
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
    }

    public static long copyAndClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            long l2 = IOUtils.copyAndCloseInput(inputStream, outputStream);
            outputStream.close();
            long l3 = l2;
            return l3;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
        finally {
            IOUtils.closeSilently(outputStream);
        }
    }

    public static long copyAndCloseInput(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            long l2 = IOUtils.copy(inputStream, outputStream);
            return l2;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
        finally {
            IOUtils.closeSilently(inputStream);
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copy(inputStream, outputStream, Long.MAX_VALUE);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long l2) throws IOException {
        try {
            long l3 = 0L;
            int n2 = (int)Math.min(l2, 4096L);
            byte[] byArray = new byte[n2];
            while (l2 > 0L && (n2 = inputStream.read(byArray, 0, n2)) >= 0) {
                if (outputStream != null) {
                    outputStream.write(byArray, 0, n2);
                }
                l3 += (long)n2;
                l2 -= (long)n2;
                n2 = (int)Math.min(l2, 4096L);
            }
            return l3;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
    }

    public static long copyAndCloseInput(Reader reader, Writer writer, long l2) throws IOException {
        try {
            long l3 = 0L;
            int n2 = (int)Math.min(l2, 4096L);
            char[] cArray = new char[n2];
            while (l2 > 0L && (n2 = reader.read(cArray, 0, n2)) >= 0) {
                if (writer != null) {
                    writer.write(cArray, 0, n2);
                }
                l2 -= (long)n2;
                n2 = (int)Math.min(l2, 4096L);
                l3 += (long)n2;
            }
            long l4 = l3;
            return l4;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
        finally {
            reader.close();
        }
    }

    public static void closeSilently(InputStream inputStream) {
        if (inputStream != null) {
            try {
                IOUtils.trace("closeSilently", null, inputStream);
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Writer writer) {
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static byte[] readBytesAndClose(InputStream inputStream, int n2) throws IOException {
        try {
            if (n2 <= 0) {
                n2 = Integer.MAX_VALUE;
            }
            int n3 = Math.min(4096, n2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
            IOUtils.copy(inputStream, byteArrayOutputStream, n2);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringAndClose(Reader reader, int n2) throws IOException {
        try {
            if (n2 <= 0) {
                n2 = Integer.MAX_VALUE;
            }
            int n3 = Math.min(4096, n2);
            StringWriter stringWriter = new StringWriter(n3);
            IOUtils.copyAndCloseInput(reader, stringWriter, n2);
            String string = stringWriter.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n2) throws IOException {
        try {
            int n3;
            int n4 = 0;
            for (int i2 = Math.min(n2, byArray.length); i2 > 0 && (n3 = inputStream.read(byArray, n4, i2)) >= 0; i2 -= n3) {
                n4 += n3;
            }
            return n4;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
    }

    public static int readFully(Reader reader, char[] cArray, int n2) throws IOException {
        try {
            int n3;
            int n4 = 0;
            for (int i2 = Math.min(n2, cArray.length); i2 > 0 && (n3 = reader.read(cArray, n4, i2)) >= 0; i2 -= n3) {
                n4 += n3;
            }
            return n4;
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
    }

    public static Reader getBufferedReader(InputStream inputStream) {
        return inputStream == null ? null : new BufferedReader(new InputStreamReader(inputStream, Constants.UTF8));
    }

    public static Reader getReader(InputStream inputStream) {
        return inputStream == null ? null : new BufferedReader(new InputStreamReader(inputStream, Constants.UTF8));
    }

    public static Writer getBufferedWriter(OutputStream outputStream) {
        return outputStream == null ? null : new BufferedWriter(new OutputStreamWriter(outputStream, Constants.UTF8));
    }

    public static Reader getAsciiReader(InputStream inputStream) {
        try {
            return inputStream == null ? null : new InputStreamReader(inputStream, "US-ASCII");
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    public static void trace(String string, String string2, Object object) {
        if (SysProperties.TRACE_IO) {
            System.out.println("IOUtils." + string + " " + string2 + " " + object);
        }
    }

    public static InputStream getInputStreamFromString(String string) {
        if (string == null) {
            return null;
        }
        return new ByteArrayInputStream(string.getBytes(Constants.UTF8));
    }

    public static void copyFiles(String string, String string2) throws IOException {
        InputStream inputStream = FileUtils.newInputStream(string);
        OutputStream outputStream = FileUtils.newOutputStream(string2, false);
        IOUtils.copyAndClose(inputStream, outputStream);
    }
}

