/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.message.DbException;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueNull;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class DateTimeUtils {
    public static final long MILLIS_PER_DAY = 86400000L;
    private static final long NANOS_PER_DAY = 86400000000000L;
    private static final int SHIFT_YEAR = 9;
    private static final int SHIFT_MONTH = 5;
    private static final int[] NORMAL_DAYS_PER_MONTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] DAYS_OFFSET = new int[]{0, 31, 61, 92, 122, 153, 184, 214, 245, 275, 306, 337, 366};
    private static final ThreadLocal<Calendar> CACHED_CALENDAR = new ThreadLocal();
    private static final ThreadLocal<Calendar> CACHED_CALENDAR_NON_DEFAULT_TIMEZONE = new ThreadLocal();

    private DateTimeUtils() {
    }

    public static void resetCalendar() {
        CACHED_CALENDAR.remove();
    }

    private static Calendar getCalendar() {
        Calendar calendar = CACHED_CALENDAR.get();
        if (calendar == null) {
            calendar = Calendar.getInstance();
            CACHED_CALENDAR.set(calendar);
        }
        calendar.clear();
        return calendar;
    }

    private static Calendar getCalendar(TimeZone timeZone) {
        Calendar calendar = CACHED_CALENDAR_NON_DEFAULT_TIMEZONE.get();
        if (calendar == null || !calendar.getTimeZone().equals(timeZone)) {
            calendar = Calendar.getInstance(timeZone);
            CACHED_CALENDAR_NON_DEFAULT_TIMEZONE.set(calendar);
        }
        calendar.clear();
        return calendar;
    }

    public static java.sql.Date convertDate(Value value, Calendar calendar) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        ValueDate valueDate = (ValueDate)value.convertTo(10);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear();
        calendar2.setLenient(true);
        long l2 = valueDate.getDateValue();
        DateTimeUtils.setCalendarFields(calendar2, DateTimeUtils.yearFromDateValue(l2), DateTimeUtils.monthFromDateValue(l2), DateTimeUtils.dayFromDateValue(l2), 0, 0, 0, 0);
        long l3 = calendar2.getTimeInMillis();
        return new java.sql.Date(l3);
    }

    public static Time convertTime(Value value, Calendar calendar) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        ValueTime valueTime = (ValueTime)value.convertTo(9);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear();
        calendar2.setLenient(true);
        long l2 = valueTime.getNanos();
        long l3 = l2 / 1000000L;
        l2 -= l3 * 1000000L;
        long l4 = l3 / 1000L;
        l3 -= l4 * 1000L;
        long l5 = l4 / 60L;
        l4 -= l5 * 60L;
        long l6 = l5 / 60L;
        DateTimeUtils.setCalendarFields(calendar2, 1970, 1, 1, (int)l6, (int)(l5 -= l6 * 60L), (int)l4, (int)l3);
        long l7 = calendar2.getTimeInMillis();
        return new Time(l7);
    }

    public static Timestamp convertTimestamp(Value value, Calendar calendar) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.clear();
        calendar2.setLenient(true);
        long l2 = valueTimestamp.getDateValue();
        long l3 = valueTimestamp.getTimeNanos();
        long l4 = l3 / 1000000L;
        l3 -= l4 * 1000000L;
        long l5 = l4 / 1000L;
        l4 -= l5 * 1000L;
        long l6 = l5 / 60L;
        l5 -= l6 * 60L;
        long l7 = l6 / 60L;
        DateTimeUtils.setCalendarFields(calendar2, DateTimeUtils.yearFromDateValue(l2), DateTimeUtils.monthFromDateValue(l2), DateTimeUtils.dayFromDateValue(l2), (int)l7, (int)(l6 -= l7 * 60L), (int)l5, (int)l4);
        long l8 = calendar2.getTimeInMillis();
        Timestamp timestamp = new Timestamp(l8);
        timestamp.setNanos((int)(l3 + l4 * 1000000L));
        return timestamp;
    }

    public static ValueDate convertDate(java.sql.Date date, Calendar calendar) {
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeInMillis(date.getTime());
        long l2 = DateTimeUtils.dateValueFromCalendar(calendar2);
        return ValueDate.fromDateValue(l2);
    }

    public static ValueTime convertTime(Time time, Calendar calendar) {
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeInMillis(time.getTime());
        long l2 = DateTimeUtils.nanosFromCalendar(calendar2);
        return ValueTime.fromNanos(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToLocal(Date date, Calendar calendar) {
        Calendar calendar2;
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        calendar = (Calendar)calendar.clone();
        Calendar calendar3 = calendar2 = Calendar.getInstance();
        synchronized (calendar3) {
            calendar2.setTime(date);
            DateTimeUtils.convertTime(calendar2, calendar);
        }
        return calendar.getTime().getTime();
    }

    private static void convertTime(Calendar calendar, Calendar calendar2) {
        calendar2.set(0, calendar.get(0));
        calendar2.set(1, calendar.get(1));
        calendar2.set(2, calendar.get(2));
        calendar2.set(5, calendar.get(5));
        calendar2.set(11, calendar.get(11));
        calendar2.set(12, calendar.get(12));
        calendar2.set(13, calendar.get(13));
        calendar2.set(14, calendar.get(14));
    }

    public static ValueTimestamp convertTimestamp(Timestamp timestamp, Calendar calendar) {
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeInMillis(timestamp.getTime());
        long l2 = DateTimeUtils.dateValueFromCalendar(calendar2);
        long l3 = DateTimeUtils.nanosFromCalendar(calendar2);
        return ValueTimestamp.fromDateValueAndNanos(l2, l3 += (long)(timestamp.getNanos() % 1000000));
    }

    public static long parseDateValue(String string, int n2, int n3) {
        int n4;
        int n5;
        if (string.charAt(n2) == '+') {
            ++n2;
        }
        int n6 = string.indexOf(45, n2 + 1);
        int n7 = string.indexOf(45, n6 + 1);
        if (n6 <= 0 || n7 <= n6) {
            throw new IllegalArgumentException(string);
        }
        int n8 = Integer.parseInt(string.substring(n2, n6));
        if (!DateTimeUtils.isValidDate(n8, n5 = Integer.parseInt(string.substring(n6 + 1, n7)), n4 = Integer.parseInt(string.substring(n7 + 1, n3)))) {
            throw new IllegalArgumentException(n8 + "-" + n5 + "-" + n4);
        }
        return DateTimeUtils.dateValue(n8, n5, n4);
    }

    public static long parseTimeNanos(String string, int n2, int n3, boolean bl2) {
        boolean bl3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        long l2 = 0L;
        int n7 = string.indexOf(58, n2);
        int n8 = string.indexOf(58, n7 + 1);
        int n9 = string.indexOf(46, n8 + 1);
        if (n7 <= 0 || n8 <= n7) {
            n7 = string.indexOf(46, n2);
            n8 = string.indexOf(46, n7 + 1);
            n9 = string.indexOf(46, n8 + 1);
            if (n7 <= 0 || n8 <= n7) {
                throw new IllegalArgumentException(string);
            }
        }
        if ((n4 = Integer.parseInt(string.substring(n2, n7))) < 0) {
            if (bl2) {
                throw new IllegalArgumentException(string);
            }
            bl3 = true;
            n4 = -n4;
        } else {
            bl3 = false;
        }
        n5 = Integer.parseInt(string.substring(n7 + 1, n8));
        if (n9 < 0) {
            n6 = Integer.parseInt(string.substring(n8 + 1, n3));
        } else {
            n6 = Integer.parseInt(string.substring(n8 + 1, n9));
            String string2 = (string.substring(n9 + 1, n3) + "000000000").substring(0, 9);
            l2 = Integer.parseInt(string2);
        }
        if (n4 >= 2000000 || n5 < 0 || n5 >= 60 || n6 < 0 || n6 >= 60) {
            throw new IllegalArgumentException(string);
        }
        if (bl2 && n4 >= 24) {
            throw new IllegalArgumentException(string);
        }
        return bl3 ? -l2 : (l2 += (((long)n4 * 60L + (long)n5) * 60L + (long)n6) * 1000000000L);
    }

    public static long getMillis(TimeZone timeZone, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        try {
            return DateTimeUtils.getTimeTry(false, timeZone, n2, n3, n4, n5, n6, n7, n8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = illegalArgumentException.toString();
            if (string.indexOf("HOUR_OF_DAY") > 0) {
                if (n5 < 0 || n5 > 23) {
                    throw illegalArgumentException;
                }
                return DateTimeUtils.getTimeTry(true, timeZone, n2, n3, n4, n5, n6, n7, n8);
            }
            if (string.indexOf("DAY_OF_MONTH") > 0) {
                int n9 = n3 == 2 ? (new GregorianCalendar().isLeapYear(n2) ? 29 : 28) : 30 + (n3 + (n3 > 7 ? 1 : 0) & 1);
                if (n4 < 1 || n4 > n9) {
                    throw illegalArgumentException;
                }
                return DateTimeUtils.getTimeTry(true, timeZone, n2, n3, n4, n5 += 6, n6, n7, n8);
            }
            return DateTimeUtils.getTimeTry(true, timeZone, n2, n3, n4, n5, n6, n7, n8);
        }
    }

    private static long getTimeTry(boolean bl2, TimeZone timeZone, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Calendar calendar = timeZone == null ? DateTimeUtils.getCalendar() : DateTimeUtils.getCalendar(timeZone);
        calendar.setLenient(bl2);
        DateTimeUtils.setCalendarFields(calendar, n2, n3, n4, n5, n6, n7, n8);
        return calendar.getTime().getTime();
    }

    private static void setCalendarFields(Calendar calendar, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n2 <= 0) {
            calendar.set(0, 0);
            calendar.set(1, 1 - n2);
        } else {
            calendar.set(0, 1);
            calendar.set(1, n2);
        }
        calendar.set(2, n3 - 1);
        calendar.set(5, n4);
        calendar.set(11, n5);
        calendar.set(12, n6);
        calendar.set(13, n7);
        calendar.set(14, n8);
    }

    public static int getDatePart(Date date, int n2) {
        Calendar calendar = DateTimeUtils.getCalendar();
        calendar.setTime(date);
        if (n2 == 1) {
            return DateTimeUtils.getYear(calendar);
        }
        int n3 = calendar.get(n2);
        if (n2 == 2) {
            return n3 + 1;
        }
        return n3;
    }

    private static int getYear(Calendar calendar) {
        int n2 = calendar.get(1);
        if (calendar.get(0) == 0) {
            n2 = 1 - n2;
        }
        return n2;
    }

    public static long getTimeLocalWithoutDst(Date date) {
        Calendar calendar = DateTimeUtils.getCalendar();
        return date.getTime() + (long)calendar.get(15);
    }

    public static long getTimeUTCWithoutDst(long l2) {
        return l2 - (long)DateTimeUtils.getCalendar().get(15);
    }

    public static int getIsoDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        int n2 = calendar.get(7) - 1;
        return n2 == 0 ? 7 : n2;
    }

    public static int getIsoWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        return calendar.get(3);
    }

    public static int getIsoYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        int n2 = DateTimeUtils.getYear(calendar);
        int n3 = calendar.get(2);
        int n4 = calendar.get(3);
        if (n3 == 0 && n4 > 51) {
            --n2;
        } else if (n3 == 11 && n4 == 1) {
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Date date, String string, String string2, String string3) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = DateTimeUtils.getDateFormat(string, string2, string3);
        synchronized (simpleDateFormat2) {
            return simpleDateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String string, String string2, String string3, String string4) {
        SimpleDateFormat simpleDateFormat = DateTimeUtils.getDateFormat(string2, string3, string4);
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(string);
            }
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string);
        }
    }

    private static SimpleDateFormat getDateFormat(String string, String string2, String string3) {
        try {
            SimpleDateFormat simpleDateFormat;
            if (string2 == null) {
                simpleDateFormat = new SimpleDateFormat(string);
            } else {
                Locale locale = new Locale(string2);
                simpleDateFormat = new SimpleDateFormat(string, locale);
            }
            if (string3 != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
            }
            return simpleDateFormat;
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string + "/" + string2 + "/" + string3);
        }
    }

    public static boolean isValidDate(int n2, int n3, int n4) {
        if (n3 < 1 || n3 > 12 || n4 < 1) {
            return false;
        }
        if (n2 > 1582) {
            if (n3 != 2) {
                return n4 <= NORMAL_DAYS_PER_MONTH[n3];
            }
            if ((n2 & 3) != 0) {
                return n4 <= 28;
            }
            return n4 <= (n2 % 100 != 0 || n2 % 400 == 0 ? 29 : 28);
        }
        if (n2 == 1582 && n3 == 10) {
            return n4 <= 31 && (n4 < 5 || n4 > 14);
        }
        if (n3 != 2 && n4 <= NORMAL_DAYS_PER_MONTH[n3]) {
            return true;
        }
        return n4 <= ((n2 & 3) != 0 ? 28 : 29);
    }

    public static java.sql.Date convertDateValueToDate(long l2) {
        long l3 = DateTimeUtils.getMillis(null, DateTimeUtils.yearFromDateValue(l2), DateTimeUtils.monthFromDateValue(l2), DateTimeUtils.dayFromDateValue(l2), 0, 0, 0, 0);
        return new java.sql.Date(l3);
    }

    public static Timestamp convertDateValueToTimestamp(long l2, long l3) {
        long l4 = l3 / 1000000L;
        l3 -= l4 * 1000000L;
        long l5 = l4 / 1000L;
        l4 -= l5 * 1000L;
        long l6 = l5 / 60L;
        l5 -= l6 * 60L;
        long l7 = l6 / 60L;
        long l8 = DateTimeUtils.getMillis(null, DateTimeUtils.yearFromDateValue(l2), DateTimeUtils.monthFromDateValue(l2), DateTimeUtils.dayFromDateValue(l2), (int)l7, (int)(l6 -= l7 * 60L), (int)l5, 0);
        Timestamp timestamp = new Timestamp(l8);
        timestamp.setNanos((int)(l3 + l4 * 1000000L));
        return timestamp;
    }

    public static Time convertNanoToTime(long l2) {
        long l3 = l2 / 1000000L;
        long l4 = l3 / 1000L;
        l3 -= l4 * 1000L;
        long l5 = l4 / 60L;
        l4 -= l5 * 60L;
        long l6 = l5 / 60L;
        long l7 = DateTimeUtils.getMillis(null, 1970, 1, 1, (int)(l6 % 24L), (int)(l5 -= l6 * 60L), (int)l4, (int)l3);
        return new Time(l7);
    }

    public static int yearFromDateValue(long l2) {
        return (int)(l2 >>> 9);
    }

    public static int monthFromDateValue(long l2) {
        return (int)(l2 >>> 5) & 0xF;
    }

    public static int dayFromDateValue(long l2) {
        return (int)(l2 & 0x1FL);
    }

    public static long dateValue(long l2, int n2, int n3) {
        return l2 << 9 | (long)(n2 << 5) | (long)n3;
    }

    public static long dateValueFromDate(long l2) {
        Calendar calendar = DateTimeUtils.getCalendar();
        calendar.setTimeInMillis(l2);
        return DateTimeUtils.dateValueFromCalendar(calendar);
    }

    private static long dateValueFromCalendar(Calendar calendar) {
        int n2 = DateTimeUtils.getYear(calendar);
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        return (long)n2 << 9 | (long)(n3 << 5) | (long)n4;
    }

    public static long nanosFromDate(long l2) {
        Calendar calendar = DateTimeUtils.getCalendar();
        calendar.setTimeInMillis(l2);
        return DateTimeUtils.nanosFromCalendar(calendar);
    }

    private static long nanosFromCalendar(Calendar calendar) {
        int n2 = calendar.get(11);
        int n3 = calendar.get(12);
        int n4 = calendar.get(13);
        int n5 = calendar.get(14);
        return ((((long)n2 * 60L + (long)n3) * 60L + (long)n4) * 1000L + (long)n5) * 1000000L;
    }

    public static ValueTimestamp normalizeTimestamp(long l2, long l3) {
        if (l3 > 86400000000000L || l3 < 0L) {
            long l4 = l3 > 86400000000000L ? l3 / 86400000000000L : (l3 - 86400000000000L + 1L) / 86400000000000L;
            l3 -= l4 * 86400000000000L;
            l2 += l4;
        }
        return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(l2), l3);
    }

    public static long absoluteDayFromDateValue(long l2) {
        long l3 = DateTimeUtils.yearFromDateValue(l2);
        int n2 = DateTimeUtils.monthFromDateValue(l2);
        int n3 = DateTimeUtils.dayFromDateValue(l2);
        if (n2 <= 2) {
            --l3;
            n2 += 12;
        }
        long l4 = (l3 * 2922L >> 3) + (long)DAYS_OFFSET[n2 - 3] + (long)n3 - 719484L;
        if (l3 <= 1582L && (l3 < 1582L || n2 * 100 + n3 < 1005)) {
            l4 += 13L;
        } else if (l3 < 1901L || l3 > 2099L) {
            l4 += l3 / 400L - l3 / 100L + 15L;
        }
        return l4;
    }

    public static long dateValueFromAbsoluteDay(long l2) {
        long l3;
        long l4;
        long l5 = l2 + 719468L;
        long l6 = 0L;
        if (l5 > 578040L) {
            l4 = l5 / 146097L;
            l6 = (l5 -= l4 * 146097L) / 36524L;
            l5 -= l6 * 36524L;
            l3 = l4 * 400L + l6 * 100L;
        } else {
            l5 += 292200000002L;
            l3 = -800000000L;
        }
        l4 = l5 / 1461L;
        long l7 = (l5 -= l4 * 1461L) / 365L;
        if ((l5 -= l7 * 365L) == 0L && (l7 == 4L || l6 == 4L)) {
            --l7;
            l5 += 365L;
        }
        l7 += l3 + l4 * 4L;
        int n2 = ((int)l5 * 2 + 1) * 5 / 306;
        l5 -= (long)(DAYS_OFFSET[n2] - 1);
        if (n2 >= 10) {
            ++l7;
            n2 -= 12;
        }
        return DateTimeUtils.dateValue(l7, n2 + 3, (int)l5);
    }

    public static Timestamp addMonths(Timestamp timestamp, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        calendar.add(2, n2);
        Timestamp timestamp2 = new Timestamp(calendar.getTimeInMillis());
        timestamp2.setNanos(timestamp.getNanos());
        return timestamp2;
    }
}

