/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.util.MathUtils;

public abstract class CacheObject
implements Comparable<CacheObject> {
    public CacheObject cachePrevious;
    public CacheObject cacheNext;
    public CacheObject cacheChained;
    private int pos;
    private boolean changed;

    public abstract boolean canRemove();

    public abstract int getMemory();

    public void setPos(int n2) {
        if (SysProperties.CHECK && (this.cachePrevious != null || this.cacheNext != null || this.cacheChained != null)) {
            DbException.throwInternalError("setPos too late");
        }
        this.pos = n2;
    }

    public int getPos() {
        return this.pos;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl2) {
        this.changed = bl2;
    }

    @Override
    public int compareTo(CacheObject cacheObject) {
        return MathUtils.compareInt(this.getPos(), cacheObject.getPos());
    }

    public boolean isStream() {
        return false;
    }
}

