/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.ArrayList;
import java.util.Collections;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.util.Cache;
import org.h2.util.CacheHead;
import org.h2.util.CacheObject;
import org.h2.util.CacheSecondLevel;
import org.h2.util.CacheTQ;
import org.h2.util.CacheWriter;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.SoftHashMap;

public class CacheLRU
implements Cache {
    static final String TYPE_NAME = "LRU";
    private final CacheWriter writer;
    private final boolean fifo;
    private final CacheObject head = new CacheHead();
    private final int mask;
    private CacheObject[] values;
    private int recordCount;
    private final int len;
    private int maxMemory;
    private int memory;

    CacheLRU(CacheWriter cacheWriter, int n2, boolean bl2) {
        this.writer = cacheWriter;
        this.fifo = bl2;
        this.setMaxMemory(n2);
        this.len = MathUtils.nextPowerOf2(this.maxMemory / 64);
        this.mask = this.len - 1;
        this.clear();
    }

    public static Cache getCache(CacheWriter cacheWriter, String string, int n2) {
        Cache cache;
        SoftHashMap<Integer, CacheObject> softHashMap = null;
        if (string.startsWith("SOFT_")) {
            softHashMap = new SoftHashMap<Integer, CacheObject>();
            string = string.substring("SOFT_".length());
        }
        if (TYPE_NAME.equals(string)) {
            cache = new CacheLRU(cacheWriter, n2, false);
        } else if ("TQ".equals(string)) {
            cache = new CacheTQ(cacheWriter, n2);
        } else {
            throw DbException.getInvalidValueException("CACHE_TYPE", string);
        }
        if (softHashMap != null) {
            cache = new CacheSecondLevel(cache, softHashMap);
        }
        return cache;
    }

    @Override
    public void clear() {
        this.head.cacheNext = this.head.cachePrevious = this.head;
        this.values = null;
        this.values = new CacheObject[this.len];
        this.recordCount = 0;
        this.memory = this.len * 8;
    }

    @Override
    public void put(CacheObject cacheObject) {
        int n2;
        CacheObject cacheObject2;
        if (SysProperties.CHECK && (cacheObject2 = this.find(n2 = cacheObject.getPos())) != null) {
            DbException.throwInternalError("try to add a record twice at pos " + n2);
        }
        n2 = cacheObject.getPos() & this.mask;
        cacheObject.cacheChained = this.values[n2];
        this.values[n2] = cacheObject;
        ++this.recordCount;
        this.memory += cacheObject.getMemory();
        this.addToFront(cacheObject);
        this.removeOldIfRequired();
    }

    @Override
    public CacheObject update(int n2, CacheObject cacheObject) {
        CacheObject cacheObject2 = this.find(n2);
        if (cacheObject2 == null) {
            this.put(cacheObject);
        } else {
            if (SysProperties.CHECK && cacheObject2 != cacheObject) {
                DbException.throwInternalError("old!=record pos:" + n2 + " old:" + cacheObject2 + " new:" + cacheObject);
            }
            if (!this.fifo) {
                this.removeFromLinkedList(cacheObject);
                this.addToFront(cacheObject);
            }
        }
        return cacheObject2;
    }

    private void removeOldIfRequired() {
        if (this.memory >= this.maxMemory) {
            this.removeOld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOld() {
        int n2 = 0;
        ArrayList arrayList = New.arrayList();
        int n3 = this.memory;
        int n4 = this.recordCount;
        boolean bl2 = false;
        CacheObject cacheObject = this.head.cacheNext;
        while (n4 > 16 && !(arrayList.size() == 0 ? n3 <= this.maxMemory : n3 * 4 <= this.maxMemory * 3)) {
            CacheObject cacheObject2 = cacheObject;
            cacheObject = cacheObject2.cacheNext;
            if (++n2 >= this.recordCount) {
                if (!bl2) {
                    this.writer.flushLog();
                    bl2 = true;
                    n2 = 0;
                } else {
                    this.writer.getTrace().info("cannot remove records, cache size too small? records:" + this.recordCount + " memory:" + this.memory);
                    break;
                }
            }
            if (SysProperties.CHECK && cacheObject2 == this.head) {
                DbException.throwInternalError("try to remove head");
            }
            if (!cacheObject2.canRemove()) {
                this.removeFromLinkedList(cacheObject2);
                this.addToFront(cacheObject2);
                continue;
            }
            --n4;
            n3 -= cacheObject2.getMemory();
            if (cacheObject2.isChanged()) {
                arrayList.add(cacheObject2);
                continue;
            }
            this.remove(cacheObject2.getPos());
        }
        if (arrayList.size() > 0) {
            CacheObject cacheObject3;
            if (!bl2) {
                this.writer.flushLog();
            }
            Collections.sort(arrayList);
            int n5 = this.maxMemory;
            int n6 = arrayList.size();
            try {
                this.maxMemory = Integer.MAX_VALUE;
                for (n2 = 0; n2 < n6; ++n2) {
                    cacheObject3 = (CacheObject)arrayList.get(n2);
                    this.writer.writeBack(cacheObject3);
                }
            }
            finally {
                this.maxMemory = n5;
            }
            for (n2 = 0; n2 < n6; ++n2) {
                cacheObject3 = (CacheObject)arrayList.get(n2);
                this.remove(cacheObject3.getPos());
                if (!SysProperties.CHECK || cacheObject3.cacheNext == null) continue;
                throw DbException.throwInternalError();
            }
        }
    }

    private void addToFront(CacheObject cacheObject) {
        if (SysProperties.CHECK && cacheObject == this.head) {
            DbException.throwInternalError("try to move head");
        }
        cacheObject.cacheNext = this.head;
        cacheObject.cachePrevious = this.head.cachePrevious;
        cacheObject.cachePrevious.cacheNext = cacheObject;
        this.head.cachePrevious = cacheObject;
    }

    private void removeFromLinkedList(CacheObject cacheObject) {
        if (SysProperties.CHECK && cacheObject == this.head) {
            DbException.throwInternalError("try to remove head");
        }
        cacheObject.cachePrevious.cacheNext = cacheObject.cacheNext;
        cacheObject.cacheNext.cachePrevious = cacheObject.cachePrevious;
        cacheObject.cacheNext = null;
        cacheObject.cachePrevious = null;
    }

    @Override
    public boolean remove(int n2) {
        CacheObject cacheObject;
        int n3 = n2 & this.mask;
        CacheObject cacheObject2 = this.values[n3];
        if (cacheObject2 == null) {
            return false;
        }
        if (cacheObject2.getPos() == n2) {
            this.values[n3] = cacheObject2.cacheChained;
        } else {
            do {
                cacheObject = cacheObject2;
                cacheObject2 = cacheObject2.cacheChained;
                if (cacheObject2 != null) continue;
                return false;
            } while (cacheObject2.getPos() != n2);
            cacheObject.cacheChained = cacheObject2.cacheChained;
        }
        --this.recordCount;
        this.memory -= cacheObject2.getMemory();
        this.removeFromLinkedList(cacheObject2);
        if (SysProperties.CHECK) {
            cacheObject2.cacheChained = null;
            cacheObject = this.find(n2);
            if (cacheObject != null) {
                DbException.throwInternalError("not removed: " + cacheObject);
            }
        }
        return true;
    }

    @Override
    public CacheObject find(int n2) {
        CacheObject cacheObject = this.values[n2 & this.mask];
        while (cacheObject != null && cacheObject.getPos() != n2) {
            cacheObject = cacheObject.cacheChained;
        }
        return cacheObject;
    }

    @Override
    public CacheObject get(int n2) {
        CacheObject cacheObject = this.find(n2);
        if (cacheObject != null && !this.fifo) {
            this.removeFromLinkedList(cacheObject);
            this.addToFront(cacheObject);
        }
        return cacheObject;
    }

    @Override
    public ArrayList<CacheObject> getAllChanged() {
        ArrayList<CacheObject> arrayList = New.arrayList();
        CacheObject cacheObject = this.head.cacheNext;
        while (cacheObject != this.head) {
            if (cacheObject.isChanged()) {
                arrayList.add(cacheObject);
            }
            cacheObject = cacheObject.cacheNext;
        }
        return arrayList;
    }

    @Override
    public void setMaxMemory(int n2) {
        int n3 = MathUtils.convertLongToInt((long)n2 * 1024L / 4L);
        this.maxMemory = n3 < 0 ? 0 : n3;
        this.removeOldIfRequired();
    }

    @Override
    public int getMaxMemory() {
        return (int)((long)this.maxMemory * 4L / 1024L);
    }

    @Override
    public int getMemory() {
        return (int)((long)this.memory * 4L / 1024L);
    }
}

