/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

public final class BitField {
    private static final int ADDRESS_BITS = 6;
    private static final int BITS = 64;
    private static final int ADDRESS_MASK = 63;
    private long[] data;
    private int maxLength;

    public BitField() {
        this(64);
    }

    public BitField(int n2) {
        this.data = new long[n2 >>> 3];
    }

    public int nextClearBit(int n2) {
        int n3 = this.data.length;
        for (int i2 = n2 >> 6; i2 < n3; ++i2) {
            int n4;
            if (this.data[i2] == -1L) continue;
            int n5 = n4 + 64;
            for (n4 = Math.max(n2, i2 << 6); n4 < n5; ++n4) {
                if (this.get(n4)) continue;
                return n4;
            }
        }
        return n3 << 6;
    }

    public boolean get(int n2) {
        int n3 = n2 >> 6;
        if (n3 >= this.data.length) {
            return false;
        }
        return (this.data[n3] & BitField.getBitMask(n2)) != 0L;
    }

    public int getByte(int n2) {
        int n3 = n2 >> 6;
        if (n3 >= this.data.length) {
            return 0;
        }
        return (int)(this.data[n3] >>> (n2 & 0x38) & 0xFFL);
    }

    public void setByte(int n2, int n3) {
        int n4 = n2 >> 6;
        this.checkCapacity(n4);
        int n5 = n4;
        this.data[n5] = this.data[n5] | (long)n3 << (n2 & 0x38);
        if (this.maxLength < n2 && n3 != 0) {
            this.maxLength = n2 + 7;
        }
    }

    public void set(int n2) {
        int n3 = n2 >> 6;
        this.checkCapacity(n3);
        int n4 = n3;
        this.data[n4] = this.data[n4] | BitField.getBitMask(n2);
        if (this.maxLength < n2) {
            this.maxLength = n2;
        }
    }

    public void clear(int n2) {
        int n3 = n2 >> 6;
        if (n3 >= this.data.length) {
            return;
        }
        int n4 = n3;
        this.data[n4] = this.data[n4] & (BitField.getBitMask(n2) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static long getBitMask(int n2) {
        return 1L << (n2 & 0x3F);
    }

    private void checkCapacity(int n2) {
        if (n2 >= this.data.length) {
            this.expandCapacity(n2);
        }
    }

    private void expandCapacity(int n2) {
        while (n2 >= this.data.length) {
            int n3 = this.data.length == 0 ? 1 : this.data.length * 2;
            long[] lArray = new long[n3];
            System.arraycopy(this.data, 0, lArray, 0, this.data.length);
            this.data = lArray;
        }
    }

    public void set(int n2, int n3, boolean bl2) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            this.set(i2, bl2);
        }
        if (bl2) {
            if (n3 > this.maxLength) {
                this.maxLength = n3;
            }
        } else if (n3 >= this.maxLength) {
            this.maxLength = n2;
        }
    }

    private void set(int n2, boolean bl2) {
        if (bl2) {
            this.set(n2);
        } else {
            this.clear(n2);
        }
    }

    public int length() {
        int n2;
        for (n2 = this.maxLength >> 6; n2 > 0 && this.data[n2] == 0L; --n2) {
        }
        this.maxLength = (n2 << 6) + (64 - Long.numberOfLeadingZeros(this.data[n2]));
        return this.maxLength;
    }
}

