/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.h2.message.DbException;
import org.h2.tools.SimpleRowSource;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.DataType;

public class SimpleResultSet
implements ResultSet,
ResultSetMetaData {
    private ArrayList<Object[]> rows;
    private Object[] currentRow;
    private int rowId = -1;
    private boolean wasNull;
    private SimpleRowSource source;
    private ArrayList<Column> columns = New.arrayList();
    private boolean autoClose = true;

    public SimpleResultSet() {
        this.rows = New.arrayList();
    }

    public SimpleResultSet(SimpleRowSource simpleRowSource) {
        this.source = simpleRowSource;
    }

    public void addColumn(String string, int n2, int n3, int n4) {
        int n5 = DataType.convertSQLTypeToValueType(n2);
        this.addColumn(string, n2, DataType.getDataType((int)n5).name, n3, n4);
    }

    public void addColumn(String string, int n2, String string2, int n3, int n4) {
        if (this.rows != null && this.rows.size() > 0) {
            throw new IllegalStateException("Cannot add a column after adding rows");
        }
        if (string == null) {
            string = "C" + (this.columns.size() + 1);
        }
        Column column = new Column();
        column.name = string;
        column.sqlType = n2;
        column.precision = n3;
        column.scale = n4;
        column.sqlTypeName = string2;
        this.columns.add(column);
    }

    public void addRow(Object ... objectArray) {
        if (this.rows == null) {
            throw new IllegalStateException("Cannot add a row when using RowSource");
        }
        this.rows.add(objectArray);
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public int getRow() {
        return this.currentRow == null ? 0 : this.rowId + 1;
    }

    @Override
    public int getType() {
        if (this.autoClose) {
            return 1003;
        }
        return 1004;
    }

    @Override
    public void close() {
        this.currentRow = null;
        this.rows = null;
        this.columns = null;
        this.rowId = -1;
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.source != null) {
            ++this.rowId;
            this.currentRow = this.source.readRow();
            if (this.currentRow != null) {
                return true;
            }
        } else if (this.rows != null && this.rowId < this.rows.size()) {
            ++this.rowId;
            if (this.rowId < this.rows.size()) {
                this.currentRow = this.rows.get(this.rowId);
                return true;
            }
            this.currentRow = null;
        }
        if (this.autoClose) {
            this.close();
        }
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.autoClose) {
            throw DbException.get(90128);
        }
        this.rowId = -1;
        if (this.source != null) {
            this.source.reset();
        }
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        if (string != null && this.columns != null) {
            int n2 = this.columns.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!string.equalsIgnoreCase(this.getColumn((int)i2).name)) continue;
                return i2 + 1;
            }
        }
        throw DbException.get(42122, string).getSQLException();
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public Statement getStatement() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        Object[] objectArray = (Object[])this.get(n2);
        return objectArray == null ? null : new SimpleArray(objectArray);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        Object object = this.get(n2);
        if (object != null && !(object instanceof BigDecimal)) {
            object = new BigDecimal(object.toString());
        }
        return (BigDecimal)object;
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        return SimpleResultSet.asInputStream(this.get(n2));
    }

    private static InputStream asInputStream(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Blob) {
            return ((Blob)object).getBinaryStream();
        }
        return (InputStream)object;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        return (Blob)this.get(n2);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        Object object = this.get(n2);
        if (object != null && !(object instanceof Boolean)) {
            object = Boolean.valueOf(object.toString());
        }
        return object == null ? false : (Boolean)object;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        Object object = this.get(n2);
        if (object != null && !(object instanceof Number)) {
            object = Byte.decode(object.toString());
        }
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        Object object = this.get(n2);
        if (object == null || object instanceof byte[]) {
            return (byte[])object;
        }
        return JdbcUtils.serialize(object, null);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        return SimpleResultSet.asReader(this.get(n2));
    }

    private static Reader asReader(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        return (Reader)object;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        Clob clob = (Clob)this.get(n2);
        return clob == null ? null : clob;
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        return (Date)this.get(n2);
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        Object object = this.get(n2);
        if (object != null && !(object instanceof Number)) {
            return Double.parseDouble(object.toString());
        }
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        Object object = this.get(n2);
        if (object != null && !(object instanceof Number)) {
            return Float.parseFloat(object.toString());
        }
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public int getInt(int n2) throws SQLException {
        Object object = this.get(n2);
        if (object != null && !(object instanceof Number)) {
            object = Integer.decode(object.toString());
        }
        return object == null ? 0 : ((Number)object).intValue();
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(int n2) throws SQLException {
        Object object = this.get(n2);
        if (object != null && !(object instanceof Number)) {
            object = Long.decode(object.toString());
        }
        return object == null ? 0L : ((Number)object).longValue();
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public String getNString(int n2) throws SQLException {
        return this.getString(n2);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(string);
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        return this.get(n2);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) {
        return null;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) {
        return null;
    }

    @Override
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public short getShort(int n2) throws SQLException {
        Object object = this.get(n2);
        if (object != null && !(object instanceof Number)) {
            object = Short.decode(object.toString());
        }
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public String getString(int n2) throws SQLException {
        Object object = this.get(n2);
        if (object == null) {
            return null;
        }
        switch (this.columns.get((int)(n2 - 1)).sqlType) {
            case 2005: {
                Clob clob = (Clob)object;
                return clob.getSubString(1L, MathUtils.convertLongToInt(clob.length()));
            }
        }
        return object.toString();
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        return (Time)this.get(n2);
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        return (Timestamp)this.get(n2);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        this.update(n2, (Object)array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.update(string, (Object)array);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.update(n2, (Object)inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.update(string, (Object)inputStream);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.update(n2, (Object)inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.update(string, (Object)inputStream);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.update(n2, (Object)inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.update(string, (Object)inputStream);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.update(n2, (Object)bigDecimal);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.update(string, (Object)bigDecimal);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.update(n2, (Object)inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.update(string, (Object)inputStream);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.update(n2, (Object)inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.update(string, (Object)inputStream);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.update(n2, (Object)inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.update(string, (Object)inputStream);
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.update(n2, (Object)blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.update(string, (Object)blob);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        this.update(n2, (Object)inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.update(string, (Object)inputStream);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        this.update(n2, (Object)inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        this.update(string, (Object)inputStream);
    }

    @Override
    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        this.update(n2, (Object)bl2);
    }

    @Override
    public void updateBoolean(String string, boolean bl2) throws SQLException {
        this.update(string, (Object)bl2);
    }

    @Override
    public void updateByte(int n2, byte by2) throws SQLException {
        this.update(n2, (Object)by2);
    }

    @Override
    public void updateByte(String string, byte by2) throws SQLException {
        this.update(string, (Object)by2);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.update(n2, (Object)byArray);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.update(string, (Object)byArray);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        this.update(n2, (Object)reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.update(string, (Object)reader);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.update(n2, (Object)reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.update(string, (Object)reader);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.update(n2, (Object)reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.update(string, (Object)reader);
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        this.update(n2, (Object)clob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.update(string, (Object)clob);
    }

    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        this.update(n2, (Object)reader);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.update(string, (Object)reader);
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        this.update(n2, (Object)reader);
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        this.update(string, (Object)reader);
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        this.update(n2, (Object)date);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.update(string, (Object)date);
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        this.update(n2, (Object)d2);
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        this.update(string, (Object)d2);
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        this.update(n2, (Object)Float.valueOf(f2));
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        this.update(string, (Object)Float.valueOf(f2));
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        this.update(n2, (Object)n3);
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        this.update(string, (Object)n2);
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        this.update(n2, (Object)l2);
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        this.update(string, (Object)l2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        this.update(n2, (Object)reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.update(string, (Object)reader);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.update(n2, (Object)reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.update(string, (Object)reader);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        this.update(n2, (Object)nClob);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.update(string, (Object)nClob);
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        this.update(n2, (Object)reader);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.update(string, (Object)reader);
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        this.update(n2, (Object)reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) throws SQLException {
        this.update(string, (Object)reader);
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        this.update(n2, (Object)string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.update(string, (Object)string2);
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        this.update(n2, null);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.update(string, null);
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        this.update(n2, object);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.update(string, object);
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.update(n2, object);
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.update(string, object);
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        this.update(n2, (Object)ref);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.update(string, (Object)ref);
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        this.update(n2, (Object)rowId);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.update(string, (Object)rowId);
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        this.update(n2, (Object)s2);
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        this.update(string, (Object)s2);
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.update(n2, (Object)sQLXML);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.update(string, (Object)sQLXML);
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        this.update(n2, (Object)string);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.update(string, (Object)string2);
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        this.update(n2, (Object)time);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.update(string, (Object)time);
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.update(n2, (Object)timestamp);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.update(string, (Object)timestamp);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getColumnDisplaySize(int n2) {
        return 15;
    }

    @Override
    public int getColumnType(int n2) throws SQLException {
        return this.getColumn((int)(n2 - 1)).sqlType;
    }

    @Override
    public int getPrecision(int n2) throws SQLException {
        return this.getColumn((int)(n2 - 1)).precision;
    }

    @Override
    public int getScale(int n2) throws SQLException {
        return this.getColumn((int)(n2 - 1)).scale;
    }

    @Override
    public int isNullable(int n2) {
        return 2;
    }

    @Override
    public boolean isAutoIncrement(int n2) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n2) {
        return true;
    }

    @Override
    public boolean isCurrency(int n2) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int n2) {
        return false;
    }

    @Override
    public boolean isReadOnly(int n2) {
        return true;
    }

    @Override
    public boolean isSearchable(int n2) {
        return true;
    }

    @Override
    public boolean isSigned(int n2) {
        return true;
    }

    @Override
    public boolean isWritable(int n2) {
        return false;
    }

    @Override
    public String getCatalogName(int n2) {
        return null;
    }

    @Override
    public String getColumnClassName(int n2) throws SQLException {
        int n3 = DataType.getValueTypeFromResultSet(this, n2);
        return DataType.getTypeClassName(n3);
    }

    @Override
    public String getColumnLabel(int n2) throws SQLException {
        return this.getColumn((int)(n2 - 1)).name;
    }

    @Override
    public String getColumnName(int n2) throws SQLException {
        return this.getColumnLabel(n2);
    }

    @Override
    public String getColumnTypeName(int n2) throws SQLException {
        return this.getColumn((int)(n2 - 1)).sqlTypeName;
    }

    @Override
    public String getSchemaName(int n2) {
        return null;
    }

    @Override
    public String getTableName(int n2) {
        return null;
    }

    @Override
    public void afterLast() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean first() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean isLast() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean last() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean previous() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    private void update(int n2, Object object) throws SQLException {
        this.checkColumnIndex(n2);
        this.currentRow[n2 - 1] = object;
    }

    private void update(String string, Object object) throws SQLException {
        this.currentRow[this.findColumn((String)string) - 1] = object;
    }

    static SQLException getUnsupportedException() {
        return DbException.get(50100).getSQLException();
    }

    private void checkColumnIndex(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.columns.size()) {
            throw DbException.getInvalidValueException("columnIndex", n2).getSQLException();
        }
    }

    private Object get(int n2) throws SQLException {
        if (this.currentRow == null) {
            throw DbException.get(2000).getSQLException();
        }
        this.checkColumnIndex(n2);
        Object object = --n2 < this.currentRow.length ? this.currentRow[n2] : null;
        this.wasNull = object == null;
        return object;
    }

    private Column getColumn(int n2) throws SQLException {
        this.checkColumnIndex(n2 + 1);
        return this.columns.get(n2);
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public boolean isClosed() {
        return this.rows == null && this.source == null;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    public void setAutoClose(boolean bl2) {
        this.autoClose = bl2;
    }

    public boolean getAutoClose() {
        return this.autoClose;
    }

    public static class SimpleArray
    implements Array {
        private final Object[] value;

        SimpleArray(Object[] objectArray) {
            this.value = objectArray;
        }

        @Override
        public Object getArray() {
            return this.value;
        }

        @Override
        public Object getArray(Map<String, Class<?>> map) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public Object getArray(long l2, int n2) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public Object getArray(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public int getBaseType() {
            return 0;
        }

        @Override
        public String getBaseTypeName() {
            return "NULL";
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public ResultSet getResultSet(long l2, int n2) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public ResultSet getResultSet(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public void free() {
        }
    }

    static class Column {
        String name;
        String sqlTypeName;
        int sqlType;
        int precision;
        int scale;

        Column() {
        }
    }
}

