/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.engine.Constants;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

public class RunScript
extends Tool {
    private boolean showResults;
    private boolean checkResults;

    public static void main(String ... stringArray) throws SQLException {
        new RunScript().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        String string = null;
        String string2 = "";
        String string3 = "";
        String string4 = "backup.sql";
        String string5 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; stringArray != null && i2 < stringArray.length; ++i2) {
            CharSequence charSequence;
            String string6 = stringArray[i2];
            if (string6.equals("-url")) {
                string = stringArray[++i2];
                continue;
            }
            if (string6.equals("-user")) {
                string2 = stringArray[++i2];
                continue;
            }
            if (string6.equals("-password")) {
                string3 = stringArray[++i2];
                continue;
            }
            if (string6.equals("-continueOnError")) {
                bl2 = true;
                continue;
            }
            if (string6.equals("-checkResults")) {
                this.checkResults = true;
                continue;
            }
            if (string6.equals("-showResults")) {
                this.showResults = true;
                continue;
            }
            if (string6.equals("-script")) {
                string4 = stringArray[++i2];
                continue;
            }
            if (string6.equals("-time")) {
                bl3 = true;
                continue;
            }
            if (string6.equals("-driver")) {
                charSequence = stringArray[++i2];
                JdbcUtils.loadUserClass((String)charSequence);
                continue;
            }
            if (string6.equals("-options")) {
                charSequence = new StringBuilder();
                ++i2;
                while (i2 < stringArray.length) {
                    ((StringBuilder)charSequence).append(' ').append(stringArray[i2]);
                    ++i2;
                }
                string5 = ((StringBuilder)charSequence).toString();
                continue;
            }
            if (string6.equals("-help") || string6.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(string6);
        }
        if (string == null) {
            this.showUsage();
            throw new SQLException("URL not set");
        }
        long l2 = System.currentTimeMillis();
        if (string5 != null) {
            RunScript.processRunscript(string, string2, string3, string4, string5);
        } else {
            this.process(string, string2, string3, string4, null, bl2);
        }
        if (bl3) {
            l2 = System.currentTimeMillis() - l2;
            this.out.println("Done in " + l2 + " ms");
        }
    }

    public static ResultSet execute(Connection connection, Reader reader) throws SQLException {
        String string;
        Statement statement = connection.createStatement();
        ResultSet resultSet = null;
        ScriptReader scriptReader = new ScriptReader(reader);
        while ((string = scriptReader.readStatement()) != null) {
            boolean bl2;
            if (string.trim().length() == 0 || !(bl2 = statement.execute(string))) continue;
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            resultSet = statement.getResultSet();
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Connection connection, String string, boolean bl2, Charset charset) throws SQLException, IOException {
        InputStream inputStream = FileUtils.newInputStream(string);
        String string2 = FileUtils.getParent(string);
        try {
            inputStream = new BufferedInputStream(inputStream, 4096);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
            this.process(connection, bl2, string2, inputStreamReader, charset);
        }
        finally {
            IOUtils.closeSilently(inputStream);
        }
    }

    private void process(Connection connection, boolean bl2, String string, Reader reader, Charset charset) throws SQLException, IOException {
        String string2;
        Statement statement = connection.createStatement();
        ScriptReader scriptReader = new ScriptReader(reader);
        while ((string2 = scriptReader.readStatement()) != null) {
            String string3 = string2.trim();
            if (string3.length() == 0) continue;
            if (string3.startsWith("@") && StringUtils.toUpperEnglish(string3).startsWith("@INCLUDE")) {
                string2 = string3;
                if (!FileUtils.isAbsolute(string2 = string2.substring("@INCLUDE".length()).trim())) {
                    string2 = string + SysProperties.FILE_SEPARATOR + string2;
                }
                this.process(connection, string2, bl2, charset);
                continue;
            }
            try {
                if (this.showResults && !string3.startsWith("-->")) {
                    this.out.print(string2 + ";");
                }
                if (this.showResults || this.checkResults) {
                    String string4;
                    boolean bl3 = statement.execute(string2);
                    if (!bl3) continue;
                    ResultSet resultSet = statement.getResultSet();
                    int n2 = resultSet.getMetaData().getColumnCount();
                    StringBuilder stringBuilder = new StringBuilder();
                    while (resultSet.next()) {
                        stringBuilder.append("\n-->");
                        for (int i2 = 0; i2 < n2; ++i2) {
                            string4 = resultSet.getString(i2 + 1);
                            if (string4 != null) {
                                string4 = StringUtils.replaceAll(string4, "\r\n", "\n");
                                string4 = StringUtils.replaceAll(string4, "\n", "\n-->    ");
                                string4 = StringUtils.replaceAll(string4, "\r", "\r-->    ");
                            }
                            stringBuilder.append(' ').append(string4);
                        }
                    }
                    stringBuilder.append("\n;");
                    String string5 = stringBuilder.toString();
                    if (this.showResults) {
                        this.out.print(string5);
                    }
                    if (!this.checkResults) continue;
                    string4 = scriptReader.readStatement() + ";";
                    string4 = StringUtils.replaceAll(string4, "\r\n", "\n");
                    if ((string4 = StringUtils.replaceAll(string4, "\r", "\n")).equals(string5)) continue;
                    string4 = StringUtils.replaceAll(string4, " ", "+");
                    string5 = StringUtils.replaceAll(string5, " ", "+");
                    throw new SQLException("Unexpected output for:\n" + string2.trim() + "\nGot:\n" + string5 + "\nExpected:\n" + string4);
                }
                statement.execute(string2);
            }
            catch (Exception exception) {
                if (bl2) {
                    exception.printStackTrace(this.out);
                    continue;
                }
                throw DbException.toSQLException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processRunscript(String string, String string2, String string3, String string4, String string5) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            Driver.load();
            connection = DriverManager.getConnection(string, string2, string3);
            statement = connection.createStatement();
            String string6 = "RUNSCRIPT FROM '" + string4 + "' " + string5;
            statement.execute(string6);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(statement);
            JdbcUtils.closeSilently(connection);
            throw throwable;
        }
        JdbcUtils.closeSilently(statement);
        JdbcUtils.closeSilently(connection);
    }

    public static void execute(String string, String string2, String string3, String string4, Charset charset, boolean bl2) throws SQLException {
        new RunScript().process(string, string2, string3, string4, charset, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(String string, String string2, String string3, String string4, Charset charset, boolean bl2) throws SQLException {
        try {
            Driver.load();
            Connection connection = DriverManager.getConnection(string, string2, string3);
            if (charset == null) {
                charset = Constants.UTF8;
            }
            try {
                this.process(connection, string4, bl2, charset);
            }
            finally {
                connection.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string4);
        }
    }
}

