/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CRC32;
import org.h2.api.JavaObjectSerializer;
import org.h2.compress.CompressLZF;
import org.h2.engine.Constants;
import org.h2.engine.MetaRecord;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreTool;
import org.h2.mvstore.StreamStore;
import org.h2.mvstore.db.TransactionStore;
import org.h2.mvstore.db.ValueDataType;
import org.h2.result.Row;
import org.h2.result.RowFactory;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.security.SHA256;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.DataReader;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.LobStorageBackend;
import org.h2.store.LobStorageMap;
import org.h2.store.PageFreeList;
import org.h2.store.PageLog;
import org.h2.store.PageStore;
import org.h2.store.fs.FileUtils;
import org.h2.util.BitField;
import org.h2.util.IOUtils;
import org.h2.util.IntArray;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.util.Tool;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;

public class Recover
extends Tool
implements DataHandler {
    private String databaseName;
    private int storageId;
    private String storageName;
    private int recordLength;
    private int valueId;
    private boolean trace;
    private boolean transactionLog;
    private ArrayList<MetaRecord> schema;
    private HashSet<Integer> objectIdSet;
    private HashMap<Integer, String> tableMap;
    private HashMap<String, String> columnTypeMap;
    private boolean remove;
    private int pageSize;
    private FileStore store;
    private int[] parents;
    private Stats stat;
    private boolean lobMaps;

    public static void main(String ... stringArray) throws SQLException {
        new Recover().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        String string = ".";
        String string2 = null;
        for (int i2 = 0; stringArray != null && i2 < stringArray.length; ++i2) {
            String string3 = stringArray[i2];
            if ("-dir".equals(string3)) {
                string = stringArray[++i2];
                continue;
            }
            if ("-db".equals(string3)) {
                string2 = stringArray[++i2];
                continue;
            }
            if ("-removePassword".equals(string3)) {
                this.remove = true;
                continue;
            }
            if ("-trace".equals(string3)) {
                this.trace = true;
                continue;
            }
            if ("-transactionLog".equals(string3)) {
                this.transactionLog = true;
                continue;
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(string3);
        }
        this.process(string, string2);
    }

    public static Reader readClob(String string) throws IOException {
        return new BufferedReader(new InputStreamReader(Recover.readBlob(string), Constants.UTF8));
    }

    public static InputStream readBlob(String string) throws IOException {
        return new BufferedInputStream(FileUtils.newInputStream(string));
    }

    public static Value.ValueBlob readBlobDb(Connection connection, long l2, long l3) {
        DataHandler dataHandler = ((JdbcConnection)connection).getSession().getDataHandler();
        Recover.verifyPageStore(dataHandler);
        return ValueLobDb.create(15, dataHandler, -2, l2, null, l3);
    }

    private static void verifyPageStore(DataHandler dataHandler) {
        if (dataHandler.getLobStorage() instanceof LobStorageMap) {
            throw DbException.get(50100, "Restore page store recovery SQL script can only be restored to a PageStore file");
        }
    }

    public static Value.ValueClob readClobDb(Connection connection, long l2, long l3) {
        DataHandler dataHandler = ((JdbcConnection)connection).getSession().getDataHandler();
        Recover.verifyPageStore(dataHandler);
        return ValueLobDb.create(16, dataHandler, -2, l2, null, l3);
    }

    public static InputStream readBlobMap(Connection connection, long l2, long l3) throws SQLException {
        final PreparedStatement preparedStatement = connection.prepareStatement("SELECT DATA FROM INFORMATION_SCHEMA.LOB_BLOCKS WHERE LOB_ID = ? AND SEQ = ? AND ? > 0");
        preparedStatement.setLong(1, l2);
        preparedStatement.setLong(3, l3);
        return new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
            private int seq;
            private byte[] data = this.fetch();

            private byte[] fetch() {
                try {
                    preparedStatement.setInt(2, this.seq++);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        return resultSet.getBytes(1);
                    }
                    return null;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }

            @Override
            public boolean hasMoreElements() {
                return this.data != null;
            }

            @Override
            public InputStream nextElement() {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
                this.data = this.fetch();
                return byteArrayInputStream;
            }
        });
    }

    public static Reader readClobMap(Connection connection, long l2, long l3) throws Exception {
        InputStream inputStream = Recover.readBlobMap(connection, l2, l3);
        return new BufferedReader(new InputStreamReader(inputStream, Constants.UTF8));
    }

    private void trace(String string) {
        if (this.trace) {
            this.out.println(string);
        }
    }

    private void traceError(String string, Throwable throwable) {
        this.out.println(string + ": " + throwable.toString());
        if (this.trace) {
            throwable.printStackTrace(this.out);
        }
    }

    public static void execute(String string, String string2) throws SQLException {
        try {
            new Recover().process(string, string2);
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    private void process(String string, String string2) {
        ArrayList<String> arrayList = FileLister.getDatabaseFiles(string, string2, true);
        if (arrayList.size() == 0) {
            this.printNoDatabaseFilesFound(string, string2);
        }
        for (String string3 : arrayList) {
            if (string3.endsWith(".h2.db")) {
                this.dumpPageStore(string3);
                continue;
            }
            if (string3.endsWith(".lob.db")) {
                this.dumpLob(string3, false);
                continue;
            }
            if (!string3.endsWith(".mv.db")) continue;
            String string4 = string3.substring(0, string3.length() - ".h2.db".length());
            PrintWriter printWriter = this.getWriter(string3, ".txt");
            MVStoreTool.dump(string3, printWriter, true);
            MVStoreTool.info(string3, printWriter);
            printWriter.close();
            printWriter = this.getWriter(string4 + ".h2.db", ".sql");
            this.dumpMVStoreFile(printWriter, string3);
            printWriter.close();
        }
    }

    private PrintWriter getWriter(String string, String string2) {
        string = string.substring(0, string.length() - 3);
        String string3 = string + string2;
        this.trace("Created file: " + string3);
        try {
            return new PrintWriter(IOUtils.getBufferedWriter(FileUtils.newOutputStream(string3, false)));
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private void writeDataError(PrintWriter printWriter, String string, byte[] byArray) {
        int n2;
        int n3;
        printWriter.println("-- ERROR: " + string + " storageId: " + this.storageId + " recordLength: " + this.recordLength + " valueId: " + this.valueId);
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n2 = byArray[n3] & 0xFF;
            if (n2 >= 32 && n2 < 128) {
                stringBuilder.append((char)n2);
                continue;
            }
            stringBuilder.append('?');
        }
        printWriter.println("-- dump: " + stringBuilder.toString());
        stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n2 = byArray[n3] & 0xFF;
            stringBuilder.append(' ');
            if (n2 < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n2));
        }
        printWriter.println("-- dump: " + stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dumpLob(String string, boolean bl2) {
        OutputStream outputStream = null;
        FileStore fileStore = null;
        long l2 = 0L;
        String string2 = string + (bl2 ? ".comp" : "") + ".txt";
        FileStoreInputStream fileStoreInputStream = null;
        try {
            outputStream = FileUtils.newOutputStream(string2, false);
            fileStore = FileStore.open(null, string, "r");
            fileStore.init();
            fileStoreInputStream = new FileStoreInputStream(fileStore, this, bl2, false);
            l2 = IOUtils.copy(fileStoreInputStream, outputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(outputStream);
            IOUtils.closeSilently(fileStoreInputStream);
            Recover.closeSilently(fileStore);
            catch (Throwable throwable2) {
                IOUtils.closeSilently(outputStream);
                IOUtils.closeSilently(fileStoreInputStream);
                Recover.closeSilently(fileStore);
                throw throwable2;
            }
        }
        IOUtils.closeSilently(outputStream);
        IOUtils.closeSilently(fileStoreInputStream);
        Recover.closeSilently(fileStore);
        if (l2 == 0L) {
            try {
                FileUtils.delete(string2);
            }
            catch (Exception exception) {
                this.traceError(string2, exception);
            }
        }
    }

    private String getSQL(String string, Value value) {
        ValueLobDb valueLobDb;
        byte[] byArray;
        if (value instanceof ValueLob) {
            ValueLob valueLob = (ValueLob)value;
            byte[] byArray2 = valueLob.getSmall();
            if (byArray2 == null) {
                String string2;
                String string3 = valueLob.getFileName();
                String string4 = string2 = valueLob.getType() == 15 ? "BLOB" : "CLOB";
                if (valueLob.isCompressed()) {
                    this.dumpLob(string3, true);
                    string3 = string3 + ".comp";
                }
                return "READ_" + string2 + "('" + string3 + ".txt')";
            }
        } else if (value instanceof ValueLobDb && (byArray = (valueLobDb = (ValueLobDb)value).getSmall()) == null) {
            String string5;
            String string6;
            int n2 = valueLobDb.getType();
            long l2 = valueLobDb.getLobId();
            long l3 = valueLobDb.getPrecision();
            if (n2 == 15) {
                string6 = "BLOB";
                string5 = "READ_BLOB";
            } else {
                string6 = "CLOB";
                string5 = "READ_CLOB";
            }
            string5 = this.lobMaps ? string5 + "_MAP" : string5 + "_DB";
            this.columnTypeMap.put(string, string6);
            return string5 + "(" + l2 + ", " + l3 + ")";
        }
        return value.getSQL();
    }

    private void setDatabaseName(String string) {
        this.databaseName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpPageStore(String string) {
        this.setDatabaseName(string.substring(0, string.length() - ".h2.db".length()));
        PrintWriter printWriter = null;
        this.stat = new Stats();
        try {
            int n2;
            int n3;
            printWriter = this.getWriter(string, ".sql");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_DB FOR \"" + this.getClass().getName() + ".readBlobDb\";");
            printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_DB FOR \"" + this.getClass().getName() + ".readClobDb\";");
            this.resetSchema();
            this.store = FileStore.open(null, string, this.remove ? "rw" : "r");
            long l2 = this.store.length();
            try {
                this.store.init();
            }
            catch (Exception exception) {
                this.writeError(printWriter, exception);
            }
            Data data = Data.create((DataHandler)this, 128);
            this.seek(0L);
            this.store.readFully(data.getBytes(), 0, 128);
            data.setPos(48);
            this.pageSize = data.readInt();
            byte by2 = data.readByte();
            byte by3 = data.readByte();
            printWriter.println("-- pageSize: " + this.pageSize + " writeVersion: " + by2 + " readVersion: " + by3);
            if (this.pageSize < 64 || this.pageSize > 32768) {
                this.pageSize = 4096;
                printWriter.println("-- ERROR: page size; using " + this.pageSize);
            }
            long l3 = l2 / (long)this.pageSize;
            this.parents = new int[(int)l3];
            data = Data.create((DataHandler)this, this.pageSize);
            for (long i2 = 3L; i2 < l3; ++i2) {
                data.reset();
                this.seek(i2);
                this.store.readFully(data.getBytes(), 0, 32);
                data.readByte();
                data.readShortInt();
                this.parents[(int)i2] = data.readInt();
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            data = Data.create((DataHandler)this, this.pageSize);
            for (long i3 = 1L; i3 != 3L; ++i3) {
                data.reset();
                this.seek(i3);
                this.store.readFully(data.getBytes(), 0, this.pageSize);
                CRC32 cRC32 = new CRC32();
                cRC32.update(data.getBytes(), 4, this.pageSize - 4);
                n3 = (int)cRC32.getValue();
                n2 = data.readInt();
                long l4 = data.readLong();
                int n7 = data.readInt();
                int n8 = data.readInt();
                int n9 = data.readInt();
                if (n3 == n2) {
                    n4 = n7;
                    n5 = n8;
                    n6 = n9;
                }
                printWriter.println("-- head " + i3 + ": writeCounter: " + l4 + " log " + n7 + ":" + n8 + "/" + n9 + " crc " + n2 + " (" + (n3 == n2 ? "ok" : "expected: " + n3) + ")");
            }
            printWriter.println("-- log " + n4 + ":" + n5 + "/" + n6);
            PrintWriter printWriter2 = new PrintWriter(new OutputStream(){

                @Override
                public void write(int n2) {
                }
            });
            this.dumpPageStore(printWriter2, l3);
            this.stat = new Stats();
            this.schema.clear();
            this.objectIdSet = New.hashSet();
            this.dumpPageStore(printWriter, l3);
            this.writeSchema(printWriter);
            try {
                this.dumpPageLogStream(printWriter, n4, n5, n6, l3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            printWriter.println("---- Statistics ----");
            printWriter.println("-- page count: " + l3 + ", free: " + this.stat.free);
            long l5 = Math.max(1L, this.stat.pageDataRows + this.stat.pageDataEmpty + this.stat.pageDataHead);
            printWriter.println("-- page data bytes: head " + this.stat.pageDataHead + ", empty " + this.stat.pageDataEmpty + ", rows " + this.stat.pageDataRows + " (" + (100L - 100L * this.stat.pageDataEmpty / l5) + "% full)");
            for (n3 = 0; n3 < this.stat.pageTypeCount.length; ++n3) {
                n2 = this.stat.pageTypeCount[n3];
                if (n2 <= 0) continue;
                printWriter.println("-- " + Recover.getPageType(n3) + " " + (long)(100 * n2) / l3 + "%, " + n2 + " page(s)");
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            try {
                this.writeError(printWriter, throwable);
            }
            catch (Throwable throwable2) {
                IOUtils.closeSilently(printWriter);
                Recover.closeSilently(this.store);
                throw throwable2;
            }
            IOUtils.closeSilently(printWriter);
            Recover.closeSilently(this.store);
        }
        IOUtils.closeSilently(printWriter);
        Recover.closeSilently(this.store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMVStoreFile(PrintWriter printWriter, String string) {
        printWriter.println("-- MVStore");
        printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB FOR \"" + this.getClass().getName() + ".readBlob\";");
        printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB FOR \"" + this.getClass().getName() + ".readClob\";");
        printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_DB FOR \"" + this.getClass().getName() + ".readBlobDb\";");
        printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_DB FOR \"" + this.getClass().getName() + ".readClobDb\";");
        printWriter.println("CREATE ALIAS IF NOT EXISTS READ_BLOB_MAP FOR \"" + this.getClass().getName() + ".readBlobMap\";");
        printWriter.println("CREATE ALIAS IF NOT EXISTS READ_CLOB_MAP FOR \"" + this.getClass().getName() + ".readClobMap\";");
        this.resetSchema();
        this.setDatabaseName(string.substring(0, string.length() - ".mv.db".length()));
        MVStore mVStore = new MVStore.Builder().fileName(string).readOnly().open();
        this.dumpLobMaps(printWriter, mVStore);
        printWriter.println("-- Meta");
        Recover.dumpMeta(printWriter, mVStore);
        printWriter.println("-- Tables");
        TransactionStore transactionStore = new TransactionStore(mVStore);
        try {
            transactionStore.init();
        }
        catch (Throwable throwable) {
            this.writeError(printWriter, throwable);
        }
        try {
            for (String string2 : mVStore.getMapNames()) {
                if (!string2.startsWith("table.")) continue;
                String string3 = string2.substring("table.".length());
                ValueDataType valueDataType = new ValueDataType(null, this, null);
                ValueDataType valueDataType2 = new ValueDataType(null, this, null);
                TransactionStore.TransactionMap transactionMap = transactionStore.begin().openMap(string2, valueDataType, valueDataType2);
                Iterator<Object> iterator = transactionMap.keyIterator(null);
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    Object object;
                    CharSequence charSequence;
                    Value value = iterator.next();
                    Value[] valueArray = ((ValueArray)transactionMap.get(value)).getList();
                    this.recordLength = valueArray.length;
                    if (!bl2) {
                        this.setStorage(Integer.parseInt(string3));
                        this.valueId = 0;
                        while (this.valueId < this.recordLength) {
                            charSequence = this.storageName + "." + this.valueId;
                            this.getSQL((String)charSequence, valueArray[this.valueId]);
                            ++this.valueId;
                        }
                        this.createTemporaryTable(printWriter);
                        bl2 = true;
                    }
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("INSERT INTO O_").append(string3).append(" VALUES(");
                    this.valueId = 0;
                    while (this.valueId < this.recordLength) {
                        if (this.valueId > 0) {
                            ((StringBuilder)charSequence).append(", ");
                        }
                        object = this.storageName + "." + this.valueId;
                        ((StringBuilder)charSequence).append(this.getSQL((String)object, valueArray[this.valueId]));
                        ++this.valueId;
                    }
                    ((StringBuilder)charSequence).append(");");
                    printWriter.println(((StringBuilder)charSequence).toString());
                    if (this.storageId != 0) continue;
                    try {
                        object = new SimpleRow(valueArray);
                        MetaRecord metaRecord = new MetaRecord((SearchRow)object);
                        this.schema.add(metaRecord);
                        if (metaRecord.getObjectType() != 0) continue;
                        String string4 = valueArray[3].getString();
                        String string5 = Recover.extractTableOrViewName(string4);
                        this.tableMap.put(metaRecord.getId(), string5);
                    }
                    catch (Throwable throwable) {
                        this.writeError(printWriter, throwable);
                    }
                }
            }
            this.writeSchema(printWriter);
            printWriter.println("DROP ALIAS READ_BLOB_MAP;");
            printWriter.println("DROP ALIAS READ_CLOB_MAP;");
            printWriter.println("DROP TABLE IF EXISTS INFORMATION_SCHEMA.LOB_BLOCKS;");
        }
        catch (Throwable throwable) {
            this.writeError(printWriter, throwable);
        }
        finally {
            mVStore.close();
        }
    }

    private static void dumpMeta(PrintWriter printWriter, MVStore mVStore) {
        MVMap<String, String> mVMap = mVStore.getMetaMap();
        for (Map.Entry<String, String> entry : mVMap.entrySet()) {
            printWriter.println("-- " + entry.getKey() + " = " + entry.getValue());
        }
    }

    private void dumpLobMaps(PrintWriter printWriter, MVStore mVStore) {
        this.lobMaps = mVStore.hasMap("lobData");
        if (!this.lobMaps) {
            return;
        }
        MVMap<Long, byte[]> mVMap = mVStore.openMap("lobData");
        StreamStore streamStore = new StreamStore(mVMap);
        MVMap mVMap2 = mVStore.openMap("lobMap");
        printWriter.println("-- LOB");
        printWriter.println("CREATE TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_BLOCKS(LOB_ID BIGINT, SEQ INT, DATA BINARY, PRIMARY KEY(LOB_ID, SEQ));");
        boolean bl2 = false;
        block2: for (Map.Entry object : mVMap2.entrySet()) {
            long l2 = (Long)object.getKey();
            Object[] objectArray = (Object[])object.getValue();
            byte[] byArray = (byte[])objectArray[0];
            InputStream inputStream = streamStore.get(byArray);
            int n2 = 8192;
            byte[] byArray2 = new byte[n2];
            try {
                int n3 = 0;
                while (true) {
                    int n4 = IOUtils.readFully(inputStream, byArray2, byArray2.length);
                    String string = StringUtils.convertBytesToHex(byArray2, n4);
                    if (n4 > 0) {
                        printWriter.println("INSERT INTO INFORMATION_SCHEMA.LOB_BLOCKS VALUES(" + l2 + ", " + n3 + ", '" + string + "');");
                    }
                    if (n4 != n2) continue block2;
                    ++n3;
                }
            }
            catch (IOException iOException) {
                this.writeError(printWriter, iOException);
                bl2 = true;
            }
        }
        printWriter.println("-- lobMap.size: " + mVMap2.sizeAsLong());
        printWriter.println("-- lobData.size: " + mVMap.sizeAsLong());
        if (bl2) {
            printWriter.println("-- lobMap");
            for (Long l3 : mVMap2.keyList()) {
                Object[] objectArray = (Object[])mVMap2.get(l3);
                byte[] byArray = (byte[])objectArray[0];
                printWriter.println("--     " + l3 + " " + StreamStore.toString(byArray));
            }
            printWriter.println("-- lobData");
            for (Long l4 : mVMap.keyList()) {
                printWriter.println("--     " + l4 + " len " + mVMap.get(l4).length);
            }
        }
    }

    private static String getPageType(int n2) {
        switch (n2) {
            case 0: {
                return "free";
            }
            case 1: {
                return "data leaf";
            }
            case 2: {
                return "data node";
            }
            case 3: {
                return "data overflow";
            }
            case 4: {
                return "btree leaf";
            }
            case 5: {
                return "btree node";
            }
            case 6: {
                return "free list";
            }
            case 7: {
                return "stream trunk";
            }
            case 8: {
                return "stream data";
            }
        }
        return "[" + n2 + "]";
    }

    private void dumpPageStore(PrintWriter printWriter, long l2) {
        Data data = Data.create((DataHandler)this, this.pageSize);
        for (long i2 = 3L; i2 < l2; ++i2) {
            data = Data.create((DataHandler)this, this.pageSize);
            this.seek(i2);
            this.store.readFully(data.getBytes(), 0, this.pageSize);
            this.dumpPage(printWriter, data, i2, l2);
        }
    }

    private void dumpPage(PrintWriter printWriter, Data data, long l2, long l3) {
        try {
            int n2 = data.readByte();
            switch (n2) {
                case 0: {
                    int n3 = n2;
                    this.stat.pageTypeCount[n3] = this.stat.pageTypeCount[n3] + 1;
                    return;
                }
            }
            boolean bl2 = (n2 & 0x10) != 0;
            n2 &= 0xFFFFFFEF;
            if (!PageStore.checksumTest(data.getBytes(), (int)l2, this.pageSize)) {
                this.writeDataError(printWriter, "checksum mismatch type: " + n2, data.getBytes());
            }
            data.readShortInt();
            switch (n2) {
                case 1: {
                    int n4 = n2;
                    this.stat.pageTypeCount[n4] = this.stat.pageTypeCount[n4] + 1;
                    int n5 = data.readInt();
                    this.setStorage(data.readVarInt());
                    int n6 = data.readVarInt();
                    short s2 = data.readShortInt();
                    printWriter.println("-- page " + l2 + ": data leaf " + (bl2 ? "(last) " : "") + "parent: " + n5 + " table: " + this.storageId + " entries: " + s2 + " columns: " + n6);
                    this.dumpPageDataLeaf(printWriter, data, bl2, l2, n6, s2);
                    break;
                }
                case 2: {
                    int n7 = n2;
                    this.stat.pageTypeCount[n7] = this.stat.pageTypeCount[n7] + 1;
                    int n8 = data.readInt();
                    this.setStorage(data.readVarInt());
                    int n9 = data.readInt();
                    short s3 = data.readShortInt();
                    printWriter.println("-- page " + l2 + ": data node " + (bl2 ? "(last) " : "") + "parent: " + n8 + " table: " + this.storageId + " entries: " + s3 + " rowCount: " + n9);
                    this.dumpPageDataNode(printWriter, data, l2, s3);
                    break;
                }
                case 3: {
                    int n10 = n2;
                    this.stat.pageTypeCount[n10] = this.stat.pageTypeCount[n10] + 1;
                    printWriter.println("-- page " + l2 + ": data overflow " + (bl2 ? "(last) " : ""));
                    break;
                }
                case 4: {
                    int n11 = n2;
                    this.stat.pageTypeCount[n11] = this.stat.pageTypeCount[n11] + 1;
                    int n12 = data.readInt();
                    this.setStorage(data.readVarInt());
                    short s4 = data.readShortInt();
                    printWriter.println("-- page " + l2 + ": b-tree leaf " + (bl2 ? "(last) " : "") + "parent: " + n12 + " index: " + this.storageId + " entries: " + s4);
                    if (this.trace) {
                        this.dumpPageBtreeLeaf(printWriter, data, s4, !bl2);
                    }
                    break;
                }
                case 5: {
                    int n13 = n2;
                    this.stat.pageTypeCount[n13] = this.stat.pageTypeCount[n13] + 1;
                    int n14 = data.readInt();
                    this.setStorage(data.readVarInt());
                    printWriter.println("-- page " + l2 + ": b-tree node " + (bl2 ? "(last) " : "") + "parent: " + n14 + " index: " + this.storageId);
                    this.dumpPageBtreeNode(printWriter, data, l2, !bl2);
                    break;
                }
                case 6: {
                    int n15 = n2;
                    this.stat.pageTypeCount[n15] = this.stat.pageTypeCount[n15] + 1;
                    printWriter.println("-- page " + l2 + ": free list " + (bl2 ? "(last)" : ""));
                    this.stat.free += this.dumpPageFreeList(printWriter, data, l2, l3);
                    break;
                }
                case 7: {
                    int n16 = n2;
                    this.stat.pageTypeCount[n16] = this.stat.pageTypeCount[n16] + 1;
                    printWriter.println("-- page " + l2 + ": log trunk");
                    break;
                }
                case 8: {
                    int n17 = n2;
                    this.stat.pageTypeCount[n17] = this.stat.pageTypeCount[n17] + 1;
                    printWriter.println("-- page " + l2 + ": log data");
                    break;
                }
                default: {
                    printWriter.println("-- ERROR page " + l2 + " unknown type " + n2);
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.writeError(printWriter, exception);
        }
    }

    private void dumpPageLogStream(PrintWriter printWriter, int n2, int n3, int n4, long l2) throws IOException {
        byte by2;
        Data data = Data.create((DataHandler)this, this.pageSize);
        DataReader dataReader = new DataReader(new PageInputStream(printWriter, this, this.store, n2, n3, n4, this.pageSize));
        printWriter.println("---- Transaction log ----");
        CompressLZF compressLZF = new CompressLZF();
        while ((by2 = dataReader.readByte()) >= 0) {
            Object object;
            int n5;
            if (by2 == 0) continue;
            if (by2 == 1) {
                Object object2;
                n5 = dataReader.readVarInt();
                int n6 = dataReader.readVarInt();
                object = new byte[this.pageSize];
                if (n6 == 0) {
                    dataReader.readFully((byte[])object, this.pageSize);
                } else if (n6 != 1) {
                    object2 = new byte[n6];
                    dataReader.readFully((byte[])object2, n6);
                    try {
                        compressLZF.expand((byte[])object2, 0, n6, (byte[])object, 0, this.pageSize);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw DbException.convertToIOException(arrayIndexOutOfBoundsException);
                    }
                }
                object2 = "";
                int n7 = object[0];
                boolean bl2 = (n7 & 0x10) != 0;
                switch (n7 &= 0xFFFFFFEF) {
                    case 0: {
                        object2 = "empty";
                        break;
                    }
                    case 1: {
                        object2 = "data leaf " + (bl2 ? "(last)" : "");
                        break;
                    }
                    case 2: {
                        object2 = "data node " + (bl2 ? "(last)" : "");
                        break;
                    }
                    case 3: {
                        object2 = "data overflow " + (bl2 ? "(last)" : "");
                        break;
                    }
                    case 4: {
                        object2 = "b-tree leaf " + (bl2 ? "(last)" : "");
                        break;
                    }
                    case 5: {
                        object2 = "b-tree node " + (bl2 ? "(last)" : "");
                        break;
                    }
                    case 6: {
                        object2 = "free list " + (bl2 ? "(last)" : "");
                        break;
                    }
                    case 7: {
                        object2 = "log trunk";
                        break;
                    }
                    case 8: {
                        object2 = "log data";
                        break;
                    }
                    default: {
                        object2 = "ERROR: unknown type " + n7;
                    }
                }
                printWriter.println("-- undo page " + n5 + " " + (String)object2);
                if (!this.trace) continue;
                Data data2 = Data.create(null, object);
                this.dumpPage(printWriter, data2, n5, l2);
                continue;
            }
            if (by2 == 5) {
                n5 = dataReader.readVarInt();
                this.setStorage(dataReader.readVarInt());
                Row row = PageLog.readRow(RowFactory.DEFAULT, dataReader, data);
                printWriter.println("-- session " + n5 + " table " + this.storageId + " + " + row.toString());
                if (!this.transactionLog) continue;
                if (this.storageId == 0 && row.getColumnCount() >= 4) {
                    int n8 = (int)row.getKey();
                    String string = row.getValue(3).getString();
                    String string2 = Recover.extractTableOrViewName(string);
                    if (row.getValue(2).getInt() == 0) {
                        this.tableMap.put(n8, string2);
                    }
                    printWriter.println(string + ";");
                    continue;
                }
                object = this.tableMap.get(this.storageId);
                if (object == null) continue;
                StatementBuilder statementBuilder = new StatementBuilder();
                statementBuilder.append("INSERT INTO ").append((String)object).append(" VALUES(");
                for (int i2 = 0; i2 < row.getColumnCount(); ++i2) {
                    statementBuilder.appendExceptFirst(", ");
                    statementBuilder.append(row.getValue(i2).getSQL());
                }
                statementBuilder.append(");");
                printWriter.println(statementBuilder.toString());
                continue;
            }
            if (by2 == 6) {
                n5 = dataReader.readVarInt();
                this.setStorage(dataReader.readVarInt());
                long l3 = dataReader.readVarLong();
                printWriter.println("-- session " + n5 + " table " + this.storageId + " - " + l3);
                if (!this.transactionLog) continue;
                if (this.storageId == 0) {
                    int n9 = (int)l3;
                    String string = this.tableMap.get(n9);
                    if (string == null) continue;
                    printWriter.println("DROP TABLE IF EXISTS " + string + ";");
                    continue;
                }
                String string = this.tableMap.get(this.storageId);
                if (string == null) continue;
                String string3 = "DELETE FROM " + string + " WHERE _ROWID_ = " + l3 + ";";
                printWriter.println(string3);
                continue;
            }
            if (by2 == 7) {
                n5 = dataReader.readVarInt();
                this.setStorage(dataReader.readVarInt());
                printWriter.println("-- session " + n5 + " table " + this.storageId + " truncate");
                if (!this.transactionLog) continue;
                printWriter.println("TRUNCATE TABLE " + this.storageId);
                continue;
            }
            if (by2 == 2) {
                n5 = dataReader.readVarInt();
                printWriter.println("-- commit " + n5);
                continue;
            }
            if (by2 == 4) {
                n5 = dataReader.readVarInt();
                printWriter.println("-- rollback " + n5);
                continue;
            }
            if (by2 == 3) {
                n5 = dataReader.readVarInt();
                String string = dataReader.readString();
                printWriter.println("-- prepare commit " + n5 + " " + string);
                continue;
            }
            if (by2 == 0) continue;
            if (by2 == 8) {
                printWriter.println("-- checkpoint");
                continue;
            }
            if (by2 == 9) {
                n5 = dataReader.readVarInt();
                StringBuilder stringBuilder = new StringBuilder("-- free");
                for (int i3 = 0; i3 < n5; ++i3) {
                    stringBuilder.append(' ').append(dataReader.readVarInt());
                }
                printWriter.println(stringBuilder);
                continue;
            }
            printWriter.println("-- ERROR: unknown operation " + by2);
            break;
        }
    }

    private String setStorage(int n2) {
        this.storageId = n2;
        this.storageName = "O_" + String.valueOf(n2).replace('-', 'M');
        return this.storageName;
    }

    private void dumpPageBtreeNode(PrintWriter printWriter, Data data, long l2, boolean bl2) {
        int n2;
        int n3;
        int n4 = data.readInt();
        int n5 = data.readShortInt();
        int[] nArray = new int[n5 + 1];
        int[] nArray2 = new int[n5];
        nArray[n5] = data.readInt();
        this.checkParent(printWriter, l2, nArray, n5);
        int n6 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < n5; ++n3) {
            nArray[n3] = data.readInt();
            this.checkParent(printWriter, l2, nArray, n3);
            n2 = data.readShortInt();
            n6 = Math.min(n2, n6);
            nArray2[n3] = n2;
        }
        n6 -= data.length();
        if (!this.trace) {
            return;
        }
        printWriter.println("--   empty: " + n6);
        for (n3 = 0; n3 < n5; ++n3) {
            Value value;
            n2 = nArray2[n3];
            data.setPos(n2);
            long l3 = data.readVarLong();
            if (bl2) {
                value = ValueLong.get(l3);
            } else {
                try {
                    value = data.readValue();
                }
                catch (Throwable throwable) {
                    this.writeDataError(printWriter, "exception " + throwable, data.getBytes());
                    continue;
                }
            }
            printWriter.println("-- [" + n3 + "] child: " + nArray[n3] + " key: " + l3 + " data: " + value);
        }
        printWriter.println("-- [" + n5 + "] child: " + nArray[n5] + " rowCount: " + n4);
    }

    private int dumpPageFreeList(PrintWriter printWriter, Data data, long l2, long l3) {
        int n2;
        int n3 = PageFreeList.getPagesAddressed(this.pageSize);
        BitField bitField = new BitField();
        for (n2 = 0; n2 < n3; n2 += 8) {
            int n4 = data.readByte() & 0xFF;
            for (int i2 = 0; i2 < 8; ++i2) {
                if ((n4 & 1 << i2) == 0) continue;
                bitField.set(n2 + i2);
            }
        }
        n2 = 0;
        long l4 = 0L;
        for (long i3 = l2; l4 < (long)n3 && i3 < l3; ++l4, ++i3) {
            if (l4 == 0L || i3 % 100L == 0L) {
                if (l4 > 0L) {
                    printWriter.println();
                }
                printWriter.print("-- " + i3 + " ");
            } else if (i3 % 20L == 0L) {
                printWriter.print(" - ");
            } else if (i3 % 10L == 0L) {
                printWriter.print(' ');
            }
            printWriter.print(bitField.get((int)l4) ? (char)'1' : '0');
            if (bitField.get((int)l4)) continue;
            ++n2;
        }
        printWriter.println();
        return n2;
    }

    private void dumpPageBtreeLeaf(PrintWriter printWriter, Data data, int n2, boolean bl2) {
        int n3;
        int n4;
        int[] nArray = new int[n2];
        int n5 = Integer.MAX_VALUE;
        for (n4 = 0; n4 < n2; ++n4) {
            n3 = data.readShortInt();
            n5 = Math.min(n3, n5);
            nArray[n4] = n3;
        }
        printWriter.println("--   empty: " + (n5 -= data.length()));
        for (n4 = 0; n4 < n2; ++n4) {
            Value value;
            n3 = nArray[n4];
            data.setPos(n3);
            long l2 = data.readVarLong();
            if (bl2) {
                value = ValueLong.get(l2);
            } else {
                try {
                    value = data.readValue();
                }
                catch (Throwable throwable) {
                    this.writeDataError(printWriter, "exception " + throwable, data.getBytes());
                    continue;
                }
            }
            printWriter.println("-- [" + n4 + "] key: " + l2 + " data: " + value);
        }
    }

    private void checkParent(PrintWriter printWriter, long l2, int[] nArray, int n2) {
        int n3 = nArray[n2];
        if (n3 < 0 || n3 >= this.parents.length) {
            printWriter.println("-- ERROR [" + l2 + "] child[" + n2 + "]: " + n3 + " >= page count: " + this.parents.length);
        } else if ((long)this.parents[n3] != l2) {
            printWriter.println("-- ERROR [" + l2 + "] child[" + n2 + "]: " + n3 + " parent: " + this.parents[n3]);
        }
    }

    private void dumpPageDataNode(PrintWriter printWriter, Data data, long l2, int n2) {
        int n3;
        int[] nArray = new int[n2 + 1];
        long[] lArray = new long[n2];
        nArray[n2] = data.readInt();
        this.checkParent(printWriter, l2, nArray, n2);
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = data.readInt();
            this.checkParent(printWriter, l2, nArray, n3);
            lArray[n3] = data.readVarLong();
        }
        if (!this.trace) {
            return;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.println("-- [" + n3 + "] child: " + nArray[n3] + " key: " + lArray[n3]);
        }
        printWriter.println("-- [" + n2 + "] child: " + nArray[n2]);
    }

    private void dumpPageDataLeaf(PrintWriter printWriter, Data data, boolean bl2, long l2, int n2, int n3) {
        int n4;
        int n5;
        int[] nArray;
        long[] lArray;
        block12: {
            lArray = new long[n3];
            nArray = new int[n3];
            long l3 = 0L;
            if (!bl2) {
                l3 = data.readInt();
                printWriter.println("--   next: " + l3);
            }
            int n6 = this.pageSize;
            for (n5 = 0; n5 < n3; ++n5) {
                lArray[n5] = data.readVarLong();
                short s2 = data.readShortInt();
                n6 = Math.min(s2, n6);
                nArray[n5] = s2;
            }
            this.stat.pageDataRows += (long)(this.pageSize - n6);
            this.stat.pageDataHead += (long)data.length();
            this.stat.pageDataEmpty += (long)(n6 -= data.length());
            if (this.trace) {
                printWriter.println("--   empty: " + n6);
            }
            if (!bl2) {
                Data data2 = Data.create((DataHandler)this, this.pageSize);
                data.setPos(this.pageSize);
                long l4 = l2;
                while (true) {
                    int n7;
                    this.checkParent(printWriter, l4, new int[]{(int)l3}, 0);
                    l4 = l3;
                    this.seek(l3);
                    this.store.readFully(data2.getBytes(), 0, this.pageSize);
                    data2.reset();
                    n4 = data2.readByte();
                    data2.readShortInt();
                    data2.readInt();
                    if (n4 == 19) {
                        n7 = data2.readShortInt();
                        printWriter.println("-- chain: " + l3 + " type: " + n4 + " size: " + n7);
                        data.checkCapacity(n7);
                        data.write(data2.getBytes(), data2.length(), n7);
                        break block12;
                    }
                    if (n4 != 3) break;
                    l3 = data2.readInt();
                    if (l3 == 0L) {
                        this.writeDataError(printWriter, "next:0", data2.getBytes());
                        break block12;
                    }
                    n7 = this.pageSize - data2.length();
                    printWriter.println("-- chain: " + l3 + " type: " + n4 + " size: " + n7 + " next: " + l3);
                    data.checkCapacity(n7);
                    data.write(data2.getBytes(), data2.length(), n7);
                }
                this.writeDataError(printWriter, "type: " + n4, data2.getBytes());
            }
        }
        for (n5 = 0; n5 < n3; ++n5) {
            int n8;
            String string;
            long l5 = lArray[n5];
            n4 = nArray[n5];
            if (this.trace) {
                printWriter.println("-- [" + n5 + "] storage: " + this.storageId + " key: " + l5 + " off: " + n4);
            }
            data.setPos(n4);
            Value[] valueArray = this.createRecord(printWriter, data, n2);
            if (valueArray == null) continue;
            this.createTemporaryTable(printWriter);
            this.writeRow(printWriter, data, valueArray);
            if (!this.remove || this.storageId != 0 || !(string = valueArray[3].getString()).startsWith("CREATE USER ") || (n8 = Utils.indexOf(data.getBytes(), "SALT ".getBytes(), n4)) < 0) continue;
            String string2 = string.substring("CREATE USER ".length(), string.indexOf("SALT ") - 1);
            if (string2.startsWith("IF NOT EXISTS ")) {
                string2 = string2.substring("IF NOT EXISTS ".length());
            }
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            byte[] byArray = SHA256.getKeyPasswordHash(string2, "".toCharArray());
            byte[] byArray2 = MathUtils.secureRandomBytes(8);
            byte[] byArray3 = SHA256.getHashWithSalt(byArray, byArray2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SALT '").append(StringUtils.convertBytesToHex(byArray2)).append("' HASH '").append(StringUtils.convertBytesToHex(byArray3)).append('\'');
            byte[] byArray4 = stringBuilder.toString().getBytes();
            System.arraycopy(byArray4, 0, data.getBytes(), n8, byArray4.length);
            this.seek(l2);
            this.store.write(data.getBytes(), 0, this.pageSize);
            if (this.trace) {
                this.out.println("User: " + string2);
            }
            this.remove = false;
        }
    }

    private void seek(long l2) {
        this.store.seek(l2 * (long)this.pageSize);
    }

    private Value[] createRecord(PrintWriter printWriter, Data data, int n2) {
        Value[] valueArray;
        this.recordLength = n2;
        if (n2 <= 0) {
            this.writeDataError(printWriter, "columnCount<0", data.getBytes());
            return null;
        }
        try {
            valueArray = new Value[n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.writeDataError(printWriter, "out of memory", data.getBytes());
            return null;
        }
        return valueArray;
    }

    private void writeRow(PrintWriter printWriter, Data data, Value[] valueArray) {
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("INSERT INTO " + this.storageName + " VALUES(");
        this.valueId = 0;
        while (this.valueId < this.recordLength) {
            try {
                object2 = data.readValue();
                valueArray[this.valueId] = object2;
                if (this.valueId > 0) {
                    stringBuilder.append(", ");
                }
                object = this.storageName + "." + this.valueId;
                stringBuilder.append(this.getSQL((String)object, (Value)object2));
            }
            catch (Exception exception) {
                this.writeDataError(printWriter, "exception " + exception, data.getBytes());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.writeDataError(printWriter, "out of memory", data.getBytes());
            }
            ++this.valueId;
        }
        stringBuilder.append(");");
        printWriter.println(stringBuilder.toString());
        if (this.storageId == 0) {
            try {
                object2 = new SimpleRow(valueArray);
                object = new MetaRecord((SearchRow)object2);
                this.schema.add((MetaRecord)object);
                if (((MetaRecord)object).getObjectType() == 0) {
                    String string = valueArray[3].getString();
                    String string2 = Recover.extractTableOrViewName(string);
                    this.tableMap.put(((MetaRecord)object).getId(), string2);
                }
            }
            catch (Throwable throwable) {
                this.writeError(printWriter, throwable);
            }
        }
    }

    private void resetSchema() {
        this.schema = New.arrayList();
        this.objectIdSet = New.hashSet();
        this.tableMap = New.hashMap();
        this.columnTypeMap = New.hashMap();
    }

    private void writeSchema(PrintWriter printWriter) {
        String string;
        Object object;
        printWriter.println("---- Schema ----");
        Collections.sort(this.schema);
        for (MetaRecord object2 : this.schema) {
            if (Recover.isSchemaObjectTypeDelayed(object2)) continue;
            String string2 = object2.getSQL();
            printWriter.println(string2 + ";");
        }
        boolean bl2 = false;
        for (Map.Entry<Integer, String> entry : this.tableMap.entrySet()) {
            object = entry.getKey();
            string = entry.getValue();
            if (!this.objectIdSet.contains(object) || !string.startsWith("INFORMATION_SCHEMA.LOB")) continue;
            this.setStorage((Integer)object);
            printWriter.println("DELETE FROM " + string + ";");
            printWriter.println("INSERT INTO " + string + " SELECT * FROM " + this.storageName + ";");
            if (!string.startsWith("INFORMATION_SCHEMA.LOBS")) continue;
            printWriter.println("UPDATE " + string + " SET TABLE = " + -2 + ";");
            bl2 = true;
        }
        for (Map.Entry<Integer, String> entry : this.tableMap.entrySet()) {
            object = entry.getKey();
            string = entry.getValue();
            if (!this.objectIdSet.contains(object)) continue;
            this.setStorage((Integer)object);
            if (string.startsWith("INFORMATION_SCHEMA.LOB")) continue;
            printWriter.println("INSERT INTO " + string + " SELECT * FROM " + this.storageName + ";");
        }
        for (Integer n2 : this.objectIdSet) {
            this.setStorage(n2);
            printWriter.println("DROP TABLE " + this.storageName + ";");
        }
        printWriter.println("DROP ALIAS READ_BLOB;");
        printWriter.println("DROP ALIAS READ_CLOB;");
        printWriter.println("DROP ALIAS READ_BLOB_DB;");
        printWriter.println("DROP ALIAS READ_CLOB_DB;");
        if (bl2) {
            printWriter.println("DELETE FROM INFORMATION_SCHEMA.LOBS WHERE TABLE = -2;");
        }
        for (MetaRecord metaRecord : this.schema) {
            if (!Recover.isSchemaObjectTypeDelayed(metaRecord)) continue;
            object = metaRecord.getSQL();
            printWriter.println((String)object + ";");
        }
    }

    private static boolean isSchemaObjectTypeDelayed(MetaRecord metaRecord) {
        switch (metaRecord.getObjectType()) {
            case 1: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private void createTemporaryTable(PrintWriter printWriter) {
        if (!this.objectIdSet.contains(this.storageId)) {
            this.objectIdSet.add(this.storageId);
            StatementBuilder statementBuilder = new StatementBuilder("CREATE TABLE ");
            statementBuilder.append(this.storageName).append('(');
            for (int i2 = 0; i2 < this.recordLength; ++i2) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append('C').append(i2).append(' ');
                String string = this.columnTypeMap.get(this.storageName + "." + i2);
                if (string == null) {
                    statementBuilder.append("VARCHAR");
                    continue;
                }
                statementBuilder.append(string);
            }
            printWriter.println(statementBuilder.append(");").toString());
            printWriter.flush();
        }
    }

    private static String extractTableOrViewName(String string) {
        int n2 = string.indexOf(" TABLE ");
        int n3 = string.indexOf(" VIEW ");
        if (n2 > 0 && n3 > 0) {
            if (n2 < n3) {
                n3 = -1;
            } else {
                n2 = -1;
            }
        }
        if (n3 > 0) {
            string = string.substring(n3 + " VIEW ".length());
        } else if (n2 > 0) {
            string = string.substring(n2 + " TABLE ".length());
        } else {
            return "UNKNOWN";
        }
        if (string.startsWith("IF NOT EXISTS ")) {
            string = string.substring("IF NOT EXISTS ".length());
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"') {
                bl2 = !bl2;
                continue;
            }
            if (bl2 || c2 > ' ' && c2 != '(') continue;
            string = string.substring(0, i2);
            return string;
        }
        return "UNKNOWN";
    }

    private static void closeSilently(FileStore fileStore) {
        if (fileStore != null) {
            fileStore.closeSilently();
        }
    }

    private void writeError(PrintWriter printWriter, Throwable throwable) {
        if (printWriter != null) {
            printWriter.println("// error: " + throwable);
        }
        this.traceError("Error", throwable);
    }

    @Override
    public String getDatabasePath() {
        return this.databaseName;
    }

    @Override
    public FileStore openFile(String string, String string2, boolean bl2) {
        return FileStore.open(this, string, "rw");
    }

    @Override
    public void checkPowerOff() {
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public int getMaxLengthInplaceLob() {
        throw DbException.throwInternalError();
    }

    @Override
    public String getLobCompressionAlgorithm(int n2) {
        return null;
    }

    @Override
    public Object getLobSyncObject() {
        return this;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    @Override
    public LobStorageBackend getLobStorage() {
        return null;
    }

    @Override
    public int readLob(long l2, byte[] byArray, long l3, byte[] byArray2, int n2, int n3) {
        throw DbException.throwInternalError();
    }

    @Override
    public JavaObjectSerializer getJavaObjectSerializer() {
        return null;
    }

    @Override
    public CompareMode getCompareMode() {
        return CompareMode.getInstance(null, 0);
    }

    static class PageInputStream
    extends InputStream {
        private final PrintWriter writer;
        private final FileStore store;
        private final Data page;
        private final int pageSize;
        private long trunkPage;
        private long nextTrunkPage;
        private long dataPage;
        private final IntArray dataPages = new IntArray();
        private boolean endOfFile;
        private int remaining;
        private int logKey;

        public PageInputStream(PrintWriter printWriter, DataHandler dataHandler, FileStore fileStore, int n2, long l2, long l3, int n3) {
            this.writer = printWriter;
            this.store = fileStore;
            this.pageSize = n3;
            this.logKey = n2 - 1;
            this.nextTrunkPage = l2;
            this.dataPage = l3;
            this.page = Data.create(dataHandler, n3);
        }

        @Override
        public int read() {
            byte[] byArray = new byte[]{0};
            int n2 = this.read(byArray);
            return n2 < 0 ? -1 : byArray[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) {
            int n4;
            if (n3 == 0) {
                return 0;
            }
            int n5 = 0;
            while (n3 > 0 && (n4 = this.readBlock(byArray, n2, n3)) >= 0) {
                n5 += n4;
                n2 += n4;
                n3 -= n4;
            }
            return n5 == 0 ? -1 : n5;
        }

        private int readBlock(byte[] byArray, int n2, int n3) {
            this.fillBuffer();
            if (this.endOfFile) {
                return -1;
            }
            int n4 = Math.min(this.remaining, n3);
            this.page.read(byArray, n2, n4);
            this.remaining -= n4;
            return n4;
        }

        private void fillBuffer() {
            int n2;
            int n3;
            int n4;
            if (this.remaining > 0 || this.endOfFile) {
                return;
            }
            while (this.dataPages.size() == 0) {
                if (this.nextTrunkPage == 0L) {
                    this.endOfFile = true;
                    return;
                }
                this.trunkPage = this.nextTrunkPage;
                this.store.seek(this.trunkPage * (long)this.pageSize);
                this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                this.page.reset();
                if (!PageStore.checksumTest(this.page.getBytes(), (int)this.trunkPage, this.pageSize)) {
                    this.writer.println("-- ERROR: checksum mismatch page: " + this.trunkPage);
                    this.endOfFile = true;
                    return;
                }
                byte by2 = this.page.readByte();
                this.page.readShortInt();
                if (by2 != 7) {
                    this.writer.println("-- log eof " + this.trunkPage + " type: " + by2 + " expected type: " + 7);
                    this.endOfFile = true;
                    return;
                }
                this.page.readInt();
                int n5 = this.page.readInt();
                ++this.logKey;
                if (n5 != this.logKey) {
                    this.writer.println("-- log eof " + this.trunkPage + " type: " + by2 + " expected key: " + this.logKey + " got: " + n5);
                }
                this.nextTrunkPage = this.page.readInt();
                this.writer.println("-- log " + n5 + ":" + this.trunkPage + " next: " + this.nextTrunkPage);
                n4 = this.page.readShortInt();
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = this.page.readInt();
                    if (this.dataPage != 0L) {
                        if ((long)n2 != this.dataPage) continue;
                        this.dataPage = 0L;
                    }
                    this.dataPages.add(n2);
                }
            }
            if (this.dataPages.size() > 0) {
                this.page.reset();
                long l2 = this.dataPages.get(0);
                this.dataPages.remove(0);
                this.store.seek(l2 * (long)this.pageSize);
                this.store.readFully(this.page.getBytes(), 0, this.pageSize);
                this.page.reset();
                n4 = this.page.readByte();
                if (n4 != 0 && !PageStore.checksumTest(this.page.getBytes(), (int)l2, this.pageSize)) {
                    this.writer.println("-- ERROR: checksum mismatch page: " + l2);
                    this.endOfFile = true;
                    return;
                }
                this.page.readShortInt();
                n3 = this.page.readInt();
                n2 = this.page.readInt();
                this.writer.println("-- log " + n2 + ":" + this.trunkPage + "/" + l2);
                if (n4 != 8) {
                    this.writer.println("-- log eof " + l2 + " type: " + n4 + " parent: " + n3 + " expected type: " + 8);
                    this.endOfFile = true;
                    return;
                }
                if (n2 != this.logKey) {
                    this.writer.println("-- log eof " + l2 + " type: " + n4 + " parent: " + n3 + " expected key: " + this.logKey + " got: " + n2);
                    this.endOfFile = true;
                    return;
                }
                this.remaining = this.pageSize - this.page.length();
            }
        }
    }

    static class Stats {
        long pageDataEmpty;
        long pageDataRows;
        long pageDataHead;
        final int[] pageTypeCount = new int[10];
        int free;

        Stats() {
        }
    }
}

