/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.h2.util.New;
import org.h2.util.StringUtils;

public class MultiDimension
implements Comparator<long[]> {
    private static final MultiDimension INSTANCE = new MultiDimension();

    protected MultiDimension() {
    }

    public static MultiDimension getInstance() {
        return INSTANCE;
    }

    public int normalize(int n2, double d2, double d3, double d4) {
        if (d2 < d3 || d2 > d4) {
            throw new IllegalArgumentException(d3 + "<" + d2 + "<" + d4);
        }
        double d5 = (d2 - d3) / (d4 - d3);
        return (int)(d5 * (double)this.getMaxValue(n2));
    }

    public int getMaxValue(int n2) {
        if (n2 < 2 || n2 > 32) {
            throw new IllegalArgumentException("" + n2);
        }
        int n3 = MultiDimension.getBitsPerValue(n2);
        return (int)((1L << n3) - 1L);
    }

    private static int getBitsPerValue(int n2) {
        return Math.min(31, 64 / n2);
    }

    public long interleave(int ... nArray) {
        int n2 = nArray.length;
        long l2 = this.getMaxValue(n2);
        int n3 = MultiDimension.getBitsPerValue(n2);
        long l3 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l4 = nArray[i2];
            if (l4 < 0L || l4 > l2) {
                throw new IllegalArgumentException("0<" + l4 + "<" + l2);
            }
            for (int i3 = 0; i3 < n3; ++i3) {
                l3 |= (l4 & 1L << i3) << i2 + (n2 - 1) * i3;
            }
        }
        return l3;
    }

    public long interleave(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("0<" + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("0<" + n3);
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < 32; ++i2) {
            l2 |= ((long)n2 & 1L << i2) << i2;
            l2 |= ((long)n3 & 1L << i2) << i2 + 1;
        }
        return l2;
    }

    public int deinterleave(int n2, long l2, int n3) {
        int n4 = MultiDimension.getBitsPerValue(n2);
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            n5 = (int)((long)n5 | l2 >> n3 + (n2 - 1) * i2 & 1L << i2);
        }
        return n5;
    }

    public String generatePreparedQuery(String string, String string2, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder("SELECT D.* FROM ");
        stringBuilder.append(StringUtils.quoteIdentifier(string)).append(" D, TABLE(_FROM_ BIGINT=?, _TO_ BIGINT=?) WHERE ").append(StringUtils.quoteIdentifier(string2)).append(" BETWEEN _FROM_ AND _TO_");
        for (String string3 : stringArray) {
            stringBuilder.append(" AND ").append(StringUtils.quoteIdentifier(string3)).append("+1 BETWEEN ?+1 AND ?+1");
        }
        return stringBuilder.toString();
    }

    public ResultSet getResult(PreparedStatement preparedStatement, int[] nArray, int[] nArray2) throws SQLException {
        int n2;
        long[][] lArray = this.getMortonRanges(nArray, nArray2);
        int n3 = lArray.length;
        Long[] longArray = new Long[n3];
        Long[] longArray2 = new Long[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            longArray[n2] = lArray[n2][0];
            longArray2[n2] = lArray[n2][1];
        }
        preparedStatement.setObject(1, longArray);
        preparedStatement.setObject(2, longArray2);
        n3 = nArray.length;
        int n4 = 3;
        for (n2 = 0; n2 < n3; ++n2) {
            preparedStatement.setInt(n4++, nArray[n2]);
            preparedStatement.setInt(n4++, nArray2[n2]);
        }
        return preparedStatement.executeQuery();
    }

    private long[][] getMortonRanges(int[] nArray, int[] nArray2) {
        int n2;
        int n3 = nArray.length;
        if (nArray2.length != n3) {
            throw new IllegalArgumentException(n3 + "=" + nArray2.length);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray[n2] <= nArray2[n2]) continue;
            int n4 = nArray[n2];
            nArray[n2] = nArray2[n2];
            nArray2[n2] = n4;
        }
        n2 = MultiDimension.getSize(nArray, nArray2, n3);
        ArrayList<long[]> arrayList = New.arrayList();
        this.addMortonRanges(arrayList, nArray, nArray2, n3, 0);
        this.combineEntries(arrayList, n2);
        long[][] lArray = new long[arrayList.size()][2];
        arrayList.toArray((T[])lArray);
        return lArray;
    }

    private static int getSize(int[] nArray, int[] nArray2, int n2) {
        int n3 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = nArray2[i2] - nArray[i2];
            n3 *= n4 + 1;
        }
        return n3;
    }

    private void combineEntries(ArrayList<long[]> arrayList, int n2) {
        Collections.sort(arrayList, this);
        for (int i2 = 10; i2 < n2; i2 += i2 / 2) {
            long[] lArray;
            Object object;
            int n3;
            for (n3 = 0; n3 < arrayList.size() - 1; ++n3) {
                object = arrayList.get(n3);
                if (object[1] + (long)i2 < (lArray = arrayList.get(n3 + 1))[0]) continue;
                object[1] = lArray[1];
                arrayList.remove(n3 + 1);
                --n3;
            }
            n3 = 0;
            object = arrayList.iterator();
            while (object.hasNext()) {
                lArray = (long[])object.next();
                n3 = (int)((long)n3 + (lArray[1] - lArray[0] + 1L));
            }
            if (n3 > 2 * n2 || arrayList.size() < 100) break;
        }
    }

    @Override
    public int compare(long[] lArray, long[] lArray2) {
        return lArray[0] > lArray2[0] ? 1 : -1;
    }

    private void addMortonRanges(ArrayList<long[]> arrayList, int[] nArray, int[] nArray2, int n2, int n3) {
        if (n3 > 100) {
            throw new IllegalArgumentException("" + n3);
        }
        int n4 = 0;
        int n5 = 0;
        long l2 = 1L;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n6 = nArray2[i2] - nArray[i2];
            if (n6 < 0) {
                throw new IllegalArgumentException("" + n6);
            }
            if ((l2 *= (long)(n6 + 1)) < 0L) {
                throw new IllegalArgumentException("" + l2);
            }
            if (n6 <= n5) continue;
            n5 = n6;
            n4 = i2;
        }
        long l3 = this.interleave(nArray);
        long l4 = this.interleave(nArray2);
        if (l4 < l3) {
            throw new IllegalArgumentException(l4 + "<" + l3);
        }
        long l5 = l4 - l3 + 1L;
        if (l5 == l2) {
            long[] lArray = new long[]{l3, l4};
            arrayList.add(lArray);
        } else {
            int n7 = MultiDimension.findMiddle(nArray[n4], nArray2[n4]);
            int n8 = nArray2[n4];
            nArray2[n4] = n7;
            this.addMortonRanges(arrayList, nArray, nArray2, n2, n3 + 1);
            nArray2[n4] = n8;
            n8 = nArray[n4];
            nArray[n4] = n7 + 1;
            this.addMortonRanges(arrayList, nArray, nArray2, n2, n3 + 1);
            nArray[n4] = n8;
        }
    }

    private static int roundUp(int n2, int n3) {
        return n2 + n3 - 1 & -n3;
    }

    private static int findMiddle(int n2, int n3) {
        int n4;
        int n5 = n3 - n2 - 1;
        if (n5 == 0) {
            return n2;
        }
        if (n5 == 1) {
            return n2 + 1;
        }
        int n6 = 0;
        while (1 << n6 < n5) {
            ++n6;
        }
        if ((n4 = MultiDimension.roundUp(n2 + 2, 1 << --n6) - 1) <= n2 || n4 >= n3) {
            throw new IllegalArgumentException(n2 + "<" + n4 + "<" + n3);
        }
        return n4;
    }
}

