/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.tools.SimpleResultSet;
import org.h2.tools.SimpleRowSource;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;

public class Csv
implements SimpleRowSource {
    private String[] columnNames;
    private String characterSet = SysProperties.FILE_ENCODING;
    private char escapeCharacter = (char)34;
    private char fieldDelimiter = (char)34;
    private char fieldSeparatorRead = (char)44;
    private String fieldSeparatorWrite = ",";
    private boolean caseSensitiveColumnNames;
    private boolean preserveWhitespace;
    private boolean writeColumnHeader = true;
    private char lineComment;
    private String lineSeparator = SysProperties.LINE_SEPARATOR;
    private String nullString = "";
    private String fileName;
    private Reader input;
    private char[] inputBuffer;
    private int inputBufferPos;
    private int inputBufferStart = -1;
    private int inputBufferEnd;
    private Writer output;
    private boolean endOfLine;
    private boolean endOfFile;

    private int writeResultSet(ResultSet resultSet) throws SQLException {
        try {
            int n2;
            int n3 = 0;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n4 = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n4];
            int[] nArray = new int[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                stringArray[n2] = resultSetMetaData.getColumnLabel(n2 + 1);
                nArray[n2] = resultSetMetaData.getColumnType(n2 + 1);
            }
            if (this.writeColumnHeader) {
                this.writeRow(stringArray);
            }
            while (resultSet.next()) {
                for (n2 = 0; n2 < n4; ++n2) {
                    Object object;
                    switch (nArray[n2]) {
                        case 91: {
                            object = resultSet.getDate(n2 + 1);
                            break;
                        }
                        case 92: {
                            object = resultSet.getTime(n2 + 1);
                            break;
                        }
                        case 93: {
                            object = resultSet.getTimestamp(n2 + 1);
                            break;
                        }
                        default: {
                            object = resultSet.getString(n2 + 1);
                        }
                    }
                    stringArray[n2] = object == null ? null : object.toString();
                }
                this.writeRow(stringArray);
                ++n3;
            }
            this.output.close();
            n2 = n3;
            return n2;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
        finally {
            this.close();
            JdbcUtils.closeSilently(resultSet);
        }
    }

    public int write(Writer writer, ResultSet resultSet) throws SQLException {
        this.output = writer;
        return this.writeResultSet(resultSet);
    }

    public int write(String string, ResultSet resultSet, String string2) throws SQLException {
        this.init(string, string2);
        try {
            this.initWrite();
            return this.writeResultSet(resultSet);
        }
        catch (IOException iOException) {
            throw Csv.convertException("IOException writing " + string, iOException);
        }
    }

    public int write(Connection connection, String string, String string2, String string3) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        int n2 = this.write(string, resultSet, string3);
        statement.close();
        return n2;
    }

    public ResultSet read(String string, String[] stringArray, String string2) throws SQLException {
        this.init(string, string2);
        try {
            return this.readResultSet(stringArray);
        }
        catch (IOException iOException) {
            throw Csv.convertException("IOException reading " + string, iOException);
        }
    }

    public ResultSet read(Reader reader, String[] stringArray) throws IOException {
        this.init(null, null);
        this.input = reader;
        return this.readResultSet(stringArray);
    }

    private ResultSet readResultSet(String[] stringArray) throws IOException {
        this.columnNames = stringArray;
        this.initRead();
        SimpleResultSet simpleResultSet = new SimpleResultSet(this);
        this.makeColumnNamesUnique();
        for (String string : this.columnNames) {
            simpleResultSet.addColumn(string, 12, Integer.MAX_VALUE, 0);
        }
        return simpleResultSet;
    }

    private void makeColumnNamesUnique() {
        for (int i2 = 0; i2 < this.columnNames.length; ++i2) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.columnNames[i2];
            if (string == null || string.length() == 0) {
                stringBuilder.append('C').append(i2 + 1);
            } else {
                stringBuilder.append(string);
            }
            for (int i3 = 0; i3 < i2; ++i3) {
                String string2 = this.columnNames[i3];
                if (!stringBuilder.toString().equals(string2)) continue;
                stringBuilder.append('1');
                i3 = -1;
            }
            this.columnNames[i2] = stringBuilder.toString();
        }
    }

    private void init(String string, String string2) {
        this.fileName = string;
        if (string2 != null) {
            this.characterSet = string2;
        }
    }

    private void initWrite() throws IOException {
        if (this.output == null) {
            try {
                OutputStream outputStream = FileUtils.newOutputStream(this.fileName, false);
                outputStream = new BufferedOutputStream(outputStream, 4096);
                this.output = new BufferedWriter(new OutputStreamWriter(outputStream, this.characterSet));
            }
            catch (Exception exception) {
                this.close();
                throw DbException.convertToIOException(exception);
            }
        }
    }

    private void writeRow(String[] stringArray) throws IOException {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string;
            if (i2 > 0 && this.fieldSeparatorWrite != null) {
                this.output.write(this.fieldSeparatorWrite);
            }
            if ((string = stringArray[i2]) != null) {
                if (this.escapeCharacter != '\u0000') {
                    if (this.fieldDelimiter != '\u0000') {
                        this.output.write(this.fieldDelimiter);
                    }
                    this.output.write(this.escape(string));
                    if (this.fieldDelimiter == '\u0000') continue;
                    this.output.write(this.fieldDelimiter);
                    continue;
                }
                this.output.write(string);
                continue;
            }
            if (this.nullString == null || this.nullString.length() <= 0) continue;
            this.output.write(this.nullString);
        }
        this.output.write(this.lineSeparator);
    }

    private String escape(String string) {
        if (string.indexOf(this.fieldDelimiter) < 0 && (this.escapeCharacter == this.fieldDelimiter || string.indexOf(this.escapeCharacter) < 0)) {
            return string;
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == this.fieldDelimiter || c2 == this.escapeCharacter) {
                stringBuilder.append(this.escapeCharacter);
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private void initRead() throws IOException {
        if (this.input == null) {
            try {
                InputStream inputStream = FileUtils.newInputStream(this.fileName);
                inputStream = new BufferedInputStream(inputStream, 4096);
                this.input = new InputStreamReader(inputStream, this.characterSet);
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
        }
        if (!this.input.markSupported()) {
            this.input = new BufferedReader(this.input);
        }
        this.input.mark(1);
        int n2 = this.input.read();
        if (n2 != 65279) {
            this.input.reset();
        }
        this.inputBuffer = new char[8192];
        if (this.columnNames == null) {
            this.readHeader();
        }
    }

    private void readHeader() throws IOException {
        ArrayList<String> arrayList = New.arrayList();
        while (true) {
            String string;
            if ((string = this.readValue()) == null) {
                if (this.endOfLine) {
                    if (!this.endOfFile && arrayList.size() <= 0) continue;
                    break;
                }
                string = "COLUMN" + arrayList.size();
                arrayList.add(string);
                continue;
            }
            if (string.length() == 0) {
                string = "COLUMN" + arrayList.size();
            } else if (!this.caseSensitiveColumnNames && Csv.isSimpleColumnName(string)) {
                string = string.toUpperCase();
            }
            arrayList.add(string);
            if (this.endOfLine) break;
        }
        this.columnNames = new String[arrayList.size()];
        arrayList.toArray(this.columnNames);
    }

    private static boolean isSimpleColumnName(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (!(i2 == 0 ? c2 != '_' && !Character.isLetter(c2) : c2 != '_' && !Character.isLetterOrDigit(c2))) continue;
            return false;
        }
        return string.length() != 0;
    }

    private void pushBack() {
        --this.inputBufferPos;
    }

    private int readChar() throws IOException {
        if (this.inputBufferPos >= this.inputBufferEnd) {
            return this.readBuffer();
        }
        return this.inputBuffer[this.inputBufferPos++];
    }

    private int readBuffer() throws IOException {
        int n2;
        if (this.endOfFile) {
            return -1;
        }
        if (this.inputBufferStart >= 0) {
            n2 = this.inputBufferPos - this.inputBufferStart;
            if (n2 > 0) {
                char[] cArray = this.inputBuffer;
                if (n2 + 4096 > cArray.length) {
                    this.inputBuffer = new char[cArray.length * 2];
                }
                System.arraycopy(cArray, this.inputBufferStart, this.inputBuffer, 0, n2);
            }
            this.inputBufferStart = 0;
        } else {
            n2 = 0;
        }
        this.inputBufferPos = n2;
        int n3 = this.input.read(this.inputBuffer, n2, 4096);
        if (n3 == -1) {
            this.inputBufferEnd = -1024;
            this.endOfFile = true;
            ++this.inputBufferPos;
            return -1;
        }
        this.inputBufferEnd = n2 + n3;
        return this.inputBuffer[this.inputBufferPos++];
    }

    private String readValue() throws IOException {
        int n2;
        this.endOfLine = false;
        this.inputBufferStart = this.inputBufferPos;
        do {
            if ((n2 = this.readChar()) == this.fieldDelimiter) {
                int n3;
                boolean bl2;
                block16: {
                    bl2 = false;
                    this.inputBufferStart = this.inputBufferPos;
                    while (true) {
                        if ((n2 = this.readChar()) == this.fieldDelimiter) {
                            n2 = this.readChar();
                            if (n2 != this.fieldDelimiter) {
                                n3 = 2;
                                break block16;
                            }
                            bl2 = true;
                            continue;
                        }
                        if (n2 == this.escapeCharacter) {
                            n2 = this.readChar();
                            if (n2 < 0) {
                                n3 = 1;
                                break block16;
                            }
                            bl2 = true;
                            continue;
                        }
                        if (n2 < 0) break;
                    }
                    n3 = 1;
                }
                String string = new String(this.inputBuffer, this.inputBufferStart, this.inputBufferPos - this.inputBufferStart - n3);
                if (bl2) {
                    string = this.unEscape(string);
                }
                this.inputBufferStart = -1;
                while (n2 != this.fieldSeparatorRead) {
                    if (n2 == 10 || n2 < 0 || n2 == 13) {
                        this.endOfLine = true;
                        break;
                    }
                    if (n2 != 32 && n2 != 9) {
                        this.pushBack();
                        break;
                    }
                    n2 = this.readChar();
                }
                return string;
            }
            if (n2 == 10 || n2 < 0 || n2 == 13) {
                this.endOfLine = true;
                return null;
            }
            if (n2 != this.fieldSeparatorRead) continue;
            return null;
        } while (n2 <= 32);
        if (this.lineComment != '\u0000' && n2 == this.lineComment) {
            this.inputBufferStart = -1;
            while ((n2 = this.readChar()) != 10 && n2 >= 0 && n2 != 13) {
            }
            this.endOfLine = true;
            return null;
        }
        while ((n2 = this.readChar()) != this.fieldSeparatorRead) {
            if (n2 != 10 && n2 >= 0 && n2 != 13) continue;
            this.endOfLine = true;
            break;
        }
        String string = new String(this.inputBuffer, this.inputBufferStart, this.inputBufferPos - this.inputBufferStart - 1);
        if (!this.preserveWhitespace) {
            string = string.trim();
        }
        this.inputBufferStart = -1;
        return this.readNull(string);
    }

    private String readNull(String string) {
        return string.equals(this.nullString) ? null : string;
    }

    private String unEscape(String string) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n3 = 0;
        char[] cArray = null;
        while ((n2 = string.indexOf(this.escapeCharacter, n3)) >= 0 || (n2 = string.indexOf(this.fieldDelimiter, n3)) >= 0) {
            if (cArray == null) {
                cArray = string.toCharArray();
            }
            stringBuilder.append(cArray, n3, n2 - n3);
            if (n2 == string.length() - 1) {
                n3 = string.length();
                break;
            }
            stringBuilder.append(cArray[n2 + 1]);
            n3 = n2 + 2;
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    @Override
    public Object[] readRow() throws SQLException {
        if (this.input == null) {
            return null;
        }
        Object[] objectArray = new String[this.columnNames.length];
        try {
            int n2 = 0;
            while (true) {
                String string;
                if ((string = this.readValue()) == null && this.endOfLine) {
                    if (n2 == 0) {
                        if (!this.endOfFile) continue;
                        return null;
                    }
                    break;
                }
                if (n2 < objectArray.length) {
                    objectArray[n2++] = string;
                }
                if (this.endOfLine) break;
            }
        }
        catch (IOException iOException) {
            throw Csv.convertException("IOException reading from " + this.fileName, iOException);
        }
        return objectArray;
    }

    private static SQLException convertException(String string, Exception exception) {
        return DbException.get(90028, exception, string).getSQLException();
    }

    @Override
    public void close() {
        IOUtils.closeSilently(this.input);
        this.input = null;
        IOUtils.closeSilently(this.output);
        this.output = null;
    }

    @Override
    public void reset() throws SQLException {
        throw new SQLException("Method is not supported", "CSV");
    }

    public void setFieldSeparatorWrite(String string) {
        this.fieldSeparatorWrite = string;
    }

    public String getFieldSeparatorWrite() {
        return this.fieldSeparatorWrite;
    }

    public void setCaseSensitiveColumnNames(boolean bl2) {
        this.caseSensitiveColumnNames = bl2;
    }

    public boolean getCaseSensitiveColumnNames() {
        return this.caseSensitiveColumnNames;
    }

    public void setFieldSeparatorRead(char c2) {
        this.fieldSeparatorRead = c2;
    }

    public char getFieldSeparatorRead() {
        return this.fieldSeparatorRead;
    }

    public void setLineCommentCharacter(char c2) {
        this.lineComment = c2;
    }

    public char getLineCommentCharacter() {
        return this.lineComment;
    }

    public void setFieldDelimiter(char c2) {
        this.fieldDelimiter = c2;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setEscapeCharacter(char c2) {
        this.escapeCharacter = c2;
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setNullString(String string) {
        this.nullString = string;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setPreserveWhitespace(boolean bl2) {
        this.preserveWhitespace = bl2;
    }

    public boolean getPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public void setWriteColumnHeader(boolean bl2) {
        this.writeColumnHeader = bl2;
    }

    public boolean getWriteColumnHeader() {
        return this.writeColumnHeader;
    }

    public String setOptions(String string) {
        String[] stringArray;
        String string2 = null;
        for (String string3 : stringArray = StringUtils.arraySplit(string, ' ', false)) {
            char c2;
            if (string3.length() == 0) continue;
            int n2 = string3.indexOf(61);
            String string4 = StringUtils.trim(string3.substring(0, n2), true, true, " ");
            String string5 = string3.substring(n2 + 1);
            char c3 = c2 = string5.length() == 0 ? (char)'\u0000' : string5.charAt(0);
            if (Csv.isParam(string4, "escape", "esc", "escapeCharacter")) {
                this.setEscapeCharacter(c2);
                continue;
            }
            if (Csv.isParam(string4, "fieldDelimiter", "fieldDelim")) {
                this.setFieldDelimiter(c2);
                continue;
            }
            if (Csv.isParam(string4, "fieldSeparator", "fieldSep")) {
                this.setFieldSeparatorRead(c2);
                this.setFieldSeparatorWrite(string5);
                continue;
            }
            if (Csv.isParam(string4, "lineComment", "lineCommentCharacter")) {
                this.setLineCommentCharacter(c2);
                continue;
            }
            if (Csv.isParam(string4, "lineSeparator", "lineSep")) {
                this.setLineSeparator(string5);
                continue;
            }
            if (Csv.isParam(string4, "null", "nullString")) {
                this.setNullString(string5);
                continue;
            }
            if (Csv.isParam(string4, "charset", "characterSet")) {
                string2 = string5;
                continue;
            }
            if (Csv.isParam(string4, "preserveWhitespace")) {
                this.setPreserveWhitespace(Boolean.parseBoolean(string5));
                continue;
            }
            if (Csv.isParam(string4, "writeColumnHeader")) {
                this.setWriteColumnHeader(Boolean.parseBoolean(string5));
                continue;
            }
            if (Csv.isParam(string4, "caseSensitiveColumnNames")) {
                this.setCaseSensitiveColumnNames(Boolean.parseBoolean(string5));
                continue;
            }
            throw DbException.getUnsupportedException(string4);
        }
        return string2;
    }

    private static boolean isParam(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }
}

