/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.CompressNo;
import org.h2.compress.Compressor;
import org.h2.compress.LZFInputStream;
import org.h2.compress.LZFOutputStream;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.util.StringUtils;

public class CompressTool {
    private static final int MAX_BUFFER_SIZE = 393216;
    private byte[] cachedBuffer;

    private CompressTool() {
    }

    private byte[] getBuffer(int n2) {
        if (n2 > 393216) {
            return DataUtils.newBytes(n2);
        }
        if (this.cachedBuffer == null || this.cachedBuffer.length < n2) {
            this.cachedBuffer = DataUtils.newBytes(n2);
        }
        return this.cachedBuffer;
    }

    public static CompressTool getInstance() {
        return new CompressTool();
    }

    public byte[] compress(byte[] byArray, String string) {
        int n2 = byArray.length;
        if (byArray.length < 5) {
            string = "NO";
        }
        Compressor compressor = CompressTool.getCompressor(string);
        byte[] byArray2 = this.getBuffer((n2 < 100 ? n2 + 100 : n2) * 2);
        int n3 = CompressTool.compress(byArray, byArray.length, compressor, byArray2);
        byte[] byArray3 = DataUtils.newBytes(n3);
        System.arraycopy(byArray2, 0, byArray3, 0, n3);
        return byArray3;
    }

    private static int compress(byte[] byArray, int n2, Compressor compressor, byte[] byArray2) {
        int n3 = 0;
        byArray2[0] = (byte)compressor.getAlgorithm();
        int n4 = 1 + CompressTool.writeVariableInt(byArray2, 1, n2);
        n3 = compressor.compress(byArray, n2, byArray2, n4);
        if (n3 > n2 + n4 || n3 <= 0) {
            byArray2[0] = 0;
            System.arraycopy(byArray, 0, byArray2, n4, n2);
            n3 = n2 + n4;
        }
        return n3;
    }

    public byte[] expand(byte[] byArray) {
        byte by2 = byArray[0];
        Compressor compressor = CompressTool.getCompressor(by2);
        try {
            int n2 = CompressTool.readVariableInt(byArray, 1);
            int n3 = 1 + CompressTool.getVariableIntLength(n2);
            byte[] byArray2 = DataUtils.newBytes(n2);
            compressor.expand(byArray, n3, byArray.length - n3, byArray2, 0, n2);
            return byArray2;
        }
        catch (Exception exception) {
            throw DbException.get(90104, exception, new String[0]);
        }
    }

    public static void expand(byte[] byArray, byte[] byArray2, int n2) {
        byte by2 = byArray[0];
        Compressor compressor = CompressTool.getCompressor(by2);
        try {
            int n3 = CompressTool.readVariableInt(byArray, 1);
            int n4 = 1 + CompressTool.getVariableIntLength(n3);
            compressor.expand(byArray, n4, byArray.length - n4, byArray2, n2, n3);
        }
        catch (Exception exception) {
            throw DbException.get(90104, exception, new String[0]);
        }
    }

    public static int readVariableInt(byte[] byArray, int n2) {
        int n3;
        if ((n3 = byArray[n2++] & 0xFF) < 128) {
            return n3;
        }
        if (n3 < 192) {
            return ((n3 & 0x3F) << 8) + (byArray[n2] & 0xFF);
        }
        if (n3 < 224) {
            return ((n3 & 0x1F) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2] & 0xFF);
        }
        if (n3 < 240) {
            return ((n3 & 0xF) << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2] & 0xFF);
        }
        return ((byArray[n2++] & 0xFF) << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2] & 0xFF);
    }

    public static int writeVariableInt(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            byArray[n2++] = -16;
            byArray[n2++] = (byte)(n3 >> 24);
            byArray[n2++] = (byte)(n3 >> 16);
            byArray[n2++] = (byte)(n3 >> 8);
            byArray[n2] = (byte)n3;
            return 5;
        }
        if (n3 < 128) {
            byArray[n2] = (byte)n3;
            return 1;
        }
        if (n3 < 16384) {
            byArray[n2++] = (byte)(0x80 | n3 >> 8);
            byArray[n2] = (byte)n3;
            return 2;
        }
        if (n3 < 0x200000) {
            byArray[n2++] = (byte)(0xC0 | n3 >> 16);
            byArray[n2++] = (byte)(n3 >> 8);
            byArray[n2] = (byte)n3;
            return 3;
        }
        if (n3 < 0x10000000) {
            byArray[n2++] = (byte)(0xE0 | n3 >> 24);
            byArray[n2++] = (byte)(n3 >> 16);
            byArray[n2++] = (byte)(n3 >> 8);
            byArray[n2] = (byte)n3;
            return 4;
        }
        byArray[n2++] = -16;
        byArray[n2++] = (byte)(n3 >> 24);
        byArray[n2++] = (byte)(n3 >> 16);
        byArray[n2++] = (byte)(n3 >> 8);
        byArray[n2] = (byte)n3;
        return 5;
    }

    public static int getVariableIntLength(int n2) {
        if (n2 < 0) {
            return 5;
        }
        if (n2 < 128) {
            return 1;
        }
        if (n2 < 16384) {
            return 2;
        }
        if (n2 < 0x200000) {
            return 3;
        }
        if (n2 < 0x10000000) {
            return 4;
        }
        return 5;
    }

    private static Compressor getCompressor(String string) {
        if (string == null) {
            string = "LZF";
        }
        int n2 = string.indexOf(32);
        String string2 = null;
        if (n2 > 0) {
            string2 = string.substring(n2 + 1);
            string = string.substring(0, n2);
        }
        int n3 = CompressTool.getCompressAlgorithm(string);
        Compressor compressor = CompressTool.getCompressor(n3);
        compressor.setOptions(string2);
        return compressor;
    }

    public static int getCompressAlgorithm(String string) {
        if ("NO".equals(string = StringUtils.toUpperEnglish(string))) {
            return 0;
        }
        if ("LZF".equals(string)) {
            return 1;
        }
        if ("DEFLATE".equals(string)) {
            return 2;
        }
        throw DbException.get(90103, string);
    }

    private static Compressor getCompressor(int n2) {
        switch (n2) {
            case 0: {
                return new CompressNo();
            }
            case 1: {
                return new CompressLZF();
            }
            case 2: {
                return new CompressDeflate();
            }
        }
        throw DbException.get(90103, "" + n2);
    }

    public static OutputStream wrapOutputStream(OutputStream outputStream, String string, String string2) {
        try {
            if ("GZIP".equals(string)) {
                outputStream = new GZIPOutputStream(outputStream);
            } else if ("ZIP".equals(string)) {
                ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
                zipOutputStream.putNextEntry(new ZipEntry(string2));
                outputStream = zipOutputStream;
            } else if ("DEFLATE".equals(string)) {
                outputStream = new DeflaterOutputStream(outputStream);
            } else if ("LZF".equals(string)) {
                outputStream = new LZFOutputStream(outputStream);
            } else if (string != null) {
                throw DbException.get(90103, string);
            }
            return outputStream;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    public static InputStream wrapInputStream(InputStream inputStream, String string, String string2) {
        try {
            if ("GZIP".equals(string)) {
                inputStream = new GZIPInputStream(inputStream);
            } else if ("ZIP".equals(string)) {
                ZipEntry zipEntry;
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                do {
                    if ((zipEntry = zipInputStream.getNextEntry()) != null) continue;
                    return null;
                } while (!string2.equals(zipEntry.getName()));
                inputStream = zipInputStream;
            } else if ("DEFLATE".equals(string)) {
                inputStream = new InflaterInputStream(inputStream);
            } else if ("LZF".equals(string)) {
                inputStream = new LZFInputStream(inputStream);
            } else if (string != null) {
                throw DbException.get(90103, string);
            }
            return inputStream;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }
}

