/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.ViewIndex;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public class TableView
extends Table {
    private static final long ROW_COUNT_APPROXIMATION = 100L;
    private String querySQL;
    private ArrayList<Table> tables;
    private Column[] columnTemplates;
    private Query viewQuery;
    private ViewIndex index;
    private boolean recursive;
    private DbException createException;
    private long lastModificationCheck;
    private long maxDataModificationId;
    private User owner;
    private Query topQuery;
    private LocalResult recursiveResult;
    private boolean tableExpression;

    public TableView(Schema schema, int n2, String string, String string2, ArrayList<Parameter> arrayList, Column[] columnArray, Session session, boolean bl2) {
        super(schema, n2, string, false, true);
        this.init(string2, arrayList, columnArray, session, bl2);
    }

    public void replace(String string, String[] stringArray, Session session, boolean bl2, boolean bl3) {
        String string2 = this.querySQL;
        Column[] columnArray = this.columnTemplates;
        boolean bl4 = this.recursive;
        this.init(string, null, this.columnTemplates, session, bl2);
        DbException dbException = this.recompile(session, bl3, true);
        if (dbException != null) {
            this.init(string2, null, columnArray, session, bl4);
            this.recompile(session, true, false);
            throw dbException;
        }
    }

    private synchronized void init(String string, ArrayList<Parameter> arrayList, Column[] columnArray, Session session, boolean bl2) {
        this.querySQL = string;
        this.columnTemplates = columnArray;
        this.recursive = bl2;
        this.index = new ViewIndex(this, string, arrayList, bl2);
        this.initColumnsAndTables(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Query compileViewQuery(Session session, String string) {
        Prepared prepared;
        session.setParsingView(true);
        try {
            prepared = session.prepare(string);
        }
        finally {
            session.setParsingView(false);
        }
        if (!(prepared instanceof Query)) {
            throw DbException.getSyntaxError(string, 0);
        }
        return (Query)prepared;
    }

    public synchronized DbException recompile(Session session, boolean bl2, boolean bl3) {
        block6: {
            try {
                TableView.compileViewQuery(session, this.querySQL);
            }
            catch (DbException dbException) {
                if (bl2) break block6;
                return dbException;
            }
        }
        ArrayList<TableView> arrayList = this.getViews();
        if (arrayList != null) {
            arrayList = New.arrayList(arrayList);
        }
        this.initColumnsAndTables(session);
        if (arrayList != null) {
            for (TableView tableView : arrayList) {
                DbException dbException = tableView.recompile(session, bl2, false);
                if (dbException == null || bl2) continue;
                return dbException;
            }
        }
        if (bl3) {
            TableView.clearIndexCaches(this.database);
        }
        return bl2 ? null : this.createException;
    }

    private void initColumnsAndTables(Session session) {
        Column[] columnArray;
        block12: {
            this.removeViewFromTables();
            try {
                Query query = TableView.compileViewQuery(session, this.querySQL);
                this.querySQL = query.getPlanSQL();
                this.tables = New.arrayList(query.getTables());
                ArrayList<Expression> arrayList = query.getExpressions();
                ArrayList<Column> arrayList2 = New.arrayList();
                int n2 = query.getColumnCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Expression expression;
                    Expression expression2 = arrayList.get(i2);
                    String string = null;
                    int n3 = -1;
                    if (this.columnTemplates != null && this.columnTemplates.length > i2) {
                        string = this.columnTemplates[i2].getName();
                        n3 = this.columnTemplates[i2].getType();
                    }
                    if (string == null) {
                        string = expression2.getAlias();
                    }
                    if (n3 == -1) {
                        n3 = expression2.getType();
                    }
                    long l2 = expression2.getPrecision();
                    int n4 = expression2.getScale();
                    int n5 = expression2.getDisplaySize();
                    Column column = new Column(string, n3, l2, n4, n5);
                    column.setTable(this, i2);
                    ExpressionColumn expressionColumn = null;
                    if (expression2 instanceof ExpressionColumn) {
                        expressionColumn = (ExpressionColumn)expression2;
                    } else if (expression2 instanceof Alias && (expression = expression2.getNonAliasExpression()) instanceof ExpressionColumn) {
                        expressionColumn = (ExpressionColumn)expression;
                    }
                    if (expressionColumn != null && (expression = expressionColumn.getColumn().getCheckConstraint(session, string)) != null) {
                        column.addCheckConstraint(session, expression);
                    }
                    arrayList2.add(column);
                }
                columnArray = new Column[arrayList2.size()];
                arrayList2.toArray(columnArray);
                this.createException = null;
                this.viewQuery = query;
            }
            catch (DbException dbException) {
                dbException.addSQL(this.getCreateSQL());
                this.createException = dbException;
                this.tables = New.arrayList();
                columnArray = new Column[]{};
                if (!this.recursive || this.columnTemplates == null) break block12;
                columnArray = new Column[this.columnTemplates.length];
                for (int i3 = 0; i3 < this.columnTemplates.length; ++i3) {
                    columnArray[i3] = this.columnTemplates[i3].getClone();
                }
                this.index.setRecursive(true);
                this.createException = null;
            }
        }
        this.setColumns(columnArray);
        if (this.getId() != 0) {
            this.addViewToTables();
        }
    }

    @Override
    public boolean isView() {
        return true;
    }

    public boolean isInvalid() {
        return this.createException != null;
    }

    @Override
    public PlanItem getBestPlanItem(Session session, int[] nArray, TableFilter[] tableFilterArray, int n2, SortOrder sortOrder, HashSet<Column> hashSet) {
        CacheKey cacheKey = new CacheKey(nArray, this);
        Map<Object, ViewIndex> map = session.getViewIndexCache(this.topQuery != null);
        ViewIndex viewIndex = map.get(cacheKey);
        if (viewIndex == null || viewIndex.isExpired()) {
            viewIndex = new ViewIndex(this, this.index, session, nArray, tableFilterArray, n2, sortOrder);
            map.put(cacheKey, viewIndex);
        }
        PlanItem planItem = new PlanItem();
        planItem.cost = viewIndex.getCost(session, nArray, tableFilterArray, n2, sortOrder, hashSet);
        planItem.setIndex(viewIndex);
        return planItem;
    }

    @Override
    public boolean isQueryComparable() {
        if (!super.isQueryComparable()) {
            return false;
        }
        for (Table table : this.tables) {
            if (table.isQueryComparable()) continue;
            return false;
        }
        return this.topQuery == null || this.topQuery.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR);
    }

    public Query getTopQuery() {
        return this.topQuery;
    }

    @Override
    public String getDropSQL() {
        return "DROP VIEW IF EXISTS " + this.getSQL() + " CASCADE";
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQL(false, true, string);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false, true);
    }

    public String getCreateSQL(boolean bl2, boolean bl3) {
        return this.getCreateSQL(bl2, bl3, this.getSQL());
    }

    private String getCreateSQL(boolean bl2, boolean bl3, String string) {
        StatementBuilder statementBuilder = new StatementBuilder("CREATE ");
        if (bl2) {
            statementBuilder.append("OR REPLACE ");
        }
        if (bl3) {
            statementBuilder.append("FORCE ");
        }
        statementBuilder.append("VIEW ");
        statementBuilder.append(string);
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        if (this.columns != null && this.columns.length > 0) {
            statementBuilder.append('(');
            for (Column column : this.columns) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(column.getSQL());
            }
            statementBuilder.append(')');
        } else if (this.columnTemplates != null) {
            statementBuilder.append('(');
            for (Column column : this.columnTemplates) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(column.getName());
            }
            statementBuilder.append(')');
        }
        return statementBuilder.append(" AS\n").append(this.querySQL).toString();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean lock(Session session, boolean bl2, boolean bl3) {
        return false;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String string, int n2, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl2, String string2) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError();
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public String getTableType() {
        return "VIEW";
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.removeViewFromTables();
        super.removeChildrenAndResources(session);
        this.database.removeMeta(session, this.getId());
        this.querySQL = null;
        this.index = null;
        TableView.clearIndexCaches(this.database);
        this.invalidate();
    }

    public static void clearIndexCaches(Database database) {
        for (Session session : database.getSessions(true)) {
            session.clearViewIndexCache();
        }
    }

    @Override
    public String getSQL() {
        if (this.isTemporary()) {
            return "(\n" + StringUtils.indent(this.querySQL) + ")";
        }
        return super.getSQL();
    }

    public String getQuery() {
        return this.querySQL;
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.getBestPlanItem(session, null, null, -1, null, null).getIndex();
    }

    @Override
    public Index getScanIndex(Session session, int[] nArray, TableFilter[] tableFilterArray, int n2, SortOrder sortOrder, HashSet<Column> hashSet) {
        if (this.createException != null) {
            String string = this.createException.getMessage();
            throw DbException.get(90109, this.createException, this.getSQL(), string);
        }
        PlanItem planItem = this.getBestPlanItem(session, nArray, tableFilterArray, n2, sortOrder, hashSet);
        return planItem.getIndex();
    }

    @Override
    public boolean canReference() {
        return false;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public long getMaxDataModificationId() {
        if (this.createException != null) {
            return Long.MAX_VALUE;
        }
        if (this.viewQuery == null) {
            return Long.MAX_VALUE;
        }
        long l2 = this.database.getModificationDataId();
        if (l2 > this.lastModificationCheck && this.maxDataModificationId <= l2) {
            this.maxDataModificationId = this.viewQuery.getMaxDataModificationId();
            this.lastModificationCheck = l2;
        }
        return this.maxDataModificationId;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    private void removeViewFromTables() {
        if (this.tables != null) {
            for (Table table : this.tables) {
                table.removeView(this);
            }
            this.tables.clear();
        }
    }

    private void addViewToTables() {
        for (Table table : this.tables) {
            table.addView(this);
        }
    }

    private void setOwner(User user) {
        this.owner = user;
    }

    public User getOwner() {
        return this.owner;
    }

    public static TableView createTempView(Session session, User user, String string, Query query, Query query2) {
        Schema schema = session.getDatabase().getSchema("PUBLIC");
        String string2 = query.getPlanSQL();
        TableView tableView = new TableView(schema, 0, string, string2, query.getParameters(), null, session, false);
        if (tableView.createException != null) {
            throw tableView.createException;
        }
        tableView.setTopQuery(query2);
        tableView.setOwner(user);
        tableView.setTemporary(true);
        return tableView;
    }

    private void setTopQuery(Query query) {
        this.topQuery = query;
    }

    @Override
    public long getRowCountApproximation() {
        return 100L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    public int getParameterOffset(ArrayList<Parameter> arrayList) {
        int n2;
        int n3 = n2 = this.topQuery == null ? -1 : TableView.getMaxParameterIndex(this.topQuery.getParameters());
        if (arrayList != null) {
            n2 = Math.max(n2, TableView.getMaxParameterIndex(arrayList));
        }
        return n2 + 1;
    }

    private static int getMaxParameterIndex(ArrayList<Parameter> arrayList) {
        int n2 = -1;
        for (Parameter parameter : arrayList) {
            n2 = Math.max(n2, parameter.getIndex());
        }
        return n2;
    }

    @Override
    public boolean isDeterministic() {
        if (this.recursive || this.viewQuery == null) {
            return false;
        }
        return this.viewQuery.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR);
    }

    public void setRecursiveResult(LocalResult localResult) {
        if (this.recursiveResult != null) {
            this.recursiveResult.close();
        }
        this.recursiveResult = localResult;
    }

    public LocalResult getRecursiveResult() {
        return this.recursiveResult;
    }

    public void setTableExpression(boolean bl2) {
        this.tableExpression = bl2;
    }

    public boolean isTableExpression() {
        return this.tableExpression;
    }

    @Override
    public void addDependencies(HashSet<DbObject> hashSet) {
        super.addDependencies(hashSet);
        if (this.tables != null) {
            for (Table table : this.tables) {
                if ("VIEW".equals(table.getTableType())) continue;
                table.addDependencies(hashSet);
            }
        }
    }

    private static final class CacheKey {
        private final int[] masks;
        private final TableView view;

        public CacheKey(int[] nArray, TableView tableView) {
            this.masks = nArray;
            this.view = tableView;
        }

        public int hashCode() {
            int n2 = 1;
            n2 = 31 * n2 + Arrays.hashCode(this.masks);
            n2 = 31 * n2 + this.view.hashCode();
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (this.view != cacheKey.view) {
                return false;
            }
            return Arrays.equals(this.masks, cacheKey.masks);
        }
    }
}

