/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.Trace;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.TableFilter;
import org.h2.util.New;

public class Plan {
    private final TableFilter[] filters;
    private final HashMap<TableFilter, PlanItem> planItems = New.hashMap();
    private final Expression[] allConditions;
    private final TableFilter[] allFilters;

    public Plan(TableFilter[] tableFilterArray, int n2, Expression expression) {
        this.filters = new TableFilter[n2];
        System.arraycopy(tableFilterArray, 0, this.filters, 0, n2);
        final ArrayList<Expression> arrayList = New.arrayList();
        final ArrayList<TableFilter> arrayList2 = New.arrayList();
        if (expression != null) {
            arrayList.add(expression);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            TableFilter tableFilter = tableFilterArray[i2];
            tableFilter.visit(new TableFilter.TableFilterVisitor(){

                @Override
                public void accept(TableFilter tableFilter) {
                    arrayList2.add(tableFilter);
                    if (tableFilter.getJoinCondition() != null) {
                        arrayList.add(tableFilter.getJoinCondition());
                    }
                }
            });
        }
        this.allConditions = new Expression[arrayList.size()];
        arrayList.toArray(this.allConditions);
        this.allFilters = new TableFilter[arrayList2.size()];
        arrayList2.toArray(this.allFilters);
    }

    public PlanItem getItem(TableFilter tableFilter) {
        return this.planItems.get(tableFilter);
    }

    public TableFilter[] getFilters() {
        return this.filters;
    }

    public void removeUnusableIndexConditions() {
        for (int i2 = 0; i2 < this.allFilters.length; ++i2) {
            TableFilter tableFilter = this.allFilters[i2];
            this.setEvaluatable(tableFilter, true);
            if (i2 < this.allFilters.length - 1 || tableFilter.getSession().getDatabase().getSettings().earlyFilter) {
                tableFilter.optimizeFullCondition(false);
            }
            tableFilter.removeUnusableIndexConditions();
        }
        for (TableFilter tableFilter : this.allFilters) {
            this.setEvaluatable(tableFilter, false);
        }
    }

    public double calculateCost(Session session) {
        Trace trace = session.getTrace();
        if (trace.isDebugEnabled()) {
            trace.debug("Plan       : calculate cost for plan {0}", Arrays.toString(this.allFilters));
        }
        double d2 = 1.0;
        boolean bl2 = false;
        HashSet<Column> hashSet = ExpressionVisitor.allColumnsForTableFilters(this.allFilters);
        for (int i2 = 0; i2 < this.allFilters.length; ++i2) {
            TableFilter tableFilter = this.allFilters[i2];
            if (trace.isDebugEnabled()) {
                trace.debug("Plan       :   for table filter {0}", tableFilter);
            }
            PlanItem planItem = tableFilter.getBestPlanItem(session, this.allFilters, i2, hashSet);
            this.planItems.put(tableFilter, planItem);
            if (trace.isDebugEnabled()) {
                trace.debug("Plan       :   best plan item cost {0} index {1}", planItem.cost, planItem.getIndex().getPlanSQL());
            }
            d2 += d2 * planItem.cost;
            this.setEvaluatable(tableFilter, true);
            Expression object = tableFilter.getJoinCondition();
            if (object == null || object.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            d2 = Double.POSITIVE_INFINITY;
        }
        if (trace.isDebugEnabled()) {
            session.getTrace().debug("Plan       : plan cost {0}", d2);
        }
        for (TableFilter tableFilter : this.allFilters) {
            this.setEvaluatable(tableFilter, false);
        }
        return d2;
    }

    private void setEvaluatable(TableFilter tableFilter, boolean bl2) {
        tableFilter.setEvaluatable(tableFilter, bl2);
        for (Expression expression : this.allConditions) {
            expression.setEvaluatable(tableFilter, bl2);
        }
    }
}

