/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectUnion;
import org.h2.index.Cursor;
import org.h2.index.IndexCursor;
import org.h2.index.IndexLookupBatch;
import org.h2.index.ViewCursor;
import org.h2.index.ViewIndex;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.TableFilter;
import org.h2.util.DoneFuture;
import org.h2.util.LazyFuture;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueLong;

public final class JoinBatch {
    static final Cursor EMPTY_CURSOR = new Cursor(){

        @Override
        public boolean previous() {
            return false;
        }

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public SearchRow getSearchRow() {
            return null;
        }

        @Override
        public Row get() {
            return null;
        }

        public String toString() {
            return "EMPTY_CURSOR";
        }
    };
    static final Future<Cursor> EMPTY_FUTURE_CURSOR = new DoneFuture<Cursor>(EMPTY_CURSOR);
    Future<Cursor> viewTopFutureCursor;
    JoinFilter top;
    JoinFilter[] filters;
    boolean batchedSubQuery;
    private boolean started;
    private JoinRow current;
    private boolean found;
    private final TableFilter additionalFilter;

    public JoinBatch(int n2, TableFilter tableFilter) {
        if (n2 > 32) {
            throw DbException.getUnsupportedException("Too many tables in join (at most 32 supported).");
        }
        this.filters = new JoinFilter[n2];
        this.additionalFilter = tableFilter;
    }

    public IndexLookupBatch getLookupBatch(int n2) {
        return this.filters[n2].lookupBatch;
    }

    public void reset(boolean bl2) {
        this.current = null;
        this.started = false;
        this.found = false;
        for (JoinFilter joinFilter : this.filters) {
            joinFilter.reset(bl2);
        }
        if (bl2 && this.additionalFilter != null) {
            this.additionalFilter.reset();
        }
    }

    public void register(TableFilter tableFilter, IndexLookupBatch indexLookupBatch) {
        assert (tableFilter != null);
        this.filters[this.top.id] = this.top = new JoinFilter(indexLookupBatch, tableFilter, this.top);
    }

    public Value getValue(int n2, Column column) {
        Object object = this.current.row(n2);
        assert (object != null);
        Row row = this.current.isRow(n2) ? (Row)object : ((Cursor)object).get();
        int n3 = column.getColumnId();
        if (n3 == -1) {
            return ValueLong.get(row.getKey());
        }
        Value value = row.getValue(column.getColumnId());
        if (value == null) {
            throw DbException.throwInternalError("value is null: " + column + " " + row);
        }
        return value;
    }

    private void start() {
        Object object;
        Cursor cursor;
        this.current = new JoinRow(new Object[this.filters.length]);
        if (this.batchedSubQuery) {
            assert (this.viewTopFutureCursor != null);
            cursor = JoinBatch.get(this.viewTopFutureCursor);
        } else {
            object = this.top.filter;
            IndexCursor indexCursor = ((TableFilter)object).getIndexCursor();
            indexCursor.find(((TableFilter)object).getSession(), ((TableFilter)object).getIndexConditions());
            cursor = indexCursor;
        }
        this.current.updateRow(this.top.id, cursor, 0L, 2L);
        object = new JoinRow(null);
        ((JoinRow)object).next = this.current;
        this.current = object;
    }

    public boolean next() {
        if (!this.started) {
            this.start();
            this.started = true;
        }
        if (this.additionalFilter == null) {
            if (this.batchedNext()) {
                assert (this.current.isComplete());
                return true;
            }
            return false;
        }
        while (true) {
            if (!this.found) {
                if (!this.batchedNext()) {
                    return false;
                }
                assert (this.current.isComplete());
                this.found = true;
                this.additionalFilter.reset();
            }
            if (this.additionalFilter.next()) {
                return true;
            }
            this.found = false;
        }
    }

    private static Cursor get(Future<Cursor> future) {
        Cursor cursor;
        try {
            cursor = future.get();
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
        return cursor == null ? EMPTY_CURSOR : cursor;
    }

    /*
     * Unable to fully structure code
     */
    private boolean batchedNext() {
        if (this.current == null) {
            return false;
        }
        this.current = this.current.next;
        if (this.current == null) {
            return false;
        }
        this.current.prev = null;
        var2_2 = var1_1 = this.filters.length - 1;
        while (this.current.row(var2_2) == null) {
            --var2_2;
        }
        block1: while (true) {
            this.fetchCurrent(var2_2);
            if (!this.current.isDropped()) {
                if (var2_2 == var1_1) {
                    return true;
                }
                var3_3 = this.filters[var2_2 + 1];
                if (var3_3.isBatchFull()) {
                    this.current = var3_3.find(this.current);
                }
                if (this.current.row(var3_3.id) != null) {
                    var2_2 = var3_3.id;
                    continue;
                }
            }
            if (this.current.next == null) {
                if (this.current.isDropped()) {
                    this.current = this.current.prev;
                    if (this.current == null) {
                        return false;
                    }
                }
                if (!JoinBatch.$assertionsDisabled && this.current.isDropped()) {
                    throw new AssertionError();
                }
                if (!JoinBatch.$assertionsDisabled && var2_2 == var1_1) {
                    throw new AssertionError();
                }
                var2_2 = 0;
                while (this.current.row(var2_2) != null) {
                    ++var2_2;
                }
                this.current = this.filters[var2_2].find(this.current);
                continue;
            }
            this.current = this.current.next;
            if (!JoinBatch.$assertionsDisabled && this.current.isRow(var2_2)) {
                throw new AssertionError();
            }
            do {
                if (this.current.row(var2_2) == null) ** break;
                continue block1;
                if (!JoinBatch.$assertionsDisabled && var2_2 == this.top.id) {
                    throw new AssertionError();
                }
            } while (JoinBatch.$assertionsDisabled || !this.current.isRow(--var2_2));
            break;
        }
        throw new AssertionError();
    }

    private void fetchCurrent(int n2) {
        boolean bl2;
        JoinFilter joinFilter;
        Cursor cursor;
        block15: {
            boolean bl3;
            assert (this.current.prev == null || this.current.prev.isRow(n2)) : "prev must be already fetched";
            assert (n2 == 0 || this.current.isRow(n2 - 1)) : "left must be already fetched";
            assert (!this.current.isRow(n2)) : "double fetching";
            Object object = this.current.row(n2);
            assert (object != null) : "x null";
            boolean bl4 = bl3 = object == EMPTY_CURSOR;
            if (bl3) {
                if (n2 == 0) {
                    this.current.drop();
                    return;
                }
            } else if (this.current.isFuture(n2)) {
                object = JoinBatch.get((Future)object);
                this.current.updateRow(n2, object, 1L, 2L);
                bl3 = true;
            }
            JoinFilter joinFilter2 = this.filters[n2];
            cursor = (Cursor)object;
            assert (cursor != null);
            joinFilter = joinFilter2.join;
            while (true) {
                if (cursor == null || !cursor.next()) {
                    if (bl3 && joinFilter2.isOuterJoin()) {
                        this.current.updateRow(n2, joinFilter2.getNullRow(), 2L, 3L);
                        cursor = null;
                        bl3 = false;
                    } else {
                        this.current.drop();
                        return;
                    }
                }
                if (!joinFilter2.isOk(cursor == null)) continue;
                bl2 = false;
                if (joinFilter == null || joinFilter.collectSearchRows()) break block15;
                if (joinFilter.isOuterJoin()) break;
            }
            bl2 = true;
        }
        if (cursor != null) {
            this.current = this.current.copyBehind(n2);
            this.current.updateRow(n2, cursor.get(), 2L, 3L);
        }
        if (bl2) {
            this.current.updateRow(joinFilter.id, EMPTY_CURSOR, 0L, 2L);
        }
    }

    private IndexLookupBatch viewIndexLookupBatch(ViewIndex viewIndex) {
        return new ViewIndexLookupBatch(viewIndex);
    }

    public static IndexLookupBatch createViewIndexLookupBatch(ViewIndex viewIndex) {
        Query query = viewIndex.getQuery();
        if (query.isUnion()) {
            ViewIndexLookupBatchUnion viewIndexLookupBatchUnion = new ViewIndexLookupBatchUnion(viewIndex);
            return viewIndexLookupBatchUnion.initialize() ? viewIndexLookupBatchUnion : null;
        }
        JoinBatch joinBatch = ((Select)query).getJoinBatch();
        if (joinBatch == null || joinBatch.getLookupBatch(0) == null) {
            return null;
        }
        assert (!joinBatch.batchedSubQuery);
        joinBatch.batchedSubQuery = true;
        return joinBatch.viewIndexLookupBatch(viewIndex);
    }

    public static IndexLookupBatch createFakeIndexLookupBatch(TableFilter tableFilter) {
        return new FakeLookupBatch(tableFilter);
    }

    public String toString() {
        return "JoinBatch->\nprev->" + (this.current == null ? null : this.current.prev) + "\n" + "curr->" + this.current + "\n" + "next->" + (this.current == null ? null : this.current.next);
    }

    private static class QueryRunnerUnion
    extends QueryRunnerBase {
        Future<Cursor>[] topFutureCursors;
        private ViewIndexLookupBatchUnion batchUnion;

        public QueryRunnerUnion(ViewIndexLookupBatchUnion viewIndexLookupBatchUnion) {
            super(viewIndexLookupBatchUnion.viewIndex);
            this.batchUnion = viewIndexLookupBatchUnion;
            this.topFutureCursors = new Future[viewIndexLookupBatchUnion.filters.size()];
        }

        @Override
        protected void clear() {
            super.clear();
            for (int i2 = 0; i2 < this.topFutureCursors.length; ++i2) {
                this.topFutureCursors[i2] = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Cursor run() throws Exception {
            int n2;
            LocalResult localResult;
            this.viewIndex.setupQueryParameters(this.viewIndex.getSession(), this.first, this.last, null);
            ArrayList<JoinBatch> arrayList = this.batchUnion.joinBatches;
            int n3 = arrayList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                assert (this.topFutureCursors[i2] != null);
                arrayList.get((int)i2).viewTopFutureCursor = this.topFutureCursors[i2];
            }
            try {
                localResult = this.viewIndex.getQuery().query(0);
                n2 = arrayList.size();
            }
            catch (Throwable throwable) {
                int n4 = arrayList.size();
                for (int i3 = 0; i3 < n4; ++i3) {
                    arrayList.get((int)i3).viewTopFutureCursor = null;
                }
                throw throwable;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                arrayList.get((int)n3).viewTopFutureCursor = null;
            }
            return this.newCursor(localResult);
        }
    }

    private static final class ViewIndexLookupBatchUnion
    extends ViewIndexLookupBatchBase<QueryRunnerUnion> {
        ArrayList<JoinFilter> filters;
        ArrayList<JoinBatch> joinBatches;
        private boolean onlyBatchedQueries = true;

        protected ViewIndexLookupBatchUnion(ViewIndex viewIndex) {
            super(viewIndex);
        }

        boolean initialize() {
            return this.collectJoinBatches(this.viewIndex.getQuery()) && this.joinBatches != null;
        }

        private boolean collectJoinBatches(Query query) {
            if (query.isUnion()) {
                SelectUnion selectUnion = (SelectUnion)query;
                return this.collectJoinBatches(selectUnion.getLeft()) && this.collectJoinBatches(selectUnion.getRight());
            }
            Select select = (Select)query;
            JoinBatch joinBatch = select.getJoinBatch();
            if (joinBatch == null) {
                this.onlyBatchedQueries = false;
            } else {
                if (joinBatch.getLookupBatch(0) == null) {
                    return false;
                }
                assert (!joinBatch.batchedSubQuery);
                joinBatch.batchedSubQuery = true;
                if (this.joinBatches == null) {
                    this.joinBatches = New.arrayList();
                    this.filters = New.arrayList();
                }
                this.filters.add(joinBatch.filters[0]);
                this.joinBatches.add(joinBatch);
            }
            return true;
        }

        @Override
        public boolean isBatchFull() {
            for (int i2 = 0; i2 < this.filters.size(); ++i2) {
                if (!this.filters.get(i2).isBatchFull()) continue;
                return true;
            }
            return false;
        }

        @Override
        protected boolean collectSearchRows(QueryRunnerUnion queryRunnerUnion) {
            boolean bl2 = false;
            for (int i2 = 0; i2 < this.filters.size(); ++i2) {
                if (this.filters.get(i2).collectSearchRows()) {
                    bl2 = true;
                    continue;
                }
                queryRunnerUnion.topFutureCursors[i2] = EMPTY_FUTURE_CURSOR;
            }
            return bl2 || !this.onlyBatchedQueries;
        }

        @Override
        protected QueryRunnerUnion newQueryRunner() {
            return new QueryRunnerUnion(this);
        }

        @Override
        protected void startQueryRunners(int n2) {
            for (int i2 = 0; i2 < this.filters.size(); ++i2) {
                int n3;
                List<Future<Cursor>> list = this.filters.get(i2).find();
                int n4 = 0;
                for (n3 = 0; n3 < n2; ++n3) {
                    Future<Cursor>[] futureArray = ((QueryRunnerUnion)this.queryRunner((int)n3)).topFutureCursors;
                    if (futureArray[i2] != null) continue;
                    futureArray[i2] = list.get(n4++);
                }
                assert (n3 == n2);
                assert (n4 == list.size());
            }
        }
    }

    private final class QueryRunner
    extends QueryRunnerBase {
        Future<Cursor> topFutureCursor;

        public QueryRunner(ViewIndex viewIndex) {
            super(viewIndex);
        }

        @Override
        protected void clear() {
            super.clear();
            this.topFutureCursor = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Cursor run() throws Exception {
            LocalResult localResult;
            if (this.topFutureCursor == null) {
                return EMPTY_CURSOR;
            }
            this.viewIndex.setupQueryParameters(this.viewIndex.getSession(), this.first, this.last, null);
            JoinBatch.this.viewTopFutureCursor = this.topFutureCursor;
            try {
                localResult = this.viewIndex.getQuery().query(0);
            }
            finally {
                JoinBatch.this.viewTopFutureCursor = null;
            }
            return this.newCursor(localResult);
        }
    }

    private final class ViewIndexLookupBatch
    extends ViewIndexLookupBatchBase<QueryRunner> {
        ViewIndexLookupBatch(ViewIndex viewIndex) {
            super(viewIndex);
        }

        @Override
        protected QueryRunner newQueryRunner() {
            return new QueryRunner(this.viewIndex);
        }

        @Override
        protected boolean collectSearchRows(QueryRunner queryRunner) {
            return JoinBatch.this.top.collectSearchRows();
        }

        @Override
        public boolean isBatchFull() {
            return JoinBatch.this.top.isBatchFull();
        }

        @Override
        protected void startQueryRunners(int n2) {
            List<Future<Cursor>> list = JoinBatch.this.top.find();
            if (list.size() != n2) {
                throw DbException.throwInternalError("Unexpected result size: " + list.size() + ", expected :" + n2);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                QueryRunner queryRunner = (QueryRunner)this.queryRunner(i2);
                queryRunner.topFutureCursor = list.get(i2);
            }
        }
    }

    private static abstract class QueryRunnerBase
    extends LazyFuture<Cursor> {
        protected final ViewIndex viewIndex;
        protected SearchRow first;
        protected SearchRow last;

        public QueryRunnerBase(ViewIndex viewIndex) {
            this.viewIndex = viewIndex;
        }

        protected void clear() {
            this.last = null;
            this.first = null;
        }

        @Override
        public final boolean reset() {
            if (super.reset()) {
                return true;
            }
            this.clear();
            return false;
        }

        protected final ViewCursor newCursor(LocalResult localResult) {
            ViewCursor viewCursor = new ViewCursor(this.viewIndex, localResult, this.first, this.last);
            this.clear();
            return viewCursor;
        }
    }

    private static abstract class ViewIndexLookupBatchBase<R extends QueryRunnerBase>
    implements IndexLookupBatch {
        protected final ViewIndex viewIndex;
        private final ArrayList<Future<Cursor>> result = New.arrayList();
        private int resultSize;
        private boolean findCalled;

        protected ViewIndexLookupBatchBase(ViewIndex viewIndex) {
            this.viewIndex = viewIndex;
        }

        @Override
        public String getPlanSQL() {
            return "view";
        }

        protected abstract boolean collectSearchRows(R var1);

        protected abstract R newQueryRunner();

        protected abstract void startQueryRunners(int var1);

        protected final boolean resetAfterFind() {
            if (!this.findCalled) {
                return false;
            }
            this.findCalled = false;
            for (int i2 = 0; i2 < this.resultSize; ++i2) {
                ((QueryRunnerBase)this.queryRunner(i2)).reset();
            }
            this.resultSize = 0;
            return true;
        }

        protected R queryRunner(int n2) {
            return (R)((QueryRunnerBase)this.result.get(n2));
        }

        @Override
        public final boolean addSearchRows(SearchRow searchRow, SearchRow searchRow2) {
            R r2;
            this.resetAfterFind();
            this.viewIndex.setupQueryParameters(this.viewIndex.getSession(), searchRow, searchRow2, null);
            if (this.resultSize < this.result.size()) {
                r2 = this.queryRunner(this.resultSize);
            } else {
                r2 = this.newQueryRunner();
                this.result.add((Future<Cursor>)r2);
            }
            ((QueryRunnerBase)r2).first = searchRow;
            ((QueryRunnerBase)r2).last = searchRow2;
            if (!this.collectSearchRows(r2)) {
                ((QueryRunnerBase)r2).clear();
                return false;
            }
            ++this.resultSize;
            return true;
        }

        @Override
        public void reset(boolean bl2) {
            if (this.resultSize != 0 && !this.resetAfterFind()) {
                for (int i2 = 0; i2 < this.resultSize; ++i2) {
                    ((QueryRunnerBase)this.queryRunner(i2)).clear();
                }
                this.resultSize = 0;
            }
        }

        @Override
        public final List<Future<Cursor>> find() {
            if (this.resultSize == 0) {
                return Collections.emptyList();
            }
            this.findCalled = true;
            this.startQueryRunners(this.resultSize);
            return this.resultSize == this.result.size() ? this.result : this.result.subList(0, this.resultSize);
        }
    }

    static final class SingletonList<E>
    extends AbstractList<E> {
        private E element;

        SingletonList() {
        }

        @Override
        public E get(int n2) {
            assert (n2 == 0);
            return this.element;
        }

        @Override
        public E set(int n2, E e2) {
            assert (n2 == 0);
            this.element = e2;
            return null;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    private static final class FakeLookupBatch
    implements IndexLookupBatch {
        private final TableFilter filter;
        private SearchRow first;
        private SearchRow last;
        private boolean full;
        private final List<Future<Cursor>> result = new SingletonList<Future<Cursor>>();

        FakeLookupBatch(TableFilter tableFilter) {
            this.filter = tableFilter;
        }

        @Override
        public String getPlanSQL() {
            return "fake";
        }

        @Override
        public void reset(boolean bl2) {
            this.full = false;
            this.last = null;
            this.first = null;
            this.result.set(0, null);
        }

        @Override
        public boolean addSearchRows(SearchRow searchRow, SearchRow searchRow2) {
            assert (!this.full);
            this.first = searchRow;
            this.last = searchRow2;
            this.full = true;
            return true;
        }

        @Override
        public boolean isBatchFull() {
            return this.full;
        }

        @Override
        public List<Future<Cursor>> find() {
            if (!this.full) {
                return Collections.emptyList();
            }
            Cursor cursor = this.filter.getIndex().find(this.filter, this.first, this.last);
            this.result.set(0, new DoneFuture<Cursor>(cursor));
            this.full = false;
            this.last = null;
            this.first = null;
            return this.result;
        }
    }

    private static final class JoinRow {
        private static final long S_NULL = 0L;
        private static final long S_FUTURE = 1L;
        private static final long S_CURSOR = 2L;
        private static final long S_ROW = 3L;
        private static final long S_MASK = 3L;
        JoinRow prev;
        JoinRow next;
        private Object[] row;
        private long state;

        JoinRow(Object[] objectArray) {
            this.row = objectArray;
        }

        private long getState(int n2) {
            return this.state >>> (n2 << 1) & 3L;
        }

        private void incrementState(int n2, long l2) {
            assert (l2 > 0L) : l2;
            this.state += l2 << (n2 << 1);
        }

        void updateRow(int n2, Object object, long l2, long l3) {
            assert (this.getState(n2) == l2) : "old state: " + this.getState(n2);
            this.row[n2] = object;
            this.incrementState(n2, l3 - l2);
            assert (this.getState(n2) == l3) : "new state: " + this.getState(n2);
        }

        Object row(int n2) {
            return this.row[n2];
        }

        boolean isRow(int n2) {
            return this.getState(n2) == 3L;
        }

        boolean isFuture(int n2) {
            return this.getState(n2) == 1L;
        }

        private boolean isCursor(int n2) {
            return this.getState(n2) == 2L;
        }

        boolean isComplete() {
            return this.isRow(this.row.length - 1);
        }

        boolean isDropped() {
            return this.row == null;
        }

        void drop() {
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            this.row = null;
        }

        JoinRow copyBehind(int n2) {
            assert (this.isCursor(n2));
            assert (n2 + 1 == this.row.length || this.row[n2 + 1] == null);
            Object[] objectArray = new Object[this.row.length];
            if (n2 != 0) {
                System.arraycopy(this.row, 0, objectArray, 0, n2);
            }
            JoinRow joinRow = new JoinRow(objectArray);
            joinRow.state = this.state;
            if (this.prev != null) {
                joinRow.prev = this.prev;
                this.prev.next = joinRow;
            }
            this.prev = joinRow;
            joinRow.next = this;
            return joinRow;
        }

        public String toString() {
            return "JoinRow->" + Arrays.toString(this.row);
        }
    }

    private static final class JoinFilter {
        final IndexLookupBatch lookupBatch;
        final int id;
        final JoinFilter join;
        final TableFilter filter;

        JoinFilter(IndexLookupBatch indexLookupBatch, TableFilter tableFilter, JoinFilter joinFilter) {
            this.filter = tableFilter;
            this.id = tableFilter.getJoinFilterId();
            this.join = joinFilter;
            this.lookupBatch = indexLookupBatch;
            assert (indexLookupBatch != null || this.id == 0);
        }

        void reset(boolean bl2) {
            if (this.lookupBatch != null) {
                this.lookupBatch.reset(bl2);
            }
        }

        Row getNullRow() {
            return this.filter.getTable().getNullRow();
        }

        boolean isOuterJoin() {
            return this.filter.isJoinOuter();
        }

        boolean isBatchFull() {
            return this.lookupBatch.isBatchFull();
        }

        boolean isOk(boolean bl2) {
            boolean bl3 = this.filter.isOk(this.filter.getFilterCondition());
            boolean bl4 = this.filter.isOk(this.filter.getJoinCondition());
            return bl3 && (bl2 || bl4);
        }

        boolean collectSearchRows() {
            assert (!this.isBatchFull());
            IndexCursor indexCursor = this.filter.getIndexCursor();
            indexCursor.prepare(this.filter.getSession(), this.filter.getIndexConditions());
            if (indexCursor.isAlwaysFalse()) {
                return false;
            }
            return this.lookupBatch.addSearchRows(indexCursor.getStart(), indexCursor.getEnd());
        }

        List<Future<Cursor>> find() {
            return this.lookupBatch.find();
        }

        JoinRow find(JoinRow joinRow) {
            assert (joinRow != null);
            List<Future<Cursor>> list = this.lookupBatch.find();
            int n2 = list.size();
            while (n2 > 0) {
                Future<Cursor> future;
                assert (joinRow.isRow(this.id - 1));
                if (joinRow.row(this.id) == EMPTY_CURSOR) {
                    joinRow = joinRow.prev;
                    continue;
                }
                assert (joinRow.row(this.id) == null);
                if ((future = list.get(--n2)) == null) {
                    joinRow.updateRow(this.id, EMPTY_CURSOR, 0L, 2L);
                } else {
                    joinRow.updateRow(this.id, future, 0L, 1L);
                }
                if (joinRow.prev == null || n2 == 0) break;
                joinRow = joinRow.prev;
            }
            while (joinRow.prev != null && joinRow.prev.row(this.id) == EMPTY_CURSOR) {
                joinRow = joinRow.prev;
            }
            assert (joinRow.prev == null || joinRow.prev.isRow(this.id));
            assert (joinRow.row(this.id) != null);
            assert (!joinRow.isRow(this.id));
            return joinRow;
        }

        public String toString() {
            return "JoinFilter->" + this.filter;
        }
    }
}

