/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.h2.store.fs.FileBase;
import org.h2.util.IOUtils;

class FileZip
extends FileBase {
    private static final byte[] SKIP_BUFFER = new byte[1024];
    private final ZipFile file;
    private final ZipEntry entry;
    private long pos;
    private InputStream in;
    private long inPos;
    private final long length;
    private boolean skipUsingRead;

    FileZip(ZipFile zipFile, ZipEntry zipEntry) {
        this.file = zipFile;
        this.entry = zipEntry;
        this.length = zipEntry.getSize();
    }

    @Override
    public long position() {
        return this.pos;
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.seek();
        int n2 = this.in.read(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        if (n2 > 0) {
            byteBuffer.position(byteBuffer.position() + n2);
            this.pos += (long)n2;
            this.inPos += (long)n2;
        }
        return n2;
    }

    private void seek() throws IOException {
        if (this.inPos > this.pos) {
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
        }
        if (this.in == null) {
            this.in = this.file.getInputStream(this.entry);
            this.inPos = 0L;
        }
        if (this.inPos < this.pos) {
            long l2 = this.pos - this.inPos;
            if (!this.skipUsingRead) {
                try {
                    IOUtils.skipFully(this.in, l2);
                }
                catch (NullPointerException nullPointerException) {
                    this.skipUsingRead = true;
                }
            }
            if (this.skipUsingRead) {
                while (l2 > 0L) {
                    int n2 = (int)Math.min((long)SKIP_BUFFER.length, l2);
                    n2 = this.in.read(SKIP_BUFFER, 0, n2);
                    l2 -= (long)n2;
                }
            }
            this.inPos = this.pos;
        }
    }

    @Override
    public FileChannel position(long l2) {
        this.pos = l2;
        return this;
    }

    @Override
    public FileChannel truncate(long l2) throws IOException {
        throw new IOException("File is read-only");
    }

    @Override
    public void force(boolean bl2) throws IOException {
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        throw new IOException("File is read-only");
    }

    @Override
    public synchronized FileLock tryLock(long l2, long l3, boolean bl2) throws IOException {
        if (bl2) {
            return new FileLock(null, l2, l3, bl2){

                @Override
                public boolean isValid() {
                    return true;
                }

                @Override
                public void release() throws IOException {
                }
            };
        }
        return null;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        this.file.close();
    }
}

