/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.h2.message.DbException;
import org.h2.store.fs.FileBase;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathSplit;

class FileSplit
extends FileBase {
    private final FilePathSplit file;
    private final String mode;
    private final long maxLength;
    private FileChannel[] list;
    private long filePointer;
    private long length;

    FileSplit(FilePathSplit filePathSplit, String string, FileChannel[] fileChannelArray, long l2, long l3) {
        this.file = filePathSplit;
        this.mode = string;
        this.list = fileChannelArray;
        this.length = l2;
        this.maxLength = l3;
    }

    @Override
    public void implCloseChannel() throws IOException {
        for (FileChannel fileChannel : this.list) {
            fileChannel.close();
        }
    }

    @Override
    public long position() {
        return this.filePointer;
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.remaining();
        if (n2 == 0) {
            return 0;
        }
        if ((n2 = (int)Math.min((long)n2, this.length - this.filePointer)) <= 0) {
            return -1;
        }
        long l2 = this.filePointer % this.maxLength;
        n2 = (int)Math.min((long)n2, this.maxLength - l2);
        FileChannel fileChannel = this.getFileChannel();
        fileChannel.position(l2);
        n2 = fileChannel.read(byteBuffer);
        this.filePointer += (long)n2;
        return n2;
    }

    @Override
    public FileChannel position(long l2) {
        this.filePointer = l2;
        return this;
    }

    private FileChannel getFileChannel() throws IOException {
        int n2 = (int)(this.filePointer / this.maxLength);
        while (n2 >= this.list.length) {
            int n3 = this.list.length;
            FileChannel[] fileChannelArray = new FileChannel[n3 + 1];
            System.arraycopy(this.list, 0, fileChannelArray, 0, n3);
            FilePath filePath = this.file.getBase(n3);
            fileChannelArray[n3] = filePath.open(this.mode);
            this.list = fileChannelArray;
        }
        return this.list[n2];
    }

    @Override
    public FileChannel truncate(long l2) throws IOException {
        if (l2 >= this.length) {
            return this;
        }
        this.filePointer = Math.min(this.filePointer, l2);
        int n2 = 1 + (int)(l2 / this.maxLength);
        if (n2 < this.list.length) {
            FileChannel[] fileChannelArray = new FileChannel[n2];
            for (int i2 = this.list.length - 1; i2 >= n2; --i2) {
                this.list[i2].truncate(0L);
                this.list[i2].close();
                try {
                    this.file.getBase(i2).delete();
                    continue;
                }
                catch (DbException dbException) {
                    throw DbException.convertToIOException(dbException);
                }
            }
            System.arraycopy(this.list, 0, fileChannelArray, 0, fileChannelArray.length);
            this.list = fileChannelArray;
        }
        long l3 = l2 - this.maxLength * (long)(n2 - 1);
        this.list[this.list.length - 1].truncate(l3);
        this.length = l2;
        return this;
    }

    @Override
    public void force(boolean bl2) throws IOException {
        for (FileChannel fileChannel : this.list) {
            fileChannel.force(bl2);
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        long l2;
        if (this.filePointer >= this.length && this.filePointer > this.maxLength) {
            l2 = this.filePointer;
            for (long i2 = this.length - this.length % this.maxLength + this.maxLength; i2 < this.filePointer; i2 += this.maxLength) {
                if (i2 > this.length) {
                    this.position(i2 - 1L);
                    this.write(ByteBuffer.wrap(new byte[1]));
                }
                this.filePointer = l2;
            }
        }
        l2 = this.filePointer % this.maxLength;
        int n2 = byteBuffer.remaining();
        FileChannel fileChannel = this.getFileChannel();
        fileChannel.position(l2);
        int n3 = (int)Math.min((long)n2, this.maxLength - l2);
        if (n3 == n2) {
            n3 = fileChannel.write(byteBuffer);
        } else {
            int n4 = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + n3);
            n3 = fileChannel.write(byteBuffer);
            byteBuffer.limit(n4);
        }
        this.filePointer += (long)n3;
        this.length = Math.max(this.length, this.filePointer);
        return n3;
    }

    @Override
    public synchronized FileLock tryLock(long l2, long l3, boolean bl2) throws IOException {
        return this.list[0].tryLock(l2, l3, bl2);
    }

    public String toString() {
        return this.file.toString();
    }
}

