/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.h2.store.fs.FileBase;
import org.h2.store.fs.FileUtils;

class FileRetryOnInterrupt
extends FileBase {
    private final String fileName;
    private final String mode;
    private FileChannel channel;
    private FileLockRetry lock;

    FileRetryOnInterrupt(String string, String string2) throws IOException {
        this.fileName = string;
        this.mode = string2;
        this.open();
    }

    private void open() throws IOException {
        this.channel = FileUtils.open(this.fileName, this.mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reopen(int n2, IOException iOException) throws IOException {
        if (n2 > 20) {
            throw iOException;
        }
        if (!(iOException instanceof ClosedByInterruptException) && !(iOException instanceof ClosedChannelException)) {
            throw iOException;
        }
        Thread.interrupted();
        FileChannel fileChannel = this.channel;
        FileRetryOnInterrupt fileRetryOnInterrupt = this;
        synchronized (fileRetryOnInterrupt) {
            if (fileChannel == this.channel) {
                this.open();
                this.reLock();
            }
        }
    }

    private void reLock() throws IOException {
        if (this.lock == null) {
            return;
        }
        try {
            this.lock.base.release();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileLock fileLock = this.channel.tryLock(this.lock.position(), this.lock.size(), this.lock.isShared());
        if (fileLock == null) {
            throw new IOException("Re-locking failed");
        }
        this.lock.base = fileLock;
    }

    @Override
    public void implCloseChannel() throws IOException {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public long position() throws IOException {
        int n2 = 0;
        while (true) {
            try {
                return this.channel.position();
            }
            catch (IOException iOException) {
                this.reopen(n2, iOException);
                ++n2;
                continue;
            }
            break;
        }
    }

    @Override
    public long size() throws IOException {
        int n2 = 0;
        while (true) {
            try {
                return this.channel.size();
            }
            catch (IOException iOException) {
                this.reopen(n2, iOException);
                ++n2;
                continue;
            }
            break;
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        long l2 = this.position();
        int n2 = 0;
        while (true) {
            try {
                return this.channel.read(byteBuffer);
            }
            catch (IOException iOException) {
                this.reopen(n2, iOException);
                this.position(l2);
                ++n2;
                continue;
            }
            break;
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer, long l2) throws IOException {
        int n2 = 0;
        while (true) {
            try {
                return this.channel.read(byteBuffer, l2);
            }
            catch (IOException iOException) {
                this.reopen(n2, iOException);
                ++n2;
                continue;
            }
            break;
        }
    }

    @Override
    public FileChannel position(long l2) throws IOException {
        int n2 = 0;
        while (true) {
            try {
                this.channel.position(l2);
                return this;
            }
            catch (IOException iOException) {
                this.reopen(n2, iOException);
                ++n2;
                continue;
            }
            break;
        }
    }

    @Override
    public FileChannel truncate(long l2) throws IOException {
        int n2 = 0;
        while (true) {
            try {
                this.channel.truncate(l2);
                return this;
            }
            catch (IOException iOException) {
                this.reopen(n2, iOException);
                ++n2;
                continue;
            }
            break;
        }
    }

    @Override
    public void force(boolean bl2) throws IOException {
        int n2 = 0;
        while (true) {
            try {
                this.channel.force(bl2);
            }
            catch (IOException iOException) {
                this.reopen(n2, iOException);
            }
            ++n2;
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        long l2 = this.position();
        int n2 = 0;
        while (true) {
            try {
                return this.channel.write(byteBuffer);
            }
            catch (IOException iOException) {
                this.reopen(n2, iOException);
                this.position(l2);
                ++n2;
                continue;
            }
            break;
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer, long l2) throws IOException {
        int n2 = 0;
        while (true) {
            try {
                return this.channel.write(byteBuffer, l2);
            }
            catch (IOException iOException) {
                this.reopen(n2, iOException);
                ++n2;
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized FileLock tryLock(long l2, long l3, boolean bl2) throws IOException {
        FileLock fileLock = this.channel.tryLock(l2, l3, bl2);
        if (fileLock == null) {
            return null;
        }
        this.lock = new FileLockRetry(fileLock, this);
        return this.lock;
    }

    public String toString() {
        return "retry:" + this.fileName;
    }

    static class FileLockRetry
    extends FileLock {
        FileLock base;

        protected FileLockRetry(FileLock fileLock, FileChannel fileChannel) {
            super(fileChannel, fileLock.position(), fileLock.size(), fileLock.isShared());
            this.base = fileLock;
        }

        @Override
        public boolean isValid() {
            return this.base.isValid();
        }

        @Override
        public void release() throws IOException {
            this.base.release();
        }
    }
}

