/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.h2.store.fs.FileBase;
import org.h2.store.fs.FilePathRec;

class FileRec
extends FileBase {
    private final FilePathRec rec;
    private final FileChannel channel;
    private final String name;

    FileRec(FilePathRec filePathRec, FileChannel fileChannel, String string) {
        this.rec = filePathRec;
        this.channel = fileChannel;
        this.name = string;
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.channel.close();
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.channel.read(byteBuffer);
    }

    @Override
    public int read(ByteBuffer byteBuffer, long l2) throws IOException {
        return this.channel.read(byteBuffer, l2);
    }

    @Override
    public FileChannel position(long l2) throws IOException {
        this.channel.position(l2);
        return this;
    }

    @Override
    public FileChannel truncate(long l2) throws IOException {
        this.rec.log(7, this.name, null, l2);
        this.channel.truncate(l2);
        return this;
    }

    @Override
    public void force(boolean bl2) throws IOException {
        this.channel.force(bl2);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.remaining();
        if (byteBuffer.position() != 0 || n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, byteBuffer.arrayOffset() + byteBuffer.position(), byArray2, 0, n2);
            byArray = byArray2;
        }
        int n3 = this.channel.write(byteBuffer);
        this.rec.log(8, this.name, byArray, this.channel.position());
        return n3;
    }

    @Override
    public int write(ByteBuffer byteBuffer, long l2) throws IOException {
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.remaining();
        if (byteBuffer.position() != 0 || n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, byteBuffer.arrayOffset() + byteBuffer.position(), byArray2, 0, n2);
            byArray = byArray2;
        }
        int n3 = this.channel.write(byteBuffer, l2);
        this.rec.log(8, this.name, byArray, l2);
        return n3;
    }

    @Override
    public synchronized FileLock tryLock(long l2, long l3, boolean bl2) throws IOException {
        return this.channel.tryLock(l2, l3, bl2);
    }

    public String toString() {
        return this.name;
    }
}

