/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileChannelOutputStream;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathWrapper;
import org.h2.store.fs.FileSplit;
import org.h2.util.New;

public class FilePathSplit
extends FilePathWrapper {
    private static final String PART_SUFFIX = ".part";

    @Override
    protected String getPrefix() {
        return this.getScheme() + ":" + this.parse(this.name)[0] + ":";
    }

    @Override
    public FilePath unwrap(String string) {
        return FilePath.get(this.parse(string)[1]);
    }

    @Override
    public boolean setReadOnly() {
        FilePath filePath;
        boolean bl2 = false;
        int n2 = 0;
        while ((filePath = this.getBase(n2)).exists()) {
            bl2 = filePath.setReadOnly();
            ++n2;
        }
        return bl2;
    }

    @Override
    public void delete() {
        FilePath filePath;
        int n2 = 0;
        while ((filePath = this.getBase(n2)).exists()) {
            filePath.delete();
            ++n2;
        }
    }

    @Override
    public long lastModified() {
        FilePath filePath;
        long l2 = 0L;
        int n2 = 0;
        while ((filePath = this.getBase(n2)).exists()) {
            long l3 = filePath.lastModified();
            l2 = Math.max(l2, l3);
            ++n2;
        }
        return l2;
    }

    @Override
    public long size() {
        FilePath filePath;
        long l2 = 0L;
        int n2 = 0;
        while ((filePath = this.getBase(n2)).exists()) {
            l2 += filePath.size();
            ++n2;
        }
        return l2;
    }

    public ArrayList<FilePath> newDirectoryStream() {
        List<FilePath> list = this.getBase().newDirectoryStream();
        ArrayList<FilePath> arrayList = New.arrayList();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FilePath filePath = list.get(i2);
            if (filePath.getName().endsWith(PART_SUFFIX)) continue;
            arrayList.add(this.wrap(filePath));
        }
        return arrayList;
    }

    @Override
    public InputStream newInputStream() throws IOException {
        FilePath filePath;
        InputStream inputStream = this.getBase().newInputStream();
        int n2 = 1;
        while ((filePath = this.getBase(n2)).exists()) {
            InputStream inputStream2 = filePath.newInputStream();
            inputStream = new SequenceInputStream(inputStream, inputStream2);
            ++n2;
        }
        return inputStream;
    }

    @Override
    public FileChannel open(String string) throws IOException {
        long l2;
        FilePath filePath;
        ArrayList<FileChannel> arrayList = New.arrayList();
        arrayList.add(this.getBase().open(string));
        int n2 = 1;
        while ((filePath = this.getBase(n2)).exists()) {
            arrayList.add(filePath.open(string));
            ++n2;
        }
        FileChannel[] fileChannelArray = new FileChannel[arrayList.size()];
        arrayList.toArray(fileChannelArray);
        long l3 = l2 = fileChannelArray[0].size();
        if (fileChannelArray.length == 1) {
            long l4 = this.getDefaultMaxLength();
            if (l2 < l4) {
                l2 = l4;
            }
        } else {
            if (l2 == 0L) {
                this.closeAndThrow(0, fileChannelArray, fileChannelArray[0], l2);
            }
            for (int i2 = 1; i2 < fileChannelArray.length - 1; ++i2) {
                FileChannel fileChannel = fileChannelArray[i2];
                long l5 = fileChannel.size();
                l3 += l5;
                if (l5 == l2) continue;
                this.closeAndThrow(i2, fileChannelArray, fileChannel, l2);
            }
            FileChannel fileChannel = fileChannelArray[fileChannelArray.length - 1];
            long l6 = fileChannel.size();
            l3 += l6;
            if (l6 > l2) {
                this.closeAndThrow(fileChannelArray.length - 1, fileChannelArray, fileChannel, l2);
            }
        }
        return new FileSplit(this, string, fileChannelArray, l3, l2);
    }

    private long getDefaultMaxLength() {
        return 1L << Integer.decode(this.parse(this.name)[0]);
    }

    private void closeAndThrow(int n2, FileChannel[] fileChannelArray, FileChannel fileChannel, long l2) throws IOException {
        String string = "Expected file length: " + l2 + " got: " + fileChannel.size() + " for " + this.getName(n2);
        for (FileChannel fileChannel2 : fileChannelArray) {
            fileChannel2.close();
        }
        throw new IOException(string);
    }

    @Override
    public OutputStream newOutputStream(boolean bl2) throws IOException {
        return new FileChannelOutputStream(this.open("rw"), bl2);
    }

    @Override
    public void moveTo(FilePath filePath, boolean bl2) {
        FilePath filePath2;
        FilePathSplit filePathSplit = (FilePathSplit)filePath;
        int n2 = 0;
        while ((filePath2 = this.getBase(n2)).exists()) {
            filePath2.moveTo(filePathSplit.getBase(n2), bl2);
            ++n2;
        }
    }

    private String[] parse(String string) {
        String string2;
        if (!string.startsWith(this.getScheme())) {
            DbException.throwInternalError(string + " doesn't start with " + this.getScheme());
        }
        if ((string = string.substring(this.getScheme().length() + 1)).length() > 0 && Character.isDigit(string.charAt(0))) {
            int n2 = string.indexOf(58);
            string2 = string.substring(0, n2);
            try {
                string = string.substring(n2 + 1);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            string2 = Long.toString(SysProperties.SPLIT_FILE_SIZE_SHIFT);
        }
        return new String[]{string2, string};
    }

    FilePath getBase(int n2) {
        return FilePath.get(this.getName(n2));
    }

    private String getName(int n2) {
        return n2 > 0 ? this.getBase().name + "." + n2 + PART_SUFFIX : this.getBase().name;
    }

    @Override
    public String getScheme() {
        return "split";
    }
}

