/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Arrays;
import org.h2.engine.Constants;
import org.h2.mvstore.DataUtils;
import org.h2.security.AES;
import org.h2.security.BlockCipher;
import org.h2.security.SHA256;
import org.h2.store.fs.FileBase;
import org.h2.store.fs.FileChannelInputStream;
import org.h2.store.fs.FileChannelOutputStream;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathWrapper;
import org.h2.store.fs.FileUtils;
import org.h2.util.MathUtils;

public class FilePathEncrypt
extends FilePathWrapper {
    private static final String SCHEME = "encrypt";

    public static void register() {
        FilePath.register(new FilePathEncrypt());
    }

    @Override
    public FileChannel open(String string) throws IOException {
        String[] stringArray = this.parse(this.name);
        FileChannel fileChannel = FileUtils.open(stringArray[1], string);
        byte[] byArray = stringArray[0].getBytes(Constants.UTF8);
        return new FileEncrypt(this.name, byArray, fileChannel);
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    protected String getPrefix() {
        String[] stringArray = this.parse(this.name);
        return this.getScheme() + ":" + stringArray[0] + ":";
    }

    @Override
    public FilePath unwrap(String string) {
        return FilePath.get(this.parse(string)[1]);
    }

    @Override
    public long size() {
        long l2 = this.getBase().size() - 4096L;
        if (((l2 = Math.max(0L, l2)) & 0xFFFL) != 0L) {
            l2 -= 4096L;
        }
        return l2;
    }

    @Override
    public OutputStream newOutputStream(boolean bl2) throws IOException {
        return new FileChannelOutputStream(this.open("rw"), bl2);
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return new FileChannelInputStream(this.open("r"), true);
    }

    private String[] parse(String string) {
        if (!string.startsWith(this.getScheme())) {
            throw new IllegalArgumentException(string + " doesn't start with " + this.getScheme());
        }
        int n2 = (string = string.substring(this.getScheme().length() + 1)).indexOf(58);
        if (n2 < 0) {
            throw new IllegalArgumentException(string + " doesn't contain encryption algorithm and password");
        }
        String string2 = string.substring(0, n2);
        string = string.substring(n2 + 1);
        return new String[]{string2, string};
    }

    public static byte[] getPasswordBytes(char[] cArray) {
        int n2 = cArray.length;
        byte[] byArray = new byte[n2 * 2];
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            byArray[i2 + i2] = (byte)(c2 >>> 8);
            byArray[i2 + i2 + 1] = (byte)c2;
        }
        return byArray;
    }

    static class XTS {
        private static final int GF_128_FEEDBACK = 135;
        private static final int CIPHER_BLOCK_SIZE = 16;
        private final BlockCipher cipher;

        XTS(BlockCipher blockCipher) {
            this.cipher = blockCipher;
        }

        void encrypt(long l2, int n2, byte[] byArray, int n3) {
            byte[] byArray2 = this.initTweak(l2);
            int n4 = 0;
            while (n4 + 16 <= n2) {
                if (n4 > 0) {
                    XTS.updateTweak(byArray2);
                }
                XTS.xorTweak(byArray, n4 + n3, byArray2);
                this.cipher.encrypt(byArray, n4 + n3, 16);
                XTS.xorTweak(byArray, n4 + n3, byArray2);
                n4 += 16;
            }
            if (n4 < n2) {
                XTS.updateTweak(byArray2);
                XTS.swap(byArray, n4 + n3, n4 - 16 + n3, n2 - n4);
                XTS.xorTweak(byArray, n4 - 16 + n3, byArray2);
                this.cipher.encrypt(byArray, n4 - 16 + n3, 16);
                XTS.xorTweak(byArray, n4 - 16 + n3, byArray2);
            }
        }

        void decrypt(long l2, int n2, byte[] byArray, int n3) {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = this.initTweak(l2);
            int n4 = 0;
            while (n4 + 16 <= n2) {
                if (n4 > 0) {
                    XTS.updateTweak(byArray2);
                    if (n4 + 16 + 16 > n2 && n4 + 16 < n2) {
                        byArray3 = (byte[])byArray2.clone();
                        XTS.updateTweak(byArray2);
                    }
                }
                XTS.xorTweak(byArray, n4 + n3, byArray2);
                this.cipher.decrypt(byArray, n4 + n3, 16);
                XTS.xorTweak(byArray, n4 + n3, byArray2);
                n4 += 16;
            }
            if (n4 < n2) {
                XTS.swap(byArray, n4, n4 - 16 + n3, n2 - n4 + n3);
                XTS.xorTweak(byArray, n4 - 16 + n3, byArray3);
                this.cipher.decrypt(byArray, n4 - 16 + n3, 16);
                XTS.xorTweak(byArray, n4 - 16 + n3, byArray3);
            }
        }

        private byte[] initTweak(long l2) {
            byte[] byArray = new byte[16];
            int n2 = 0;
            while (n2 < 16) {
                byArray[n2] = (byte)(l2 & 0xFFL);
                ++n2;
                l2 >>>= 8;
            }
            this.cipher.encrypt(byArray, 0, 16);
            return byArray;
        }

        private static void xorTweak(byte[] byArray, int n2, byte[] byArray2) {
            for (int i2 = 0; i2 < 16; ++i2) {
                int n3 = n2 + i2;
                byArray[n3] = (byte)(byArray[n3] ^ byArray2[i2]);
            }
        }

        private static void updateTweak(byte[] byArray) {
            int n2 = 0;
            byte by2 = 0;
            for (int i2 = 0; i2 < 16; ++i2) {
                by2 = (byte)(byArray[i2] >> 7 & 1);
                byArray[i2] = (byte)((byArray[i2] << 1) + n2 & 0xFF);
                n2 = by2;
            }
            if (by2 != 0) {
                byArray[0] = (byte)(byArray[0] ^ 0x87);
            }
        }

        private static void swap(byte[] byArray, int n2, int n3, int n4) {
            for (int i2 = 0; i2 < n4; ++i2) {
                byte by2 = byArray[n2 + i2];
                byArray[n2 + i2] = byArray[n3 + i2];
                byArray[n3 + i2] = by2;
            }
        }
    }

    public static class FileEncrypt
    extends FileBase {
        static final int BLOCK_SIZE = 4096;
        static final int BLOCK_SIZE_MASK = 4095;
        static final int HEADER_LENGTH = 4096;
        private static final byte[] HEADER = "H2encrypt\n".getBytes();
        private static final int SALT_POS = HEADER.length;
        private static final int SALT_LENGTH = 8;
        private static final int HASH_ITERATIONS = 10;
        private final FileChannel base;
        private long pos;
        private long size;
        private final String name;
        private XTS xts;
        private byte[] encryptionKey;

        public FileEncrypt(String string, byte[] byArray, FileChannel fileChannel) {
            this.name = string;
            this.base = fileChannel;
            this.encryptionKey = byArray;
        }

        private void init() throws IOException {
            byte[] byArray;
            Object object;
            boolean bl2;
            if (this.xts != null) {
                return;
            }
            this.size = this.base.size() - 4096L;
            boolean bl3 = bl2 = this.size < 0L;
            if (bl2) {
                object = Arrays.copyOf(HEADER, 4096);
                byArray = MathUtils.secureRandomBytes(8);
                System.arraycopy(byArray, 0, object, SALT_POS, byArray.length);
                DataUtils.writeFully(this.base, 0L, ByteBuffer.wrap((byte[])object));
                this.size = 0L;
            } else {
                byArray = new byte[8];
                DataUtils.readFully(this.base, SALT_POS, ByteBuffer.wrap(byArray));
                if ((this.size & 0xFFFL) != 0L) {
                    this.size -= 4096L;
                }
            }
            object = new AES();
            ((AES)object).setKey(SHA256.getPBKDF2(this.encryptionKey, byArray, 10, 16));
            this.encryptionKey = null;
            this.xts = new XTS((BlockCipher)object);
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.base.close();
        }

        @Override
        public FileChannel position(long l2) throws IOException {
            this.pos = l2;
            return this;
        }

        @Override
        public long position() throws IOException {
            return this.pos;
        }

        @Override
        public int read(ByteBuffer byteBuffer) throws IOException {
            int n2 = this.read(byteBuffer, this.pos);
            if (n2 > 0) {
                this.pos += (long)n2;
            }
            return n2;
        }

        @Override
        public int read(ByteBuffer byteBuffer, long l2) throws IOException {
            int n2 = byteBuffer.remaining();
            if (n2 == 0) {
                return 0;
            }
            this.init();
            n2 = (int)Math.min((long)n2, this.size - l2);
            if (l2 >= this.size) {
                return -1;
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("pos: " + l2);
            }
            if ((l2 & 0xFFFL) != 0L || (n2 & 0xFFF) != 0) {
                long l3 = l2 / 4096L * 4096L;
                int n3 = (int)(l2 - l3);
                int n4 = (n2 + n3 + 4096 - 1) / 4096 * 4096;
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n4);
                this.readInternal(byteBuffer2, l3, n4);
                byteBuffer2.flip();
                byteBuffer2.limit(n3 + n2);
                byteBuffer2.position(n3);
                byteBuffer.put(byteBuffer2);
                return n2;
            }
            this.readInternal(byteBuffer, l2, n2);
            return n2;
        }

        private void readInternal(ByteBuffer byteBuffer, long l2, int n2) throws IOException {
            int n3 = byteBuffer.position();
            FileEncrypt.readFully(this.base, l2 + 4096L, byteBuffer);
            long l3 = l2 / 4096L;
            while (n2 > 0) {
                this.xts.decrypt(l3++, 4096, byteBuffer.array(), byteBuffer.arrayOffset() + n3);
                n3 += 4096;
                n2 -= 4096;
            }
        }

        private static void readFully(FileChannel fileChannel, long l2, ByteBuffer byteBuffer) throws IOException {
            do {
                int n2;
                if ((n2 = fileChannel.read(byteBuffer, l2)) < 0) {
                    throw new EOFException();
                }
                l2 += (long)n2;
            } while (byteBuffer.remaining() > 0);
        }

        @Override
        public int write(ByteBuffer byteBuffer, long l2) throws IOException {
            this.init();
            int n2 = byteBuffer.remaining();
            if ((l2 & 0xFFFL) != 0L || (n2 & 0xFFF) != 0) {
                long l3 = l2 / 4096L * 4096L;
                int n3 = (int)(l2 - l3);
                int n4 = (n2 + n3 + 4096 - 1) / 4096 * 4096;
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n4);
                int n5 = (int)(this.size - l3 + 4096L - 1L) / 4096 * 4096;
                int n6 = Math.min(n4, n5);
                if (n6 > 0) {
                    this.readInternal(byteBuffer2, l3, n6);
                    byteBuffer2.rewind();
                }
                byteBuffer2.limit(n3 + n2);
                byteBuffer2.position(n3);
                byteBuffer2.put(byteBuffer);
                byteBuffer2.limit(n4);
                byteBuffer2.rewind();
                this.writeInternal(byteBuffer2, l3, n4);
                long l4 = l2 + (long)n2;
                this.size = Math.max(this.size, l4);
                int n7 = (int)(this.size & 0xFFFL);
                if (n7 > 0) {
                    byteBuffer2 = ByteBuffer.allocate(n7);
                    DataUtils.writeFully(this.base, l3 + 4096L + (long)n4, byteBuffer2);
                }
                return n2;
            }
            this.writeInternal(byteBuffer, l2, n2);
            long l5 = l2 + (long)n2;
            this.size = Math.max(this.size, l5);
            return n2;
        }

        private void writeInternal(ByteBuffer byteBuffer, long l2, int n2) throws IOException {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            long l3 = l2 / 4096L;
            int n3 = 0;
            for (int i2 = n2; i2 > 0; i2 -= 4096) {
                this.xts.encrypt(l3++, 4096, byteBuffer2.array(), byteBuffer2.arrayOffset() + n3);
                n3 += 4096;
            }
            FileEncrypt.writeFully(this.base, l2 + 4096L, byteBuffer2);
        }

        private static void writeFully(FileChannel fileChannel, long l2, ByteBuffer byteBuffer) throws IOException {
            int n2 = 0;
            do {
                int n3 = fileChannel.write(byteBuffer, l2 + (long)n2);
                n2 += n3;
            } while (byteBuffer.remaining() > 0);
        }

        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            int n2 = this.write(byteBuffer, this.pos);
            if (n2 > 0) {
                this.pos += (long)n2;
            }
            return n2;
        }

        @Override
        public long size() throws IOException {
            this.init();
            return this.size;
        }

        @Override
        public FileChannel truncate(long l2) throws IOException {
            this.init();
            if (l2 > this.size) {
                return this;
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("newSize: " + l2);
            }
            int n2 = (int)(l2 & 0xFFFL);
            if (n2 > 0) {
                this.base.truncate(l2 + 4096L + 4096L);
            } else {
                this.base.truncate(l2 + 4096L);
            }
            this.size = l2;
            this.pos = Math.min(this.pos, this.size);
            return this;
        }

        @Override
        public void force(boolean bl2) throws IOException {
            this.base.force(bl2);
        }

        @Override
        public FileLock tryLock(long l2, long l3, boolean bl2) throws IOException {
            return this.base.tryLock(l2, l3, bl2);
        }

        public String toString() {
            return this.name;
        }
    }
}

