/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.h2.compress.CompressLZF;
import org.h2.util.MathUtils;

class FileNioMemData {
    private static final int CACHE_SIZE = 8;
    private static final int BLOCK_SIZE_SHIFT = 16;
    private static final int BLOCK_SIZE = 65536;
    private static final int BLOCK_SIZE_MASK = 65535;
    private static final CompressLZF LZF = new CompressLZF();
    private static final byte[] BUFFER = new byte[131072];
    private static final ByteBuffer COMPRESSED_EMPTY_BLOCK;
    private static final Cache<CompressItem, CompressItem> COMPRESS_LATER;
    private String name;
    private final boolean compress;
    private long length;
    private ByteBuffer[] data;
    private long lastModified;
    private boolean isReadOnly;
    private boolean isLockedExclusive;
    private int sharedLockCount;

    FileNioMemData(String string, boolean bl2) {
        this.name = string;
        this.compress = bl2;
        this.data = new ByteBuffer[0];
        this.lastModified = System.currentTimeMillis();
    }

    synchronized boolean lockExclusive() {
        if (this.sharedLockCount > 0 || this.isLockedExclusive) {
            return false;
        }
        this.isLockedExclusive = true;
        return true;
    }

    synchronized boolean lockShared() {
        if (this.isLockedExclusive) {
            return false;
        }
        ++this.sharedLockCount;
        return true;
    }

    synchronized void unlock() {
        if (this.isLockedExclusive) {
            this.isLockedExclusive = false;
        } else {
            this.sharedLockCount = Math.max(0, this.sharedLockCount - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compressLater(ByteBuffer[] byteBufferArray, int n2) {
        CompressItem compressItem = new CompressItem();
        compressItem.data = byteBufferArray;
        compressItem.page = n2;
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            COMPRESS_LATER.put(compressItem, compressItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expand(ByteBuffer[] byteBufferArray, int n2) {
        ByteBuffer byteBuffer = byteBufferArray[n2];
        if (byteBuffer.capacity() == 65536) {
            return;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(65536);
        if (byteBuffer != COMPRESSED_EMPTY_BLOCK) {
            CompressLZF compressLZF = LZF;
            synchronized (compressLZF) {
                byteBuffer.position(0);
                CompressLZF.expand(byteBuffer, byteBuffer2);
            }
        }
        byteBufferArray[n2] = byteBuffer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void compress(ByteBuffer[] byteBufferArray, int n2) {
        ByteBuffer byteBuffer = byteBufferArray[n2];
        CompressLZF compressLZF = LZF;
        synchronized (compressLZF) {
            int n3 = LZF.compress(byteBuffer, 0, BUFFER, 0);
            byteBuffer = ByteBuffer.allocateDirect(n3);
            byteBuffer.put(BUFFER, 0, n3);
            byteBufferArray[n2] = byteBuffer;
        }
    }

    void touch(boolean bl2) throws IOException {
        if (this.isReadOnly || bl2) {
            throw new IOException("Read only");
        }
        this.lastModified = System.currentTimeMillis();
    }

    long length() {
        return this.length;
    }

    void truncate(long l2) {
        this.changeLength(l2);
        long l3 = MathUtils.roundUpLong(l2, 65536L);
        if (l3 != l2) {
            int n2 = (int)(l2 >>> 16);
            FileNioMemData.expand(this.data, n2);
            ByteBuffer byteBuffer = this.data[n2];
            for (int i2 = (int)(l2 & 0xFFFFL); i2 < 65536; ++i2) {
                byteBuffer.put(i2, (byte)0);
            }
            if (this.compress) {
                FileNioMemData.compressLater(this.data, n2);
            }
        }
    }

    private void changeLength(long l2) {
        this.length = l2;
        int n2 = (int)((l2 = MathUtils.roundUpLong(l2, 65536L)) >>> 16);
        if (n2 != this.data.length) {
            ByteBuffer[] byteBufferArray = new ByteBuffer[n2];
            System.arraycopy(this.data, 0, byteBufferArray, 0, Math.min(this.data.length, byteBufferArray.length));
            for (int i2 = this.data.length; i2 < n2; ++i2) {
                byteBufferArray[i2] = COMPRESSED_EMPTY_BLOCK;
            }
            this.data = byteBufferArray;
        }
    }

    long readWrite(long l2, ByteBuffer byteBuffer, int n2, int n3, boolean bl2) {
        long l3 = l2 + (long)n3;
        if (l3 > this.length) {
            if (bl2) {
                this.changeLength(l3);
            } else {
                n3 = (int)(this.length - l2);
            }
        }
        while (n3 > 0) {
            ByteBuffer byteBuffer2;
            int n4 = (int)Math.min((long)n3, 65536L - (l2 & 0xFFFFL));
            int n5 = (int)(l2 >>> 16);
            FileNioMemData.expand(this.data, n5);
            ByteBuffer byteBuffer3 = this.data[n5];
            int n6 = (int)(l2 & 0xFFFFL);
            if (bl2) {
                byteBuffer2 = byteBuffer.slice();
                byteBuffer2.position(n2);
                byteBuffer2.limit(n2 + n4);
                byteBuffer3.position(n6);
                byteBuffer3.put(byteBuffer2);
            } else {
                byteBuffer3.position(n6);
                byteBuffer2 = byteBuffer3.slice();
                byteBuffer2.limit(n4);
                int n7 = byteBuffer.position();
                byteBuffer.position(n2);
                byteBuffer.put(byteBuffer2);
                byteBuffer.position(n7);
            }
            if (this.compress) {
                FileNioMemData.compressLater(this.data, n5);
            }
            n2 += n4;
            l2 += (long)n4;
            n3 -= n4;
        }
        return l2;
    }

    void setName(String string) {
        this.name = string;
    }

    String getName() {
        return this.name;
    }

    long getLastModified() {
        return this.lastModified;
    }

    boolean canWrite() {
        return !this.isReadOnly;
    }

    boolean setReadOnly() {
        this.isReadOnly = true;
        return true;
    }

    static {
        COMPRESS_LATER = new Cache(8);
        byte[] byArray = new byte[65536];
        int n2 = LZF.compress(byArray, 65536, BUFFER, 0);
        COMPRESSED_EMPTY_BLOCK = ByteBuffer.allocateDirect(n2);
        COMPRESSED_EMPTY_BLOCK.put(BUFFER, 0, n2);
    }

    static class CompressItem {
        ByteBuffer[] data;
        int page;

        CompressItem() {
        }

        public int hashCode() {
            return this.page;
        }

        public boolean equals(Object object) {
            if (object instanceof CompressItem) {
                CompressItem compressItem = (CompressItem)object;
                return compressItem.data == this.data && compressItem.page == this.page;
            }
            return false;
        }
    }

    static class Cache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int size;

        Cache(int n2) {
            super(n2, 0.75f, true);
            this.size = n2;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            if (this.size() < this.size) {
                return false;
            }
            CompressItem compressItem = (CompressItem)entry.getKey();
            FileNioMemData.compress(compressItem.data, compressItem.page);
            return true;
        }
    }
}

