/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.h2.engine.SysProperties;
import org.h2.store.fs.FileBase;

class FileNioMapped
extends FileBase {
    private static final long GC_TIMEOUT_MS = 10000L;
    private final String name;
    private final FileChannel.MapMode mode;
    private RandomAccessFile file;
    private MappedByteBuffer mapped;
    private long fileLength;
    private int pos;

    FileNioMapped(String string, String string2) throws IOException {
        this.mode = "r".equals(string2) ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
        this.name = string;
        this.file = new RandomAccessFile(string, string2);
        this.reMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unMap() throws IOException {
        Object object;
        if (this.mapped == null) {
            return;
        }
        this.mapped.force();
        boolean bl2 = true;
        if (SysProperties.NIO_CLEANER_HACK) {
            try {
                object = this.mapped.getClass().getMethod("cleaner", new Class[0]);
                ((Method)object).setAccessible(true);
                Object object2 = ((Method)object).invoke((Object)this.mapped, new Object[0]);
                if (object2 != null) {
                    Method method = object2.getClass().getMethod("clean", new Class[0]);
                    method.invoke(object2, new Object[0]);
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
            }
            finally {
                this.mapped = null;
            }
        }
        if (bl2) {
            object = new WeakReference<MappedByteBuffer>(this.mapped);
            this.mapped = null;
            long l2 = System.currentTimeMillis();
            while (((Reference)object).get() != null) {
                if (System.currentTimeMillis() - l2 > 10000L) {
                    throw new IOException("Timeout (10000 ms) reached while trying to GC mapped buffer");
                }
                System.gc();
                Thread.yield();
            }
        }
    }

    private void reMap() throws IOException {
        int n2 = 0;
        if (this.mapped != null) {
            n2 = this.pos;
            this.unMap();
        }
        this.fileLength = this.file.length();
        FileNioMapped.checkFileSizeLimit(this.fileLength);
        this.mapped = this.file.getChannel().map(this.mode, 0L, this.fileLength);
        int n3 = this.mapped.limit();
        int n4 = this.mapped.capacity();
        if ((long)n3 < this.fileLength || (long)n4 < this.fileLength) {
            throw new IOException("Unable to map: length=" + n3 + " capacity=" + n4 + " length=" + this.fileLength);
        }
        if (SysProperties.NIO_LOAD_MAPPED) {
            this.mapped.load();
        }
        this.pos = Math.min(n2, (int)this.fileLength);
    }

    private static void checkFileSizeLimit(long l2) throws IOException {
        if (l2 > Integer.MAX_VALUE) {
            throw new IOException("File over 2GB is not supported yet when using this file system");
        }
    }

    @Override
    public void implCloseChannel() throws IOException {
        if (this.file != null) {
            this.unMap();
            this.file.close();
            this.file = null;
        }
    }

    @Override
    public long position() {
        return this.pos;
    }

    public String toString() {
        return "nioMapped:" + this.name;
    }

    @Override
    public synchronized long size() throws IOException {
        return this.fileLength;
    }

    @Override
    public synchronized int read(ByteBuffer byteBuffer) throws IOException {
        try {
            int n2 = byteBuffer.remaining();
            if (n2 == 0) {
                return 0;
            }
            if ((n2 = (int)Math.min((long)n2, this.fileLength - (long)this.pos)) <= 0) {
                return -1;
            }
            this.mapped.position(this.pos);
            this.mapped.get(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n2);
            byteBuffer.position(byteBuffer.position() + n2);
            this.pos += n2;
            return n2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EOFException eOFException = new EOFException("EOF");
            eOFException.initCause(illegalArgumentException);
            throw eOFException;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            EOFException eOFException = new EOFException("EOF");
            eOFException.initCause(bufferUnderflowException);
            throw eOFException;
        }
    }

    @Override
    public FileChannel position(long l2) throws IOException {
        FileNioMapped.checkFileSizeLimit(l2);
        this.pos = (int)l2;
        return this;
    }

    @Override
    public synchronized FileChannel truncate(long l2) throws IOException {
        if (this.mode == FileChannel.MapMode.READ_ONLY) {
            throw new NonWritableChannelException();
        }
        if (l2 < this.size()) {
            this.setFileLength(l2);
        }
        return this;
    }

    public synchronized void setFileLength(long l2) throws IOException {
        FileNioMapped.checkFileSizeLimit(l2);
        int n2 = this.pos;
        this.unMap();
        int n3 = 0;
        while (true) {
            try {
                this.file.setLength(l2);
            }
            catch (IOException iOException) {
                if (n3 > 16 || iOException.toString().indexOf("user-mapped section open") < 0) {
                    throw iOException;
                }
                System.gc();
                ++n3;
                continue;
            }
            break;
        }
        this.reMap();
        this.pos = (int)Math.min(l2, (long)n2);
    }

    @Override
    public void force(boolean bl2) throws IOException {
        this.mapped.force();
        this.file.getFD().sync();
    }

    @Override
    public synchronized int write(ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.remaining();
        if (this.mapped.capacity() < this.pos + n2) {
            this.setFileLength(this.pos + n2);
        }
        this.mapped.position(this.pos);
        this.mapped.put(byteBuffer);
        this.pos += n2;
        return n2;
    }

    @Override
    public synchronized FileLock tryLock(long l2, long l3, boolean bl2) throws IOException {
        return this.file.getChannel().tryLock(l2, l3, bl2);
    }
}

