/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.h2.store.fs.FileBase;

class FileNio
extends FileBase {
    private final String name;
    private final FileChannel channel;

    FileNio(String string, String string2) throws IOException {
        this.name = string;
        this.channel = new RandomAccessFile(string, string2).getChannel();
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.channel.close();
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.channel.read(byteBuffer);
    }

    @Override
    public FileChannel position(long l2) throws IOException {
        this.channel.position(l2);
        return this;
    }

    @Override
    public int read(ByteBuffer byteBuffer, long l2) throws IOException {
        return this.channel.read(byteBuffer, l2);
    }

    @Override
    public int write(ByteBuffer byteBuffer, long l2) throws IOException {
        return this.channel.write(byteBuffer, l2);
    }

    @Override
    public FileChannel truncate(long l2) throws IOException {
        long l3 = this.channel.size();
        if (l2 < l3) {
            long l4 = this.channel.position();
            this.channel.truncate(l2);
            long l5 = this.channel.position();
            if (l4 < l2) {
                if (l5 != l4) {
                    this.channel.position(l4);
                }
            } else if (l5 > l2) {
                this.channel.position(l2);
            }
        }
        return this;
    }

    @Override
    public void force(boolean bl2) throws IOException {
        this.channel.force(bl2);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        try {
            return this.channel.write(byteBuffer);
        }
        catch (NonWritableChannelException nonWritableChannelException) {
            throw new IOException("read only");
        }
    }

    @Override
    public synchronized FileLock tryLock(long l2, long l3, boolean bl2) throws IOException {
        return this.channel.tryLock(l2, l3, bl2);
    }

    public String toString() {
        return "nio:" + this.name;
    }
}

