/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.h2.store.fs.FileBase;
import org.h2.store.fs.FileMemData;

class FileMem
extends FileBase {
    final FileMemData data;
    private final boolean readOnly;
    private long pos;

    FileMem(FileMemData fileMemData, boolean bl2) {
        this.data = fileMemData;
        this.readOnly = bl2;
    }

    @Override
    public long size() {
        return this.data.length();
    }

    @Override
    public FileChannel truncate(long l2) throws IOException {
        if (this.readOnly) {
            throw new NonWritableChannelException();
        }
        if (l2 < this.size()) {
            this.data.touch(this.readOnly);
            this.pos = Math.min(this.pos, l2);
            this.data.truncate(l2);
        }
        return this;
    }

    @Override
    public FileChannel position(long l2) {
        this.pos = l2;
        return this;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.remaining();
        if (n2 == 0) {
            return 0;
        }
        this.data.touch(this.readOnly);
        this.pos = this.data.readWrite(this.pos, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n2, true);
        byteBuffer.position(byteBuffer.position() + n2);
        return n2;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.remaining();
        if (n2 == 0) {
            return 0;
        }
        long l2 = this.data.readWrite(this.pos, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n2, false);
        n2 = (int)(l2 - this.pos);
        if (n2 <= 0) {
            return -1;
        }
        byteBuffer.position(byteBuffer.position() + n2);
        this.pos = l2;
        return n2;
    }

    @Override
    public long position() {
        return this.pos;
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.pos = 0L;
    }

    @Override
    public void force(boolean bl2) throws IOException {
    }

    @Override
    public synchronized FileLock tryLock(long l2, long l3, boolean bl2) throws IOException {
        if (bl2 ? !this.data.lockShared() : !this.data.lockExclusive()) {
            return null;
        }
        FileLock fileLock = new FileLock(null, l2, l3, bl2){

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public void release() throws IOException {
                FileMem.this.data.unlock();
            }
        };
        return fileLock;
    }

    public String toString() {
        return this.data.getName();
    }
}

