/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.h2.engine.SysProperties;
import org.h2.store.fs.FileBase;

class FileDisk
extends FileBase {
    private final RandomAccessFile file;
    private final String name;
    private final boolean readOnly;

    FileDisk(String string, String string2) throws FileNotFoundException {
        this.file = new RandomAccessFile(string, string2);
        this.name = string;
        this.readOnly = string2.equals("r");
    }

    @Override
    public void force(boolean bl2) throws IOException {
        String string = SysProperties.SYNC_METHOD;
        if (!"".equals(string)) {
            if ("sync".equals(string)) {
                this.file.getFD().sync();
            } else if ("force".equals(string)) {
                this.file.getChannel().force(true);
            } else if ("forceFalse".equals(string)) {
                this.file.getChannel().force(false);
            } else {
                this.file.getFD().sync();
            }
        }
    }

    @Override
    public FileChannel truncate(long l2) throws IOException {
        if (this.readOnly) {
            throw new NonWritableChannelException();
        }
        if (l2 < this.file.length()) {
            this.file.setLength(l2);
        }
        return this;
    }

    @Override
    public synchronized FileLock tryLock(long l2, long l3, boolean bl2) throws IOException {
        return this.file.getChannel().tryLock(l2, l3, bl2);
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.file.close();
    }

    @Override
    public long position() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public long size() throws IOException {
        return this.file.length();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n2 = this.file.read(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        if (n2 > 0) {
            byteBuffer.position(byteBuffer.position() + n2);
        }
        return n2;
    }

    @Override
    public FileChannel position(long l2) throws IOException {
        this.file.seek(l2);
        return this;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.remaining();
        this.file.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n2);
        byteBuffer.position(byteBuffer.position() + n2);
        return n2;
    }

    public String toString() {
        return this.name;
    }
}

