/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import org.h2.Driver;
import org.h2.engine.Database;
import org.h2.message.TraceSystem;

public class WriterThread
implements Runnable {
    private volatile WeakReference<Database> databaseRef;
    private int writeDelay;
    private Thread thread;
    private volatile boolean stop;

    private WriterThread(Database database, int n2) {
        this.databaseRef = new WeakReference<Database>(database);
        this.writeDelay = n2;
    }

    public void setWriteDelay(int n2) {
        this.writeDelay = n2;
    }

    public static WriterThread create(Database database, int n2) {
        try {
            WriterThread writerThread = new WriterThread(database, n2);
            writerThread.thread = new Thread((Runnable)writerThread, "H2 Log Writer " + database.getShortName());
            Driver.setThreadContextClassLoader(writerThread.thread);
            writerThread.thread.setDaemon(true);
            return writerThread;
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Database database;
        while (!this.stop && (database = (Database)this.databaseRef.get()) != null) {
            int n2;
            block11: {
                n2 = this.writeDelay;
                try {
                    if (database.isFileLockSerialized()) {
                        n2 = 5;
                        database.checkpointIfRequired();
                    } else {
                        database.flush();
                    }
                }
                catch (Exception exception) {
                    TraceSystem traceSystem = database.getTraceSystem();
                    if (traceSystem == null) break block11;
                    traceSystem.getTrace(2).error(exception, "flush");
                }
            }
            WriterThread writerThread = this;
            synchronized (writerThread) {
                int n3;
                for (n2 = Math.max(n2, 5); !this.stop && n2 > 0; n2 -= n3) {
                    n3 = Math.min(n2, 100);
                    try {
                        this.wait(n3);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.databaseRef = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        this.stop = true;
        WriterThread writerThread = this;
        synchronized (writerThread) {
            this.notify();
        }
    }

    public void startThread() {
        this.thread.start();
        this.thread = null;
    }
}

