/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.store.PageStreamData;

public class PageStreamTrunk
extends Page {
    private static final int DATA_START = 17;
    int parent;
    int nextTrunk;
    private final PageStore store;
    private int logKey;
    private int[] pageIds;
    private int pageCount;
    private Data data;

    private PageStreamTrunk(PageStore pageStore, int n2, int n3, int n4, int n5, int[] nArray) {
        this.setPos(n3);
        this.parent = n2;
        this.store = pageStore;
        this.nextTrunk = n4;
        this.logKey = n5;
        this.pageCount = nArray.length;
        this.pageIds = nArray;
    }

    private PageStreamTrunk(PageStore pageStore, Data data, int n2) {
        this.setPos(n2);
        this.data = data;
        this.store = pageStore;
    }

    static PageStreamTrunk read(PageStore pageStore, Data data, int n2) {
        PageStreamTrunk pageStreamTrunk = new PageStreamTrunk(pageStore, data, n2);
        pageStreamTrunk.read();
        return pageStreamTrunk;
    }

    static PageStreamTrunk create(PageStore pageStore, int n2, int n3, int n4, int n5, int[] nArray) {
        return new PageStreamTrunk(pageStore, n2, n3, n4, n5, nArray);
    }

    private void read() {
        this.data.reset();
        this.data.readByte();
        this.data.readShortInt();
        this.parent = this.data.readInt();
        this.logKey = this.data.readInt();
        this.nextTrunk = this.data.readInt();
        this.pageCount = this.data.readShortInt();
        this.pageIds = new int[this.pageCount];
        for (int i2 = 0; i2 < this.pageCount; ++i2) {
            this.pageIds[i2] = this.data.readInt();
        }
    }

    int getPageData(int n2) {
        if (n2 >= this.pageIds.length) {
            return -1;
        }
        return this.pageIds[n2];
    }

    @Override
    public void write() {
        this.data = this.store.createData();
        this.data.writeByte((byte)7);
        this.data.writeShortInt(0);
        this.data.writeInt(this.parent);
        this.data.writeInt(this.logKey);
        this.data.writeInt(this.nextTrunk);
        this.data.writeShortInt(this.pageCount);
        for (int i2 = 0; i2 < this.pageCount; ++i2) {
            this.data.writeInt(this.pageIds[i2]);
        }
        this.store.writePage(this.getPos(), this.data);
    }

    static int getPagesAddressed(int n2) {
        return (n2 - 17) / 4;
    }

    boolean contains(int n2) {
        for (int i2 = 0; i2 < this.pageCount; ++i2) {
            if (this.pageIds[i2] != n2) continue;
            return true;
        }
        return false;
    }

    int free(int n2) {
        this.store.free(this.getPos(), false);
        int n3 = 1;
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.pageCount; ++i2) {
            int n4 = this.pageIds[i2];
            if (bl2) {
                this.store.freeUnused(n4);
            } else {
                this.store.free(n4, false);
            }
            ++n3;
            if (n4 != n2) continue;
            bl2 = true;
        }
        return n3;
    }

    @Override
    public int getMemory() {
        return this.store.getPageSize() >> 2;
    }

    @Override
    public void moveTo(Session session, int n2) {
    }

    int getLogKey() {
        return this.logKey;
    }

    public int getNextTrunk() {
        return this.nextTrunk;
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    public String toString() {
        return "page[" + this.getPos() + "] stream trunk key:" + this.logKey + " next:" + this.nextTrunk;
    }

    @Override
    public boolean canMove() {
        return false;
    }

    static class Iterator {
        private final PageStore store;
        private int first;
        private int next;
        private int previous;
        private boolean canDelete;
        private int current;

        Iterator(PageStore pageStore, int n2) {
            this.store = pageStore;
            this.next = n2;
        }

        int getCurrentPageId() {
            return this.current;
        }

        PageStreamTrunk next() {
            Page page;
            this.canDelete = false;
            if (this.first == 0) {
                this.first = this.next;
            } else if (this.first == this.next) {
                return null;
            }
            if (this.next == 0 || this.next >= this.store.getPageCount()) {
                return null;
            }
            this.current = this.next;
            try {
                page = this.store.getPage(this.next);
            }
            catch (DbException dbException) {
                if (dbException.getErrorCode() == 90030) {
                    return null;
                }
                throw dbException;
            }
            if (page == null || page instanceof PageStreamTrunk || page instanceof PageStreamData) {
                this.canDelete = true;
            }
            if (!(page instanceof PageStreamTrunk)) {
                return null;
            }
            PageStreamTrunk pageStreamTrunk = (PageStreamTrunk)page;
            if (this.previous > 0 && pageStreamTrunk.parent != this.previous) {
                return null;
            }
            this.previous = this.next;
            this.next = pageStreamTrunk.nextTrunk;
            return pageStreamTrunk;
        }

        boolean canDelete() {
            return this.canDelete;
        }
    }
}

