/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import org.h2.engine.Session;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageStreamData
extends Page {
    private static final int DATA_START = 11;
    private final PageStore store;
    private int trunk;
    private int logKey;
    private Data data;
    private int remaining;

    private PageStreamData(PageStore pageStore, int n2, int n3, int n4) {
        this.setPos(n2);
        this.store = pageStore;
        this.trunk = n3;
        this.logKey = n4;
    }

    static PageStreamData read(PageStore pageStore, Data data, int n2) {
        PageStreamData pageStreamData = new PageStreamData(pageStore, n2, 0, 0);
        pageStreamData.data = data;
        pageStreamData.read();
        return pageStreamData;
    }

    static PageStreamData create(PageStore pageStore, int n2, int n3, int n4) {
        return new PageStreamData(pageStore, n2, n3, n4);
    }

    private void read() {
        this.data.reset();
        this.data.readByte();
        this.data.readShortInt();
        this.trunk = this.data.readInt();
        this.logKey = this.data.readInt();
    }

    void initWrite() {
        this.data = this.store.createData();
        this.data.writeByte((byte)8);
        this.data.writeShortInt(0);
        this.data.writeInt(this.trunk);
        this.data.writeInt(this.logKey);
        this.remaining = this.store.getPageSize() - this.data.length();
    }

    int write(byte[] byArray, int n2, int n3) {
        int n4 = Math.min(this.remaining, n3);
        this.data.write(byArray, n2, n4);
        this.remaining -= n4;
        return n4;
    }

    @Override
    public void write() {
        this.store.writePage(this.getPos(), this.data);
    }

    static int getCapacity(int n2) {
        return n2 - 11;
    }

    void read(int n2, byte[] byArray, int n3, int n4) {
        System.arraycopy(this.data.getBytes(), n2, byArray, n3, n4);
    }

    int getRemaining() {
        return this.remaining;
    }

    @Override
    public int getMemory() {
        return this.store.getPageSize() >> 2;
    }

    @Override
    public void moveTo(Session session, int n2) {
    }

    int getLogKey() {
        return this.logKey;
    }

    public String toString() {
        return "[" + this.getPos() + "] stream data key:" + this.logKey + " pos:" + this.data.length() + " remaining:" + this.remaining;
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    public static int getReadStart() {
        return 11;
    }

    @Override
    public boolean canMove() {
        return false;
    }
}

