/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import org.h2.message.DbException;
import org.h2.store.InDoubtTransaction;
import org.h2.store.PageStore;

public class PageStoreInDoubtTransaction
implements InDoubtTransaction {
    private final PageStore store;
    private final int sessionId;
    private final int pos;
    private final String transactionName;
    private int state;

    public PageStoreInDoubtTransaction(PageStore pageStore, int n2, int n3, String string) {
        this.store = pageStore;
        this.sessionId = n2;
        this.pos = n3;
        this.transactionName = string;
        this.state = 0;
    }

    @Override
    public void setState(int n2) {
        switch (n2) {
            case 1: {
                this.store.setInDoubtTransactionState(this.sessionId, this.pos, true);
                break;
            }
            case 2: {
                this.store.setInDoubtTransactionState(this.sessionId, this.pos, false);
                break;
            }
            default: {
                DbException.throwInternalError("state=" + n2);
            }
        }
        this.state = n2;
    }

    @Override
    public String getState() {
        switch (this.state) {
            case 0: {
                return "IN_DOUBT";
            }
            case 1: {
                return "COMMIT";
            }
            case 2: {
                return "ROLLBACK";
            }
        }
        throw DbException.throwInternalError("state=" + this.state);
    }

    @Override
    public String getTransactionName() {
        return this.transactionName;
    }
}

