/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.zip.CRC32;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MultiVersionIndex;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.index.PageBtreeNode;
import org.h2.index.PageDataIndex;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageDataNode;
import org.h2.index.PageDataOverflow;
import org.h2.index.PageDelegateIndex;
import org.h2.index.PageIndex;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.InDoubtTransaction;
import org.h2.store.Page;
import org.h2.store.PageFreeList;
import org.h2.store.PageLog;
import org.h2.store.PageStreamData;
import org.h2.store.PageStreamTrunk;
import org.h2.store.fs.FileUtils;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.table.Table;
import org.h2.util.BitField;
import org.h2.util.Cache;
import org.h2.util.CacheLRU;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.IntArray;
import org.h2.util.IntIntHashMap;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;

public class PageStore
implements CacheWriter {
    public static final int PAGE_SIZE_MIN = 64;
    public static final int PAGE_SIZE_MAX = 32768;
    public static final int LOG_MODE_OFF = 0;
    public static final int LOG_MODE_SYNC = 2;
    private static final int PAGE_ID_FREE_LIST_ROOT = 3;
    private static final int PAGE_ID_META_ROOT = 4;
    private static final int MIN_PAGE_COUNT = 5;
    private static final int INCREMENT_KB = 1024;
    private static final int INCREMENT_PERCENT_MIN = 35;
    private static final int READ_VERSION = 3;
    private static final int WRITE_VERSION = 3;
    private static final int META_TYPE_DATA_INDEX = 0;
    private static final int META_TYPE_BTREE_INDEX = 1;
    private static final int META_TABLE_ID = -1;
    private static final int COMPACT_BLOCK_SIZE = 1536;
    private final Database database;
    private final Trace trace;
    private final String fileName;
    private FileStore file;
    private String accessMode;
    private int pageSize = 4096;
    private int pageSizeShift;
    private long writeCountBase;
    private long writeCount;
    private long readCount;
    private int logKey;
    private int logFirstTrunkPage;
    private int logFirstDataPage;
    private final Cache cache;
    private int freeListPagesPerList;
    private boolean recoveryRunning;
    private boolean ignoreBigLog;
    private int firstFreeListIndex;
    private long fileLength;
    private int pageCount;
    private PageLog log;
    private Schema metaSchema;
    private RegularTable metaTable;
    private PageDataIndex metaIndex;
    private final IntIntHashMap metaRootPageId = new IntIntHashMap();
    private final HashMap<Integer, PageIndex> metaObjects = New.hashMap();
    private HashMap<Integer, PageIndex> tempObjects;
    private HashMap<Integer, Integer> reservedPages;
    private boolean isNew;
    private long maxLogSize = 0x1000000L;
    private final Session pageStoreSession;
    private final BitField freed = new BitField();
    private final ArrayList<PageFreeList> freeLists = New.arrayList();
    private boolean recordPageReads;
    private ArrayList<Integer> recordedPagesList;
    private IntIntHashMap recordedPagesIndex;
    private long changeCount = 1L;
    private Data emptyPage;
    private long logSizeBase;
    private HashMap<String, Integer> statistics;
    private int logMode = 2;
    private boolean lockFile;
    private boolean readMode;
    private int backupLevel;

    public PageStore(Database database, String string, String string2, int n2) {
        this.fileName = string;
        this.accessMode = string2;
        this.database = database;
        this.trace = database.getTrace(14);
        String string3 = database.getCacheType();
        this.cache = CacheLRU.getCache(this, string3, n2);
        this.pageStoreSession = new Session(database, null, 0);
    }

    public void statisticsStart() {
        this.statistics = New.hashMap();
    }

    public HashMap<String, Integer> statisticsEnd() {
        HashMap<String, Integer> hashMap = this.statistics;
        this.statistics = null;
        return hashMap;
    }

    private void statisticsIncrement(String string) {
        if (this.statistics != null) {
            Integer n2 = this.statistics.get(string);
            this.statistics.put(string, n2 == null ? 1 : n2 + 1);
        }
    }

    public synchronized int copyDirect(int n2, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[this.pageSize];
        if (n2 >= this.pageCount) {
            return -1;
        }
        this.file.seek((long)n2 << this.pageSizeShift);
        this.file.readFullyDirect(byArray, 0, this.pageSize);
        ++this.readCount;
        outputStream.write(byArray, 0, this.pageSize);
        return n2 + 1;
    }

    public synchronized void open() {
        try {
            this.metaRootPageId.put(-1, 4);
            if (FileUtils.exists(this.fileName)) {
                long l2 = FileUtils.size(this.fileName);
                if (l2 < 320L) {
                    if (this.database.isReadOnly()) {
                        throw DbException.get(90030, this.fileName + " length: " + l2);
                    }
                    this.openNew();
                } else {
                    this.openExisting();
                }
            } else {
                this.openNew();
            }
        }
        catch (DbException dbException) {
            this.close();
            throw dbException;
        }
    }

    private void openNew() {
        this.setPageSize(this.pageSize);
        this.freeListPagesPerList = PageFreeList.getPagesAddressed(this.pageSize);
        this.file = this.database.openFile(this.fileName, this.accessMode, false);
        this.lockFile();
        this.recoveryRunning = true;
        this.writeStaticHeader();
        this.writeVariableHeader();
        this.log = new PageLog(this);
        this.increaseFileSize(5);
        this.openMetaIndex();
        this.logFirstTrunkPage = this.allocatePage();
        this.log.openForWriting(this.logFirstTrunkPage, false);
        this.isNew = true;
        this.recoveryRunning = false;
        this.increaseFileSize();
    }

    private void lockFile() {
        if (this.lockFile && !this.file.tryLock()) {
            throw DbException.get(90020, this.fileName);
        }
    }

    private void openExisting() {
        try {
            this.file = this.database.openFile(this.fileName, this.accessMode, true);
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 90031 && dbException.getMessage().contains("locked")) {
                throw DbException.get(90020, dbException, this.fileName);
            }
            throw dbException;
        }
        this.lockFile();
        this.readStaticHeader();
        this.freeListPagesPerList = PageFreeList.getPagesAddressed(this.pageSize);
        this.fileLength = this.file.length();
        this.pageCount = (int)(this.fileLength / (long)this.pageSize);
        if (this.pageCount < 5) {
            if (this.database.isReadOnly()) {
                throw DbException.get(90030, this.fileName + " pageCount: " + this.pageCount);
            }
            this.file.releaseLock();
            this.file.close();
            FileUtils.delete(this.fileName);
            this.openNew();
            return;
        }
        this.readVariableHeader();
        this.log = new PageLog(this);
        this.log.openForReading(this.logKey, this.logFirstTrunkPage, this.logFirstDataPage);
        boolean bl2 = this.database.isMultiVersion();
        this.database.setMultiVersion(false);
        boolean bl3 = this.recover();
        this.database.setMultiVersion(bl2);
        if (!this.database.isReadOnly()) {
            this.readMode = true;
            if (!bl3 || !SysProperties.MODIFY_ON_WRITE || this.tempObjects != null) {
                this.openForWriting();
                this.removeOldTempIndexes();
            }
        }
    }

    private void openForWriting() {
        if (!this.readMode || this.database.isReadOnly()) {
            return;
        }
        this.readMode = false;
        this.recoveryRunning = true;
        this.log.free();
        this.logFirstTrunkPage = this.allocatePage();
        this.log.openForWriting(this.logFirstTrunkPage, false);
        this.recoveryRunning = false;
        this.freed.set(0, this.pageCount, true);
        this.checkpoint();
    }

    private void removeOldTempIndexes() {
        if (this.tempObjects != null) {
            this.metaObjects.putAll(this.tempObjects);
            for (PageIndex pageIndex : this.tempObjects.values()) {
                if (!pageIndex.getTable().isTemporary()) continue;
                pageIndex.truncate(this.pageStoreSession);
                pageIndex.remove(this.pageStoreSession);
            }
            this.pageStoreSession.commit(true);
            this.tempObjects = null;
        }
        this.metaObjects.clear();
        this.metaObjects.put(-1, this.metaIndex);
    }

    private void writeIndexRowCounts() {
        for (PageIndex pageIndex : this.metaObjects.values()) {
            pageIndex.writeRowCount();
        }
    }

    private void writeBack() {
        ArrayList<CacheObject> arrayList = this.cache.getAllChanged();
        Collections.sort(arrayList);
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeBack(arrayList.get(i2));
        }
    }

    public synchronized void checkpoint() {
        this.trace.debug("checkpoint");
        if (this.log == null || this.readMode || this.database.isReadOnly() || this.backupLevel > 0) {
            return;
        }
        this.database.checkPowerOff();
        this.writeIndexRowCounts();
        this.log.checkpoint();
        this.writeBack();
        int n2 = this.getFirstUncommittedSection();
        this.log.removeUntil(n2);
        this.writeBack();
        this.log.checkpoint();
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("writeFree");
        }
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[this.pageSize];
        for (int i2 = 3; i2 < this.pageCount; ++i2) {
            if (this.isUsed(i2)) {
                this.freed.clear(i2);
                continue;
            }
            if (this.freed.get(i2)) continue;
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("free " + i2);
            }
            this.file.seek((long)i2 << this.pageSizeShift);
            this.file.readFully(byArray, 0, 16);
            if (byArray[0] != 0) {
                this.file.seek((long)i2 << this.pageSizeShift);
                this.file.write(byArray2, 0, this.pageSize);
                ++this.writeCount;
            }
            this.freed.set(i2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void compact(int n2) {
        int n3;
        int n4;
        boolean bl2;
        if (!this.database.getSettings().pageStoreTrim) {
            return;
        }
        if (SysProperties.MODIFY_ON_WRITE && this.readMode && n2 == 0) {
            return;
        }
        this.openForWriting();
        int n5 = -1;
        for (int i2 = this.getFreeListId(this.pageCount); i2 >= 0 && (n5 = this.getFreeList(i2).getLastUsed()) == -1; --i2) {
        }
        this.writeBack();
        this.log.free();
        this.recoveryRunning = true;
        try {
            this.logFirstTrunkPage = n5 + 1;
            this.allocatePage(this.logFirstTrunkPage);
            this.log.openForWriting(this.logFirstTrunkPage, true);
            this.log.checkpoint();
        }
        finally {
            this.recoveryRunning = false;
        }
        long l2 = System.currentTimeMillis();
        boolean bl3 = n2 == 82;
        boolean bl4 = bl2 = n2 == 84;
        if (this.database.getSettings().defragAlways) {
            bl2 = true;
            bl3 = true;
        }
        int n6 = this.database.getSettings().maxCompactTime;
        int n7 = this.database.getSettings().maxCompactCount;
        if (bl3 || bl2) {
            n6 = Integer.MAX_VALUE;
            n7 = Integer.MAX_VALUE;
        }
        int n8 = bl3 ? 1536 : 1;
        int n9 = 5;
        int n10 = 0;
        block10: for (n4 = n5; n4 > 5 && n10 < n7; n4 -= n8) {
            for (n3 = n4 - n8 + 1; n3 <= n4; ++n3) {
                if (n3 <= 5 || !this.isUsed(n3)) continue;
                PageStore object = this;
                synchronized (object) {
                    n9 = this.getFirstFree(n9);
                    if (n9 == -1 || n9 >= n3) {
                        n10 = n7;
                        continue block10;
                    }
                    if (this.compact(n3, n9)) {
                        ++n10;
                        long l3 = System.currentTimeMillis();
                        if (l3 > l2 + (long)n6) {
                            n10 = n7;
                            continue block10;
                        }
                    }
                    continue;
                }
            }
        }
        if (bl2) {
            this.log.checkpoint();
            this.writeBack();
            this.cache.clear();
            ArrayList<Table> arrayList = this.database.getAllTablesAndViews(false);
            this.recordedPagesList = New.arrayList();
            this.recordedPagesIndex = new IntIntHashMap();
            this.recordPageReads = true;
            Session session = this.database.getSystemSession();
            for (Table table : arrayList) {
                if (table.isTemporary() || !"TABLE".equals(table.getTableType())) continue;
                Index index = table.getScanIndex(session);
                Cursor cursor = index.find(session, null, null);
                while (cursor.next()) {
                    cursor.get();
                }
                for (Index index2 : table.getIndexes()) {
                    if (index2 == index || !index2.canScan()) continue;
                    cursor = index2.find(session, null, null);
                    while (cursor.next()) {
                    }
                }
            }
            this.recordPageReads = false;
            n3 = 4;
            boolean bl5 = false;
            int n11 = this.recordedPagesList.size();
            for (int i2 = 0; i2 < n11; ++i2) {
                int n12;
                Page page;
                this.log.checkpoint();
                this.writeBack();
                int n13 = this.recordedPagesList.get(i2);
                Page page2 = this.getPage(n13);
                if (!page2.canMove()) continue;
                while ((page = this.getPage(++n3)) != null && !page.canMove()) {
                }
                if (n3 == n13) continue;
                if ((n12 = this.getFirstFree(n12)) == -1) {
                    DbException.throwInternalError("no free page for defrag");
                }
                this.cache.clear();
                this.swap(n13, n3, n12);
                int n14 = this.recordedPagesIndex.get(n3);
                if (n14 != -1) {
                    this.recordedPagesList.set(n14, n13);
                    this.recordedPagesIndex.put(n13, n14);
                }
                this.recordedPagesList.set(i2, n3);
                this.recordedPagesIndex.put(n3, i2);
            }
            this.recordedPagesList = null;
            this.recordedPagesIndex = null;
        }
        this.checkpoint();
        this.log.checkpoint();
        this.writeIndexRowCounts();
        this.log.checkpoint();
        this.writeBack();
        this.commit(this.pageStoreSession);
        this.writeBack();
        this.log.checkpoint();
        this.log.free();
        this.recoveryRunning = true;
        try {
            this.setLogFirstPage(++this.logKey, 0, 0);
        }
        finally {
            this.recoveryRunning = false;
        }
        this.writeBack();
        for (n4 = this.getFreeListId(this.pageCount); n4 >= 0 && (n5 = this.getFreeList(n4).getLastUsed()) == -1; --n4) {
        }
        n4 = n5 + 1;
        if (n4 < this.pageCount) {
            this.freed.set(n4, this.pageCount, false);
        }
        this.pageCount = n4;
        this.freeLists.clear();
        this.trace.debug("pageCount: " + this.pageCount);
        long l4 = (long)this.pageCount << this.pageSizeShift;
        if (this.file.length() != l4) {
            this.file.setLength(l4);
            ++this.writeCount;
        }
    }

    private int getFirstFree(int n2) {
        int n3 = -1;
        int n4 = this.getFreeListId(n2);
        while (n2 < this.pageCount && (n3 = this.getFreeList(n4).getFirstFree(n2)) == -1) {
            ++n4;
        }
        return n3;
    }

    private void swap(int n2, int n3, int n4) {
        Page page;
        if (n2 < 5 || n3 < 5) {
            System.out.println(this.isUsed(n2) + " " + this.isUsed(n3));
            DbException.throwInternalError("can't swap " + n2 + " and " + n3);
        }
        if ((page = (Page)this.cache.get(n4)) != null) {
            DbException.throwInternalError("not free: " + page);
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("swap " + n2 + " and " + n3 + " via " + n4);
        }
        Page page2 = null;
        if (this.isUsed(n2)) {
            page2 = this.getPage(n2);
            if (page2 != null) {
                page2.moveTo(this.pageStoreSession, n4);
            }
            this.free(n2);
        }
        if (n4 != n3) {
            if (this.isUsed(n3)) {
                Page page3 = this.getPage(n3);
                if (page3 != null) {
                    page3.moveTo(this.pageStoreSession, n2);
                }
                this.free(n3);
            }
            if (page2 != null) {
                page = this.getPage(n4);
                if (page != null) {
                    page.moveTo(this.pageStoreSession, n3);
                }
                this.free(n4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compact(int n2, int n3) {
        Page page;
        if (n2 < 5 || n3 == -1 || n3 >= n2 || !this.isUsed(n2)) {
            return false;
        }
        Page page2 = (Page)this.cache.get(n3);
        if (page2 != null) {
            DbException.throwInternalError("not free: " + page2);
        }
        if ((page = this.getPage(n2)) == null) {
            this.freePage(n2);
        } else if (page instanceof PageStreamData || page instanceof PageStreamTrunk) {
            if (page.getPos() < this.log.getMinPageId()) {
                this.freePage(n2);
            }
        } else {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("move " + page.getPos() + " to " + n3);
            }
            try {
                page.moveTo(this.pageStoreSession, n3);
            }
            finally {
                ++this.changeCount;
                if (SysProperties.CHECK && this.changeCount < 0L) {
                    throw DbException.throwInternalError("changeCount has wrapped");
                }
            }
        }
        return true;
    }

    public synchronized Page getPage(int n2) {
        Page page = (Page)this.cache.get(n2);
        if (page != null) {
            return page;
        }
        Data data = this.createData();
        this.readPage(n2, data);
        byte by2 = data.readByte();
        if (by2 == 0) {
            return null;
        }
        data.readShortInt();
        data.readInt();
        if (!PageStore.checksumTest(data.getBytes(), n2, this.pageSize)) {
            throw DbException.get(90030, "wrong checksum");
        }
        switch (by2 & 0xFFFFFFEF) {
            case 6: {
                page = PageFreeList.read(this, data, n2);
                break;
            }
            case 1: {
                int n3 = data.readVarInt();
                PageIndex pageIndex = this.metaObjects.get(n3);
                if (pageIndex == null) {
                    throw DbException.get(90030, "index not found " + n3);
                }
                if (!(pageIndex instanceof PageDataIndex)) {
                    throw DbException.get(90030, "not a data index " + n3 + " " + pageIndex);
                }
                PageDataIndex pageDataIndex = (PageDataIndex)pageIndex;
                if (this.statistics != null) {
                    this.statisticsIncrement(pageDataIndex.getTable().getName() + "." + pageDataIndex.getName() + " read");
                }
                page = PageDataLeaf.read(pageDataIndex, data, n2);
                break;
            }
            case 2: {
                int n4 = data.readVarInt();
                PageIndex pageIndex = this.metaObjects.get(n4);
                if (pageIndex == null) {
                    throw DbException.get(90030, "index not found " + n4);
                }
                if (!(pageIndex instanceof PageDataIndex)) {
                    throw DbException.get(90030, "not a data index " + n4 + " " + pageIndex);
                }
                PageDataIndex pageDataIndex = (PageDataIndex)pageIndex;
                if (this.statistics != null) {
                    this.statisticsIncrement(pageDataIndex.getTable().getName() + "." + pageDataIndex.getName() + " read");
                }
                page = PageDataNode.read(pageDataIndex, data, n2);
                break;
            }
            case 3: {
                page = PageDataOverflow.read(this, data, n2);
                if (this.statistics == null) break;
                this.statisticsIncrement("overflow read");
                break;
            }
            case 4: {
                int n5 = data.readVarInt();
                PageIndex pageIndex = this.metaObjects.get(n5);
                if (pageIndex == null) {
                    throw DbException.get(90030, "index not found " + n5);
                }
                if (!(pageIndex instanceof PageBtreeIndex)) {
                    throw DbException.get(90030, "not a btree index " + n5 + " " + pageIndex);
                }
                PageBtreeIndex pageBtreeIndex = (PageBtreeIndex)pageIndex;
                if (this.statistics != null) {
                    this.statisticsIncrement(pageBtreeIndex.getTable().getName() + "." + pageBtreeIndex.getName() + " read");
                }
                page = PageBtreeLeaf.read(pageBtreeIndex, data, n2);
                break;
            }
            case 5: {
                int n6 = data.readVarInt();
                PageIndex pageIndex = this.metaObjects.get(n6);
                if (pageIndex == null) {
                    throw DbException.get(90030, "index not found " + n6);
                }
                if (!(pageIndex instanceof PageBtreeIndex)) {
                    throw DbException.get(90030, "not a btree index " + n6 + " " + pageIndex);
                }
                PageBtreeIndex pageBtreeIndex = (PageBtreeIndex)pageIndex;
                if (this.statistics != null) {
                    this.statisticsIncrement(pageBtreeIndex.getTable().getName() + "." + pageBtreeIndex.getName() + " read");
                }
                page = PageBtreeNode.read(pageBtreeIndex, data, n2);
                break;
            }
            case 7: {
                page = PageStreamTrunk.read(this, data, n2);
                break;
            }
            case 8: {
                page = PageStreamData.read(this, data, n2);
                break;
            }
            default: {
                throw DbException.get(90030, "page=" + n2 + " type=" + by2);
            }
        }
        this.cache.put(page);
        return page;
    }

    private int getFirstUncommittedSection() {
        this.trace.debug("getFirstUncommittedSection");
        Session[] sessionArray = this.database.getSessions(true);
        int n2 = this.log.getLogSectionId();
        for (Session session : sessionArray) {
            int n3 = session.getFirstUncommittedLog();
            if (n3 == -1 || n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private void readStaticHeader() {
        this.file.seek(48L);
        Data data = Data.create((DataHandler)this.database, new byte[16]);
        this.file.readFully(data.getBytes(), 0, 16);
        ++this.readCount;
        this.setPageSize(data.readInt());
        byte by2 = data.readByte();
        byte by3 = data.readByte();
        if (by3 > 3) {
            throw DbException.get(90048, this.fileName);
        }
        if (by2 > 3) {
            this.close();
            this.database.setReadOnly(true);
            this.accessMode = "r";
            this.file = this.database.openFile(this.fileName, this.accessMode, true);
        }
    }

    private void readVariableHeader() {
        Data data = this.createData();
        int n2 = 1;
        while (true) {
            if (n2 == 3) {
                throw DbException.get(90030, this.fileName);
            }
            data.reset();
            this.readPage(n2, data);
            CRC32 cRC32 = new CRC32();
            cRC32.update(data.getBytes(), 4, this.pageSize - 4);
            int n3 = (int)cRC32.getValue();
            int n4 = data.readInt();
            if (n3 == n4) break;
            ++n2;
        }
        this.writeCountBase = data.readLong();
        this.logKey = data.readInt();
        this.logFirstTrunkPage = data.readInt();
        this.logFirstDataPage = data.readInt();
    }

    public void setPageSize(int n2) {
        if (n2 < 64 || n2 > 32768) {
            throw DbException.get(90030, this.fileName + " pageSize: " + n2);
        }
        boolean bl2 = false;
        int n3 = 0;
        for (int i2 = 1; i2 <= n2; i2 += i2) {
            if (n2 == i2) {
                bl2 = true;
                break;
            }
            ++n3;
        }
        if (!bl2) {
            throw DbException.get(90030, this.fileName);
        }
        this.pageSize = n2;
        this.emptyPage = this.createData();
        this.pageSizeShift = n3;
    }

    private void writeStaticHeader() {
        Data data = Data.create((DataHandler)this.database, new byte[this.pageSize - 48]);
        data.writeInt(this.pageSize);
        data.writeByte((byte)3);
        data.writeByte((byte)3);
        this.file.seek(48L);
        this.file.write(data.getBytes(), 0, this.pageSize - 48);
        ++this.writeCount;
    }

    void setLogFirstPage(int n2, int n3, int n4) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("setLogFirstPage key: " + n2 + " trunk: " + n3 + " data: " + n4);
        }
        this.logKey = n2;
        this.logFirstTrunkPage = n3;
        this.logFirstDataPage = n4;
        this.writeVariableHeader();
    }

    private void writeVariableHeader() {
        this.trace.debug("writeVariableHeader");
        if (this.logMode == 2) {
            this.file.sync();
        }
        Data data = this.createData();
        data.writeInt(0);
        data.writeLong(this.getWriteCountTotal());
        data.writeInt(this.logKey);
        data.writeInt(this.logFirstTrunkPage);
        data.writeInt(this.logFirstDataPage);
        CRC32 cRC32 = new CRC32();
        cRC32.update(data.getBytes(), 4, this.pageSize - 4);
        data.setInt(0, (int)cRC32.getValue());
        this.file.seek(this.pageSize);
        this.file.write(data.getBytes(), 0, this.pageSize);
        this.file.seek(this.pageSize + this.pageSize);
        this.file.write(data.getBytes(), 0, this.pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        this.trace.debug("close");
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
        if (this.file != null) {
            try {
                this.file.releaseLock();
                this.file.close();
            }
            finally {
                this.file = null;
            }
        }
    }

    @Override
    public synchronized void flushLog() {
        if (this.file != null) {
            this.log.flush();
        }
    }

    public synchronized void sync() {
        if (this.file != null) {
            this.log.flush();
            this.file.sync();
        }
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public synchronized void writeBack(CacheObject cacheObject) {
        Page page = (Page)cacheObject;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("writeBack " + page);
        }
        page.write();
        page.setChanged(false);
    }

    public synchronized void logUndo(Page page, Data data) {
        int n2;
        if (this.logMode == 0) {
            return;
        }
        this.checkOpen();
        this.database.checkWritingAllowed();
        if (!this.recoveryRunning && !this.log.getUndo(n2 = page.getPos())) {
            if (data == null) {
                data = this.readPage(n2);
            }
            this.openForWriting();
            this.log.addUndo(n2, data);
        }
    }

    public synchronized void update(Page page) {
        if (this.trace.isDebugEnabled() && !page.isChanged()) {
            this.trace.debug("updateRecord " + page.toString());
        }
        this.checkOpen();
        this.database.checkWritingAllowed();
        page.setChanged(true);
        int n2 = page.getPos();
        if (SysProperties.CHECK && !this.recoveryRunning && this.logMode != 0) {
            this.log.addUndo(n2, null);
        }
        this.allocatePage(n2);
        this.cache.update(n2, page);
    }

    private int getFreeListId(int n2) {
        return (n2 - 3) / this.freeListPagesPerList;
    }

    private PageFreeList getFreeListForPage(int n2) {
        return this.getFreeList(this.getFreeListId(n2));
    }

    private PageFreeList getFreeList(int n2) {
        PageFreeList pageFreeList = null;
        if (n2 < this.freeLists.size() && (pageFreeList = this.freeLists.get(n2)) != null) {
            return pageFreeList;
        }
        int n3 = 3 + n2 * this.freeListPagesPerList;
        while (n3 >= this.pageCount) {
            this.increaseFileSize();
        }
        if (n3 < this.pageCount) {
            pageFreeList = (PageFreeList)this.getPage(n3);
        }
        if (pageFreeList == null) {
            pageFreeList = PageFreeList.create(this, n3);
            this.cache.put(pageFreeList);
        }
        while (this.freeLists.size() <= n2) {
            this.freeLists.add(null);
        }
        this.freeLists.set(n2, pageFreeList);
        return pageFreeList;
    }

    private void freePage(int n2) {
        int n3 = this.getFreeListId(n2);
        PageFreeList pageFreeList = this.getFreeList(n3);
        this.firstFreeListIndex = Math.min(n3, this.firstFreeListIndex);
        pageFreeList.free(n2);
    }

    void allocatePage(int n2) {
        PageFreeList pageFreeList = this.getFreeListForPage(n2);
        pageFreeList.allocate(n2);
    }

    private boolean isUsed(int n2) {
        return this.getFreeListForPage(n2).isUsed(n2);
    }

    void allocatePages(IntArray intArray, int n2, BitField bitField, int n3) {
        intArray.ensureCapacity(intArray.size() + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            n3 = n4 = this.allocatePage(bitField, n3);
            intArray.add(n4);
        }
    }

    public synchronized int allocatePage() {
        this.openForWriting();
        int n2 = this.allocatePage(null, 0);
        if (!this.recoveryRunning && this.logMode != 0) {
            this.log.addUndo(n2, this.emptyPage);
        }
        return n2;
    }

    private int allocatePage(BitField bitField, int n2) {
        int n3;
        int n4 = this.firstFreeListIndex;
        while (true) {
            PageFreeList pageFreeList;
            if ((n3 = (pageFreeList = this.getFreeList(n4)).allocate(bitField, n2)) >= 0) {
                this.firstFreeListIndex = n4;
                break;
            }
            ++n4;
        }
        while (n3 >= this.pageCount) {
            this.increaseFileSize();
        }
        if (this.trace.isDebugEnabled()) {
            // empty if block
        }
        return n3;
    }

    private void increaseFileSize() {
        int n2;
        int n3 = 0x100000 / this.pageSize;
        int n4 = this.pageCount * 35 / 100;
        if (n3 < n4) {
            n3 = (1 + n4 / n3) * n3;
        }
        if ((n2 = this.database.getSettings().pageStoreMaxGrowth) < n3) {
            n3 = n2;
        }
        this.increaseFileSize(n3);
    }

    private void increaseFileSize(int n2) {
        for (int i2 = this.pageCount; i2 < this.pageCount + n2; ++i2) {
            this.freed.set(i2);
        }
        this.pageCount += n2;
        long l2 = (long)this.pageCount << this.pageSizeShift;
        this.file.setLength(l2);
        ++this.writeCount;
        this.fileLength = l2;
    }

    public synchronized void free(int n2) {
        this.free(n2, true);
    }

    void free(int n2, boolean bl2) {
        if (this.trace.isDebugEnabled()) {
            // empty if block
        }
        this.cache.remove(n2);
        if (SysProperties.CHECK && !this.recoveryRunning && bl2 && this.logMode != 0) {
            this.log.addUndo(n2, null);
        }
        this.freePage(n2);
        if (this.recoveryRunning) {
            int n3;
            this.writePage(n2, this.createData());
            if (this.reservedPages != null && this.reservedPages.containsKey(n2) && (n3 = this.reservedPages.get(n2).intValue()) > this.log.getLogPos()) {
                this.allocatePage(n2);
            }
        }
    }

    void freeUnused(int n2) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("freeUnused " + n2);
        }
        this.cache.remove(n2);
        this.freePage(n2);
        this.freed.set(n2);
    }

    public Data createData() {
        return Data.create((DataHandler)this.database, new byte[this.pageSize]);
    }

    public synchronized Data readPage(int n2) {
        Data data = this.createData();
        this.readPage(n2, data);
        return data;
    }

    void readPage(int n2, Data data) {
        if (this.recordPageReads && n2 >= 5 && this.recordedPagesIndex.get(n2) == -1) {
            this.recordedPagesIndex.put(n2, this.recordedPagesList.size());
            this.recordedPagesList.add(n2);
        }
        if (n2 < 0 || n2 >= this.pageCount) {
            throw DbException.get(90030, n2 + " of " + this.pageCount);
        }
        this.file.seek((long)n2 << this.pageSizeShift);
        this.file.readFully(data.getBytes(), 0, this.pageSize);
        ++this.readCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public synchronized void writePage(int n2, Data data) {
        if (n2 <= 0) {
            DbException.throwInternalError("write to page " + n2);
        }
        byte[] byArray = data.getBytes();
        if (SysProperties.CHECK) {
            boolean bl2;
            boolean bl3 = (n2 - 3) % this.freeListPagesPerList == 0;
            boolean bl4 = bl2 = byArray[0] == 6;
            if (byArray[0] != 0 && bl3 != bl2) {
                throw DbException.throwInternalError();
            }
        }
        this.checksumSet(byArray, n2);
        this.file.seek((long)n2 << this.pageSizeShift);
        this.file.write(byArray, 0, this.pageSize);
        ++this.writeCount;
    }

    public synchronized void removeFromCache(int n2) {
        this.cache.remove(n2);
    }

    Database getDatabase() {
        return this.database;
    }

    private boolean recover() {
        PageDataIndex pageDataIndex;
        this.trace.debug("log recover");
        this.recoveryRunning = true;
        boolean bl2 = true;
        bl2 &= this.log.recover(0);
        if (this.reservedPages != null) {
            for (int n2 : this.reservedPages.keySet()) {
                if (this.trace.isDebugEnabled()) {
                    this.trace.debug("reserve " + n2);
                }
                this.allocatePage(n2);
            }
        }
        bl2 &= this.log.recover(1);
        this.openMetaIndex();
        this.readMetaData();
        bl2 &= this.log.recover(2);
        boolean bl3 = false;
        if (!this.database.isReadOnly()) {
            if (this.log.getInDoubtTransactions().size() == 0) {
                int n2;
                this.log.recoverEnd();
                n2 = this.getFirstUncommittedSection();
                this.log.removeUntil(n2);
            } else {
                bl3 = true;
            }
        }
        this.isNew = (pageDataIndex = (PageDataIndex)this.metaObjects.get(0)) == null;
        for (PageIndex pageIndex : this.metaObjects.values()) {
            if (pageIndex.getTable().isTemporary()) {
                if (this.tempObjects == null) {
                    this.tempObjects = New.hashMap();
                }
                this.tempObjects.put(pageIndex.getId(), pageIndex);
                continue;
            }
            pageIndex.close(this.pageStoreSession);
        }
        this.allocatePage(4);
        this.writeIndexRowCounts();
        this.recoveryRunning = false;
        this.reservedPages = null;
        this.writeBack();
        this.cache.clear();
        this.freeLists.clear();
        this.metaObjects.clear();
        this.metaObjects.put(-1, this.metaIndex);
        if (bl3) {
            this.database.setReadOnly(true);
        }
        this.trace.debug("log recover done");
        return bl2;
    }

    public synchronized void logAddOrRemoveRow(Session session, int n2, Row row, boolean bl2) {
        if (this.logMode != 0 && !this.recoveryRunning) {
            this.log.logAddOrRemoveRow(session, n2, row, bl2);
        }
    }

    public synchronized void commit(Session session) {
        this.checkOpen();
        this.openForWriting();
        this.log.commit(session.getId());
        long l2 = this.log.getSize();
        if (l2 - this.logSizeBase > this.maxLogSize / 2L) {
            int n2 = this.log.getLogFirstSectionId();
            this.checkpoint();
            int n3 = this.log.getLogSectionId();
            if (n3 - n2 <= 2) {
                return;
            }
            long l3 = this.log.getSize();
            if (l3 < l2 || l2 < this.maxLogSize) {
                this.ignoreBigLog = false;
                return;
            }
            if (!this.ignoreBigLog) {
                this.ignoreBigLog = true;
                this.trace.error(null, "Transaction log could not be truncated; size: " + l3 / 1024L / 1024L + " MB");
            }
            this.logSizeBase = this.log.getSize();
        }
    }

    public synchronized void prepareCommit(Session session, String string) {
        this.log.prepareCommit(session, string);
    }

    public boolean isNew() {
        return this.isNew;
    }

    void allocateIfIndexRoot(int n2, int n3, Row row) {
        if (n3 == -1) {
            int n4 = row.getValue(3).getInt();
            if (this.reservedPages == null) {
                this.reservedPages = New.hashMap();
            }
            this.reservedPages.put(n4, n2);
        }
    }

    void redoDelete(int n2, long l2) {
        Index index = this.metaObjects.get(n2);
        PageDataIndex pageDataIndex = (PageDataIndex)index;
        Row row = pageDataIndex.getRowWithKey(l2);
        if (row == null || row.getKey() != l2) {
            this.trace.error(null, "Entry not found: " + l2 + " found instead: " + row + " - ignoring");
            return;
        }
        this.redo(n2, row, false);
    }

    void redo(int n2, Row row, boolean bl2) {
        Index index;
        if (n2 == -1) {
            if (bl2) {
                this.addMeta(row, this.pageStoreSession, true);
            } else {
                this.removeMeta(row);
            }
        }
        if ((index = (Index)this.metaObjects.get(n2)) == null) {
            throw DbException.throwInternalError("Table not found: " + n2 + " " + row + " " + bl2);
        }
        Table table = index.getTable();
        if (bl2) {
            table.addRow(this.pageStoreSession, row);
        } else {
            table.removeRow(this.pageStoreSession, row);
        }
    }

    void redoTruncate(int n2) {
        Index index = this.metaObjects.get(n2);
        Table table = index.getTable();
        table.truncate(this.pageStoreSession);
    }

    private void openMetaIndex() {
        CreateTableData createTableData = new CreateTableData();
        ArrayList<Column> arrayList = createTableData.columns;
        arrayList.add(new Column("ID", 4));
        arrayList.add(new Column("TYPE", 4));
        arrayList.add(new Column("PARENT", 4));
        arrayList.add(new Column("HEAD", 4));
        arrayList.add(new Column("OPTIONS", 13));
        arrayList.add(new Column("COLUMNS", 13));
        createTableData.schema = this.metaSchema = new Schema(this.database, 0, "", null, true);
        createTableData.tableName = "PAGE_INDEX";
        createTableData.id = -1;
        createTableData.temporary = false;
        createTableData.persistData = true;
        createTableData.persistIndexes = true;
        createTableData.create = false;
        createTableData.session = this.pageStoreSession;
        this.metaTable = new RegularTable(createTableData);
        this.metaIndex = (PageDataIndex)this.metaTable.getScanIndex(this.pageStoreSession);
        this.metaObjects.clear();
        this.metaObjects.put(-1, this.metaIndex);
    }

    private void readMetaData() {
        int n2;
        Row row;
        Cursor cursor = this.metaIndex.find(this.pageStoreSession, null, null);
        while (cursor.next()) {
            row = cursor.get();
            n2 = row.getValue(1).getInt();
            if (n2 != 0) continue;
            this.addMeta(row, this.pageStoreSession, false);
        }
        cursor = this.metaIndex.find(this.pageStoreSession, null, null);
        while (cursor.next()) {
            row = cursor.get();
            n2 = row.getValue(1).getInt();
            if (n2 == 0) continue;
            this.addMeta(row, this.pageStoreSession, false);
        }
    }

    private void removeMeta(Row row) {
        int n2 = row.getValue(0).getInt();
        PageIndex pageIndex = this.metaObjects.get(n2);
        pageIndex.getTable().removeIndex(pageIndex);
        if (pageIndex instanceof PageBtreeIndex || pageIndex instanceof PageDelegateIndex) {
            if (pageIndex.isTemporary()) {
                this.pageStoreSession.removeLocalTempTableIndex(pageIndex);
            } else {
                pageIndex.getSchema().remove(pageIndex);
            }
        }
        pageIndex.remove(this.pageStoreSession);
        this.metaObjects.remove(n2);
    }

    private void addMeta(Row row, Session session, boolean bl2) {
        Index index;
        Object object;
        int n2 = row.getValue(0).getInt();
        int n3 = row.getValue(1).getInt();
        int n4 = row.getValue(2).getInt();
        int n5 = row.getValue(3).getInt();
        String[] stringArray = StringUtils.arraySplit(row.getValue(4).getString(), ',', false);
        String string = row.getValue(5).getString();
        String[] stringArray2 = StringUtils.arraySplit(string, ',', false);
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("addMeta id=" + n2 + " type=" + n3 + " root=" + n5 + " parent=" + n4 + " columns=" + string);
        }
        if (bl2 && n5 != 0) {
            this.writePage(n5, this.createData());
            this.allocatePage(n5);
        }
        this.metaRootPageId.put(n2, n5);
        if (n3 == 0) {
            Object object2;
            object = new CreateTableData();
            if (SysProperties.CHECK && stringArray2 == null) {
                throw DbException.throwInternalError(row.toString());
            }
            int n6 = stringArray2.length;
            for (int i2 = 0; i2 < n6; i2 += 1) {
                object2 = new Column("C" + i2, 4);
                ((CreateTableData)object).columns.add((Column)object2);
            }
            ((CreateTableData)object).schema = this.metaSchema;
            ((CreateTableData)object).tableName = "T" + n2;
            ((CreateTableData)object).id = n2;
            ((CreateTableData)object).temporary = stringArray[2].equals("temp");
            ((CreateTableData)object).persistData = true;
            ((CreateTableData)object).persistIndexes = true;
            ((CreateTableData)object).create = false;
            ((CreateTableData)object).session = session;
            RegularTable regularTable = new RegularTable((CreateTableData)object);
            n6 = SysProperties.SORT_BINARY_UNSIGNED ? 1 : 0;
            if (stringArray.length > 3) {
                n6 = Boolean.parseBoolean(stringArray[3]) ? 1 : 0;
            }
            object2 = CompareMode.getInstance(stringArray[0], Integer.parseInt(stringArray[1]), n6 != 0);
            regularTable.setCompareMode((CompareMode)object2);
            index = regularTable.getScanIndex(session);
        } else {
            IndexType indexType;
            Object object3;
            object = this.metaObjects.get(n4);
            if (object == null) {
                throw DbException.get(90030, "Table not found:" + n4 + " for " + row + " meta:" + this.metaObjects);
            }
            RegularTable regularTable = (RegularTable)object.getTable();
            Column[] columnArray = regularTable.getColumns();
            int n7 = stringArray2.length;
            IndexColumn[] indexColumnArray = new IndexColumn[n7];
            for (int i3 = 0; i3 < n7; ++i3) {
                Object object4;
                object3 = stringArray2[i3];
                IndexColumn[] indexColumnArray2 = new IndexColumn();
                int n8 = object3.indexOf(47);
                if (n8 >= 0) {
                    object4 = object3.substring(n8 + 1);
                    indexColumnArray2.sortType = Integer.parseInt((String)object4);
                    object3 = object3.substring(0, n8);
                }
                indexColumnArray2.column = object4 = columnArray[Integer.parseInt((String)object3)];
                indexColumnArray[i3] = indexColumnArray2;
            }
            if (stringArray[3].equals("d")) {
                indexType = IndexType.createPrimaryKey(true, false);
                object3 = regularTable.getColumns();
                for (IndexColumn indexColumn : indexColumnArray) {
                    object3[indexColumn.column.getColumnId()].setNullable(false);
                }
            } else {
                indexType = IndexType.createNonUnique(true);
            }
            index = regularTable.addIndex(session, "I" + n2, n2, indexColumnArray, indexType, false, null);
        }
        object = index instanceof MultiVersionIndex ? (PageIndex)((MultiVersionIndex)index).getBaseIndex() : (PageIndex)index;
        this.metaObjects.put(n2, (PageIndex)object);
    }

    public synchronized void addIndex(PageIndex pageIndex) {
        this.metaObjects.put(pageIndex.getId(), pageIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMeta(PageIndex pageIndex, Session session) {
        Object object;
        Table table = pageIndex.getTable();
        if (SysProperties.CHECK && !table.isTemporary()) {
            object = this.database;
            synchronized (object) {
                PageStore pageStore = this;
                synchronized (pageStore) {
                    this.database.verifyMetaLocked(session);
                }
            }
        }
        object = this;
        synchronized (object) {
            int n2 = pageIndex instanceof PageDataIndex ? 0 : 1;
            IndexColumn[] indexColumnArray = pageIndex.getIndexColumns();
            StatementBuilder statementBuilder = new StatementBuilder();
            for (IndexColumn indexColumn : indexColumnArray) {
                statementBuilder.appendExceptFirst(",");
                int n3 = indexColumn.column.getColumnId();
                statementBuilder.append(n3);
                int n4 = indexColumn.sortType;
                if (n4 == 0) continue;
                statementBuilder.append('/');
                statementBuilder.append(n4);
            }
            String string = statementBuilder.toString();
            CompareMode compareMode = table.getCompareMode();
            String string2 = compareMode.getName() + "," + compareMode.getStrength() + ",";
            if (table.isTemporary()) {
                string2 = string2 + "temp";
            }
            string2 = string2 + ",";
            if (pageIndex instanceof PageDelegateIndex) {
                string2 = string2 + "d";
            }
            string2 = string2 + "," + compareMode.isBinaryUnsigned();
            Row row = this.metaTable.getTemplateRow();
            row.setValue(0, ValueInt.get(pageIndex.getId()));
            row.setValue(1, ValueInt.get(n2));
            row.setValue(2, ValueInt.get(table.getId()));
            row.setValue(3, ValueInt.get(pageIndex.getRootPageId()));
            row.setValue(4, ValueString.get(string2));
            row.setValue(5, ValueString.get(string));
            row.setKey(pageIndex.getId() + 1);
            this.metaIndex.add(session, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMeta(Index index, Session session) {
        Object object;
        if (SysProperties.CHECK && !index.getTable().isTemporary()) {
            object = this.database;
            synchronized (object) {
                PageStore pageStore = this;
                synchronized (pageStore) {
                    this.database.verifyMetaLocked(session);
                }
            }
        }
        object = this;
        synchronized (object) {
            if (!this.recoveryRunning) {
                this.removeMetaIndex(index, session);
                this.metaObjects.remove(index.getId());
            }
        }
    }

    private void removeMetaIndex(Index index, Session session) {
        int n2 = index.getId() + 1;
        Row row = this.metaIndex.getRow(session, n2);
        if (row.getKey() != (long)n2) {
            throw DbException.get(90030, "key: " + n2 + " index: " + index + " table: " + index.getTable() + " row: " + row);
        }
        this.metaIndex.remove(session, row);
    }

    public void setMaxLogSize(long l2) {
        this.maxLogSize = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInDoubtTransactionState(int n2, int n3, boolean bl2) {
        boolean bl3 = this.database.isReadOnly();
        try {
            this.database.setReadOnly(false);
            this.log.setInDoubtTransactionState(n2, n3, bl2);
        }
        finally {
            this.database.setReadOnly(bl3);
        }
    }

    public ArrayList<InDoubtTransaction> getInDoubtTransactions() {
        return this.log.getInDoubtTransactions();
    }

    public boolean isRecoveryRunning() {
        return this.recoveryRunning;
    }

    private void checkOpen() {
        if (this.file == null) {
            throw DbException.get(90098);
        }
    }

    public long getWriteCountTotal() {
        return this.writeCount + this.writeCountBase;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public long getReadCount() {
        return this.readCount;
    }

    public synchronized void logTruncate(Session session, int n2) {
        if (!this.recoveryRunning) {
            this.openForWriting();
            this.log.logTruncate(session, n2);
        }
    }

    public int getRootPageId(int n2) {
        return this.metaRootPageId.get(n2);
    }

    public Cache getCache() {
        return this.cache;
    }

    private void checksumSet(byte[] byArray, int n2) {
        int n3 = this.pageSize;
        byte by2 = byArray[0];
        if (by2 == 0) {
            return;
        }
        int n4 = 255 + (by2 & 0xFF);
        int n5 = 255 + n4;
        n5 += (n4 += byArray[6] & 0xFF);
        n5 += (n4 += byArray[(n3 >> 1) - 1] & 0xFF);
        n5 += (n4 += byArray[n3 >> 1] & 0xFF);
        n5 += (n4 += byArray[n3 - 2] & 0xFF);
        byArray[1] = (byte)((n4 & 0xFF) + (n4 >> 8) ^ n2);
        byArray[2] = (byte)(((n5 += (n4 += byArray[n3 - 1] & 0xFF)) & 0xFF) + (n5 >> 8) ^ n2 >> 8);
    }

    public static boolean checksumTest(byte[] byArray, int n2, int n3) {
        int n4 = n3;
        int n5 = 255 + (byArray[0] & 0xFF);
        int n6 = 255 + n5;
        n6 += (n5 += byArray[6] & 0xFF);
        n6 += (n5 += byArray[(n4 >> 1) - 1] & 0xFF);
        n6 += (n5 += byArray[n4 >> 1] & 0xFF);
        n6 += (n5 += byArray[n4 - 2] & 0xFF);
        return byArray[1] == (byte)((n5 & 0xFF) + (n5 >> 8) ^ n2) && byArray[2] == (byte)(((n6 += (n5 += byArray[n4 - 1] & 0xFF)) & 0xFF) + (n6 >> 8) ^ n2 >> 8);
    }

    public void incrementChangeCount() {
        ++this.changeCount;
        if (SysProperties.CHECK && this.changeCount < 0L) {
            throw DbException.throwInternalError("changeCount has wrapped");
        }
    }

    public long getChangeCount() {
        return this.changeCount;
    }

    public void setLogMode(int n2) {
        this.logMode = n2;
    }

    public int getLogMode() {
        return this.logMode;
    }

    public void setLockFile(boolean bl2) {
        this.lockFile = bl2;
    }

    public BitField getObjectIds() {
        BitField bitField = new BitField();
        Cursor cursor = this.metaIndex.find(this.pageStoreSession, null, null);
        while (cursor.next()) {
            Row row = cursor.get();
            int n2 = row.getValue(0).getInt();
            if (n2 <= 0) continue;
            bitField.set(n2);
        }
        return bitField;
    }

    public Session getPageStoreSession() {
        return this.pageStoreSession;
    }

    public synchronized void setBackup(boolean bl2) {
        this.backupLevel += bl2 ? 1 : -1;
    }
}

