/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.store.PageStore;
import org.h2.store.PageStreamData;
import org.h2.store.PageStreamTrunk;
import org.h2.util.BitField;
import org.h2.util.IntArray;

public class PageOutputStream {
    private PageStore store;
    private final Trace trace;
    private final BitField exclude;
    private final boolean atEnd;
    private final int minPageId;
    private int trunkPageId;
    private int trunkNext;
    private IntArray reservedPages = new IntArray();
    private PageStreamTrunk trunk;
    private int trunkIndex;
    private PageStreamData data;
    private int reserved;
    private boolean needFlush;
    private boolean writing;
    private int pageCount;
    private int logKey;

    public PageOutputStream(PageStore pageStore, int n2, BitField bitField, int n3, boolean bl2) {
        this.trace = pageStore.getTrace();
        this.store = pageStore;
        this.trunkPageId = n2;
        this.exclude = bitField;
        this.logKey = n3 - 1;
        this.atEnd = bl2;
        this.minPageId = bl2 ? n2 : 0;
    }

    void reserve(int n2) {
        if (this.reserved < n2) {
            int n3 = this.store.getPageSize();
            int n4 = PageStreamData.getCapacity(n3);
            int n5 = PageStreamTrunk.getPagesAddressed(n3);
            int n6 = 0;
            int n7 = 0;
            do {
                n6 += n5 + 1;
            } while ((n7 += n5 * n4) < n2);
            int n8 = this.atEnd ? this.trunkPageId : 0;
            this.store.allocatePages(this.reservedPages, n6, this.exclude, n8);
            this.reserved += n7;
            if (this.data == null) {
                this.initNextData();
            }
        }
    }

    private void initNextData() {
        int n2;
        int n3 = n2 = this.trunk == null ? -1 : this.trunk.getPageData(this.trunkIndex++);
        if (n2 == -1) {
            int n4 = this.trunkPageId;
            if (this.trunkNext != 0) {
                this.trunkPageId = this.trunkNext;
            }
            int n5 = PageStreamTrunk.getPagesAddressed(this.store.getPageSize());
            int[] nArray = new int[n5];
            for (int i2 = 0; i2 < n5; ++i2) {
                nArray[i2] = this.reservedPages.get(i2);
            }
            this.trunkNext = this.reservedPages.get(n5);
            ++this.logKey;
            this.trunk = PageStreamTrunk.create(this.store, n4, this.trunkPageId, this.trunkNext, this.logKey, nArray);
            this.trunkIndex = 0;
            ++this.pageCount;
            this.trunk.write();
            this.reservedPages.removeRange(0, n5 + 1);
            n2 = this.trunk.getPageData(this.trunkIndex++);
        }
        this.data = PageStreamData.create(this.store, n2, this.trunk.getPos(), this.logKey);
        ++this.pageCount;
        this.data.initWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n2, int n3) {
        if (n3 <= 0) {
            return;
        }
        if (this.writing) {
            DbException.throwInternalError("writing while still writing");
        }
        try {
            this.reserve(n3);
            this.writing = true;
            while (n3 > 0) {
                int n4 = this.data.write(byArray, n2, n3);
                if (n4 < n3) {
                    this.storePage();
                    this.initNextData();
                }
                this.reserved -= n4;
                n2 += n4;
                n3 -= n4;
            }
            this.needFlush = true;
        }
        finally {
            this.writing = false;
        }
    }

    private void storePage() {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("pageOut.storePage " + this.data);
        }
        this.data.write();
    }

    public void flush() {
        if (this.needFlush) {
            this.storePage();
            this.needFlush = false;
        }
    }

    public void close() {
        this.store = null;
    }

    int getCurrentDataPageId() {
        return this.data.getPos();
    }

    void fillPage() {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("pageOut.storePage fill " + this.data.getPos());
        }
        this.reserve(this.data.getRemaining() + 1);
        this.reserved -= this.data.getRemaining();
        this.data.write();
        this.initNextData();
    }

    long getSize() {
        return this.pageCount * this.store.getPageSize();
    }

    void free(PageStreamTrunk pageStreamTrunk) {
        this.pageCount -= pageStreamTrunk.free(0);
    }

    void freeReserved() {
        if (this.reservedPages.size() > 0) {
            int[] nArray = new int[this.reservedPages.size()];
            this.reservedPages.toArray(nArray);
            this.reservedPages = new IntArray();
            this.reserved = 0;
            for (int n2 : nArray) {
                this.store.free(n2, false);
            }
        }
    }

    int getMinPageId() {
        return this.minPageId;
    }
}

