/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.h2.compress.CompressLZF;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.Row;
import org.h2.result.RowFactory;
import org.h2.store.Data;
import org.h2.store.DataReader;
import org.h2.store.InDoubtTransaction;
import org.h2.store.Page;
import org.h2.store.PageInputStream;
import org.h2.store.PageOutputStream;
import org.h2.store.PageStore;
import org.h2.store.PageStoreInDoubtTransaction;
import org.h2.store.PageStreamData;
import org.h2.store.PageStreamTrunk;
import org.h2.store.SessionState;
import org.h2.util.BitField;
import org.h2.util.IntArray;
import org.h2.util.IntIntHashMap;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class PageLog {
    public static final int NOOP = 0;
    public static final int UNDO = 1;
    public static final int COMMIT = 2;
    public static final int PREPARE_COMMIT = 3;
    public static final int ROLLBACK = 4;
    public static final int ADD = 5;
    public static final int REMOVE = 6;
    public static final int TRUNCATE = 7;
    public static final int CHECKPOINT = 8;
    public static final int FREE_LOG = 9;
    static final int RECOVERY_STAGE_UNDO = 0;
    static final int RECOVERY_STAGE_ALLOCATE = 1;
    static final int RECOVERY_STAGE_REDO = 2;
    private static final boolean COMPRESS_UNDO = true;
    private final PageStore store;
    private final Trace trace;
    private Data writeBuffer;
    private PageOutputStream pageOut;
    private int firstTrunkPage;
    private int firstDataPage;
    private final Data dataBuffer;
    private int logKey;
    private int logSectionId;
    private int logPos;
    private int firstSectionId;
    private final CompressLZF compress;
    private final byte[] compressBuffer;
    private BitField undo = new BitField();
    private final BitField undoAll = new BitField();
    private final IntIntHashMap logSectionPageMap = new IntIntHashMap();
    private HashMap<Integer, SessionState> sessionStates = New.hashMap();
    private BitField usedLogPages;
    private boolean freeing;

    PageLog(PageStore pageStore) {
        this.store = pageStore;
        this.dataBuffer = pageStore.createData();
        this.trace = pageStore.getTrace();
        this.compress = new CompressLZF();
        this.compressBuffer = new byte[pageStore.getPageSize() * 2];
    }

    void openForWriting(int n2, boolean bl2) {
        this.trace.debug("log openForWriting firstPage: " + n2);
        this.firstTrunkPage = n2;
        ++this.logKey;
        this.pageOut = new PageOutputStream(this.store, n2, this.undoAll, this.logKey, bl2);
        this.pageOut.reserve(1);
        this.store.setLogFirstPage(this.logKey, n2, this.pageOut.getCurrentDataPageId());
        this.writeBuffer = this.store.createData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free() {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log free");
        }
        int n2 = 0;
        if (this.pageOut != null) {
            n2 = this.pageOut.getCurrentDataPageId();
            this.pageOut.freeReserved();
        }
        try {
            this.freeing = true;
            int n3 = 0;
            int n4 = 1024;
            int n5 = 0;
            PageStreamTrunk.Iterator iterator = new PageStreamTrunk.Iterator(this.store, this.firstTrunkPage);
            while (this.firstTrunkPage != 0 && this.firstTrunkPage < this.store.getPageCount()) {
                PageStreamTrunk pageStreamTrunk = iterator.next();
                if (pageStreamTrunk == null) {
                    if (iterator.canDelete()) {
                        this.store.free(this.firstTrunkPage, false);
                    }
                    break;
                }
                if (n5++ >= n4) {
                    n3 = pageStreamTrunk.getPos();
                    n5 = 0;
                    n4 *= 2;
                } else if (n3 != 0 && n3 == pageStreamTrunk.getPos()) {
                    throw DbException.throwInternalError("endless loop at " + pageStreamTrunk);
                }
                pageStreamTrunk.free(n2);
                this.firstTrunkPage = pageStreamTrunk.getNextTrunk();
            }
        }
        finally {
            this.freeing = false;
        }
    }

    void openForReading(int n2, int n3, int n4) {
        this.logKey = n2;
        this.firstTrunkPage = n3;
        this.firstDataPage = n4;
    }

    boolean recover(int n2) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log recover stage: " + n2);
        }
        if (n2 == 1) {
            PageInputStream pageInputStream = new PageInputStream(this.store, this.logKey, this.firstTrunkPage, this.firstDataPage);
            this.usedLogPages = pageInputStream.allocateAllPages();
            pageInputStream.close();
            return true;
        }
        PageInputStream pageInputStream = new PageInputStream(this.store, this.logKey, this.firstTrunkPage, this.firstDataPage);
        DataReader dataReader = new DataReader(pageInputStream);
        int n3 = 0;
        Data data = this.store.createData();
        boolean bl2 = true;
        try {
            byte by2;
            int n4 = 0;
            while ((by2 = dataReader.readByte()) >= 0) {
                int n5;
                ++n4;
                bl2 = false;
                if (by2 == 1) {
                    n5 = dataReader.readVarInt();
                    int n6 = dataReader.readVarInt();
                    if (n6 == 0) {
                        dataReader.readFully(data.getBytes(), this.store.getPageSize());
                    } else if (n6 == 1) {
                        Arrays.fill(data.getBytes(), 0, this.store.getPageSize(), (byte)0);
                    } else {
                        dataReader.readFully(this.compressBuffer, n6);
                        try {
                            this.compress.expand(this.compressBuffer, 0, n6, data.getBytes(), 0, this.store.getPageSize());
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            DbException.convertToIOException(arrayIndexOutOfBoundsException);
                        }
                    }
                    if (n2 != 0) continue;
                    if (!this.undo.get(n5)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log undo {0}", n5);
                        }
                        this.store.writePage(n5, data);
                        this.undo.set(n5);
                        this.undoAll.set(n5);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log undo skip {0}", n5);
                    continue;
                }
                if (by2 == 5) {
                    n5 = dataReader.readVarInt();
                    int n7 = dataReader.readVarInt();
                    Row row = PageLog.readRow(this.store.getDatabase().getRowFactory(), dataReader, data);
                    if (n2 == 0) {
                        this.store.allocateIfIndexRoot(n4, n7, row);
                        continue;
                    }
                    if (n2 != 2) continue;
                    if (this.isSessionCommitted(n5, n3, n4)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log redo + table: " + n7 + " s: " + n5 + " " + row);
                        }
                        this.store.redo(n7, row, true);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log ignore s: " + n5 + " + table: " + n7 + " " + row);
                    continue;
                }
                if (by2 == 6) {
                    n5 = dataReader.readVarInt();
                    int n8 = dataReader.readVarInt();
                    long l2 = dataReader.readVarLong();
                    if (n2 != 2) continue;
                    if (this.isSessionCommitted(n5, n3, n4)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log redo - table: " + n8 + " s:" + n5 + " key: " + l2);
                        }
                        this.store.redoDelete(n8, l2);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log ignore s: " + n5 + " - table: " + n8 + " " + l2);
                    continue;
                }
                if (by2 == 7) {
                    n5 = dataReader.readVarInt();
                    int n9 = dataReader.readVarInt();
                    if (n2 != 2) continue;
                    if (this.isSessionCommitted(n5, n3, n4)) {
                        if (this.trace.isDebugEnabled()) {
                            this.trace.debug("log redo truncate table: " + n9);
                        }
                        this.store.redoTruncate(n9);
                        continue;
                    }
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log ignore s: " + n5 + " truncate table: " + n9);
                    continue;
                }
                if (by2 == 3) {
                    n5 = dataReader.readVarInt();
                    String string = dataReader.readString();
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log prepare commit " + n5 + " " + string + " pos: " + n4);
                    }
                    if (n2 != 0) continue;
                    int n10 = pageInputStream.getDataPage();
                    this.setPrepareCommit(n5, n10, string);
                    continue;
                }
                if (by2 == 4) {
                    n5 = dataReader.readVarInt();
                    if (!this.trace.isDebugEnabled()) continue;
                    this.trace.debug("log rollback " + n5 + " pos: " + n4);
                    continue;
                }
                if (by2 == 2) {
                    n5 = dataReader.readVarInt();
                    if (this.trace.isDebugEnabled()) {
                        this.trace.debug("log commit " + n5 + " pos: " + n4);
                    }
                    if (n2 != 0) continue;
                    this.setLastCommitForSession(n5, n3, n4);
                    continue;
                }
                if (by2 == 0) continue;
                if (by2 == 8) {
                    ++n3;
                    continue;
                }
                if (by2 == 9) {
                    n5 = dataReader.readVarInt();
                    for (int i2 = 0; i2 < n5; ++i2) {
                        int n11 = dataReader.readVarInt();
                        if (n2 != 2 || this.usedLogPages.get(n11)) continue;
                        this.store.free(n11, false);
                    }
                    continue;
                }
                if (!this.trace.isDebugEnabled()) continue;
                this.trace.debug("log end");
                break;
            }
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 90030) {
                this.trace.debug("log recovery stopped");
            }
            throw dbException;
        }
        catch (IOException iOException) {
            this.trace.debug("log recovery completed");
        }
        this.undo = new BitField();
        if (n2 == 2) {
            this.usedLogPages = null;
        }
        return bl2;
    }

    private void setPrepareCommit(int n2, int n3, String string) {
        SessionState sessionState = this.getOrAddSessionState(n2);
        PageStoreInDoubtTransaction pageStoreInDoubtTransaction = string == null ? null : new PageStoreInDoubtTransaction(this.store, n2, n3, string);
        sessionState.inDoubtTransaction = pageStoreInDoubtTransaction;
    }

    public static Row readRow(RowFactory rowFactory, DataReader dataReader, Data data) throws IOException {
        long l2 = dataReader.readVarLong();
        int n2 = dataReader.readVarInt();
        data.reset();
        data.checkCapacity(n2);
        dataReader.readFully(data.getBytes(), n2);
        int n3 = data.readVarInt();
        Value[] valueArray = new Value[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            valueArray[i2] = data.readValue();
        }
        Row row = rowFactory.createRow(valueArray, -1);
        row.setKey(l2);
        return row;
    }

    boolean getUndo(int n2) {
        return this.undo.get(n2);
    }

    void addUndo(int n2, Data data) {
        if (this.undo.get(n2) || this.freeing) {
            return;
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log undo " + n2);
        }
        if (SysProperties.CHECK && data == null) {
            DbException.throwInternalError("Undo entry not written");
        }
        this.undo.set(n2);
        this.undoAll.set(n2);
        Data data2 = this.getBuffer();
        data2.writeByte((byte)1);
        data2.writeVarInt(n2);
        if (data.getBytes()[0] == 0) {
            data2.writeVarInt(1);
        } else {
            int n3 = this.store.getPageSize();
            int n4 = this.compress.compress(data.getBytes(), n3, this.compressBuffer, 0);
            if (n4 < n3) {
                data2.writeVarInt(n4);
                data2.checkCapacity(n4);
                data2.write(this.compressBuffer, 0, n4);
            } else {
                data2.writeVarInt(0);
                data2.checkCapacity(n3);
                data2.write(data.getBytes(), 0, n3);
            }
        }
        this.write(data2);
    }

    private void freeLogPages(IntArray intArray) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log frees " + intArray.get(0) + ".." + intArray.get(intArray.size() - 1));
        }
        Data data = this.getBuffer();
        data.writeByte((byte)9);
        int n2 = intArray.size();
        data.writeVarInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            data.writeVarInt(intArray.get(i2));
        }
        this.write(data);
    }

    private void write(Data data) {
        this.pageOut.write(data.getBytes(), 0, data.length());
        data.reset();
    }

    void commit(int n2) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log commit s: " + n2);
        }
        if (this.store.getDatabase().getPageStore() == null) {
            return;
        }
        Data data = this.getBuffer();
        data.writeByte((byte)2);
        data.writeVarInt(n2);
        this.write(data);
        if (this.store.getDatabase().getFlushOnEachCommit()) {
            this.flush();
        }
    }

    void prepareCommit(Session session, String string) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log prepare commit s: " + session.getId() + ", " + string);
        }
        if (this.store.getDatabase().getPageStore() == null) {
            return;
        }
        int n2 = this.store.getPageSize();
        this.pageOut.flush();
        this.pageOut.fillPage();
        Data data = this.getBuffer();
        data.writeByte((byte)3);
        data.writeVarInt(session.getId());
        data.writeString(string);
        if (data.length() >= PageStreamData.getCapacity(n2)) {
            throw DbException.getInvalidValueException("transaction name (too long)", string);
        }
        this.write(data);
        this.flushOut();
        this.pageOut.fillPage();
        if (this.store.getDatabase().getFlushOnEachCommit()) {
            this.flush();
        }
    }

    void logAddOrRemoveRow(Session session, int n2, Row row, boolean bl2) {
        int n3;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log " + (bl2 ? "+" : "-") + " s: " + session.getId() + " table: " + n2 + " row: " + row);
        }
        session.addLogPos(this.logSectionId, this.logPos);
        ++this.logPos;
        Data data = this.dataBuffer;
        data.reset();
        int n4 = row.getColumnCount();
        data.writeVarInt(n4);
        data.checkCapacity(row.getByteCount(data));
        if (session.isRedoLogBinaryEnabled()) {
            for (n3 = 0; n3 < n4; ++n3) {
                data.writeValue(row.getValue(n3));
            }
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                Value value = row.getValue(n3);
                if (value.getType() == 12) {
                    data.writeValue(ValueNull.INSTANCE);
                    continue;
                }
                data.writeValue(value);
            }
        }
        Data data2 = this.getBuffer();
        data2.writeByte((byte)(bl2 ? 5 : 6));
        data2.writeVarInt(session.getId());
        data2.writeVarInt(n2);
        data2.writeVarLong(row.getKey());
        if (bl2) {
            data2.writeVarInt(data.length());
            data2.checkCapacity(data.length());
            data2.write(data.getBytes(), 0, data.length());
        }
        this.write(data2);
    }

    void logTruncate(Session session, int n2) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("log truncate s: " + session.getId() + " table: " + n2);
        }
        session.addLogPos(this.logSectionId, this.logPos);
        ++this.logPos;
        Data data = this.getBuffer();
        data.writeByte((byte)7);
        data.writeVarInt(session.getId());
        data.writeVarInt(n2);
        this.write(data);
    }

    void flush() {
        if (this.pageOut != null) {
            this.flushOut();
        }
    }

    void checkpoint() {
        Data data = this.getBuffer();
        data.writeByte((byte)8);
        this.write(data);
        this.undo = new BitField();
        ++this.logSectionId;
        this.logPos = 0;
        this.pageOut.flush();
        this.pageOut.fillPage();
        int n2 = this.pageOut.getCurrentDataPageId();
        this.logSectionPageMap.put(this.logSectionId, n2);
    }

    int getLogSectionId() {
        return this.logSectionId;
    }

    int getLogFirstSectionId() {
        return this.firstSectionId;
    }

    int getLogPos() {
        return this.logPos;
    }

    void removeUntil(int n2) {
        if (n2 == 0) {
            return;
        }
        int n3 = this.logSectionPageMap.get(n2);
        this.firstTrunkPage = this.removeUntil(this.firstTrunkPage, n3);
        this.store.setLogFirstPage(this.logKey, this.firstTrunkPage, n3);
        while (this.firstSectionId < n2) {
            if (this.firstSectionId > 0) {
                this.logSectionPageMap.remove(this.firstSectionId);
            }
            ++this.firstSectionId;
        }
    }

    private int removeUntil(int n2, int n3) {
        this.trace.debug("log.removeUntil " + n2 + " " + n3);
        int n4 = n2;
        while (true) {
            int n5;
            Page page;
            PageStreamTrunk pageStreamTrunk;
            if ((pageStreamTrunk = (PageStreamTrunk)(page = this.store.getPage(n2))) == null) {
                throw DbException.throwInternalError("log.removeUntil not found: " + n3 + " last " + n4);
            }
            this.logKey = pageStreamTrunk.getLogKey();
            n4 = pageStreamTrunk.getPos();
            if (pageStreamTrunk.contains(n3)) {
                return n4;
            }
            n2 = pageStreamTrunk.getNextTrunk();
            IntArray intArray = new IntArray();
            intArray.add(pageStreamTrunk.getPos());
            int n6 = 0;
            while ((n5 = pageStreamTrunk.getPageData(n6)) != -1) {
                intArray.add(n5);
                ++n6;
            }
            this.freeLogPages(intArray);
            this.pageOut.free(pageStreamTrunk);
        }
    }

    void close() {
        this.trace.debug("log close");
        if (this.pageOut != null) {
            this.pageOut.close();
            this.pageOut = null;
        }
        this.writeBuffer = null;
    }

    private boolean isSessionCommitted(int n2, int n3, int n4) {
        SessionState sessionState = this.sessionStates.get(n2);
        if (sessionState == null) {
            return false;
        }
        return sessionState.isCommitted(n3, n4);
    }

    private void setLastCommitForSession(int n2, int n3, int n4) {
        SessionState sessionState = this.getOrAddSessionState(n2);
        sessionState.lastCommitLog = n3;
        sessionState.lastCommitPos = n4;
        sessionState.inDoubtTransaction = null;
    }

    private SessionState getOrAddSessionState(int n2) {
        Integer n3 = n2;
        SessionState sessionState = this.sessionStates.get(n3);
        if (sessionState == null) {
            sessionState = new SessionState();
            this.sessionStates.put(n3, sessionState);
            sessionState.sessionId = n2;
        }
        return sessionState;
    }

    long getSize() {
        return this.pageOut == null ? 0L : this.pageOut.getSize();
    }

    ArrayList<InDoubtTransaction> getInDoubtTransactions() {
        ArrayList<InDoubtTransaction> arrayList = New.arrayList();
        for (SessionState sessionState : this.sessionStates.values()) {
            PageStoreInDoubtTransaction pageStoreInDoubtTransaction = sessionState.inDoubtTransaction;
            if (pageStoreInDoubtTransaction == null) continue;
            arrayList.add(pageStoreInDoubtTransaction);
        }
        return arrayList;
    }

    void setInDoubtTransactionState(int n2, int n3, boolean bl2) {
        PageStreamData pageStreamData = (PageStreamData)this.store.getPage(n3);
        pageStreamData.initWrite();
        Data data = this.store.createData();
        data.writeByte((byte)(bl2 ? 2 : 4));
        data.writeVarInt(n2);
        byte[] byArray = data.getBytes();
        pageStreamData.write(byArray, 0, byArray.length);
        byArray = new byte[pageStreamData.getRemaining()];
        pageStreamData.write(byArray, 0, byArray.length);
        pageStreamData.write();
    }

    void recoverEnd() {
        this.sessionStates = New.hashMap();
    }

    private void flushOut() {
        this.pageOut.flush();
    }

    private Data getBuffer() {
        if (this.writeBuffer.length() == 0) {
            return this.writeBuffer;
        }
        return this.store.createData();
    }

    int getMinPageId() {
        return this.pageOut == null ? 0 : this.pageOut.getMinPageId();
    }
}

