/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.store.PageStreamData;
import org.h2.store.PageStreamTrunk;
import org.h2.util.BitField;

public class PageInputStream
extends InputStream {
    private final PageStore store;
    private final Trace trace;
    private final int firstTrunkPage;
    private final PageStreamTrunk.Iterator trunkIterator;
    private int dataPage;
    private PageStreamTrunk trunk;
    private int trunkIndex;
    private PageStreamData data;
    private int dataPos;
    private boolean endOfFile;
    private int remaining;
    private final byte[] buffer = new byte[]{0};
    private int logKey;

    PageInputStream(PageStore pageStore, int n2, int n3, int n4) {
        this.store = pageStore;
        this.trace = pageStore.getTrace();
        this.logKey = n2 - 1;
        this.firstTrunkPage = n3;
        this.trunkIterator = new PageStreamTrunk.Iterator(pageStore, n3);
        this.dataPage = n4;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.read(this.buffer);
        return n2 < 0 ? -1 : this.buffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 == 0) {
            return 0;
        }
        int n5 = 0;
        while (n3 > 0 && (n4 = this.readBlock(byArray, n2, n3)) >= 0) {
            n5 += n4;
            n2 += n4;
            n3 -= n4;
        }
        return n5 == 0 ? -1 : n5;
    }

    private int readBlock(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.fillBuffer();
            if (this.endOfFile) {
                return -1;
            }
            int n4 = Math.min(this.remaining, n3);
            this.data.read(this.dataPos, byArray, n2, n4);
            this.remaining -= n4;
            this.dataPos += n4;
            return n4;
        }
        catch (DbException dbException) {
            throw new EOFException();
        }
    }

    private void fillBuffer() {
        int n2;
        if (this.remaining > 0 || this.endOfFile) {
            return;
        }
        while (true) {
            if (this.trunk == null) {
                this.trunk = this.trunkIterator.next();
                this.trunkIndex = 0;
                ++this.logKey;
                if (this.trunk == null || this.trunk.getLogKey() != this.logKey) {
                    this.endOfFile = true;
                    return;
                }
            }
            if (this.trunk == null) continue;
            if ((n2 = this.trunk.getPageData(this.trunkIndex++)) == -1) {
                this.trunk = null;
                continue;
            }
            if (this.dataPage == -1 || this.dataPage == n2) break;
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("pageIn.readPage " + n2);
        }
        this.dataPage = -1;
        this.data = null;
        Page page = this.store.getPage(n2);
        if (page instanceof PageStreamData) {
            this.data = (PageStreamData)page;
        }
        if (this.data == null || this.data.getLogKey() != this.logKey) {
            this.endOfFile = true;
            return;
        }
        this.dataPos = PageStreamData.getReadStart();
        this.remaining = this.store.getPageSize() - this.dataPos;
    }

    BitField allocateAllPages() {
        BitField bitField = new BitField();
        int n2 = this.logKey;
        PageStreamTrunk.Iterator iterator = new PageStreamTrunk.Iterator(this.store, this.firstTrunkPage);
        block0: while (true) {
            PageStreamTrunk pageStreamTrunk = iterator.next();
            ++n2;
            if (iterator.canDelete()) {
                this.store.allocatePage(iterator.getCurrentPageId());
            }
            if (pageStreamTrunk == null || pageStreamTrunk.getLogKey() != n2) break;
            bitField.set(pageStreamTrunk.getPos());
            int n3 = 0;
            while (true) {
                int n4;
                if ((n4 = pageStreamTrunk.getPageData(n3)) == -1) continue block0;
                bitField.set(n4);
                this.store.allocatePage(n4);
                ++n3;
            }
            break;
        }
        return bitField;
    }

    int getDataPage() {
        return this.data.getPos();
    }

    @Override
    public void close() {
    }
}

