/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import org.h2.engine.Session;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.util.BitField;

public class PageFreeList
extends Page {
    private static final int DATA_START = 3;
    private final PageStore store;
    private final BitField used;
    private final int pageCount;
    private boolean full;
    private Data data;

    private PageFreeList(PageStore pageStore, int n2) {
        this.setPos(n2);
        this.store = pageStore;
        this.pageCount = (pageStore.getPageSize() - 3) * 8;
        this.used = new BitField(this.pageCount);
        this.used.set(0);
    }

    static PageFreeList read(PageStore pageStore, Data data, int n2) {
        PageFreeList pageFreeList = new PageFreeList(pageStore, n2);
        pageFreeList.data = data;
        pageFreeList.read();
        return pageFreeList;
    }

    static PageFreeList create(PageStore pageStore, int n2) {
        return new PageFreeList(pageStore, n2);
    }

    int allocate(BitField bitField, int n2) {
        int n3;
        block4: {
            if (this.full) {
                return -1;
            }
            int n4 = Math.max(0, n2 - this.getPos());
            do {
                if ((n3 = this.used.nextClearBit(n4)) >= this.pageCount) {
                    if (n4 == 0) {
                        this.full = true;
                    }
                    return -1;
                }
                if (bitField == null || !bitField.get(n3 + this.getPos())) break block4;
            } while ((n4 = bitField.nextClearBit(n3 + this.getPos()) - this.getPos()) < this.pageCount);
            return -1;
        }
        this.used.set(n3);
        this.store.logUndo(this, this.data);
        this.store.update(this);
        return n3 + this.getPos();
    }

    int getFirstFree(int n2) {
        if (this.full) {
            return -1;
        }
        int n3 = Math.max(0, n2 - this.getPos());
        int n4 = this.used.nextClearBit(n3);
        if (n4 >= this.pageCount) {
            return -1;
        }
        return n4 + this.getPos();
    }

    int getLastUsed() {
        int n2 = this.used.length() - 1;
        return n2 <= 0 ? -1 : n2 + this.getPos();
    }

    void allocate(int n2) {
        int n3 = n2 - this.getPos();
        if (n3 >= 0 && !this.used.get(n3)) {
            this.used.set(n3);
            this.store.logUndo(this, this.data);
            this.store.update(this);
        }
    }

    void free(int n2) {
        this.full = false;
        this.store.logUndo(this, this.data);
        this.used.clear(n2 - this.getPos());
        this.store.update(this);
    }

    private void read() {
        this.data.reset();
        this.data.readByte();
        this.data.readShortInt();
        for (int i2 = 0; i2 < this.pageCount; i2 += 8) {
            int n2 = this.data.readByte() & 0xFF;
            this.used.setByte(i2, n2);
        }
        this.full = false;
    }

    @Override
    public void write() {
        this.data = this.store.createData();
        this.data.writeByte((byte)6);
        this.data.writeShortInt(0);
        for (int i2 = 0; i2 < this.pageCount; i2 += 8) {
            this.data.writeByte((byte)this.used.getByte(i2));
        }
        this.store.writePage(this.getPos(), this.data);
    }

    public static int getPagesAddressed(int n2) {
        return (n2 - 3) * 8;
    }

    @Override
    public int getMemory() {
        return this.store.getPageSize() >> 2;
    }

    boolean isUsed(int n2) {
        return this.used.get(n2 - this.getPos());
    }

    @Override
    public void moveTo(Session session, int n2) {
        this.store.free(this.getPos(), false);
    }

    public String toString() {
        return "page [" + this.getPos() + "] freeList" + (this.full ? "full" : "");
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    @Override
    public boolean canMove() {
        return false;
    }
}

