/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.value.ValueLobDb;

class LobStorageRemoteInputStream
extends InputStream {
    private final DataHandler handler;
    private final long lob;
    private final byte[] hmac;
    private long pos;
    private long remainingBytes;

    public LobStorageRemoteInputStream(DataHandler dataHandler, ValueLobDb valueLobDb, byte[] byArray, long l2) {
        this.handler = dataHandler;
        this.lob = valueLobDb.getLobId();
        this.hmac = byArray;
        this.remainingBytes = l2;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray, 0, 1);
        return n2 < 0 ? n2 : byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        if ((n3 = (int)Math.min((long)n3, this.remainingBytes)) == 0) {
            return -1;
        }
        try {
            n3 = this.handler.readLob(this.lob, this.hmac, this.pos, byArray, n2, n3);
        }
        catch (DbException dbException) {
            throw DbException.convertToIOException(dbException);
        }
        if (n3 == 0) {
            return -1;
        }
        this.remainingBytes -= (long)n3;
        this.pos += (long)n3;
        return n3;
    }

    @Override
    public long skip(long l2) {
        this.remainingBytes -= l2;
        this.pos += l2;
        return l2;
    }
}

