/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.StreamStore;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.store.CountingReaderInputStream;
import org.h2.store.LimitInputStream;
import org.h2.store.LobStorageInterface;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueLobDb;

public class LobStorageMap
implements LobStorageInterface {
    private static final boolean TRACE = false;
    private final Database database;
    private boolean init;
    private Object nextLobIdSync = new Object();
    private long nextLobId;
    private MVMap<Long, Object[]> lobMap;
    private MVMap<Object[], Boolean> refMap;
    private MVMap<Long, byte[]> dataMap;
    private StreamStore streamStore;

    public LobStorageMap(Database database) {
        this.database = database;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        MVTableEngine.Store store = this.database.getMvStore();
        MVStore mVStore = store == null ? MVStore.open(null) : store.getStore();
        this.lobMap = mVStore.openMap("lobMap");
        this.refMap = mVStore.openMap("lobRef");
        this.dataMap = mVStore.openMap("lobData");
        this.streamStore = new StreamStore(this.dataMap);
        if (this.database.isReadOnly()) {
            return;
        }
        if (this.dataMap.isEmpty()) {
            return;
        }
        long l2 = -1L;
        Object object = this.lobMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<Long, Object[]> entry = object.next();
            long l3 = entry.getKey();
            Object[] objectArray = entry.getValue();
            byte[] byArray = (byte[])objectArray[0];
            long l4 = this.streamStore.getMaxBlockKey(byArray);
            if (l4 == -1L || l4 <= l2) continue;
            l2 = l4;
        }
        while ((object = this.dataMap.lastKey()) != null && (Long)object > l2) {
            this.dataMap.remove(object);
        }
        object = this.dataMap.lastKey();
        if (object != null) {
            this.streamStore.setNextKey((Long)object + 1L);
        }
    }

    @Override
    public Value createBlob(InputStream inputStream, long l2) {
        this.init();
        int n2 = 15;
        if (l2 < 0L) {
            l2 = Long.MAX_VALUE;
        }
        int n3 = (int)Math.min(l2, (long)this.database.getMaxLengthInplaceLob());
        try {
            if (n3 != 0 && n3 < Integer.MAX_VALUE) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n3);
                bufferedInputStream.mark(n3);
                byte[] byArray = new byte[n3];
                int n4 = IOUtils.readFully(bufferedInputStream, byArray, n3);
                if (n4 < n3) {
                    if (n4 < byArray.length) {
                        byArray = Arrays.copyOf(byArray, n4);
                    }
                    return ValueLobDb.createSmallLob(n2, byArray);
                }
                bufferedInputStream.reset();
                inputStream = bufferedInputStream;
            }
            if (l2 != Long.MAX_VALUE) {
                inputStream = new LimitInputStream(inputStream, l2);
            }
            return this.createLob(inputStream, n2);
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    @Override
    public Value createClob(Reader closeable, long l2) {
        this.init();
        int n2 = 16;
        if (l2 < 0L) {
            l2 = Long.MAX_VALUE;
        }
        int n3 = (int)Math.min(l2, (long)this.database.getMaxLengthInplaceLob());
        try {
            Object object;
            Closeable closeable2;
            if (n3 != 0 && n3 < Integer.MAX_VALUE) {
                closeable2 = new BufferedReader((Reader)closeable, n3);
                ((BufferedReader)closeable2).mark(n3);
                object = new char[n3];
                int n4 = IOUtils.readFully((Reader)closeable2, (char[])object, n3);
                if (n4 < n3) {
                    if (n4 < ((Object)object).length) {
                        object = Arrays.copyOf((char[])object, n4);
                    }
                    byte[] byArray = new String((char[])object, 0, n4).getBytes(Constants.UTF8);
                    return ValueLobDb.createSmallLob(n2, byArray);
                }
                ((BufferedReader)closeable2).reset();
                closeable = closeable2;
            }
            closeable2 = new CountingReaderInputStream((Reader)closeable, l2);
            object = this.createLob((InputStream)closeable2, n2);
            object = ValueLobDb.create(n2, this.database, ((ValueLobDb)object).getTableId(), ((ValueLobDb)object).getLobId(), null, ((CountingReaderInputStream)closeable2).getLength());
            return object;
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private ValueLobDb createLob(InputStream inputStream, int n2) throws IOException {
        byte[] byArray;
        try {
            byArray = this.streamStore.put(inputStream);
        }
        catch (Exception exception) {
            throw DbException.convertToIOException(exception);
        }
        long l2 = this.generateLobId();
        long l3 = this.streamStore.length(byArray);
        int n3 = -2;
        Object[] objectArray = new Object[]{byArray, n3, l3, 0};
        this.lobMap.put(l2, objectArray);
        Object[] objectArray2 = new Object[]{byArray, l2};
        this.refMap.put(objectArray2, Boolean.TRUE);
        ValueLobDb valueLobDb = ValueLobDb.create(n2, this.database, n3, l2, null, l3);
        return valueLobDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateLobId() {
        Object object = this.nextLobIdSync;
        synchronized (object) {
            if (this.nextLobId == 0L) {
                Long l2 = this.lobMap.lastKey();
                this.nextLobId = l2 == null ? 1L : l2 + 1L;
            }
            return this.nextLobId++;
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    public ValueLobDb copyLob(ValueLobDb valueLobDb, int n2, long l2) {
        this.init();
        int n3 = valueLobDb.getType();
        long l3 = valueLobDb.getLobId();
        long l4 = valueLobDb.getPrecision();
        if (l4 != l2) {
            throw DbException.throwInternalError("Length is different");
        }
        Object[] objectArray = this.lobMap.get(l3);
        objectArray = (Object[])objectArray.clone();
        byte[] byArray = (byte[])objectArray[0];
        long l5 = this.generateLobId();
        objectArray[1] = n2;
        this.lobMap.put(l5, objectArray);
        Object[] objectArray2 = new Object[]{byArray, l5};
        this.refMap.put(objectArray2, Boolean.TRUE);
        ValueLobDb valueLobDb2 = ValueLobDb.create(n3, this.database, n2, l5, null, l2);
        return valueLobDb2;
    }

    @Override
    public InputStream getInputStream(ValueLobDb valueLobDb, byte[] byArray, long l2) throws IOException {
        this.init();
        Object[] objectArray = this.lobMap.get(valueLobDb.getLobId());
        if (objectArray == null) {
            if (valueLobDb.getTableId() == -3 || valueLobDb.getTableId() == -1) {
                throw DbException.get(90039, "" + valueLobDb.getLobId() + "/" + valueLobDb.getTableId());
            }
            throw DbException.throwInternalError("Lob not found: " + valueLobDb.getLobId() + "/" + valueLobDb.getTableId());
        }
        byte[] byArray2 = (byte[])objectArray[0];
        return this.streamStore.get(byArray2);
    }

    @Override
    public void setTable(ValueLobDb valueLobDb, int n2) {
        this.init();
        long l2 = valueLobDb.getLobId();
        Object[] objectArray = this.lobMap.remove(l2);
        objectArray[1] = n2;
        this.lobMap.put(l2, objectArray);
    }

    @Override
    public void removeAllForTable(int n2) {
        this.init();
        if (this.database.getMvStore().getStore().isClosed()) {
            return;
        }
        ArrayList arrayList = New.arrayList();
        for (Map.Entry<Long, Object[]> entry : this.lobMap.entrySet()) {
            Object[] objectArray = entry.getValue();
            int n3 = (Integer)objectArray[1];
            if (n3 != n2) continue;
            arrayList.add(entry.getKey());
        }
        Iterator<Map.Entry<Long, Object>> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            long l2 = (Long)((Object)iterator.next());
            this.removeLob(n2, l2);
        }
        if (n2 == -1) {
            this.removeAllForTable(-2);
            this.removeAllForTable(-3);
        }
    }

    @Override
    public void removeLob(ValueLobDb valueLobDb) {
        this.init();
        int n2 = valueLobDb.getTableId();
        long l2 = valueLobDb.getLobId();
        this.removeLob(n2, l2);
    }

    private void removeLob(int n2, long l2) {
        byte[] byArray;
        Object[] objectArray = this.lobMap.remove(l2);
        if (objectArray == null) {
            return;
        }
        byte[] byArray2 = (byte[])objectArray[0];
        Object[] objectArray2 = new Object[]{byArray2, l2};
        this.refMap.remove(objectArray2);
        objectArray2 = new Object[]{byArray2, 0L};
        objectArray = this.refMap.ceilingKey(objectArray2);
        boolean bl2 = false;
        if (objectArray != null && Arrays.equals(byArray2, byArray = (byte[])objectArray[0])) {
            bl2 = true;
        }
        if (!bl2) {
            this.streamStore.remove(byArray2);
        }
    }

    private static void trace(String string) {
        System.out.println("[" + Thread.currentThread().getName() + "] LOB " + string);
    }
}

