/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.h2.store.DataHandler;
import org.h2.store.LobStorageInterface;
import org.h2.store.LobStorageRemoteInputStream;
import org.h2.value.Value;
import org.h2.value.ValueLobDb;

public class LobStorageFrontend
implements LobStorageInterface {
    public static final int TABLE_ID_SESSION_VARIABLE = -1;
    public static final int TABLE_TEMP = -2;
    public static final int TABLE_RESULT = -3;
    private final DataHandler handler;

    public LobStorageFrontend(DataHandler dataHandler) {
        this.handler = dataHandler;
    }

    @Override
    public void removeLob(ValueLobDb valueLobDb) {
    }

    @Override
    public InputStream getInputStream(ValueLobDb valueLobDb, byte[] byArray, long l2) throws IOException {
        if (l2 < 0L) {
            l2 = Long.MAX_VALUE;
        }
        return new BufferedInputStream(new LobStorageRemoteInputStream(this.handler, valueLobDb, byArray, l2));
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ValueLobDb copyLob(ValueLobDb valueLobDb, int n2, long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTable(ValueLobDb valueLobDb, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllForTable(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value createBlob(InputStream inputStream, long l2) {
        return ValueLobDb.createTempBlob(inputStream, l2, this.handler);
    }

    @Override
    public Value createClob(Reader reader, long l2) {
        return ValueLobDb.createTempClob(reader, l2, this.handler);
    }

    @Override
    public void init() {
    }
}

