/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.engine.Database;
import org.h2.engine.SessionInterface;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.store.CountingReaderInputStream;
import org.h2.store.LobStorageInterface;
import org.h2.tools.CompressTool;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueLobDb;

public class LobStorageBackend
implements LobStorageInterface {
    public static final String LOB_DATA_TABLE = "LOB_DATA";
    private static final String LOB_SCHEMA = "INFORMATION_SCHEMA";
    private static final String LOBS = "INFORMATION_SCHEMA.LOBS";
    private static final String LOB_MAP = "INFORMATION_SCHEMA.LOB_MAP";
    private static final String LOB_DATA = "INFORMATION_SCHEMA.LOB_DATA";
    private static final int BLOCK_LENGTH = 20000;
    private static final int HASH_CACHE_SIZE = 4096;
    JdbcConnection conn;
    final Database database;
    private final HashMap<String, PreparedStatement> prepared = New.hashMap();
    private long nextBlock;
    private final CompressTool compress = CompressTool.getInstance();
    private long[] hashBlocks;
    private boolean init;

    public LobStorageBackend(Database database) {
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.init) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.init) {
                return;
            }
            this.init = true;
            this.conn = this.database.getLobConnectionForRegularUse();
            JdbcConnection jdbcConnection = this.database.getLobConnectionForInit();
            try {
                Statement statement = jdbcConnection.createStatement();
                boolean bl2 = true;
                PreparedStatement preparedStatement = jdbcConnection.prepareStatement("SELECT ZERO() FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=? AND TABLE_NAME=? AND COLUMN_NAME=?");
                preparedStatement.setString(1, LOB_SCHEMA);
                preparedStatement.setString(2, "LOB_MAP");
                preparedStatement.setString(3, "POS");
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    preparedStatement = jdbcConnection.prepareStatement("SELECT ZERO() FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? AND TABLE_NAME=?");
                    preparedStatement.setString(1, LOB_SCHEMA);
                    preparedStatement.setString(2, LOB_DATA_TABLE);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    statement.execute("CREATE CACHED TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOBS(ID BIGINT PRIMARY KEY, BYTE_COUNT BIGINT, TABLE INT) HIDDEN");
                    statement.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_TABLE ON INFORMATION_SCHEMA.LOBS(TABLE)");
                    statement.execute("CREATE CACHED TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_MAP(LOB BIGINT, SEQ INT, POS BIGINT, HASH INT, BLOCK BIGINT, PRIMARY KEY(LOB, SEQ)) HIDDEN");
                    statement.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP RENAME TO INFORMATION_SCHEMA.LOB_MAP HIDDEN");
                    statement.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP ADD IF NOT EXISTS POS BIGINT BEFORE HASH");
                    statement.execute("ALTER TABLE INFORMATION_SCHEMA.LOB_MAP DROP COLUMN IF EXISTS \"OFFSET\"");
                    statement.execute("CREATE INDEX IF NOT EXISTS INFORMATION_SCHEMA.INDEX_LOB_MAP_DATA_LOB ON INFORMATION_SCHEMA.LOB_MAP(BLOCK, LOB)");
                    statement.execute("CREATE CACHED TABLE IF NOT EXISTS INFORMATION_SCHEMA.LOB_DATA(BLOCK BIGINT PRIMARY KEY, COMPRESSED INT, DATA BINARY) HIDDEN");
                }
                resultSet = statement.executeQuery("SELECT MAX(BLOCK) FROM INFORMATION_SCHEMA.LOB_DATA");
                resultSet.next();
                this.nextBlock = resultSet.getLong(1) + 1L;
                statement.close();
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
    }

    private long getNextLobId() throws SQLException {
        String string = "SELECT MAX(LOB) FROM INFORMATION_SCHEMA.LOB_MAP";
        PreparedStatement preparedStatement = this.prepare(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        long l2 = resultSet.getLong(1) + 1L;
        this.reuse(string, preparedStatement);
        string = "SELECT MAX(ID) FROM INFORMATION_SCHEMA.LOBS";
        preparedStatement = this.prepare(string);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        l2 = Math.max(l2, resultSet.getLong(1) + 1L);
        this.reuse(string, preparedStatement);
        return l2;
    }

    @Override
    public void removeAllForTable(int n2) {
        this.init();
        try {
            String string = "SELECT ID FROM INFORMATION_SCHEMA.LOBS WHERE TABLE = ?";
            PreparedStatement preparedStatement = this.prepare(string);
            preparedStatement.setInt(1, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                this.removeLob(resultSet.getLong(1));
            }
            this.reuse(string, preparedStatement);
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        if (n2 == -1) {
            this.removeAllForTable(-2);
            this.removeAllForTable(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readBlock(long l2) throws SQLException {
        LobStorageBackend.assertNotHolds(this.conn.getSession());
        Database database = this.database;
        synchronized (database) {
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                String string = "SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
                PreparedStatement preparedStatement = this.prepare(string);
                preparedStatement.setLong(1, l2);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw DbException.get(90028, "Missing lob entry, block: " + l2).getSQLException();
                }
                int n2 = resultSet.getInt(1);
                byte[] byArray = resultSet.getBytes(2);
                if (n2 != 0) {
                    byArray = this.compress.expand(byArray);
                }
                this.reuse(string, preparedStatement);
                return byArray;
            }
        }
    }

    PreparedStatement prepare(String string) throws SQLException {
        if (SysProperties.CHECK2 && !Thread.holdsLock(this.database)) {
            throw DbException.throwInternalError();
        }
        PreparedStatement preparedStatement = this.prepared.remove(string);
        if (preparedStatement == null) {
            preparedStatement = this.conn.prepareStatement(string);
        }
        return preparedStatement;
    }

    void reuse(String string, PreparedStatement preparedStatement) {
        if (SysProperties.CHECK2 && !Thread.holdsLock(this.database)) {
            throw DbException.throwInternalError();
        }
        this.prepared.put(string, preparedStatement);
    }

    @Override
    public void removeLob(ValueLobDb valueLobDb) {
        this.removeLob(valueLobDb.getLobId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLob(long l2) {
        try {
            LobStorageBackend.assertNotHolds(this.conn.getSession());
            Database database = this.database;
            synchronized (database) {
                SessionInterface sessionInterface = this.conn.getSession();
                synchronized (sessionInterface) {
                    String string = "SELECT BLOCK, HASH FROM INFORMATION_SCHEMA.LOB_MAP D WHERE D.LOB = ? AND NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.LOB_MAP O WHERE O.BLOCK = D.BLOCK AND O.LOB <> ?)";
                    PreparedStatement preparedStatement = this.prepare(string);
                    preparedStatement.setLong(1, l2);
                    preparedStatement.setLong(2, l2);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    ArrayList arrayList = New.arrayList();
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getLong(1));
                        int n2 = resultSet.getInt(2);
                        this.setHashCacheBlock(n2, -1L);
                    }
                    this.reuse(string, preparedStatement);
                    string = "DELETE FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
                    preparedStatement = this.prepare(string);
                    preparedStatement.setLong(1, l2);
                    preparedStatement.execute();
                    this.reuse(string, preparedStatement);
                    string = "DELETE FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
                    preparedStatement = this.prepare(string);
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        long l3 = (Long)iterator.next();
                        preparedStatement.setLong(1, l3);
                        preparedStatement.execute();
                    }
                    this.reuse(string, preparedStatement);
                    string = "DELETE FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                    preparedStatement = this.prepare(string);
                    preparedStatement.setLong(1, l2);
                    preparedStatement.execute();
                    this.reuse(string, preparedStatement);
                }
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(ValueLobDb valueLobDb, byte[] byArray, long l2) throws IOException {
        try {
            this.init();
            LobStorageBackend.assertNotHolds(this.conn.getSession());
            Database database = this.database;
            synchronized (database) {
                SessionInterface sessionInterface = this.conn.getSession();
                synchronized (sessionInterface) {
                    long l3 = valueLobDb.getLobId();
                    return new LobInputStream(l3, l2);
                }
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convertToIOException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueLobDb addLob(InputStream inputStream, long l2, int n2, CountingReaderInputStream countingReaderInputStream) {
        try {
            byte[] byArray = new byte[20000];
            if (l2 < 0L) {
                l2 = Long.MAX_VALUE;
            }
            long l3 = 0L;
            long l4 = -1L;
            int n3 = this.database.getMaxLengthInplaceLob();
            String string = this.database.getLobCompressionAlgorithm(n2);
            try {
                Object object;
                Object object2 = null;
                int n4 = 0;
                while (l2 > 0L) {
                    int n5 = (int)Math.min(20000L, l2);
                    if ((n5 = IOUtils.readFully(inputStream, byArray, n5)) <= 0) break;
                    l2 -= (long)n5;
                    if (n5 != byArray.length) {
                        object = new byte[n5];
                        System.arraycopy(byArray, 0, object, 0, n5);
                    } else {
                        object = byArray;
                    }
                    if (n4 == 0 && ((Object)object).length < 20000 && ((Object)object).length <= n3) {
                        object2 = object;
                        break;
                    }
                    LobStorageBackend.assertNotHolds(this.conn.getSession());
                    Database database = this.database;
                    synchronized (database) {
                        SessionInterface sessionInterface = this.conn.getSession();
                        synchronized (sessionInterface) {
                            if (n4 == 0) {
                                l4 = this.getNextLobId();
                            }
                            this.storeBlock(l4, n4, l3, (byte[])object, string);
                        }
                    }
                    l3 += (long)n5;
                    ++n4;
                }
                if (l4 == -1L && object2 == null) {
                    object2 = new byte[]{};
                }
                if (object2 != null) {
                    long l5 = countingReaderInputStream == null ? (long)((byte[])object2).length : countingReaderInputStream.getLength();
                    object = ValueLobDb.createSmallLob(n2, object2, l5);
                    return object;
                }
                long l6 = countingReaderInputStream == null ? l3 : countingReaderInputStream.getLength();
                return this.registerLob(n2, l4, -2, l3, l6);
            }
            catch (IOException iOException) {
                if (l4 != -1L) {
                    this.removeLob(l4);
                }
                throw DbException.convertIOException(iOException, null);
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueLobDb registerLob(int n2, long l2, int n3, long l3, long l4) throws SQLException {
        LobStorageBackend.assertNotHolds(this.conn.getSession());
        Database database = this.database;
        synchronized (database) {
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                String string = "INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, TABLE) VALUES(?, ?, ?)";
                PreparedStatement preparedStatement = this.prepare(string);
                preparedStatement.setLong(1, l2);
                preparedStatement.setLong(2, l3);
                preparedStatement.setInt(3, n3);
                preparedStatement.execute();
                this.reuse(string, preparedStatement);
                ValueLobDb valueLobDb = ValueLobDb.create(n2, this.database, n3, l2, null, l4);
                return valueLobDb;
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    public ValueLobDb copyLob(ValueLobDb valueLobDb, int n2, long l2) {
        int n3 = valueLobDb.getType();
        long l3 = valueLobDb.getLobId();
        LobStorageBackend.assertNotHolds(this.conn.getSession());
        Database database = this.database;
        synchronized (database) {
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                try {
                    this.init();
                    long l4 = this.getNextLobId();
                    String string = "INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, POS, HASH, BLOCK) SELECT ?, SEQ, POS, HASH, BLOCK FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
                    PreparedStatement preparedStatement = this.prepare(string);
                    preparedStatement.setLong(1, l4);
                    preparedStatement.setLong(2, l3);
                    preparedStatement.executeUpdate();
                    this.reuse(string, preparedStatement);
                    string = "INSERT INTO INFORMATION_SCHEMA.LOBS(ID, BYTE_COUNT, TABLE) SELECT ?, BYTE_COUNT, ? FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                    preparedStatement = this.prepare(string);
                    preparedStatement.setLong(1, l4);
                    preparedStatement.setLong(2, n2);
                    preparedStatement.setLong(3, l3);
                    preparedStatement.executeUpdate();
                    this.reuse(string, preparedStatement);
                    ValueLobDb valueLobDb2 = ValueLobDb.create(n3, this.database, n2, l4, null, l2);
                    return valueLobDb2;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
        }
    }

    private long getHashCacheBlock(int n2) {
        this.initHashCache();
        int n3 = n2 & 0xFFF;
        long l2 = this.hashBlocks[n3];
        if (l2 == (long)n2) {
            return this.hashBlocks[n3 + 4096];
        }
        return -1L;
    }

    private void setHashCacheBlock(int n2, long l2) {
        this.initHashCache();
        int n3 = n2 & 0xFFF;
        this.hashBlocks[n3] = n2;
        this.hashBlocks[n3 + 4096] = l2;
    }

    private void initHashCache() {
        if (this.hashBlocks == null) {
            this.hashBlocks = new long[8192];
        }
    }

    void storeBlock(long l2, int n2, long l3, byte[] byArray, String string) throws SQLException {
        PreparedStatement preparedStatement;
        String string2;
        boolean bl2 = false;
        if (string != null) {
            byArray = this.compress.compress(byArray, string);
        }
        int n3 = Arrays.hashCode(byArray);
        LobStorageBackend.assertHoldsLock(this.conn.getSession());
        LobStorageBackend.assertHoldsLock(this.database);
        long l4 = this.getHashCacheBlock(n3);
        if (l4 != -1L) {
            string2 = "SELECT COMPRESSED, DATA FROM INFORMATION_SCHEMA.LOB_DATA WHERE BLOCK = ?";
            preparedStatement = this.prepare(string2);
            preparedStatement.setLong(1, l4);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl3 = resultSet.getInt(1) != 0;
                byte[] byArray2 = resultSet.getBytes(2);
                if (bl3 == (string != null) && Arrays.equals(byArray, byArray2)) {
                    bl2 = true;
                }
            }
            this.reuse(string2, preparedStatement);
        }
        if (!bl2) {
            l4 = this.nextBlock++;
            this.setHashCacheBlock(n3, l4);
            string2 = "INSERT INTO INFORMATION_SCHEMA.LOB_DATA(BLOCK, COMPRESSED, DATA) VALUES(?, ?, ?)";
            preparedStatement = this.prepare(string2);
            preparedStatement.setLong(1, l4);
            preparedStatement.setInt(2, string == null ? 0 : 1);
            preparedStatement.setBytes(3, byArray);
            preparedStatement.execute();
            this.reuse(string2, preparedStatement);
        }
        string2 = "INSERT INTO INFORMATION_SCHEMA.LOB_MAP(LOB, SEQ, POS, HASH, BLOCK) VALUES(?, ?, ?, ?, ?)";
        preparedStatement = this.prepare(string2);
        preparedStatement.setLong(1, l2);
        preparedStatement.setInt(2, n2);
        preparedStatement.setLong(3, l3);
        preparedStatement.setLong(4, n3);
        preparedStatement.setLong(5, l4);
        preparedStatement.execute();
        this.reuse(string2, preparedStatement);
    }

    @Override
    public Value createBlob(InputStream inputStream, long l2) {
        this.init();
        return this.addLob(inputStream, l2, 15, null);
    }

    @Override
    public Value createClob(Reader reader, long l2) {
        this.init();
        long l3 = l2 == -1L ? Long.MAX_VALUE : l2;
        CountingReaderInputStream countingReaderInputStream = new CountingReaderInputStream(reader, l3);
        ValueLobDb valueLobDb = this.addLob(countingReaderInputStream, Long.MAX_VALUE, 16, countingReaderInputStream);
        return valueLobDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTable(ValueLobDb valueLobDb, int n2) {
        long l2 = valueLobDb.getLobId();
        LobStorageBackend.assertNotHolds(this.conn.getSession());
        Database database = this.database;
        synchronized (database) {
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                try {
                    this.init();
                    String string = "UPDATE INFORMATION_SCHEMA.LOBS SET TABLE = ? WHERE ID = ?";
                    PreparedStatement preparedStatement = this.prepare(string);
                    preparedStatement.setInt(1, n2);
                    preparedStatement.setLong(2, l2);
                    preparedStatement.executeUpdate();
                    this.reuse(string, preparedStatement);
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
        }
    }

    private static void assertNotHolds(Object object) {
        if (Thread.holdsLock(object)) {
            throw DbException.throwInternalError();
        }
    }

    static void assertHoldsLock(Object object) {
        if (!Thread.holdsLock(object)) {
            throw DbException.throwInternalError();
        }
    }

    public class LobInputStream
    extends InputStream {
        private final long[] lobMapBlocks;
        private int lobMapIndex;
        private long remainingBytes;
        private byte[] buffer;
        private int bufferPos;

        public LobInputStream(long l2, long l3) throws SQLException {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            String string;
            LobStorageBackend.assertHoldsLock(LobStorageBackend.this.conn.getSession());
            LobStorageBackend.assertHoldsLock(LobStorageBackend.this.database);
            if (l3 == -1L) {
                string = "SELECT BYTE_COUNT FROM INFORMATION_SCHEMA.LOBS WHERE ID = ?";
                preparedStatement = LobStorageBackend.this.prepare(string);
                preparedStatement.setLong(1, l2);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw DbException.get(90028, "Missing lob entry: " + l2).getSQLException();
                }
                l3 = resultSet.getLong(1);
                LobStorageBackend.this.reuse(string, preparedStatement);
            }
            this.remainingBytes = l3;
            string = "SELECT COUNT(*) FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ?";
            preparedStatement = LobStorageBackend.this.prepare(string);
            preparedStatement.setLong(1, l2);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            int n2 = resultSet.getInt(1);
            if (n2 == 0) {
                throw DbException.get(90028, "Missing lob entry: " + l2).getSQLException();
            }
            LobStorageBackend.this.reuse(string, preparedStatement);
            this.lobMapBlocks = new long[n2];
            string = "SELECT BLOCK FROM INFORMATION_SCHEMA.LOB_MAP WHERE LOB = ? ORDER BY SEQ";
            preparedStatement = LobStorageBackend.this.prepare(string);
            preparedStatement.setLong(1, l2);
            resultSet = preparedStatement.executeQuery();
            int n3 = 0;
            while (resultSet.next()) {
                this.lobMapBlocks[n3] = resultSet.getLong(1);
                ++n3;
            }
            LobStorageBackend.this.reuse(string, preparedStatement);
        }

        @Override
        public int read() throws IOException {
            this.fillBuffer();
            if (this.remainingBytes <= 0L) {
                return -1;
            }
            --this.remainingBytes;
            return this.buffer[this.bufferPos++] & 0xFF;
        }

        @Override
        public long skip(long l2) throws IOException {
            if (l2 <= 0L) {
                return 0L;
            }
            long l3 = l2;
            if ((l3 -= (long)this.skipSmall(l3)) > 20000L) {
                while (l3 > 20000L) {
                    l3 -= 20000L;
                    this.remainingBytes -= 20000L;
                    ++this.lobMapIndex;
                }
                this.bufferPos = 0;
                this.buffer = null;
            }
            this.fillBuffer();
            l3 -= (long)this.skipSmall(l3);
            l3 -= super.skip(l3);
            return l2 - l3;
        }

        private int skipSmall(long l2) {
            if (this.buffer != null && this.bufferPos < this.buffer.length) {
                int n2 = MathUtils.convertLongToInt(Math.min(l2, (long)(this.buffer.length - this.bufferPos)));
                this.bufferPos += n2;
                this.remainingBytes -= (long)n2;
                return n2;
            }
            return 0;
        }

        @Override
        public int available() throws IOException {
            return MathUtils.convertLongToInt(this.remainingBytes);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.readFully(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.readFully(byArray, n2, n3);
        }

        private int readFully(byte[] byArray, int n2, int n3) throws IOException {
            if (n3 == 0) {
                return 0;
            }
            int n4 = 0;
            while (n3 > 0) {
                this.fillBuffer();
                if (this.remainingBytes <= 0L) break;
                int n5 = (int)Math.min((long)n3, this.remainingBytes);
                n5 = Math.min(n5, this.buffer.length - this.bufferPos);
                System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n5);
                this.bufferPos += n5;
                n4 += n5;
                this.remainingBytes -= (long)n5;
                n2 += n5;
                n3 -= n5;
            }
            return n4 == 0 ? -1 : n4;
        }

        private void fillBuffer() throws IOException {
            if (this.buffer != null && this.bufferPos < this.buffer.length) {
                return;
            }
            if (this.remainingBytes <= 0L) {
                return;
            }
            if (this.lobMapIndex >= this.lobMapBlocks.length) {
                System.out.println("halt!");
            }
            try {
                this.buffer = LobStorageBackend.this.readBlock(this.lobMapBlocks[this.lobMapIndex]);
                ++this.lobMapIndex;
                this.bufferPos = 0;
            }
            catch (SQLException sQLException) {
                throw DbException.convertToIOException(sQLException);
            }
        }
    }
}

