/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitInputStream
extends FilterInputStream {
    private long remaining;

    public LimitInputStream(InputStream inputStream, long l2) {
        super(inputStream);
        this.remaining = l2;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(this.remaining, (long)this.in.available());
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        int n2 = this.in.read();
        if (n2 >= 0) {
            --this.remaining;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        int n4 = this.in.read(byArray, n2, n3 = (int)Math.min((long)n3, this.remaining));
        if (n4 >= 0) {
            this.remaining -= (long)n4;
        }
        return n4;
    }
}

