/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.OutputStream;
import org.h2.store.Data;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.tools.CompressTool;

public class FileStoreOutputStream
extends OutputStream {
    private FileStore store;
    private final Data page;
    private final String compressionAlgorithm;
    private final CompressTool compress;
    private final byte[] buffer = new byte[]{0};

    public FileStoreOutputStream(FileStore fileStore, DataHandler dataHandler, String string) {
        this.store = fileStore;
        if (string != null) {
            this.compress = CompressTool.getInstance();
            this.compressionAlgorithm = string;
        } else {
            this.compress = null;
            this.compressionAlgorithm = null;
        }
        this.page = Data.create(dataHandler, 16);
    }

    @Override
    public void write(int n2) {
        this.buffer[0] = (byte)n2;
        this.write(this.buffer);
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n3 > 0) {
            this.page.reset();
            if (this.compress != null) {
                if (n2 != 0 || n3 != byArray.length) {
                    byte[] byArray2 = new byte[n3];
                    System.arraycopy(byArray, n2, byArray2, 0, n3);
                    byArray = byArray2;
                    n2 = 0;
                }
                int n4 = n3;
                byArray = this.compress.compress(byArray, this.compressionAlgorithm);
                n3 = byArray.length;
                this.page.checkCapacity(8 + n3);
                this.page.writeInt(n3);
                this.page.writeInt(n4);
                this.page.write(byArray, n2, n3);
            } else {
                this.page.checkCapacity(4 + n3);
                this.page.writeInt(n3);
                this.page.write(byArray, n2, n3);
            }
            this.page.fillAligned();
            this.store.write(this.page.getBytes(), 0, this.page.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.store != null) {
            try {
                this.store.close();
            }
            finally {
                this.store = null;
            }
        }
    }
}

