/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.h2.util.IOUtils;

public class DataReader
extends Reader {
    private final InputStream in;

    public DataReader(InputStream inputStream) {
        this.in = inputStream;
    }

    public byte readByte() throws IOException {
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new FastEOFException();
        }
        return (byte)n2;
    }

    public int readVarInt() throws IOException {
        byte by2 = this.readByte();
        if (by2 >= 0) {
            return by2;
        }
        int n2 = by2 & 0x7F;
        by2 = this.readByte();
        if (by2 >= 0) {
            return n2 | by2 << 7;
        }
        n2 |= (by2 & 0x7F) << 7;
        by2 = this.readByte();
        if (by2 >= 0) {
            return n2 | by2 << 14;
        }
        n2 |= (by2 & 0x7F) << 14;
        by2 = this.readByte();
        if (by2 >= 0) {
            return n2 | by2 << 21;
        }
        return n2 | (by2 & 0x7F) << 21 | this.readByte() << 28;
    }

    public long readVarLong() throws IOException {
        long l2 = this.readByte();
        if (l2 >= 0L) {
            return l2;
        }
        l2 &= 0x7FL;
        int n2 = 7;
        while (true) {
            long l3 = this.readByte();
            l2 |= (l3 & 0x7FL) << n2;
            if (l3 >= 0L) {
                return l2;
            }
            n2 += 7;
        }
    }

    public void readFully(byte[] byArray, int n2) throws IOException {
        int n3 = IOUtils.readFully(this.in, byArray, n2);
        if (n3 < n2) {
            throw new FastEOFException();
        }
    }

    public String readString() throws IOException {
        int n2 = this.readVarInt();
        return this.readString(n2);
    }

    private String readString(int n2) throws IOException {
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = this.readChar();
        }
        return new String(cArray);
    }

    private char readChar() throws IOException {
        int n2 = this.readByte() & 0xFF;
        if (n2 < 128) {
            return (char)n2;
        }
        if (n2 >= 224) {
            return (char)(((n2 & 0xF) << 12) + ((this.readByte() & 0x3F) << 6) + (this.readByte() & 0x3F));
        }
        return (char)(((n2 & 0x1F) << 6) + (this.readByte() & 0x3F));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 == 0) {
            return 0;
        }
        try {
            for (n4 = 0; n4 < n3; ++n4) {
                cArray[n4] = this.readChar();
            }
            return n3;
        }
        catch (EOFException eOFException) {
            if (n4 == 0) {
                return -1;
            }
            return n4;
        }
    }

    static class FastEOFException
    extends EOFException {
        private static final long serialVersionUID = 1L;

        FastEOFException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

