/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.store.DataHandler;
import org.h2.tools.SimpleResultSet;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLob;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueTimestampUtc;
import org.h2.value.ValueUuid;

public class Data {
    public static final int LENGTH_INT = 4;
    private static final int LENGTH_LONG = 8;
    private static final int INT_0_15 = 32;
    private static final int LONG_0_7 = 48;
    private static final int DECIMAL_0_1 = 56;
    private static final int DECIMAL_SMALL_0 = 58;
    private static final int DECIMAL_SMALL = 59;
    private static final int DOUBLE_0_1 = 60;
    private static final int FLOAT_0_1 = 62;
    private static final int BOOLEAN_FALSE = 64;
    private static final int BOOLEAN_TRUE = 65;
    private static final int INT_NEG = 66;
    private static final int LONG_NEG = 67;
    private static final int STRING_0_31 = 68;
    private static final int BYTES_0_31 = 100;
    private static final int LOCAL_TIME = 132;
    private static final int LOCAL_DATE = 133;
    private static final int LOCAL_TIMESTAMP = 134;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final boolean STORE_LOCAL_TIME = false;
    private byte[] data;
    private int pos;
    private final DataHandler handler;

    private Data(DataHandler dataHandler, byte[] byArray) {
        this.handler = dataHandler;
        this.data = byArray;
    }

    public void setInt(int n2, int n3) {
        byte[] byArray = this.data;
        byArray[n2] = (byte)(n3 >> 24);
        byArray[n2 + 1] = (byte)(n3 >> 16);
        byArray[n2 + 2] = (byte)(n3 >> 8);
        byArray[n2 + 3] = (byte)n3;
    }

    public void writeInt(int n2) {
        byte[] byArray = this.data;
        byArray[this.pos] = (byte)(n2 >> 24);
        byArray[this.pos + 1] = (byte)(n2 >> 16);
        byArray[this.pos + 2] = (byte)(n2 >> 8);
        byArray[this.pos + 3] = (byte)n2;
        this.pos += 4;
    }

    public int readInt() {
        byte[] byArray = this.data;
        int n2 = (byArray[this.pos] << 24) + ((byArray[this.pos + 1] & 0xFF) << 16) + ((byArray[this.pos + 2] & 0xFF) << 8) + (byArray[this.pos + 3] & 0xFF);
        this.pos += 4;
        return n2;
    }

    public static int getStringLen(String string) {
        int n2 = string.length();
        return Data.getStringWithoutLengthLen(string, n2) + Data.getVarIntLen(n2);
    }

    private static int getStringWithoutLengthLen(String string, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '\u0800') {
                n3 += 2;
                continue;
            }
            if (c2 < '\u0080') continue;
            ++n3;
        }
        return n2 + n3;
    }

    public String readString() {
        int n2 = this.readVarInt();
        return this.readString(n2);
    }

    private String readString(int n2) {
        byte[] byArray = this.data;
        int n3 = this.pos;
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            cArray[i2] = (n4 = byArray[n3++] & 0xFF) < 128 ? (char)n4 : (n4 >= 224 ? (char)(((n4 & 0xF) << 12) + ((byArray[n3++] & 0x3F) << 6) + (byArray[n3++] & 0x3F)) : (char)(((n4 & 0x1F) << 6) + (byArray[n3++] & 0x3F)));
        }
        this.pos = n3;
        return new String(cArray);
    }

    public void writeString(String string) {
        int n2 = string.length();
        this.writeVarInt(n2);
        this.writeStringWithoutLength(string, n2);
    }

    private void writeStringWithoutLength(String string, int n2) {
        int n3 = this.pos;
        byte[] byArray = this.data;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '\u0080') {
                byArray[n3++] = (byte)c2;
                continue;
            }
            if (c2 >= '\u0800') {
                byArray[n3++] = (byte)(0xE0 | c2 >> 12);
                byArray[n3++] = (byte)(c2 >> 6 & 0x3F);
                byArray[n3++] = (byte)(c2 & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xC0 | c2 >> 6);
            byArray[n3++] = (byte)(c2 & 0x3F);
        }
        this.pos = n3;
    }

    private void writeStringWithoutLength(char[] cArray, int n2) {
        int n3 = this.pos;
        byte[] byArray = this.data;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (c2 < '\u0080') {
                byArray[n3++] = (byte)c2;
                continue;
            }
            if (c2 >= '\u0800') {
                byArray[n3++] = (byte)(0xE0 | c2 >> 12);
                byArray[n3++] = (byte)(c2 >> 6 & 0x3F);
                byArray[n3++] = (byte)(c2 & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xC0 | c2 >> 6);
            byArray[n3++] = (byte)(c2 & 0x3F);
        }
        this.pos = n3;
    }

    public static Data create(DataHandler dataHandler, int n2) {
        return new Data(dataHandler, new byte[n2]);
    }

    public static Data create(DataHandler dataHandler, byte[] byArray) {
        return new Data(dataHandler, byArray);
    }

    public int length() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void reset() {
        this.pos = 0;
    }

    public void write(byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.data, this.pos, n3);
        this.pos += n3;
    }

    public void read(byte[] byArray, int n2, int n3) {
        System.arraycopy(this.data, this.pos, byArray, n2, n3);
        this.pos += n3;
    }

    public void writeByte(byte by2) {
        this.data[this.pos++] = by2;
    }

    public byte readByte() {
        return this.data[this.pos++];
    }

    public long readLong() {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public void writeLong(long l2) {
        this.writeInt((int)(l2 >>> 32));
        this.writeInt((int)l2);
    }

    public void writeValue(Value value) {
        int n2 = this.pos;
        if (value == ValueNull.INSTANCE) {
            this.data[this.pos++] = 0;
            return;
        }
        int n3 = value.getType();
        switch (n3) {
            case 1: {
                this.writeByte((byte)(value.getBoolean() != false ? 65 : 64));
                break;
            }
            case 2: {
                this.writeByte((byte)n3);
                this.writeByte(value.getByte());
                break;
            }
            case 3: {
                this.writeByte((byte)n3);
                this.writeShortInt(value.getShort());
                break;
            }
            case 4: {
                int n4 = value.getInt();
                if (n4 < 0) {
                    this.writeByte((byte)66);
                    this.writeVarInt(-n4);
                    break;
                }
                if (n4 < 16) {
                    this.writeByte((byte)(32 + n4));
                    break;
                }
                this.writeByte((byte)n3);
                this.writeVarInt(n4);
                break;
            }
            case 5: {
                long l2 = value.getLong();
                if (l2 < 0L) {
                    this.writeByte((byte)67);
                    this.writeVarLong(-l2);
                    break;
                }
                if (l2 < 8L) {
                    this.writeByte((byte)(48L + l2));
                    break;
                }
                this.writeByte((byte)n3);
                this.writeVarLong(l2);
                break;
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    this.writeByte((byte)56);
                    break;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    this.writeByte((byte)57);
                    break;
                }
                int n5 = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n6 = bigInteger.bitLength();
                if (n6 <= 63) {
                    if (n5 == 0) {
                        this.writeByte((byte)58);
                        this.writeVarLong(bigInteger.longValue());
                        break;
                    }
                    this.writeByte((byte)59);
                    this.writeVarInt(n5);
                    this.writeVarLong(bigInteger.longValue());
                    break;
                }
                this.writeByte((byte)n3);
                this.writeVarInt(n5);
                byte[] byArray = bigInteger.toByteArray();
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 9: {
                this.writeByte((byte)n3);
                this.writeVarLong(DateTimeUtils.getTimeLocalWithoutDst(value.getTime()));
                break;
            }
            case 10: {
                this.writeByte((byte)n3);
                long l3 = DateTimeUtils.getTimeLocalWithoutDst(value.getDate());
                this.writeVarLong(l3 / 60000L);
                break;
            }
            case 11: {
                Timestamp timestamp = value.getTimestamp();
                this.writeByte((byte)n3);
                this.writeVarLong(DateTimeUtils.getTimeLocalWithoutDst(timestamp));
                this.writeVarInt(timestamp.getNanos() % 1000000);
                break;
            }
            case 23: {
                ValueTimestampUtc valueTimestampUtc = (ValueTimestampUtc)value;
                this.writeByte((byte)n3);
                this.writeVarLong(valueTimestampUtc.getUtcDateTimeNanos());
                break;
            }
            case 24: {
                Object object = (ValueTimestampTimeZone)value;
                this.writeByte((byte)n3);
                this.writeVarLong(((ValueTimestampTimeZone)object).getDateValue());
                this.writeVarLong(((ValueTimestampTimeZone)object).getTimeNanos());
                this.writeVarInt(((ValueTimestampTimeZone)object).getTimeZoneOffsetMins());
            }
            case 19: 
            case 22: {
                this.writeByte((byte)n3);
                Object object = value.getBytesNoCopy();
                int n7 = ((Object)object).length;
                this.writeVarInt(n7);
                this.write((byte[])object, 0, n7);
                break;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n8 = byArray.length;
                if (n8 < 32) {
                    this.writeByte((byte)(100 + n8));
                    this.write(byArray, 0, n8);
                    break;
                }
                this.writeByte((byte)n3);
                this.writeVarInt(n8);
                this.write(byArray, 0, n8);
                break;
            }
            case 20: {
                this.writeByte((byte)n3);
                ValueUuid valueUuid = (ValueUuid)value;
                this.writeLong(valueUuid.getHigh());
                this.writeLong(valueUuid.getLow());
                break;
            }
            case 13: {
                String string = value.getString();
                int n9 = string.length();
                if (n9 < 32) {
                    this.writeByte((byte)(68 + n9));
                    this.writeStringWithoutLength(string, n9);
                    break;
                }
                this.writeByte((byte)n3);
                this.writeString(string);
                break;
            }
            case 14: 
            case 21: {
                this.writeByte((byte)n3);
                this.writeString(value.getString());
                break;
            }
            case 7: {
                double d2 = value.getDouble();
                if (d2 == 1.0) {
                    this.writeByte((byte)61);
                    break;
                }
                long l4 = Double.doubleToLongBits(d2);
                if (l4 == ValueDouble.ZERO_BITS) {
                    this.writeByte((byte)60);
                    break;
                }
                this.writeByte((byte)n3);
                this.writeVarLong(Long.reverse(l4));
                break;
            }
            case 8: {
                float f2 = value.getFloat();
                if (f2 == 1.0f) {
                    this.writeByte((byte)63);
                    break;
                }
                int n10 = Float.floatToIntBits(f2);
                if (n10 == ValueFloat.ZERO_BITS) {
                    this.writeByte((byte)62);
                    break;
                }
                this.writeByte((byte)n3);
                this.writeVarInt(Integer.reverse(n10));
                break;
            }
            case 15: 
            case 16: {
                this.writeByte((byte)n3);
                if (value instanceof ValueLob) {
                    ValueLob valueLob = (ValueLob)value;
                    valueLob.convertToFileIfRequired(this.handler);
                    byte[] byArray = valueLob.getSmall();
                    if (byArray == null) {
                        int n11 = -1;
                        if (!valueLob.isLinkedToTable()) {
                            n11 = -2;
                        }
                        this.writeVarInt(n11);
                        this.writeVarInt(valueLob.getTableId());
                        this.writeVarInt(valueLob.getObjectId());
                        this.writeVarLong(valueLob.getPrecision());
                        this.writeByte((byte)(valueLob.isCompressed() ? 1 : 0));
                        if (n11 != -2) break;
                        this.writeString(valueLob.getFileName());
                        break;
                    }
                    this.writeVarInt(byArray.length);
                    this.write(byArray, 0, byArray.length);
                    break;
                }
                ValueLobDb valueLobDb = (ValueLobDb)value;
                byte[] byArray = valueLobDb.getSmall();
                if (byArray == null) {
                    this.writeVarInt(-3);
                    this.writeVarInt(valueLobDb.getTableId());
                    this.writeVarLong(valueLobDb.getLobId());
                    this.writeVarLong(valueLobDb.getPrecision());
                    break;
                }
                this.writeVarInt(byArray.length);
                this.write(byArray, 0, byArray.length);
                break;
            }
            case 17: {
                this.writeByte((byte)n3);
                Value[] valueArray = ((ValueArray)value).getList();
                this.writeVarInt(valueArray.length);
                for (Value value2 : valueArray) {
                    this.writeValue(value2);
                }
                break;
            }
            case 18: {
                this.writeByte((byte)n3);
                try {
                    int n12;
                    ResultSet resultSet = ((ValueResultSet)value).getResultSet();
                    resultSet.beforeFirst();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n13 = resultSetMetaData.getColumnCount();
                    this.writeVarInt(n13);
                    for (n12 = 0; n12 < n13; ++n12) {
                        this.writeString(resultSetMetaData.getColumnName(n12 + 1));
                        this.writeVarInt(resultSetMetaData.getColumnType(n12 + 1));
                        this.writeVarInt(resultSetMetaData.getPrecision(n12 + 1));
                        this.writeVarInt(resultSetMetaData.getScale(n12 + 1));
                    }
                    while (resultSet.next()) {
                        this.writeByte((byte)1);
                        for (n12 = 0; n12 < n13; ++n12) {
                            int n14 = DataType.getValueTypeFromResultSet(resultSetMetaData, n12 + 1);
                            Value value3 = DataType.readValue(null, resultSet, n12 + 1, n14);
                            this.writeValue(value3);
                        }
                    }
                    this.writeByte((byte)0);
                    resultSet.beforeFirst();
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
            }
            default: {
                DbException.throwInternalError("type=" + value.getType());
            }
        }
        if (SysProperties.CHECK2 && this.pos - n2 != Data.getValueLen(value, this.handler)) {
            throw DbException.throwInternalError("value size error: got " + (this.pos - n2) + " expected " + Data.getValueLen(value, this.handler));
        }
    }

    public Value readValue() {
        int n2 = this.data[this.pos++] & 0xFF;
        switch (n2) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 65: {
                return ValueBoolean.get(true);
            }
            case 64: {
                return ValueBoolean.get(false);
            }
            case 66: {
                return ValueInt.get(-this.readVarInt());
            }
            case 4: {
                return ValueInt.get(this.readVarInt());
            }
            case 67: {
                return ValueLong.get(-this.readVarLong());
            }
            case 5: {
                return ValueLong.get(this.readVarLong());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 3: {
                return ValueShort.get(this.readShortInt());
            }
            case 56: {
                return (ValueDecimal)ValueDecimal.ZERO;
            }
            case 57: {
                return (ValueDecimal)ValueDecimal.ONE;
            }
            case 58: {
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong()));
            }
            case 59: {
                int n3 = this.readVarInt();
                return ValueDecimal.get(BigDecimal.valueOf(this.readVarLong(), n3));
            }
            case 6: {
                int n4 = this.readVarInt();
                int n5 = this.readVarInt();
                byte[] byArray = DataUtils.newBytes(n5);
                this.read(byArray, 0, n5);
                BigInteger bigInteger = new BigInteger(byArray);
                return ValueDecimal.get(new BigDecimal(bigInteger, n4));
            }
            case 133: {
                return ValueDate.fromDateValue(this.readVarLong());
            }
            case 10: {
                long l2 = this.readVarLong() * 60000L;
                return ValueDate.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(l2));
            }
            case 132: {
                long l3 = this.readVarLong() * 1000000L + this.readVarLong();
                return ValueTime.fromNanos(l3);
            }
            case 9: {
                return ValueTime.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(this.readVarLong()));
            }
            case 134: {
                long l4 = this.readVarLong();
                long l5 = this.readVarLong() * 1000000L + this.readVarLong();
                return ValueTimestamp.fromDateValueAndNanos(l4, l5);
            }
            case 11: {
                return ValueTimestamp.fromMillisNanos(DateTimeUtils.getTimeUTCWithoutDst(this.readVarLong()), this.readVarInt());
            }
            case 23: {
                return ValueTimestampUtc.fromNanos(this.readVarLong());
            }
            case 24: {
                long l6 = this.readVarLong();
                long l7 = this.readVarLong();
                short s2 = (short)this.readVarInt();
                return ValueTimestampTimeZone.fromDateValueAndNanos(l6, l7, s2);
            }
            case 12: {
                int n6 = this.readVarInt();
                byte[] byArray = DataUtils.newBytes(n6);
                this.read(byArray, 0, n6);
                return ValueBytes.getNoCopy(byArray);
            }
            case 22: {
                int n7 = this.readVarInt();
                byte[] byArray = DataUtils.newBytes(n7);
                this.read(byArray, 0, n7);
                return ValueGeometry.get(byArray);
            }
            case 19: {
                int n8 = this.readVarInt();
                byte[] byArray = DataUtils.newBytes(n8);
                this.read(byArray, 0, n8);
                return ValueJavaObject.getNoCopy(null, byArray, this.handler);
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 62: {
                return ValueFloat.get(0.0f);
            }
            case 63: {
                return ValueFloat.get(1.0f);
            }
            case 60: {
                return ValueDouble.get(0.0);
            }
            case 61: {
                return ValueDouble.get(1.0);
            }
            case 7: {
                return ValueDouble.get(Double.longBitsToDouble(Long.reverse(this.readVarLong())));
            }
            case 8: {
                return ValueFloat.get(Float.intBitsToFloat(Integer.reverse(this.readVarInt())));
            }
            case 15: 
            case 16: {
                int n9 = this.readVarInt();
                if (n9 >= 0) {
                    byte[] byArray = DataUtils.newBytes(n9);
                    this.read(byArray, 0, n9);
                    return ValueLobDb.createSmallLob(n2, byArray);
                }
                if (n9 == -3) {
                    int n10 = this.readVarInt();
                    long l8 = this.readVarLong();
                    long l9 = this.readVarLong();
                    ValueLobDb valueLobDb = ValueLobDb.create(n2, this.handler, n10, l8, null, l9);
                    return valueLobDb;
                }
                int n11 = this.readVarInt();
                int n12 = this.readVarInt();
                long l10 = 0L;
                boolean bl2 = false;
                if (n9 == -1 || n9 == -2) {
                    l10 = this.readVarLong();
                    boolean bl3 = bl2 = this.readByte() == 1;
                }
                if (n9 == -2) {
                    String string = this.readString();
                    return ValueLob.openUnlinked(n2, this.handler, n11, n12, l10, bl2, string);
                }
                return ValueLob.openLinked(n2, this.handler, n11, n12, l10, bl2);
            }
            case 17: {
                int n13 = this.readVarInt();
                Value[] valueArray = new Value[n13];
                for (int i2 = 0; i2 < n13; ++i2) {
                    valueArray[i2] = this.readValue();
                }
                return ValueArray.get(valueArray);
            }
            case 18: {
                SimpleResultSet simpleResultSet = new SimpleResultSet();
                simpleResultSet.setAutoClose(false);
                int n14 = this.readVarInt();
                for (int i3 = 0; i3 < n14; ++i3) {
                    simpleResultSet.addColumn(this.readString(), this.readVarInt(), this.readVarInt(), this.readVarInt());
                }
                while (this.readByte() != 0) {
                    Object[] objectArray = new Object[n14];
                    for (int i4 = 0; i4 < n14; ++i4) {
                        objectArray[i4] = this.readValue().getObject();
                    }
                    simpleResultSet.addRow(objectArray);
                }
                return ValueResultSet.get(simpleResultSet);
            }
        }
        if (n2 >= 32 && n2 < 48) {
            return ValueInt.get(n2 - 32);
        }
        if (n2 >= 48 && n2 < 56) {
            return ValueLong.get(n2 - 48);
        }
        if (n2 >= 100 && n2 < 132) {
            int n15 = n2 - 100;
            byte[] byArray = DataUtils.newBytes(n15);
            this.read(byArray, 0, n15);
            return ValueBytes.getNoCopy(byArray);
        }
        if (n2 >= 68 && n2 < 100) {
            return ValueString.get(this.readString(n2 - 68));
        }
        throw DbException.get(90030, "type: " + n2);
    }

    public int getValueLen(Value value) {
        return Data.getValueLen(value, this.handler);
    }

    public static int getValueLen(Value value, DataHandler dataHandler) {
        if (value == ValueNull.INSTANCE) {
            return 1;
        }
        switch (value.getType()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                int n2 = value.getInt();
                if (n2 < 0) {
                    return 1 + Data.getVarIntLen(-n2);
                }
                if (n2 < 16) {
                    return 1;
                }
                return 1 + Data.getVarIntLen(n2);
            }
            case 5: {
                long l2 = value.getLong();
                if (l2 < 0L) {
                    return 1 + Data.getVarLongLen(-l2);
                }
                if (l2 < 8L) {
                    return 1;
                }
                return 1 + Data.getVarLongLen(l2);
            }
            case 7: {
                double d2 = value.getDouble();
                if (d2 == 1.0) {
                    return 1;
                }
                long l3 = Double.doubleToLongBits(d2);
                if (l3 == ValueDouble.ZERO_BITS) {
                    return 1;
                }
                return 1 + Data.getVarLongLen(Long.reverse(l3));
            }
            case 8: {
                float f2 = value.getFloat();
                if (f2 == 1.0f) {
                    return 1;
                }
                int n3 = Float.floatToIntBits(f2);
                if (n3 == ValueFloat.ZERO_BITS) {
                    return 1;
                }
                return 1 + Data.getVarIntLen(Integer.reverse(n3));
            }
            case 13: {
                String string = value.getString();
                int n4 = string.length();
                if (n4 < 32) {
                    return 1 + Data.getStringWithoutLengthLen(string, n4);
                }
                return 1 + Data.getStringLen(string);
            }
            case 14: 
            case 21: {
                return 1 + Data.getStringLen(value.getString());
            }
            case 6: {
                BigDecimal bigDecimal = value.getBigDecimal();
                if (BigDecimal.ZERO.equals(bigDecimal)) {
                    return 1;
                }
                if (BigDecimal.ONE.equals(bigDecimal)) {
                    return 1;
                }
                int n5 = bigDecimal.scale();
                BigInteger bigInteger = bigDecimal.unscaledValue();
                int n6 = bigInteger.bitLength();
                if (n6 <= 63) {
                    if (n5 == 0) {
                        return 1 + Data.getVarLongLen(bigInteger.longValue());
                    }
                    return 1 + Data.getVarIntLen(n5) + Data.getVarLongLen(bigInteger.longValue());
                }
                byte[] byArray = bigInteger.toByteArray();
                return 1 + Data.getVarIntLen(n5) + Data.getVarIntLen(byArray.length) + byArray.length;
            }
            case 9: {
                return 1 + Data.getVarLongLen(DateTimeUtils.getTimeLocalWithoutDst(value.getTime()));
            }
            case 10: {
                long l4 = DateTimeUtils.getTimeLocalWithoutDst(value.getDate());
                return 1 + Data.getVarLongLen(l4 / 60000L);
            }
            case 11: {
                Timestamp timestamp = value.getTimestamp();
                return 1 + Data.getVarLongLen(DateTimeUtils.getTimeLocalWithoutDst(timestamp)) + Data.getVarIntLen(timestamp.getNanos() % 1000000);
            }
            case 23: {
                ValueTimestampUtc valueTimestampUtc = (ValueTimestampUtc)value;
                return 1 + Data.getVarLongLen(valueTimestampUtc.getUtcDateTimeNanos());
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                long l5 = valueTimestampTimeZone.getDateValue();
                long l6 = valueTimestampTimeZone.getTimeNanos();
                short s2 = valueTimestampTimeZone.getTimeZoneOffsetMins();
                return 1 + Data.getVarLongLen(l5) + Data.getVarLongLen(l6) + Data.getVarIntLen(s2);
            }
            case 19: 
            case 22: {
                byte[] byArray = value.getBytesNoCopy();
                return 1 + Data.getVarIntLen(byArray.length) + byArray.length;
            }
            case 12: {
                byte[] byArray = value.getBytesNoCopy();
                int n7 = byArray.length;
                if (n7 < 32) {
                    return 1 + byArray.length;
                }
                return 1 + Data.getVarIntLen(byArray.length) + byArray.length;
            }
            case 20: {
                return 17;
            }
            case 15: 
            case 16: {
                int n8 = 1;
                if (value instanceof ValueLob) {
                    ValueLob valueLob = (ValueLob)value;
                    valueLob.convertToFileIfRequired(dataHandler);
                    byte[] byArray = valueLob.getSmall();
                    if (byArray == null) {
                        int n9 = -1;
                        if (!valueLob.isLinkedToTable()) {
                            n9 = -2;
                        }
                        n8 += Data.getVarIntLen(n9);
                        n8 += Data.getVarIntLen(valueLob.getTableId());
                        n8 += Data.getVarIntLen(valueLob.getObjectId());
                        n8 += Data.getVarLongLen(valueLob.getPrecision());
                        ++n8;
                        if (n9 == -2) {
                            n8 += Data.getStringLen(valueLob.getFileName());
                        }
                    } else {
                        n8 += Data.getVarIntLen(byArray.length);
                        n8 += byArray.length;
                    }
                } else {
                    ValueLobDb valueLobDb = (ValueLobDb)value;
                    byte[] byArray = valueLobDb.getSmall();
                    if (byArray == null) {
                        n8 += Data.getVarIntLen(-3);
                        n8 += Data.getVarIntLen(valueLobDb.getTableId());
                        n8 += Data.getVarLongLen(valueLobDb.getLobId());
                        n8 += Data.getVarLongLen(valueLobDb.getPrecision());
                    } else {
                        n8 += Data.getVarIntLen(byArray.length);
                        n8 += byArray.length;
                    }
                }
                return n8;
            }
            case 17: {
                Value[] valueArray = ((ValueArray)value).getList();
                int n10 = 1 + Data.getVarIntLen(valueArray.length);
                for (Value value2 : valueArray) {
                    n10 += Data.getValueLen(value2, dataHandler);
                }
                return n10;
            }
            case 18: {
                int n11 = 1;
                try {
                    int n12;
                    ResultSet resultSet = ((ValueResultSet)value).getResultSet();
                    resultSet.beforeFirst();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n13 = resultSetMetaData.getColumnCount();
                    n11 += Data.getVarIntLen(n13);
                    for (n12 = 0; n12 < n13; ++n12) {
                        n11 += Data.getStringLen(resultSetMetaData.getColumnName(n12 + 1));
                        n11 += Data.getVarIntLen(resultSetMetaData.getColumnType(n12 + 1));
                        n11 += Data.getVarIntLen(resultSetMetaData.getPrecision(n12 + 1));
                        n11 += Data.getVarIntLen(resultSetMetaData.getScale(n12 + 1));
                    }
                    while (resultSet.next()) {
                        ++n11;
                        for (n12 = 0; n12 < n13; ++n12) {
                            int n14 = DataType.getValueTypeFromResultSet(resultSetMetaData, n12 + 1);
                            Value value3 = DataType.readValue(null, resultSet, n12 + 1, n14);
                            n11 += Data.getValueLen(value3, dataHandler);
                        }
                    }
                    resultSet.beforeFirst();
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
                return ++n11;
            }
        }
        throw DbException.throwInternalError("type=" + value.getType());
    }

    public void setPos(int n2) {
        this.pos = n2;
    }

    public void writeShortInt(int n2) {
        byte[] byArray = this.data;
        byArray[this.pos++] = (byte)(n2 >> 8);
        byArray[this.pos++] = (byte)n2;
    }

    public short readShortInt() {
        byte[] byArray = this.data;
        return (short)(((byArray[this.pos++] & 0xFF) << 8) + (byArray[this.pos++] & 0xFF));
    }

    public void truncate(int n2) {
        if (this.pos > n2) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.data, 0, byArray, 0, n2);
            this.pos = n2;
            this.data = byArray;
        }
    }

    private static int getVarIntLen(int n2) {
        if ((n2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void writeVarInt(int n2) {
        while ((n2 & 0xFFFFFF80) != 0) {
            this.data[this.pos++] = (byte)(0x80 | n2 & 0x7F);
            n2 >>>= 7;
        }
        this.data[this.pos++] = (byte)n2;
    }

    public int readVarInt() {
        byte by2 = this.data[this.pos];
        if (by2 >= 0) {
            ++this.pos;
            return by2;
        }
        return this.readVarIntRest(by2);
    }

    private int readVarIntRest(int n2) {
        int n3 = n2 & 0x7F;
        n2 = this.data[this.pos + 1];
        if (n2 >= 0) {
            this.pos += 2;
            return n3 | n2 << 7;
        }
        n3 |= (n2 & 0x7F) << 7;
        n2 = this.data[this.pos + 2];
        if (n2 >= 0) {
            this.pos += 3;
            return n3 | n2 << 14;
        }
        n3 |= (n2 & 0x7F) << 14;
        n2 = this.data[this.pos + 3];
        if (n2 >= 0) {
            this.pos += 4;
            return n3 | n2 << 21;
        }
        this.pos += 5;
        return n3 |= (n2 & 0x7F) << 21 | this.data[this.pos + 4] << 28;
    }

    public static int getVarLongLen(long l2) {
        int n2 = 1;
        while ((l2 >>>= 7) != 0L) {
            ++n2;
        }
        return n2;
    }

    public void writeVarLong(long l2) {
        while ((l2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.data[this.pos++] = (byte)(l2 & 0x7FL | 0x80L);
            l2 >>>= 7;
        }
        this.data[this.pos++] = (byte)l2;
    }

    public long readVarLong() {
        long l2;
        if ((l2 = (long)this.data[this.pos++]) >= 0L) {
            return l2;
        }
        l2 &= 0x7FL;
        int n2 = 7;
        while (true) {
            long l3 = this.data[this.pos++];
            l2 |= (l3 & 0x7FL) << n2;
            if (l3 >= 0L) {
                return l2;
            }
            n2 += 7;
        }
    }

    public void checkCapacity(int n2) {
        if (this.pos + n2 >= this.data.length) {
            this.expand(n2);
        }
    }

    private void expand(int n2) {
        byte[] byArray = DataUtils.newBytes((this.data.length + n2) * 2);
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        this.data = byArray;
    }

    public void fillAligned() {
        int n2;
        this.pos = n2 = MathUtils.roundUpInt(this.pos + 2, 16);
        if (this.data.length < n2) {
            this.checkCapacity(n2 - this.data.length);
        }
    }

    public static void copyString(Reader reader, OutputStream outputStream) throws IOException {
        int n2;
        char[] cArray = new char[4096];
        Data data = new Data(null, new byte[12288]);
        while ((n2 = reader.read(cArray)) >= 0) {
            data.writeStringWithoutLength(cArray, n2);
            outputStream.write(data.data, 0, data.pos);
            data.reset();
        }
    }

    public DataHandler getHandler() {
        return this.handler;
    }
}

