/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.h2.engine.Constants;

public class CountingReaderInputStream
extends InputStream {
    private final Reader reader;
    private final CharBuffer charBuffer = CharBuffer.allocate(4096);
    private final CharsetEncoder encoder = Constants.UTF8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    private ByteBuffer byteBuffer = ByteBuffer.allocate(0);
    private long length;
    private long remaining;

    CountingReaderInputStream(Reader reader, long l2) {
        this.reader = reader;
        this.remaining = l2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (!this.fetch()) {
            return -1;
        }
        n3 = Math.min(n3, this.byteBuffer.remaining());
        this.byteBuffer.get(byArray, n2, n3);
        return n3;
    }

    @Override
    public int read() throws IOException {
        if (!this.fetch()) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    private boolean fetch() throws IOException {
        if (this.byteBuffer != null && this.byteBuffer.remaining() == 0) {
            this.fillBuffer();
        }
        return this.byteBuffer != null;
    }

    private void fillBuffer() throws IOException {
        int n2 = (int)Math.min((long)(this.charBuffer.capacity() - this.charBuffer.position()), this.remaining);
        if (n2 > 0) {
            n2 = this.reader.read(this.charBuffer.array(), this.charBuffer.position(), n2);
        }
        if (n2 > 0) {
            this.remaining -= (long)n2;
        } else {
            n2 = 0;
            this.remaining = 0L;
        }
        this.length += (long)n2;
        this.charBuffer.limit(this.charBuffer.position() + n2);
        this.charBuffer.rewind();
        this.byteBuffer = ByteBuffer.allocate(4096);
        boolean bl2 = this.remaining == 0L;
        this.encoder.encode(this.charBuffer, this.byteBuffer, bl2);
        if (bl2 && this.byteBuffer.position() == 0) {
            this.byteBuffer = null;
            return;
        }
        this.byteBuffer.flip();
        this.charBuffer.compact();
        this.charBuffer.flip();
        this.charBuffer.position(this.charBuffer.limit());
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

