/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.h2.Driver;
import org.h2.engine.Constants;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.server.Service;
import org.h2.server.ShutdownHandler;
import org.h2.server.web.ConnectionInfo;
import org.h2.server.web.WebSession;
import org.h2.server.web.WebThread;
import org.h2.store.fs.FileUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.New;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.util.Tool;
import org.h2.util.Utils;

public class WebServer
implements Service {
    static final String[][] LANGUAGES = new String[][]{{"cs", "\u010ce\u0161tina"}, {"de", "Deutsch"}, {"en", "English"}, {"es", "Espa\u00f1ol"}, {"fr", "Fran\u00e7ais"}, {"hu", "Magyar"}, {"ko", "\ud55c\uad6d\uc5b4"}, {"in", "Indonesia"}, {"it", "Italiano"}, {"ja", "\u65e5\u672c\u8a9e"}, {"nl", "Nederlands"}, {"pl", "Polski"}, {"pt_BR", "Portugu\u00eas (Brasil)"}, {"pt_PT", "Portugu\u00eas (Europeu)"}, {"ru", "\u0440\u0443\u0441\u0441\u043a\u0438\u0439"}, {"sk", "Slovensky"}, {"tr", "T\u00fcrk\u00e7e"}, {"uk", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"}, {"zh_CN", "\u4e2d\u6587 (\u7b80\u4f53)"}, {"zh_TW", "\u4e2d\u6587 (\u7e41\u9ad4)"}};
    private static final String COMMAND_HISTORY = "commandHistory";
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String[] GENERIC = new String[]{"Generic JNDI Data Source|javax.naming.InitialContext|java:comp/env/jdbc/Test|sa", "Generic Firebird Server|org.firebirdsql.jdbc.FBDriver|jdbc:firebirdsql:localhost:c:/temp/firebird/test|sysdba", "Generic SQLite|org.sqlite.JDBC|jdbc:sqlite:test|sa", "Generic DB2|com.ibm.db2.jcc.DB2Driver|jdbc:db2://localhost/test|", "Generic Oracle|oracle.jdbc.driver.OracleDriver|jdbc:oracle:thin:@localhost:1521:XE|sa", "Generic MS SQL Server 2000|com.microsoft.jdbc.sqlserver.SQLServerDriver|jdbc:microsoft:sqlserver://localhost:1433;DatabaseName=sqlexpress|sa", "Generic MS SQL Server 2005|com.microsoft.sqlserver.jdbc.SQLServerDriver|jdbc:sqlserver://localhost;DatabaseName=test|sa", "Generic PostgreSQL|org.postgresql.Driver|jdbc:postgresql:test|", "Generic MySQL|com.mysql.jdbc.Driver|jdbc:mysql://localhost:3306/test|", "Generic HSQLDB|org.hsqldb.jdbcDriver|jdbc:hsqldb:test;hsqldb.default_table_type=cached|sa", "Generic Derby (Server)|org.apache.derby.jdbc.ClientDriver|jdbc:derby://localhost:1527/test;create=true|sa", "Generic Derby (Embedded)|org.apache.derby.jdbc.EmbeddedDriver|jdbc:derby:test;create=true|sa", "Generic H2 (Server)|org.h2.Driver|jdbc:h2:tcp://localhost/~/test|sa", "Generic H2 (Embedded)|org.h2.Driver|jdbc:h2:~/test|sa"};
    private static int ticker;
    private static final long SESSION_TIMEOUT;
    private int port;
    private boolean allowOthers;
    private boolean isDaemon;
    private final Set<WebThread> running = Collections.synchronizedSet(new HashSet());
    private boolean ssl;
    private final HashMap<String, ConnectionInfo> connInfoMap = New.hashMap();
    private long lastTimeoutCheck;
    private final HashMap<String, WebSession> sessions = New.hashMap();
    private final HashSet<String> languages = New.hashSet();
    private String startDateTime;
    private ServerSocket serverSocket;
    private String url;
    private ShutdownHandler shutdownHandler;
    private Thread listenerThread;
    private boolean ifExists;
    private boolean trace;
    private TranslateThread translateThread;
    private boolean allowChunked = true;
    private String serverPropertiesDir = "~";
    private String commandHistoryString;

    byte[] getFile(String string) throws IOException {
        this.trace("getFile <" + string + ">");
        byte[] byArray = Utils.getResource("/org/h2/server/web/res/" + string);
        if (byArray == null) {
            this.trace(" null");
        } else {
            this.trace(" size=" + byArray.length);
        }
        return byArray;
    }

    static boolean isSimpleName(String string) {
        for (char c2 : string.toCharArray()) {
            if (c2 == '.' || c2 == '_' || c2 == '-' || Character.isLetterOrDigit(c2)) continue;
            return false;
        }
        return true;
    }

    synchronized void remove(WebThread webThread) {
        this.running.remove(webThread);
    }

    private static String generateSessionId() {
        byte[] byArray = MathUtils.secureRandomBytes(16);
        return StringUtils.convertBytesToHex(byArray);
    }

    WebSession getSession(String string) {
        Object object;
        long l2 = System.currentTimeMillis();
        if (this.lastTimeoutCheck + SESSION_TIMEOUT < l2) {
            object = New.arrayList(this.sessions.keySet()).iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                WebSession webSession = this.sessions.get(string2);
                if (webSession.lastAccess + SESSION_TIMEOUT >= l2) continue;
                this.trace("timeout for " + string2);
                this.sessions.remove(string2);
            }
            this.lastTimeoutCheck = l2;
        }
        if ((object = this.sessions.get(string)) != null) {
            ((WebSession)object).lastAccess = System.currentTimeMillis();
        }
        return object;
    }

    WebSession createNewSession(String string) {
        String string2;
        while (this.sessions.get(string2 = WebServer.generateSessionId()) != null) {
        }
        WebSession webSession = new WebSession(this);
        webSession.lastAccess = System.currentTimeMillis();
        webSession.put("sessionId", string2);
        webSession.put("ip", string);
        webSession.put("language", DEFAULT_LANGUAGE);
        webSession.put("frame-border", "0");
        webSession.put("frameset-border", "4");
        this.sessions.put(string2, webSession);
        this.readTranslations(webSession, DEFAULT_LANGUAGE);
        return this.getSession(string2);
    }

    String getStartDateTime() {
        if (this.startDateTime == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", new Locale(DEFAULT_LANGUAGE, ""));
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.startDateTime = simpleDateFormat.format(System.currentTimeMillis());
        }
        return this.startDateTime;
    }

    @Override
    public void init(String ... stringArray) {
        for (int i2 = 0; stringArray != null && i2 < stringArray.length; ++i2) {
            if (!"-properties".equals(stringArray[i2])) continue;
            this.serverPropertiesDir = stringArray[++i2];
        }
        Properties properties = this.loadProperties();
        this.port = SortedProperties.getIntProperty(properties, "webPort", 8082);
        this.ssl = SortedProperties.getBooleanProperty(properties, "webSSL", false);
        this.allowOthers = SortedProperties.getBooleanProperty(properties, "webAllowOthers", false);
        this.commandHistoryString = properties.getProperty(COMMAND_HISTORY);
        for (int i3 = 0; stringArray != null && i3 < stringArray.length; ++i3) {
            String string = stringArray[i3];
            if (Tool.isOption(string, "-webPort")) {
                this.port = Integer.decode(stringArray[++i3]);
                continue;
            }
            if (Tool.isOption(string, "-webSSL")) {
                this.ssl = true;
                continue;
            }
            if (Tool.isOption(string, "-webAllowOthers")) {
                this.allowOthers = true;
                continue;
            }
            if (Tool.isOption(string, "-webDaemon")) {
                this.isDaemon = true;
                continue;
            }
            if (Tool.isOption(string, "-baseDir")) {
                String string2 = stringArray[++i3];
                SysProperties.setBaseDir(string2);
                continue;
            }
            if (Tool.isOption(string, "-ifExists")) {
                this.ifExists = true;
                continue;
            }
            if (Tool.isOption(string, "-properties")) {
                ++i3;
                continue;
            }
            if (!Tool.isOption(string, "-trace")) continue;
            this.trace = true;
        }
        for (String[] stringArray2 : LANGUAGES) {
            this.languages.add(stringArray2[0]);
        }
        this.updateURL();
    }

    @Override
    public String getURL() {
        this.updateURL();
        return this.url;
    }

    private void updateURL() {
        try {
            this.url = (this.ssl ? "https" : "http") + "://" + NetUtils.getLocalAddress() + ":" + this.port;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public void start() {
        this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
        this.port = this.serverSocket.getLocalPort();
        this.updateURL();
    }

    @Override
    public void listen() {
        this.listenerThread = Thread.currentThread();
        try {
            while (this.serverSocket != null) {
                Socket socket = this.serverSocket.accept();
                WebThread webThread = new WebThread(socket, this);
                this.running.add(webThread);
                webThread.start();
            }
        }
        catch (Exception exception) {
            this.trace(exception.toString());
        }
    }

    @Override
    public boolean isRunning(boolean bl2) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket socket = NetUtils.createLoopbackSocket(this.port, this.ssl);
            socket.close();
            return true;
        }
        catch (Exception exception) {
            if (bl2) {
                this.traceError(exception);
            }
            return false;
        }
    }

    public boolean isStopped() {
        return this.serverSocket == null;
    }

    @Override
    public void stop() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                this.traceError(iOException);
            }
            this.serverSocket = null;
        }
        if (this.listenerThread != null) {
            try {
                this.listenerThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                DbException.traceThrowable(interruptedException);
            }
        }
        for (WebSession object : New.arrayList(this.sessions.values())) {
            object.close();
        }
        for (WebThread webThread : New.arrayList(this.running)) {
            try {
                webThread.stopNow();
                webThread.join(100);
            }
            catch (Exception exception) {
                this.traceError(exception);
            }
        }
    }

    void trace(String string) {
        if (this.trace) {
            System.out.println(string);
        }
    }

    void traceError(Throwable throwable) {
        if (this.trace) {
            throwable.printStackTrace();
        }
    }

    boolean supportsLanguage(String string) {
        return this.languages.contains(string);
    }

    void readTranslations(WebSession webSession, String string) {
        Properties properties = new Properties();
        try {
            this.trace("translation: " + string);
            byte[] byArray = this.getFile("_text_" + string + ".prop");
            this.trace("  " + new String(byArray));
            properties = SortedProperties.fromLines(new String(byArray, Constants.UTF8));
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String string2 = (String)entry.getValue();
                if (!string2.startsWith("#")) continue;
                entry.setValue(string2.substring(1));
            }
        }
        catch (IOException iOException) {
            DbException.traceThrowable(iOException);
        }
        webSession.put("text", new HashMap<Object, Object>(properties));
    }

    ArrayList<HashMap<String, Object>> getSessions() {
        ArrayList<HashMap<String, Object>> arrayList = New.arrayList();
        for (WebSession webSession : this.sessions.values()) {
            arrayList.add(webSession.getInfo());
        }
        return arrayList;
    }

    @Override
    public String getType() {
        return "Web Console";
    }

    @Override
    public String getName() {
        return "H2 Console Server";
    }

    void setAllowOthers(boolean bl2) {
        this.allowOthers = bl2;
    }

    @Override
    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    void setSSL(boolean bl2) {
        this.ssl = bl2;
    }

    void setPort(int n2) {
        this.port = n2;
    }

    boolean getSSL() {
        return this.ssl;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public boolean isCommandHistoryAllowed() {
        return this.commandHistoryString != null;
    }

    public void setCommandHistoryAllowed(boolean bl2) {
        if (bl2) {
            if (this.commandHistoryString == null) {
                this.commandHistoryString = "";
            }
        } else {
            this.commandHistoryString = null;
        }
    }

    public ArrayList<String> getCommandHistoryList() {
        ArrayList<String> arrayList = New.arrayList();
        if (this.commandHistoryString == null) {
            return arrayList;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (true) {
            if (n2 == this.commandHistoryString.length() || this.commandHistoryString.charAt(n2) == ';') {
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.delete(0, stringBuilder.length());
                }
                if (n2 == this.commandHistoryString.length()) {
                    break;
                }
            } else if (this.commandHistoryString.charAt(n2) == '\\' && n2 < this.commandHistoryString.length() - 1) {
                stringBuilder.append(this.commandHistoryString.charAt(++n2));
            } else {
                stringBuilder.append(this.commandHistoryString.charAt(n2));
            }
            ++n2;
        }
        return arrayList;
    }

    public void saveCommandHistoryList(ArrayList<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(string.replace("\\", "\\\\").replace(";", "\\;"));
        }
        this.commandHistoryString = stringBuilder.toString();
        this.saveProperties(null);
    }

    ConnectionInfo getSetting(String string) {
        return this.connInfoMap.get(string);
    }

    void updateSetting(ConnectionInfo connectionInfo) {
        this.connInfoMap.put(connectionInfo.name, connectionInfo);
        connectionInfo.lastAccess = ticker++;
    }

    void removeSetting(String string) {
        this.connInfoMap.remove(string);
    }

    private Properties loadProperties() {
        try {
            if ("null".equals(this.serverPropertiesDir)) {
                return new Properties();
            }
            return SortedProperties.loadProperties(this.serverPropertiesDir + "/" + ".h2.server.properties");
        }
        catch (Exception exception) {
            DbException.traceThrowable(exception);
            return new Properties();
        }
    }

    String[] getSettingNames() {
        ArrayList<ConnectionInfo> arrayList = this.getSettings();
        String[] stringArray = new String[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            stringArray[i2] = arrayList.get((int)i2).name;
        }
        return stringArray;
    }

    synchronized ArrayList<ConnectionInfo> getSettings() {
        ArrayList<ConnectionInfo> arrayList = New.arrayList();
        if (this.connInfoMap.size() == 0) {
            Properties properties = this.loadProperties();
            if (properties.size() == 0) {
                for (String string : GENERIC) {
                    ConnectionInfo connectionInfo = new ConnectionInfo(string);
                    arrayList.add(connectionInfo);
                    this.updateSetting(connectionInfo);
                }
            } else {
                String string;
                int n2 = 0;
                while ((string = properties.getProperty(String.valueOf(n2))) != null) {
                    ConnectionInfo connectionInfo = new ConnectionInfo(string);
                    arrayList.add(connectionInfo);
                    this.updateSetting(connectionInfo);
                    ++n2;
                }
            }
        } else {
            arrayList.addAll(this.connInfoMap.values());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    synchronized void saveProperties(Properties properties) {
        try {
            Cloneable cloneable;
            if (properties == null) {
                cloneable = this.loadProperties();
                properties = new SortedProperties();
                properties.setProperty("webPort", "" + SortedProperties.getIntProperty((Properties)cloneable, "webPort", this.port));
                properties.setProperty("webAllowOthers", "" + SortedProperties.getBooleanProperty((Properties)cloneable, "webAllowOthers", this.allowOthers));
                properties.setProperty("webSSL", "" + SortedProperties.getBooleanProperty((Properties)cloneable, "webSSL", this.ssl));
                if (this.commandHistoryString != null) {
                    properties.setProperty(COMMAND_HISTORY, this.commandHistoryString);
                }
            }
            cloneable = this.getSettings();
            int n2 = ((ArrayList)cloneable).size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ConnectionInfo connectionInfo = (ConnectionInfo)((ArrayList)cloneable).get(i2);
                if (connectionInfo == null) continue;
                properties.setProperty(String.valueOf(n2 - i2 - 1), connectionInfo.getString());
            }
            if (!"null".equals(this.serverPropertiesDir)) {
                OutputStream outputStream = FileUtils.newOutputStream(this.serverPropertiesDir + "/" + ".h2.server.properties", false);
                properties.store(outputStream, "H2 Server Properties");
                outputStream.close();
            }
        }
        catch (Exception exception) {
            DbException.traceThrowable(exception);
        }
    }

    Connection getConnection(String string, String string2, String string3, String string4) throws SQLException {
        string = string.trim();
        string2 = string2.trim();
        Driver.load();
        Properties properties = new Properties();
        properties.setProperty("user", string3.trim());
        properties.setProperty("password", string4);
        if (string2.startsWith("jdbc:h2:")) {
            if (this.ifExists) {
                string2 = string2 + ";IFEXISTS=TRUE";
            }
            return Driver.load().connect(string2, properties);
        }
        return JdbcUtils.getConnection(string, string2, properties);
    }

    void shutdown() {
        if (this.shutdownHandler != null) {
            this.shutdownHandler.shutdown();
        }
    }

    public void setShutdownHandler(ShutdownHandler shutdownHandler) {
        this.shutdownHandler = shutdownHandler;
    }

    public String addSession(Connection connection) throws SQLException {
        WebSession webSession = this.createNewSession("local");
        webSession.setShutdownServerOnDisconnect();
        webSession.setConnection(connection);
        webSession.put("url", connection.getMetaData().getURL());
        String string = (String)webSession.get("sessionId");
        return this.url + "/frame.jsp?jsessionid=" + string;
    }

    String startTranslate(Map<Object, Object> map) {
        if (this.translateThread != null) {
            this.translateThread.stopNow();
        }
        this.translateThread = new TranslateThread(map);
        this.translateThread.setDaemon(true);
        this.translateThread.start();
        return this.translateThread.getFileName();
    }

    @Override
    public boolean isDaemon() {
        return this.isDaemon;
    }

    void setAllowChunked(boolean bl2) {
        this.allowChunked = bl2;
    }

    boolean getAllowChunked() {
        return this.allowChunked;
    }

    static {
        SESSION_TIMEOUT = SysProperties.CONSOLE_TIMEOUT;
    }

    private class TranslateThread
    extends Thread {
        private final File file = new File("translation.properties");
        private final Map<Object, Object> translation;
        private volatile boolean stopNow;

        TranslateThread(Map<Object, Object> map) {
            this.translation = map;
        }

        public String getFileName() {
            return this.file.getAbsolutePath();
        }

        public void stopNow() {
            this.stopNow = true;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            while (!this.stopNow) {
                try {
                    Closeable closeable;
                    SortedProperties sortedProperties = new SortedProperties();
                    if (this.file.exists()) {
                        closeable = FileUtils.newInputStream(this.file.getName());
                        sortedProperties.load((InputStream)closeable);
                        this.translation.putAll(sortedProperties);
                    } else {
                        closeable = FileUtils.newOutputStream(this.file.getName(), false);
                        sortedProperties.putAll(this.translation);
                        sortedProperties.store((OutputStream)closeable, "Translation");
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    WebServer.this.traceError(exception);
                }
            }
        }
    }
}

