/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.h2.util.New;

public class PageParser {
    private static final int TAB_WIDTH = 4;
    private final String page;
    private int pos;
    private final Map<String, Object> settings;
    private final int len;
    private StringBuilder result;

    private PageParser(String string, Map<String, Object> map, int n2) {
        this.page = string;
        this.pos = n2;
        this.len = string.length();
        this.settings = map;
        this.result = new StringBuilder(this.len);
    }

    public static String parse(String string, Map<String, Object> map) {
        PageParser pageParser = new PageParser(string, map, 0);
        return pageParser.replaceTags();
    }

    private void setError(int n2) {
        String string = this.page.substring(0, n2) + "####BUG####" + this.page.substring(n2);
        string = PageParser.escapeHtml(string);
        this.result = new StringBuilder();
        this.result.append(string);
    }

    private String parseBlockUntil(String string) throws ParseException {
        PageParser pageParser = new PageParser(this.page, this.settings, this.pos);
        pageParser.parseAll();
        if (!pageParser.readIf(string)) {
            throw new ParseException(this.page, pageParser.pos);
        }
        this.pos = pageParser.pos;
        return pageParser.result.toString();
    }

    private String replaceTags() {
        try {
            this.parseAll();
            if (this.pos != this.len) {
                this.setError(this.pos);
            }
        }
        catch (ParseException parseException) {
            this.setError(this.pos);
        }
        return this.result.toString();
    }

    private void parseAll() throws ParseException {
        int n2;
        StringBuilder stringBuilder = this.result;
        String string = this.page;
        block4: for (n2 = this.pos; n2 < this.len; ++n2) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '<': {
                    String string2;
                    if (string.charAt(n2 + 3) == ':' && string.charAt(n2 + 1) == '/') {
                        this.pos = n2;
                        return;
                    }
                    if (string.charAt(n2 + 2) == ':') {
                        Object object;
                        Object object2;
                        String string3;
                        this.pos = n2;
                        if (this.readIf("<c:forEach")) {
                            string3 = this.readParam("var");
                            string2 = this.readParam("items");
                            this.read(">");
                            int n3 = this.pos;
                            object2 = (ArrayList)this.get(string2);
                            if (object2 == null) {
                                this.result.append("?items?");
                                object2 = New.arrayList();
                            }
                            if (object2.size() == 0) {
                                this.parseBlockUntil("</c:forEach>");
                            }
                            object = object2.iterator();
                            while (object.hasNext()) {
                                Object e2 = object.next();
                                this.settings.put(string3, e2);
                                this.pos = n3;
                                String string4 = this.parseBlockUntil("</c:forEach>");
                                this.result.append(string4);
                            }
                        } else if (this.readIf("<c:if")) {
                            string3 = this.readParam("test");
                            int n4 = string3.indexOf("=='");
                            if (n4 < 0) {
                                this.setError(n2);
                                return;
                            }
                            String string5 = string3.substring(n4 + 3, string3.length() - 1);
                            string3 = string3.substring(0, n4);
                            object2 = (String)this.get(string3);
                            this.read(">");
                            object = this.parseBlockUntil("</c:if>");
                            --this.pos;
                            if (((String)object2).equals(string5)) {
                                this.result.append((String)object);
                            }
                        } else {
                            this.setError(n2);
                            return;
                        }
                        n2 = this.pos;
                        continue block4;
                    }
                    stringBuilder.append(c2);
                    continue block4;
                }
                case '$': {
                    String string2;
                    if (string.length() > n2 + 1 && string.charAt(n2 + 1) == '{') {
                        int n5 = string.indexOf(125, n2 += 2);
                        if (n5 < 0) {
                            this.setError(n2);
                            return;
                        }
                        string2 = string.substring(n2, n5).trim();
                        n2 = n5;
                        String string6 = (String)this.get(string2);
                        this.replaceTags(string6);
                        continue block4;
                    }
                    stringBuilder.append(c2);
                    continue block4;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        this.pos = n2;
    }

    private Object get(String string) {
        int n2 = string.indexOf(46);
        if (n2 >= 0) {
            String string2 = string.substring(n2 + 1);
            HashMap hashMap = (HashMap)this.settings.get(string = string.substring(0, n2));
            if (hashMap == null) {
                return "?" + string + "?";
            }
            return hashMap.get(string2);
        }
        return this.settings.get(string);
    }

    private void replaceTags(String string) {
        if (string != null) {
            this.result.append(PageParser.parse(string, this.settings));
        }
    }

    private String readParam(String string) throws ParseException {
        this.read(string);
        this.read("=");
        this.read("\"");
        int n2 = this.pos;
        while (this.page.charAt(this.pos) != '\"') {
            ++this.pos;
        }
        int n3 = this.pos;
        this.read("\"");
        String string2 = this.page.substring(n2, n3);
        return PageParser.parse(string2, this.settings);
    }

    private void skipSpaces() {
        while (this.page.charAt(this.pos) == ' ') {
            ++this.pos;
        }
    }

    private void read(String string) throws ParseException {
        if (!this.readIf(string)) {
            throw new ParseException(string, this.pos);
        }
    }

    private boolean readIf(String string) {
        this.skipSpaces();
        if (this.page.regionMatches(this.pos, string, 0, string.length())) {
            this.pos += string.length();
            this.skipSpaces();
            return true;
        }
        return false;
    }

    static String escapeHtmlData(String string) {
        return PageParser.escapeHtml(string, false);
    }

    public static String escapeHtml(String string) {
        return PageParser.escapeHtml(string, true);
    }

    private static String escapeHtml(String string, boolean bl2) {
        if (string == null) {
            return null;
        }
        if (bl2 && string.length() == 0) {
            return "&nbsp;";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl3 = true;
        block9: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ' ' || c2 == '\t') {
                for (int i3 = 0; i3 < (c2 == ' ' ? 1 : 4); ++i3) {
                    if (bl3 && bl2) {
                        stringBuilder.append("&nbsp;");
                        continue;
                    }
                    stringBuilder.append(' ');
                    bl3 = true;
                }
                continue;
            }
            bl3 = false;
            switch (c2) {
                case '$': {
                    stringBuilder.append("&#36;");
                    continue block9;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    stringBuilder.append("&#39;");
                    continue block9;
                }
                case '\n': {
                    if (bl2) {
                        stringBuilder.append("<br />");
                        bl3 = true;
                        continue block9;
                    }
                    stringBuilder.append(c2);
                    continue block9;
                }
                default: {
                    if (c2 >= '\u0080') {
                        stringBuilder.append("&#").append((int)c2).append(';');
                        continue block9;
                    }
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    static String escapeJavaScript(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block8: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block8;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block8;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }
}

