/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Engine;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.expression.ParameterRemote;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.DbException;
import org.h2.result.ResultColumn;
import org.h2.result.ResultInterface;
import org.h2.server.TcpServer;
import org.h2.store.LobStorageInterface;
import org.h2.util.IOUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.SmallMap;
import org.h2.util.StringUtils;
import org.h2.value.Transfer;
import org.h2.value.Value;
import org.h2.value.ValueLobDb;

public class TcpServerThread
implements Runnable {
    protected final Transfer transfer;
    private final TcpServer server;
    private Session session;
    private boolean stop;
    private Thread thread;
    private Command commit;
    private final SmallMap cache = new SmallMap(SysProperties.SERVER_CACHED_OBJECTS);
    private final SmallLRUCache<Long, CachedInputStream> lobs = SmallLRUCache.newInstance(Math.max(SysProperties.SERVER_CACHED_OBJECTS, SysProperties.SERVER_RESULT_SET_FETCH_SIZE * 5));
    private final int threadId;
    private int clientVersion;
    private String sessionId;

    TcpServerThread(Socket socket, TcpServer tcpServer, int n2) {
        this.server = tcpServer;
        this.threadId = n2;
        this.transfer = new Transfer(null);
        this.transfer.setSocket(socket);
    }

    private void trace(String string) {
        this.server.trace(this + " " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.transfer.init();
            this.trace("Connect");
            try {
                int n2;
                String string;
                if (!this.server.allow(this.transfer.getSocket())) {
                    throw DbException.get(90117);
                }
                int n3 = this.transfer.readInt();
                if (n3 < 6) {
                    throw DbException.get(90047, "" + this.clientVersion, "6");
                }
                if (n3 > 15) {
                    throw DbException.get(90047, "" + this.clientVersion, "15");
                }
                int n4 = this.transfer.readInt();
                this.clientVersion = n4 >= 15 ? 15 : n3;
                this.transfer.setVersion(this.clientVersion);
                String string2 = this.transfer.readString();
                String string3 = this.transfer.readString();
                if (string2 == null && string3 == null) {
                    string = this.transfer.readString();
                    int n5 = this.transfer.readInt();
                    this.stop = true;
                    if (n5 == 13) {
                        n2 = this.transfer.readInt();
                        this.server.cancelStatement(string, n2);
                    } else if (n5 == 14) {
                        string2 = this.server.checkKeyAndGetDatabaseName(string);
                        if (!string.equals(string2)) {
                            this.transfer.writeInt(1);
                        } else {
                            this.transfer.writeInt(0);
                        }
                    }
                }
                if ((string = this.server.getBaseDir()) == null) {
                    string = SysProperties.getBaseDir();
                }
                string2 = this.server.checkKeyAndGetDatabaseName(string2);
                ConnectionInfo connectionInfo = new ConnectionInfo(string2);
                connectionInfo.setOriginalURL(string3);
                connectionInfo.setUserName(this.transfer.readString());
                connectionInfo.setUserPasswordHash(this.transfer.readBytes());
                connectionInfo.setFilePasswordHash(this.transfer.readBytes());
                n2 = this.transfer.readInt();
                for (int i2 = 0; i2 < n2; ++i2) {
                    connectionInfo.setProperty(this.transfer.readString(), this.transfer.readString());
                }
                if (string != null) {
                    connectionInfo.setBaseDir(string);
                }
                if (this.server.getIfExists()) {
                    connectionInfo.setProperty("IFEXISTS", "TRUE");
                }
                this.transfer.writeInt(1);
                this.transfer.writeInt(this.clientVersion);
                this.transfer.flush();
                if (this.clientVersion >= 13 && connectionInfo.getFilePasswordHash() != null) {
                    connectionInfo.setFileEncryptionKey(this.transfer.readBytes());
                }
                this.session = Engine.getInstance().createSession(connectionInfo);
                this.transfer.setSession(this.session);
                this.server.addConnection(this.threadId, string3, connectionInfo.getUserName());
                this.trace("Connected");
            }
            catch (Throwable throwable) {
                this.sendError(throwable);
                this.stop = true;
            }
            while (!this.stop) {
                try {
                    this.process();
                }
                catch (Throwable throwable) {
                    this.sendError(throwable);
                }
            }
            this.trace("Disconnect");
        }
        catch (Throwable throwable) {
            this.server.traceError(throwable);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession() {
        if (this.session != null) {
            RuntimeException runtimeException = null;
            try {
                Command command = this.session.prepareLocal("ROLLBACK");
                command.executeUpdate();
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
                this.server.traceError(runtimeException2);
            }
            catch (Exception exception) {
                this.server.traceError(exception);
            }
            try {
                this.session.close();
                this.server.removeConnection(this.threadId);
            }
            catch (RuntimeException runtimeException3) {
                if (runtimeException == null) {
                    runtimeException = runtimeException3;
                    this.server.traceError(runtimeException3);
                }
            }
            catch (Exception exception) {
                this.server.traceError(exception);
            }
            finally {
                this.session = null;
            }
            if (runtimeException != null) {
                throw runtimeException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        try {
            this.stop = true;
            this.closeSession();
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        finally {
            this.transfer.close();
            this.trace("Close");
            this.server.remove(this);
        }
    }

    private void sendError(Throwable throwable) {
        try {
            String string;
            String string2;
            SQLException sQLException = DbException.convert(throwable).getSQLException();
            StringWriter stringWriter = new StringWriter();
            sQLException.printStackTrace(new PrintWriter(stringWriter));
            String string3 = stringWriter.toString();
            if (sQLException instanceof JdbcSQLException) {
                JdbcSQLException jdbcSQLException = (JdbcSQLException)sQLException;
                string2 = jdbcSQLException.getOriginalMessage();
                string = jdbcSQLException.getSQL();
            } else {
                string2 = sQLException.getMessage();
                string = null;
            }
            this.transfer.writeInt(0).writeString(sQLException.getSQLState()).writeString(string2).writeString(string).writeInt(sQLException.getErrorCode()).writeString(string3).flush();
        }
        catch (Exception exception) {
            if (!this.transfer.isClosed()) {
                this.server.traceError(exception);
            }
            this.stop = true;
        }
    }

    private void setParameters(Command command) throws IOException {
        int n2 = this.transfer.readInt();
        ArrayList<? extends ParameterInterface> arrayList = command.getParameters();
        for (int i2 = 0; i2 < n2; ++i2) {
            Parameter parameter = (Parameter)arrayList.get(i2);
            parameter.setValue(this.transfer.readValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws IOException {
        int n2 = this.transfer.readInt();
        switch (n2) {
            case 0: 
            case 11: {
                int n3 = this.transfer.readInt();
                String string = this.transfer.readString();
                int n4 = this.session.getModificationId();
                Command command = this.session.prepareLocal(string);
                boolean bl2 = command.isReadOnly();
                this.cache.addObject(n3, command);
                boolean bl3 = command.isQuery();
                ArrayList<? extends ParameterInterface> arrayList = command.getParameters();
                this.transfer.writeInt(this.getState(n4)).writeBoolean(bl3).writeBoolean(bl2).writeInt(arrayList.size());
                if (n2 == 11) {
                    for (ParameterInterface parameterInterface : arrayList) {
                        ParameterRemote.writeMetaData(this.transfer, parameterInterface);
                    }
                }
                this.transfer.flush();
                break;
            }
            case 1: {
                this.stop = true;
                this.closeSession();
                this.transfer.writeInt(1).flush();
                this.close();
                break;
            }
            case 8: {
                if (this.commit == null) {
                    this.commit = this.session.prepareLocal("COMMIT");
                }
                int n5 = this.session.getModificationId();
                this.commit.executeUpdate();
                this.transfer.writeInt(this.getState(n5)).flush();
                break;
            }
            case 10: {
                int n6 = this.transfer.readInt();
                int n7 = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(n6, false);
                ResultInterface resultInterface = command.getMetaData();
                this.cache.addObject(n7, resultInterface);
                int n8 = resultInterface.getVisibleColumnCount();
                this.transfer.writeInt(1).writeInt(n8).writeInt(0);
                for (int i2 = 0; i2 < n8; ++i2) {
                    ResultColumn.writeColumn(this.transfer, resultInterface, i2);
                }
                this.transfer.flush();
                break;
            }
            case 2: {
                int inputStream;
                ResultInterface resultInterface;
                int n10 = this.transfer.readInt();
                int n11 = this.transfer.readInt();
                int n12 = this.transfer.readInt();
                int n13 = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(n10, false);
                this.setParameters(command);
                int n14 = this.session.getModificationId();
                Session session = this.session;
                synchronized (session) {
                    resultInterface = command.executeQuery(n12, false);
                }
                this.cache.addObject(n11, resultInterface);
                int n15 = resultInterface.getVisibleColumnCount();
                int n16 = this.getState(n14);
                this.transfer.writeInt(n16).writeInt(n15);
                int valueLobDb = resultInterface.getRowCount();
                this.transfer.writeInt(valueLobDb);
                for (inputStream = 0; inputStream < n15; ++inputStream) {
                    ResultColumn.writeColumn(this.transfer, resultInterface, inputStream);
                }
                inputStream = Math.min(valueLobDb, n13);
                for (int i2 = 0; i2 < inputStream; ++i2) {
                    this.sendRow(resultInterface);
                }
                this.transfer.flush();
                break;
            }
            case 3: {
                int n18;
                int n19;
                int n20 = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(n20, false);
                this.setParameters(command);
                int n21 = this.session.getModificationId();
                Session session = this.session;
                synchronized (session) {
                    n19 = command.executeUpdate();
                }
                if (this.session.isClosed()) {
                    n18 = 2;
                    this.stop = true;
                } else {
                    n18 = this.getState(n21);
                }
                this.transfer.writeInt(n18).writeInt(n19).writeBoolean(this.session.getAutoCommit());
                this.transfer.flush();
                break;
            }
            case 4: {
                int n22 = this.transfer.readInt();
                Command command = (Command)this.cache.getObject(n22, true);
                if (command == null) break;
                command.close();
                this.cache.freeObject(n22);
                break;
            }
            case 5: {
                int n23 = this.transfer.readInt();
                int n24 = this.transfer.readInt();
                ResultInterface resultInterface = (ResultInterface)this.cache.getObject(n23, false);
                this.transfer.writeInt(1);
                for (int i4 = 0; i4 < n24; ++i4) {
                    this.sendRow(resultInterface);
                }
                this.transfer.flush();
                break;
            }
            case 6: {
                int n25 = this.transfer.readInt();
                ResultInterface resultInterface = (ResultInterface)this.cache.getObject(n25, false);
                resultInterface.reset();
                break;
            }
            case 7: {
                int n26 = this.transfer.readInt();
                ResultInterface resultInterface = (ResultInterface)this.cache.getObject(n26, true);
                if (resultInterface == null) break;
                resultInterface.close();
                this.cache.freeObject(n26);
                break;
            }
            case 9: {
                int n27 = this.transfer.readInt();
                int n28 = this.transfer.readInt();
                Object object = this.cache.getObject(n27, false);
                this.cache.freeObject(n27);
                this.cache.addObject(n28, object);
                break;
            }
            case 12: {
                this.sessionId = this.transfer.readString();
                this.transfer.writeInt(1);
                this.transfer.writeBoolean(this.session.getAutoCommit());
                this.transfer.flush();
                break;
            }
            case 15: {
                boolean bl4 = this.transfer.readBoolean();
                this.session.setAutoCommit(bl4);
                this.transfer.writeInt(1).flush();
                break;
            }
            case 16: {
                this.transfer.writeInt(1).writeInt(this.session.hasPendingTransaction() ? 1 : 0).flush();
                break;
            }
            case 17: {
                CachedInputStream cachedInputStream;
                boolean bl5;
                byte[] byArray;
                long l2 = this.transfer.readLong();
                if (this.clientVersion >= 11) {
                    if (this.clientVersion >= 12) {
                        byArray = this.transfer.readBytes();
                        bl5 = true;
                    } else {
                        byArray = null;
                        bl5 = false;
                    }
                    cachedInputStream = (CachedInputStream)this.lobs.get(l2);
                    if (cachedInputStream == null && bl5) {
                        cachedInputStream = new CachedInputStream(null);
                        this.lobs.put(l2, cachedInputStream);
                    }
                } else {
                    bl5 = false;
                    byArray = null;
                    cachedInputStream = (CachedInputStream)this.lobs.get(l2);
                }
                long l3 = this.transfer.readLong();
                int n29 = this.transfer.readInt();
                if (bl5) {
                    this.transfer.verifyLobMac(byArray, l2);
                }
                if (cachedInputStream == null) {
                    throw DbException.get(90007);
                }
                if (cachedInputStream.getPos() != l3) {
                    LobStorageInterface object = this.session.getDataHandler().getLobStorage();
                    ValueLobDb valueLobDb = ValueLobDb.create(15, null, -1, l2, byArray, -1L);
                    InputStream inputStream = object.getInputStream(valueLobDb, byArray, -1L);
                    cachedInputStream = new CachedInputStream(inputStream);
                    this.lobs.put(l2, cachedInputStream);
                    inputStream.skip(l3);
                }
                n29 = Math.min(65536, n29);
                byte[] byArray2 = new byte[n29];
                n29 = IOUtils.readFully(cachedInputStream, byArray2, n29);
                this.transfer.writeInt(1);
                this.transfer.writeInt(n29);
                this.transfer.writeBytes(byArray2, 0, n29);
                this.transfer.flush();
                break;
            }
            default: {
                this.trace("Unknown operation: " + n2);
                this.closeSession();
                this.close();
            }
        }
    }

    private int getState(int n2) {
        if (this.session.getModificationId() == n2) {
            return 1;
        }
        return 3;
    }

    private void sendRow(ResultInterface resultInterface) throws IOException {
        if (resultInterface.next()) {
            this.transfer.writeBoolean(true);
            Value[] valueArray = resultInterface.currentRow();
            for (int i2 = 0; i2 < resultInterface.getVisibleColumnCount(); ++i2) {
                if (this.clientVersion >= 12) {
                    this.transfer.writeValue(valueArray[i2]);
                    continue;
                }
                this.writeValue(valueArray[i2]);
            }
        } else {
            this.transfer.writeBoolean(false);
        }
    }

    private void writeValue(Value value) throws IOException {
        ValueLobDb valueLobDb;
        if ((value.getType() == 16 || value.getType() == 15) && value instanceof ValueLobDb && (valueLobDb = (ValueLobDb)value).isStored()) {
            long l2 = valueLobDb.getLobId();
            this.lobs.put(l2, new CachedInputStream(null));
        }
        this.transfer.writeValue(value);
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    Thread getThread() {
        return this.thread;
    }

    void cancelStatement(String string, int n2) {
        if (StringUtils.equals(string, this.sessionId)) {
            Command command = (Command)this.cache.getObject(n2, false);
            command.cancel();
        }
    }

    static class CachedInputStream
    extends FilterInputStream {
        private static final ByteArrayInputStream DUMMY = new ByteArrayInputStream(new byte[0]);
        private long pos;

        CachedInputStream(InputStream inputStream) {
            super(inputStream == null ? DUMMY : inputStream);
            if (inputStream == null) {
                this.pos = -1L;
            }
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if ((n3 = super.read(byArray, n2, n3)) > 0) {
                this.pos += (long)n3;
            }
            return n3;
        }

        @Override
        public int read() throws IOException {
            int n2 = this.in.read();
            if (n2 >= 0) {
                ++this.pos;
            }
            return n2;
        }

        @Override
        public long skip(long l2) throws IOException {
            if ((l2 = super.skip(l2)) > 0L) {
                this.pos += l2;
            }
            return l2;
        }

        public long getPos() {
            return this.pos;
        }
    }
}

