/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security;

import java.util.Arrays;

public class SHA256 {
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int[] HH = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private final byte[] result = new byte[32];
    private final int[] w = new int[64];
    private final int[] hh = new int[8];

    public static byte[] getHashWithSalt(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return SHA256.getHash(byArray3, true);
    }

    public static byte[] getKeyPasswordHash(String string, char[] cArray) {
        String string2 = string + "@";
        byte[] byArray = new byte[2 * (string2.length() + cArray.length)];
        int n2 = 0;
        int n3 = string2.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = string2.charAt(i2);
            byArray[n2++] = (byte)(n4 >> 8);
            byArray[n2++] = (byte)n4;
        }
        for (char c2 : cArray) {
            byArray[n2++] = (byte)(c2 >> 8);
            byArray[n2++] = (byte)c2;
        }
        Arrays.fill(cArray, '\u0000');
        return SHA256.getHash(byArray, true);
    }

    public static byte[] getHMAC(byte[] byArray, byte[] byArray2) {
        byArray = SHA256.normalizeKeyForHMAC(byArray);
        int n2 = byArray2.length;
        int n3 = 64 + Math.max(32, n2);
        int n4 = SHA256.getIntCount(n3);
        byte[] byArray3 = new byte[n4 * 4];
        int[] nArray = new int[n4];
        SHA256 sHA256 = new SHA256();
        byte[] byArray4 = new byte[64 + n2];
        byte[] byArray5 = new byte[96];
        sHA256.calculateHMAC(byArray, byArray2, n2, byArray4, byArray5, byArray3, nArray);
        return sHA256.result;
    }

    private void calculateHMAC(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int[] nArray) {
        Arrays.fill(byArray3, 0, 64, (byte)54);
        SHA256.xor(byArray3, byArray, 64);
        System.arraycopy(byArray2, 0, byArray3, 64, n2);
        this.calculateHash(byArray3, 64 + n2, byArray5, nArray);
        Arrays.fill(byArray4, 0, 64, (byte)92);
        SHA256.xor(byArray4, byArray, 64);
        System.arraycopy(this.result, 0, byArray4, 64, 32);
        this.calculateHash(byArray4, 96, byArray5, nArray);
    }

    private static byte[] normalizeKeyForHMAC(byte[] byArray) {
        if (byArray.length > 64) {
            byArray = SHA256.getHash(byArray, false);
        }
        if (byArray.length < 64) {
            byArray = Arrays.copyOf(byArray, 64);
        }
        return byArray;
    }

    private static void xor(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            byArray[n3] = (byte)(byArray[n3] ^ byArray2[i2]);
        }
    }

    public static byte[] getPBKDF2(byte[] byArray, byte[] byArray2, int n2, int n3) {
        byte[] byArray3 = new byte[n3];
        byte[] byArray4 = SHA256.normalizeKeyForHMAC(byArray);
        SHA256 sHA256 = new SHA256();
        int n4 = 64 + Math.max(32, byArray2.length + 4);
        byte[] byArray5 = new byte[n4];
        int n5 = SHA256.getIntCount(n4);
        byte[] byArray6 = new byte[n5 * 4];
        int[] nArray = new int[n5];
        byte[] byArray7 = new byte[64 + n4];
        byte[] byArray8 = new byte[96];
        int n6 = 1;
        for (int i2 = 0; i2 < n3; i2 += 32) {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (i3 == 0) {
                    System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
                    SHA256.writeInt(byArray5, byArray2.length, n6);
                    n4 = byArray2.length + 4;
                } else {
                    System.arraycopy(sHA256.result, 0, byArray5, 0, 32);
                    n4 = 32;
                }
                sHA256.calculateHMAC(byArray4, byArray5, n4, byArray7, byArray8, byArray6, nArray);
                for (int i4 = 0; i4 < 32 && i4 + i2 < n3; ++i4) {
                    int n7 = i4 + i2;
                    byArray3[n7] = (byte)(byArray3[n7] ^ sHA256.result[i4]);
                }
            }
            ++n6;
        }
        Arrays.fill(byArray, (byte)0);
        Arrays.fill(byArray4, (byte)0);
        return byArray3;
    }

    public static byte[] getHash(byte[] byArray, boolean bl2) {
        int n2 = byArray.length;
        int n3 = SHA256.getIntCount(n2);
        byte[] byArray2 = new byte[n3 * 4];
        int[] nArray = new int[n3];
        SHA256 sHA256 = new SHA256();
        sHA256.calculateHash(byArray, n2, byArray2, nArray);
        if (bl2) {
            sHA256.fillWithNull();
            Arrays.fill(nArray, 0);
            Arrays.fill(byArray2, (byte)0);
            Arrays.fill(byArray, (byte)0);
        }
        return sHA256.result;
    }

    private static int getIntCount(int n2) {
        return (n2 + 9 + 63) / 64 * 16;
    }

    private void fillWithNull() {
        Arrays.fill(this.w, 0);
        Arrays.fill(this.hh, 0);
    }

    private void calculateHash(byte[] byArray, int n2, byte[] byArray2, int[] nArray) {
        int n3;
        int[] nArray2 = this.w;
        int[] nArray3 = this.hh;
        byte[] byArray3 = this.result;
        int n4 = SHA256.getIntCount(n2);
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = -128;
        Arrays.fill(byArray2, n2 + 1, n4 * 4, (byte)0);
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = SHA256.readInt(byArray2, n5);
            n5 += 4;
        }
        nArray[n4 - 2] = n2 >>> 29;
        nArray[n4 - 1] = n2 << 3;
        System.arraycopy(HH, 0, nArray3, 0, 8);
        for (n5 = 0; n5 < n4; n5 += 16) {
            int n6;
            int n7;
            int n8;
            for (n3 = 0; n3 < 16; ++n3) {
                nArray2[n3] = nArray[n5 + n3];
            }
            for (n3 = 16; n3 < 64; ++n3) {
                n8 = nArray2[n3 - 2];
                n7 = SHA256.rot(n8, 17) ^ SHA256.rot(n8, 19) ^ n8 >>> 10;
                n8 = nArray2[n3 - 15];
                n6 = SHA256.rot(n8, 7) ^ SHA256.rot(n8, 18) ^ n8 >>> 3;
                nArray2[n3] = n7 + nArray2[n3 - 7] + n6 + nArray2[n3 - 16];
            }
            n3 = nArray3[0];
            n8 = nArray3[1];
            n7 = nArray3[2];
            n6 = nArray3[3];
            int n9 = nArray3[4];
            int n10 = nArray3[5];
            int n11 = nArray3[6];
            int n12 = nArray3[7];
            for (int i2 = 0; i2 < 64; ++i2) {
                int n13 = n12 + (SHA256.rot(n9, 6) ^ SHA256.rot(n9, 11) ^ SHA256.rot(n9, 25)) + (n9 & n10 ^ ~n9 & n11) + K[i2] + nArray2[i2];
                int n14 = (SHA256.rot(n3, 2) ^ SHA256.rot(n3, 13) ^ SHA256.rot(n3, 22)) + (n3 & n8 ^ n3 & n7 ^ n8 & n7);
                n12 = n11;
                n11 = n10;
                n10 = n9;
                n9 = n6 + n13;
                n6 = n7;
                n7 = n8;
                n8 = n3;
                n3 = n13 + n14;
            }
            nArray3[0] = nArray3[0] + n3;
            nArray3[1] = nArray3[1] + n8;
            nArray3[2] = nArray3[2] + n7;
            nArray3[3] = nArray3[3] + n6;
            nArray3[4] = nArray3[4] + n9;
            nArray3[5] = nArray3[5] + n10;
            nArray3[6] = nArray3[6] + n11;
            nArray3[7] = nArray3[7] + n12;
        }
        for (n5 = 0; n5 < 8; ++n5) {
            SHA256.writeInt(byArray3, n5 * 4, nArray3[n5]);
        }
    }

    private static int rot(int n2, int n3) {
        return Integer.rotateRight(n2, n3);
    }

    private static int readInt(byte[] byArray, int n2) {
        return ((byArray[n2] & 0xFF) << 24) + ((byArray[n2 + 1] & 0xFF) << 16) + ((byArray[n2 + 2] & 0xFF) << 8) + (byArray[n2 + 3] & 0xFF);
    }

    private static void writeInt(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)(n3 >> 24);
        byArray[n2 + 1] = (byte)(n3 >> 16);
        byArray[n2 + 2] = (byte)(n3 >> 8);
        byArray[n2 + 3] = (byte)n3;
    }
}

