/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security;

import org.h2.security.BlockCipher;

public class AES
implements BlockCipher {
    private static final int[] RCON;
    private static final int[] FS;
    private static final int[] FT0;
    private static final int[] FT1;
    private static final int[] FT2;
    private static final int[] FT3;
    private static final int[] RS;
    private static final int[] RT0;
    private static final int[] RT1;
    private static final int[] RT2;
    private static final int[] RT3;
    private final int[] encKey = new int[44];
    private final int[] decKey = new int[44];

    private static int rot8(int n2) {
        return n2 >>> 8 | n2 << 24;
    }

    private static int xtime(int n2) {
        return (n2 << 1 ^ ((n2 & 0x80) != 0 ? 27 : 0)) & 0xFF;
    }

    private static int mul(int[] nArray, int[] nArray2, int n2, int n3) {
        return n2 != 0 && n3 != 0 ? nArray[(nArray2[n2] + nArray2[n3]) % 255] : 0;
    }

    private static int getDec(int n2) {
        return RT0[FS[n2 >> 24 & 0xFF]] ^ RT1[FS[n2 >> 16 & 0xFF]] ^ RT2[FS[n2 >> 8 & 0xFF]] ^ RT3[FS[n2 & 0xFF]];
    }

    @Override
    public void setKey(byte[] byArray) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            this.encKey[n2] = this.decKey[n2] = (byArray[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
        }
        n2 = 0;
        n3 = 0;
        while (n3 < 10) {
            this.encKey[n2 + 4] = this.encKey[n2] ^ RCON[n3] ^ FS[this.encKey[n2 + 3] >> 16 & 0xFF] << 24 ^ FS[this.encKey[n2 + 3] >> 8 & 0xFF] << 16 ^ FS[this.encKey[n2 + 3] & 0xFF] << 8 ^ FS[this.encKey[n2 + 3] >> 24 & 0xFF];
            this.encKey[n2 + 5] = this.encKey[n2 + 1] ^ this.encKey[n2 + 4];
            this.encKey[n2 + 6] = this.encKey[n2 + 2] ^ this.encKey[n2 + 5];
            this.encKey[n2 + 7] = this.encKey[n2 + 3] ^ this.encKey[n2 + 6];
            ++n3;
            n2 += 4;
        }
        n3 = 0;
        this.decKey[n3++] = this.encKey[n2++];
        this.decKey[n3++] = this.encKey[n2++];
        this.decKey[n3++] = this.encKey[n2++];
        this.decKey[n3++] = this.encKey[n2++];
        for (int i2 = 1; i2 < 10; ++i2) {
            n2 -= 8;
            this.decKey[n3++] = AES.getDec(this.encKey[n2++]);
            this.decKey[n3++] = AES.getDec(this.encKey[n2++]);
            this.decKey[n3++] = AES.getDec(this.encKey[n2++]);
            this.decKey[n3++] = AES.getDec(this.encKey[n2++]);
        }
        n2 -= 8;
        this.decKey[n3++] = this.encKey[n2++];
        this.decKey[n3++] = this.encKey[n2++];
        this.decKey[n3++] = this.encKey[n2++];
        this.decKey[n3] = this.encKey[n2];
    }

    @Override
    public void encrypt(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; i2 += 16) {
            this.encryptBlock(byArray, byArray, i2);
        }
    }

    @Override
    public void decrypt(byte[] byArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; i2 += 16) {
            this.decryptBlock(byArray, byArray, i2);
        }
    }

    private void encryptBlock(byte[] byArray, byte[] byArray2, int n2) {
        int[] nArray = this.encKey;
        int n3 = (byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF) ^ nArray[0];
        int n4 = (byArray[n2 + 4] << 24 | (byArray[n2 + 5] & 0xFF) << 16 | (byArray[n2 + 6] & 0xFF) << 8 | byArray[n2 + 7] & 0xFF) ^ nArray[1];
        int n5 = (byArray[n2 + 8] << 24 | (byArray[n2 + 9] & 0xFF) << 16 | (byArray[n2 + 10] & 0xFF) << 8 | byArray[n2 + 11] & 0xFF) ^ nArray[2];
        int n6 = (byArray[n2 + 12] << 24 | (byArray[n2 + 13] & 0xFF) << 16 | (byArray[n2 + 14] & 0xFF) << 8 | byArray[n2 + 15] & 0xFF) ^ nArray[3];
        int n7 = FT0[n3 >> 24 & 0xFF] ^ FT1[n4 >> 16 & 0xFF] ^ FT2[n5 >> 8 & 0xFF] ^ FT3[n6 & 0xFF] ^ nArray[4];
        int n8 = FT0[n4 >> 24 & 0xFF] ^ FT1[n5 >> 16 & 0xFF] ^ FT2[n6 >> 8 & 0xFF] ^ FT3[n3 & 0xFF] ^ nArray[5];
        int n9 = FT0[n5 >> 24 & 0xFF] ^ FT1[n6 >> 16 & 0xFF] ^ FT2[n3 >> 8 & 0xFF] ^ FT3[n4 & 0xFF] ^ nArray[6];
        int n10 = FT0[n6 >> 24 & 0xFF] ^ FT1[n3 >> 16 & 0xFF] ^ FT2[n4 >> 8 & 0xFF] ^ FT3[n5 & 0xFF] ^ nArray[7];
        n3 = FT0[n7 >> 24 & 0xFF] ^ FT1[n8 >> 16 & 0xFF] ^ FT2[n9 >> 8 & 0xFF] ^ FT3[n10 & 0xFF] ^ nArray[8];
        n4 = FT0[n8 >> 24 & 0xFF] ^ FT1[n9 >> 16 & 0xFF] ^ FT2[n10 >> 8 & 0xFF] ^ FT3[n7 & 0xFF] ^ nArray[9];
        n5 = FT0[n9 >> 24 & 0xFF] ^ FT1[n10 >> 16 & 0xFF] ^ FT2[n7 >> 8 & 0xFF] ^ FT3[n8 & 0xFF] ^ nArray[10];
        n6 = FT0[n10 >> 24 & 0xFF] ^ FT1[n7 >> 16 & 0xFF] ^ FT2[n8 >> 8 & 0xFF] ^ FT3[n9 & 0xFF] ^ nArray[11];
        n7 = FT0[n3 >> 24 & 0xFF] ^ FT1[n4 >> 16 & 0xFF] ^ FT2[n5 >> 8 & 0xFF] ^ FT3[n6 & 0xFF] ^ nArray[12];
        n8 = FT0[n4 >> 24 & 0xFF] ^ FT1[n5 >> 16 & 0xFF] ^ FT2[n6 >> 8 & 0xFF] ^ FT3[n3 & 0xFF] ^ nArray[13];
        n9 = FT0[n5 >> 24 & 0xFF] ^ FT1[n6 >> 16 & 0xFF] ^ FT2[n3 >> 8 & 0xFF] ^ FT3[n4 & 0xFF] ^ nArray[14];
        n10 = FT0[n6 >> 24 & 0xFF] ^ FT1[n3 >> 16 & 0xFF] ^ FT2[n4 >> 8 & 0xFF] ^ FT3[n5 & 0xFF] ^ nArray[15];
        n3 = FT0[n7 >> 24 & 0xFF] ^ FT1[n8 >> 16 & 0xFF] ^ FT2[n9 >> 8 & 0xFF] ^ FT3[n10 & 0xFF] ^ nArray[16];
        n4 = FT0[n8 >> 24 & 0xFF] ^ FT1[n9 >> 16 & 0xFF] ^ FT2[n10 >> 8 & 0xFF] ^ FT3[n7 & 0xFF] ^ nArray[17];
        n5 = FT0[n9 >> 24 & 0xFF] ^ FT1[n10 >> 16 & 0xFF] ^ FT2[n7 >> 8 & 0xFF] ^ FT3[n8 & 0xFF] ^ nArray[18];
        n6 = FT0[n10 >> 24 & 0xFF] ^ FT1[n7 >> 16 & 0xFF] ^ FT2[n8 >> 8 & 0xFF] ^ FT3[n9 & 0xFF] ^ nArray[19];
        n7 = FT0[n3 >> 24 & 0xFF] ^ FT1[n4 >> 16 & 0xFF] ^ FT2[n5 >> 8 & 0xFF] ^ FT3[n6 & 0xFF] ^ nArray[20];
        n8 = FT0[n4 >> 24 & 0xFF] ^ FT1[n5 >> 16 & 0xFF] ^ FT2[n6 >> 8 & 0xFF] ^ FT3[n3 & 0xFF] ^ nArray[21];
        n9 = FT0[n5 >> 24 & 0xFF] ^ FT1[n6 >> 16 & 0xFF] ^ FT2[n3 >> 8 & 0xFF] ^ FT3[n4 & 0xFF] ^ nArray[22];
        n10 = FT0[n6 >> 24 & 0xFF] ^ FT1[n3 >> 16 & 0xFF] ^ FT2[n4 >> 8 & 0xFF] ^ FT3[n5 & 0xFF] ^ nArray[23];
        n3 = FT0[n7 >> 24 & 0xFF] ^ FT1[n8 >> 16 & 0xFF] ^ FT2[n9 >> 8 & 0xFF] ^ FT3[n10 & 0xFF] ^ nArray[24];
        n4 = FT0[n8 >> 24 & 0xFF] ^ FT1[n9 >> 16 & 0xFF] ^ FT2[n10 >> 8 & 0xFF] ^ FT3[n7 & 0xFF] ^ nArray[25];
        n5 = FT0[n9 >> 24 & 0xFF] ^ FT1[n10 >> 16 & 0xFF] ^ FT2[n7 >> 8 & 0xFF] ^ FT3[n8 & 0xFF] ^ nArray[26];
        n6 = FT0[n10 >> 24 & 0xFF] ^ FT1[n7 >> 16 & 0xFF] ^ FT2[n8 >> 8 & 0xFF] ^ FT3[n9 & 0xFF] ^ nArray[27];
        n7 = FT0[n3 >> 24 & 0xFF] ^ FT1[n4 >> 16 & 0xFF] ^ FT2[n5 >> 8 & 0xFF] ^ FT3[n6 & 0xFF] ^ nArray[28];
        n8 = FT0[n4 >> 24 & 0xFF] ^ FT1[n5 >> 16 & 0xFF] ^ FT2[n6 >> 8 & 0xFF] ^ FT3[n3 & 0xFF] ^ nArray[29];
        n9 = FT0[n5 >> 24 & 0xFF] ^ FT1[n6 >> 16 & 0xFF] ^ FT2[n3 >> 8 & 0xFF] ^ FT3[n4 & 0xFF] ^ nArray[30];
        n10 = FT0[n6 >> 24 & 0xFF] ^ FT1[n3 >> 16 & 0xFF] ^ FT2[n4 >> 8 & 0xFF] ^ FT3[n5 & 0xFF] ^ nArray[31];
        n3 = FT0[n7 >> 24 & 0xFF] ^ FT1[n8 >> 16 & 0xFF] ^ FT2[n9 >> 8 & 0xFF] ^ FT3[n10 & 0xFF] ^ nArray[32];
        n4 = FT0[n8 >> 24 & 0xFF] ^ FT1[n9 >> 16 & 0xFF] ^ FT2[n10 >> 8 & 0xFF] ^ FT3[n7 & 0xFF] ^ nArray[33];
        n5 = FT0[n9 >> 24 & 0xFF] ^ FT1[n10 >> 16 & 0xFF] ^ FT2[n7 >> 8 & 0xFF] ^ FT3[n8 & 0xFF] ^ nArray[34];
        n6 = FT0[n10 >> 24 & 0xFF] ^ FT1[n7 >> 16 & 0xFF] ^ FT2[n8 >> 8 & 0xFF] ^ FT3[n9 & 0xFF] ^ nArray[35];
        n7 = FT0[n3 >> 24 & 0xFF] ^ FT1[n4 >> 16 & 0xFF] ^ FT2[n5 >> 8 & 0xFF] ^ FT3[n6 & 0xFF] ^ nArray[36];
        n8 = FT0[n4 >> 24 & 0xFF] ^ FT1[n5 >> 16 & 0xFF] ^ FT2[n6 >> 8 & 0xFF] ^ FT3[n3 & 0xFF] ^ nArray[37];
        n9 = FT0[n5 >> 24 & 0xFF] ^ FT1[n6 >> 16 & 0xFF] ^ FT2[n3 >> 8 & 0xFF] ^ FT3[n4 & 0xFF] ^ nArray[38];
        n10 = FT0[n6 >> 24 & 0xFF] ^ FT1[n3 >> 16 & 0xFF] ^ FT2[n4 >> 8 & 0xFF] ^ FT3[n5 & 0xFF] ^ nArray[39];
        n3 = (FS[n7 >> 24 & 0xFF] << 24 | FS[n8 >> 16 & 0xFF] << 16 | FS[n9 >> 8 & 0xFF] << 8 | FS[n10 & 0xFF]) ^ nArray[40];
        n4 = (FS[n8 >> 24 & 0xFF] << 24 | FS[n9 >> 16 & 0xFF] << 16 | FS[n10 >> 8 & 0xFF] << 8 | FS[n7 & 0xFF]) ^ nArray[41];
        n5 = (FS[n9 >> 24 & 0xFF] << 24 | FS[n10 >> 16 & 0xFF] << 16 | FS[n7 >> 8 & 0xFF] << 8 | FS[n8 & 0xFF]) ^ nArray[42];
        n6 = (FS[n10 >> 24 & 0xFF] << 24 | FS[n7 >> 16 & 0xFF] << 16 | FS[n8 >> 8 & 0xFF] << 8 | FS[n9 & 0xFF]) ^ nArray[43];
        byArray2[n2] = (byte)(n3 >> 24);
        byArray2[n2 + 1] = (byte)(n3 >> 16);
        byArray2[n2 + 2] = (byte)(n3 >> 8);
        byArray2[n2 + 3] = (byte)n3;
        byArray2[n2 + 4] = (byte)(n4 >> 24);
        byArray2[n2 + 5] = (byte)(n4 >> 16);
        byArray2[n2 + 6] = (byte)(n4 >> 8);
        byArray2[n2 + 7] = (byte)n4;
        byArray2[n2 + 8] = (byte)(n5 >> 24);
        byArray2[n2 + 9] = (byte)(n5 >> 16);
        byArray2[n2 + 10] = (byte)(n5 >> 8);
        byArray2[n2 + 11] = (byte)n5;
        byArray2[n2 + 12] = (byte)(n6 >> 24);
        byArray2[n2 + 13] = (byte)(n6 >> 16);
        byArray2[n2 + 14] = (byte)(n6 >> 8);
        byArray2[n2 + 15] = (byte)n6;
    }

    private void decryptBlock(byte[] byArray, byte[] byArray2, int n2) {
        int[] nArray = this.decKey;
        int n3 = (byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF) ^ nArray[0];
        int n4 = (byArray[n2 + 4] << 24 | (byArray[n2 + 5] & 0xFF) << 16 | (byArray[n2 + 6] & 0xFF) << 8 | byArray[n2 + 7] & 0xFF) ^ nArray[1];
        int n5 = (byArray[n2 + 8] << 24 | (byArray[n2 + 9] & 0xFF) << 16 | (byArray[n2 + 10] & 0xFF) << 8 | byArray[n2 + 11] & 0xFF) ^ nArray[2];
        int n6 = (byArray[n2 + 12] << 24 | (byArray[n2 + 13] & 0xFF) << 16 | (byArray[n2 + 14] & 0xFF) << 8 | byArray[n2 + 15] & 0xFF) ^ nArray[3];
        int n7 = RT0[n3 >> 24 & 0xFF] ^ RT1[n6 >> 16 & 0xFF] ^ RT2[n5 >> 8 & 0xFF] ^ RT3[n4 & 0xFF] ^ nArray[4];
        int n8 = RT0[n4 >> 24 & 0xFF] ^ RT1[n3 >> 16 & 0xFF] ^ RT2[n6 >> 8 & 0xFF] ^ RT3[n5 & 0xFF] ^ nArray[5];
        int n9 = RT0[n5 >> 24 & 0xFF] ^ RT1[n4 >> 16 & 0xFF] ^ RT2[n3 >> 8 & 0xFF] ^ RT3[n6 & 0xFF] ^ nArray[6];
        int n10 = RT0[n6 >> 24 & 0xFF] ^ RT1[n5 >> 16 & 0xFF] ^ RT2[n4 >> 8 & 0xFF] ^ RT3[n3 & 0xFF] ^ nArray[7];
        n3 = RT0[n7 >> 24 & 0xFF] ^ RT1[n10 >> 16 & 0xFF] ^ RT2[n9 >> 8 & 0xFF] ^ RT3[n8 & 0xFF] ^ nArray[8];
        n4 = RT0[n8 >> 24 & 0xFF] ^ RT1[n7 >> 16 & 0xFF] ^ RT2[n10 >> 8 & 0xFF] ^ RT3[n9 & 0xFF] ^ nArray[9];
        n5 = RT0[n9 >> 24 & 0xFF] ^ RT1[n8 >> 16 & 0xFF] ^ RT2[n7 >> 8 & 0xFF] ^ RT3[n10 & 0xFF] ^ nArray[10];
        n6 = RT0[n10 >> 24 & 0xFF] ^ RT1[n9 >> 16 & 0xFF] ^ RT2[n8 >> 8 & 0xFF] ^ RT3[n7 & 0xFF] ^ nArray[11];
        n7 = RT0[n3 >> 24 & 0xFF] ^ RT1[n6 >> 16 & 0xFF] ^ RT2[n5 >> 8 & 0xFF] ^ RT3[n4 & 0xFF] ^ nArray[12];
        n8 = RT0[n4 >> 24 & 0xFF] ^ RT1[n3 >> 16 & 0xFF] ^ RT2[n6 >> 8 & 0xFF] ^ RT3[n5 & 0xFF] ^ nArray[13];
        n9 = RT0[n5 >> 24 & 0xFF] ^ RT1[n4 >> 16 & 0xFF] ^ RT2[n3 >> 8 & 0xFF] ^ RT3[n6 & 0xFF] ^ nArray[14];
        n10 = RT0[n6 >> 24 & 0xFF] ^ RT1[n5 >> 16 & 0xFF] ^ RT2[n4 >> 8 & 0xFF] ^ RT3[n3 & 0xFF] ^ nArray[15];
        n3 = RT0[n7 >> 24 & 0xFF] ^ RT1[n10 >> 16 & 0xFF] ^ RT2[n9 >> 8 & 0xFF] ^ RT3[n8 & 0xFF] ^ nArray[16];
        n4 = RT0[n8 >> 24 & 0xFF] ^ RT1[n7 >> 16 & 0xFF] ^ RT2[n10 >> 8 & 0xFF] ^ RT3[n9 & 0xFF] ^ nArray[17];
        n5 = RT0[n9 >> 24 & 0xFF] ^ RT1[n8 >> 16 & 0xFF] ^ RT2[n7 >> 8 & 0xFF] ^ RT3[n10 & 0xFF] ^ nArray[18];
        n6 = RT0[n10 >> 24 & 0xFF] ^ RT1[n9 >> 16 & 0xFF] ^ RT2[n8 >> 8 & 0xFF] ^ RT3[n7 & 0xFF] ^ nArray[19];
        n7 = RT0[n3 >> 24 & 0xFF] ^ RT1[n6 >> 16 & 0xFF] ^ RT2[n5 >> 8 & 0xFF] ^ RT3[n4 & 0xFF] ^ nArray[20];
        n8 = RT0[n4 >> 24 & 0xFF] ^ RT1[n3 >> 16 & 0xFF] ^ RT2[n6 >> 8 & 0xFF] ^ RT3[n5 & 0xFF] ^ nArray[21];
        n9 = RT0[n5 >> 24 & 0xFF] ^ RT1[n4 >> 16 & 0xFF] ^ RT2[n3 >> 8 & 0xFF] ^ RT3[n6 & 0xFF] ^ nArray[22];
        n10 = RT0[n6 >> 24 & 0xFF] ^ RT1[n5 >> 16 & 0xFF] ^ RT2[n4 >> 8 & 0xFF] ^ RT3[n3 & 0xFF] ^ nArray[23];
        n3 = RT0[n7 >> 24 & 0xFF] ^ RT1[n10 >> 16 & 0xFF] ^ RT2[n9 >> 8 & 0xFF] ^ RT3[n8 & 0xFF] ^ nArray[24];
        n4 = RT0[n8 >> 24 & 0xFF] ^ RT1[n7 >> 16 & 0xFF] ^ RT2[n10 >> 8 & 0xFF] ^ RT3[n9 & 0xFF] ^ nArray[25];
        n5 = RT0[n9 >> 24 & 0xFF] ^ RT1[n8 >> 16 & 0xFF] ^ RT2[n7 >> 8 & 0xFF] ^ RT3[n10 & 0xFF] ^ nArray[26];
        n6 = RT0[n10 >> 24 & 0xFF] ^ RT1[n9 >> 16 & 0xFF] ^ RT2[n8 >> 8 & 0xFF] ^ RT3[n7 & 0xFF] ^ nArray[27];
        n7 = RT0[n3 >> 24 & 0xFF] ^ RT1[n6 >> 16 & 0xFF] ^ RT2[n5 >> 8 & 0xFF] ^ RT3[n4 & 0xFF] ^ nArray[28];
        n8 = RT0[n4 >> 24 & 0xFF] ^ RT1[n3 >> 16 & 0xFF] ^ RT2[n6 >> 8 & 0xFF] ^ RT3[n5 & 0xFF] ^ nArray[29];
        n9 = RT0[n5 >> 24 & 0xFF] ^ RT1[n4 >> 16 & 0xFF] ^ RT2[n3 >> 8 & 0xFF] ^ RT3[n6 & 0xFF] ^ nArray[30];
        n10 = RT0[n6 >> 24 & 0xFF] ^ RT1[n5 >> 16 & 0xFF] ^ RT2[n4 >> 8 & 0xFF] ^ RT3[n3 & 0xFF] ^ nArray[31];
        n3 = RT0[n7 >> 24 & 0xFF] ^ RT1[n10 >> 16 & 0xFF] ^ RT2[n9 >> 8 & 0xFF] ^ RT3[n8 & 0xFF] ^ nArray[32];
        n4 = RT0[n8 >> 24 & 0xFF] ^ RT1[n7 >> 16 & 0xFF] ^ RT2[n10 >> 8 & 0xFF] ^ RT3[n9 & 0xFF] ^ nArray[33];
        n5 = RT0[n9 >> 24 & 0xFF] ^ RT1[n8 >> 16 & 0xFF] ^ RT2[n7 >> 8 & 0xFF] ^ RT3[n10 & 0xFF] ^ nArray[34];
        n6 = RT0[n10 >> 24 & 0xFF] ^ RT1[n9 >> 16 & 0xFF] ^ RT2[n8 >> 8 & 0xFF] ^ RT3[n7 & 0xFF] ^ nArray[35];
        n7 = RT0[n3 >> 24 & 0xFF] ^ RT1[n6 >> 16 & 0xFF] ^ RT2[n5 >> 8 & 0xFF] ^ RT3[n4 & 0xFF] ^ nArray[36];
        n8 = RT0[n4 >> 24 & 0xFF] ^ RT1[n3 >> 16 & 0xFF] ^ RT2[n6 >> 8 & 0xFF] ^ RT3[n5 & 0xFF] ^ nArray[37];
        n9 = RT0[n5 >> 24 & 0xFF] ^ RT1[n4 >> 16 & 0xFF] ^ RT2[n3 >> 8 & 0xFF] ^ RT3[n6 & 0xFF] ^ nArray[38];
        n10 = RT0[n6 >> 24 & 0xFF] ^ RT1[n5 >> 16 & 0xFF] ^ RT2[n4 >> 8 & 0xFF] ^ RT3[n3 & 0xFF] ^ nArray[39];
        n3 = (RS[n7 >> 24 & 0xFF] << 24 | RS[n10 >> 16 & 0xFF] << 16 | RS[n9 >> 8 & 0xFF] << 8 | RS[n8 & 0xFF]) ^ nArray[40];
        n4 = (RS[n8 >> 24 & 0xFF] << 24 | RS[n7 >> 16 & 0xFF] << 16 | RS[n10 >> 8 & 0xFF] << 8 | RS[n9 & 0xFF]) ^ nArray[41];
        n5 = (RS[n9 >> 24 & 0xFF] << 24 | RS[n8 >> 16 & 0xFF] << 16 | RS[n7 >> 8 & 0xFF] << 8 | RS[n10 & 0xFF]) ^ nArray[42];
        n6 = (RS[n10 >> 24 & 0xFF] << 24 | RS[n9 >> 16 & 0xFF] << 16 | RS[n8 >> 8 & 0xFF] << 8 | RS[n7 & 0xFF]) ^ nArray[43];
        byArray2[n2] = (byte)(n3 >> 24);
        byArray2[n2 + 1] = (byte)(n3 >> 16);
        byArray2[n2 + 2] = (byte)(n3 >> 8);
        byArray2[n2 + 3] = (byte)n3;
        byArray2[n2 + 4] = (byte)(n4 >> 24);
        byArray2[n2 + 5] = (byte)(n4 >> 16);
        byArray2[n2 + 6] = (byte)(n4 >> 8);
        byArray2[n2 + 7] = (byte)n4;
        byArray2[n2 + 8] = (byte)(n5 >> 24);
        byArray2[n2 + 9] = (byte)(n5 >> 16);
        byArray2[n2 + 10] = (byte)(n5 >> 8);
        byArray2[n2 + 11] = (byte)n5;
        byArray2[n2 + 12] = (byte)(n6 >> 24);
        byArray2[n2 + 13] = (byte)(n6 >> 16);
        byArray2[n2 + 14] = (byte)(n6 >> 8);
        byArray2[n2 + 15] = (byte)n6;
    }

    @Override
    public int getKeyLength() {
        return 16;
    }

    static {
        int n2;
        RCON = new int[10];
        FS = new int[256];
        FT0 = new int[256];
        FT1 = new int[256];
        FT2 = new int[256];
        FT3 = new int[256];
        RS = new int[256];
        RT0 = new int[256];
        RT1 = new int[256];
        RT2 = new int[256];
        RT3 = new int[256];
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int n3 = 0;
        int n4 = 1;
        while (n3 < 256) {
            nArray[n3] = n4;
            nArray2[n4] = n3++;
            n4 ^= AES.xtime(n4);
        }
        n4 = 1;
        for (n3 = 0; n3 < 10; ++n3) {
            AES.RCON[n3] = n4 << 24;
            n4 = AES.xtime(n4);
        }
        AES.FS[0] = 99;
        AES.RS[99] = 0;
        for (n3 = 1; n3 < 256; ++n3) {
            n2 = n4 = nArray[255 - nArray2[n3]];
            n2 = (n2 << 1 | n2 >> 7) & 0xFF;
            n4 ^= n2;
            n2 = (n2 << 1 | n2 >> 7) & 0xFF;
            n4 ^= n2;
            n2 = (n2 << 1 | n2 >> 7) & 0xFF;
            n4 ^= n2;
            n2 = (n2 << 1 | n2 >> 7) & 0xFF;
            AES.FS[n3] = (n4 ^= n2 ^ 0x63) & 0xFF;
            AES.RS[n4] = n3 & 0xFF;
        }
        for (n3 = 0; n3 < 256; ++n3) {
            n4 = FS[n3];
            n2 = AES.xtime(n4);
            AES.FT0[n3] = n4 ^ n2 ^ n4 << 8 ^ n4 << 16 ^ n2 << 24;
            AES.FT1[n3] = AES.rot8(FT0[n3]);
            AES.FT2[n3] = AES.rot8(FT1[n3]);
            AES.FT3[n3] = AES.rot8(FT2[n3]);
            n2 = RS[n3];
            AES.RT0[n3] = AES.mul(nArray, nArray2, 11, n2) ^ AES.mul(nArray, nArray2, 13, n2) << 8 ^ AES.mul(nArray, nArray2, 9, n2) << 16 ^ AES.mul(nArray, nArray2, 14, n2) << 24;
            AES.RT1[n3] = AES.rot8(RT0[n3]);
            AES.RT2[n3] = AES.rot8(RT1[n3]);
            AES.RT3[n3] = AES.rot8(RT2[n3]);
        }
    }
}

