/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.math.BigInteger;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;

public class Sequence
extends SchemaObjectBase {
    public static final int DEFAULT_CACHE_SIZE = 32;
    private long value;
    private long valueWithMargin;
    private long increment;
    private long cacheSize;
    private long minValue;
    private long maxValue;
    private boolean cycle;
    private boolean belongsToTable;
    private Object flushSync = new Object();
    private boolean writeWithMargin;

    public Sequence(Schema schema, int n2, String string, long l2, long l3) {
        this(schema, n2, string, l2, l3, null, null, null, false, true);
    }

    public Sequence(Schema schema, int n2, String string, Long l2, Long l3, Long l4, Long l5, Long l6, boolean bl2, boolean bl3) {
        this.initSchemaObjectBase(schema, n2, string, 9);
        this.increment = l3 != null ? l3 : 1L;
        this.minValue = l5 != null ? l5 : Sequence.getDefaultMinValue(l2, this.increment);
        this.maxValue = l6 != null ? l6 : Sequence.getDefaultMaxValue(l2, this.increment);
        this.valueWithMargin = this.value = l2 != null ? l2.longValue() : this.getDefaultStartValue(this.increment);
        this.cacheSize = l4 != null ? Math.max(1L, l4) : 32L;
        this.cycle = bl2;
        this.belongsToTable = bl3;
        if (!Sequence.isValid(this.value, this.minValue, this.maxValue, this.increment)) {
            throw DbException.get(90009, string, String.valueOf(this.value), String.valueOf(this.minValue), String.valueOf(this.maxValue), String.valueOf(this.increment));
        }
    }

    public synchronized void modify(Long l2, Long l3, Long l4, Long l5) {
        if (l2 == null) {
            l2 = this.value;
        }
        if (l3 == null) {
            l3 = this.minValue;
        }
        if (l4 == null) {
            l4 = this.maxValue;
        }
        if (l5 == null) {
            l5 = this.increment;
        }
        if (!Sequence.isValid(l2, l3, l4, l5)) {
            throw DbException.get(90009, this.getName(), String.valueOf(l2), String.valueOf(l3), String.valueOf(l4), String.valueOf(l5));
        }
        this.value = l2;
        this.valueWithMargin = l2;
        this.minValue = l3;
        this.maxValue = l4;
        this.increment = l5;
    }

    private static boolean isValid(long l2, long l3, long l4, long l5) {
        return l3 <= l2 && l4 >= l2 && l4 > l3 && l5 != 0L && BigInteger.valueOf(l5).abs().compareTo(BigInteger.valueOf(l4).subtract(BigInteger.valueOf(l3))) < 0;
    }

    private static long getDefaultMinValue(Long l2, long l3) {
        long l4;
        long l5 = l4 = l3 >= 0L ? 1L : Long.MIN_VALUE;
        if (l2 != null && l3 >= 0L && l2 < l4) {
            l4 = l2;
        }
        return l4;
    }

    private static long getDefaultMaxValue(Long l2, long l3) {
        long l4;
        long l5 = l4 = l3 >= 0L ? Long.MAX_VALUE : -1L;
        if (l2 != null && l3 < 0L && l2 > l4) {
            l4 = l2;
        }
        return l4;
    }

    private long getDefaultStartValue(long l2) {
        return l2 >= 0L ? this.minValue : this.maxValue;
    }

    public boolean getBelongsToTable() {
        return this.belongsToTable;
    }

    public long getIncrement() {
        return this.increment;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public boolean getCycle() {
        return this.cycle;
    }

    public void setCycle(boolean bl2) {
        this.cycle = bl2;
    }

    @Override
    public String getDropSQL() {
        if (this.getBelongsToTable()) {
            return null;
        }
        return "DROP SEQUENCE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    @Override
    public synchronized String getCreateSQL() {
        long l2 = this.writeWithMargin ? this.valueWithMargin : this.value;
        StringBuilder stringBuilder = new StringBuilder("CREATE SEQUENCE ");
        stringBuilder.append(this.getSQL()).append(" START WITH ").append(l2);
        if (this.increment != 1L) {
            stringBuilder.append(" INCREMENT BY ").append(this.increment);
        }
        if (this.minValue != Sequence.getDefaultMinValue(l2, this.increment)) {
            stringBuilder.append(" MINVALUE ").append(this.minValue);
        }
        if (this.maxValue != Sequence.getDefaultMaxValue(l2, this.increment)) {
            stringBuilder.append(" MAXVALUE ").append(this.maxValue);
        }
        if (this.cycle) {
            stringBuilder.append(" CYCLE");
        }
        if (this.cacheSize != 32L) {
            stringBuilder.append(" CACHE ").append(this.cacheSize);
        }
        if (this.belongsToTable) {
            stringBuilder.append(" BELONGS_TO_TABLE");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNext(Session session) {
        long l2;
        boolean bl2 = false;
        Sequence sequence = this;
        synchronized (sequence) {
            if (this.increment > 0L && this.value >= this.valueWithMargin || this.increment < 0L && this.value <= this.valueWithMargin) {
                this.valueWithMargin += this.increment * this.cacheSize;
                bl2 = true;
            }
            if (this.increment > 0L && this.value > this.maxValue || this.increment < 0L && this.value < this.minValue) {
                if (this.cycle) {
                    this.value = this.increment > 0L ? this.minValue : this.maxValue;
                    this.valueWithMargin = this.value + this.increment * this.cacheSize;
                    bl2 = true;
                } else {
                    throw DbException.get(90006, this.getName());
                }
            }
            l2 = this.value;
            this.value += this.increment;
        }
        if (bl2) {
            this.flush(session);
        }
        return l2;
    }

    public void flushWithoutMargin() {
        if (this.valueWithMargin != this.value) {
            this.valueWithMargin = this.value;
            this.flush(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Session session) {
        if (this.isTemporary()) {
            return;
        }
        if (session == null || !this.database.isSysTableLockedBy(session)) {
            Session session2;
            Session session3 = session2 = this.database.getSystemSession();
            synchronized (session3) {
                Object object = this.flushSync;
                synchronized (object) {
                    this.flushInternal(session2);
                }
                session2.commit(false);
            }
        }
        Session session4 = session;
        synchronized (session4) {
            Object object = this.flushSync;
            synchronized (object) {
                this.flushInternal(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInternal(Session session) {
        boolean bl2 = this.database.lockMeta(session);
        try {
            this.writeWithMargin = true;
            this.database.updateMeta(session, this);
        }
        finally {
            this.writeWithMargin = false;
        }
        if (!bl2) {
            this.database.unlockMeta(session);
        }
    }

    public void close() {
        this.flushWithoutMargin();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }

    public synchronized long getCurrentValue() {
        return this.value - this.increment;
    }

    public void setBelongsToTable(boolean bl2) {
        this.belongsToTable = bl2;
    }

    public void setCacheSize(long l2) {
        this.cacheSize = Math.max(1L, l2);
    }

    public long getCacheSize() {
        return this.cacheSize;
    }
}

